/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.lang.StringUtil;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.ExifSubIFDDescriptor;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NikonType2MakernoteDescriptor
extends TagDescriptor<NikonType2MakernoteDirectory> {
    public NikonType2MakernoteDescriptor(@NotNull NikonType2MakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 13: {
                return this.getProgramShiftDescription();
            }
            case 14: {
                return this.getExposureDifferenceDescription();
            }
            case 132: {
                return this.getLensDescription();
            }
            case 146: {
                return this.getHueAdjustmentDescription();
            }
            case 141: {
                return this.getColorModeDescription();
            }
            case 18: {
                return this.getAutoFlashCompensationDescription();
            }
            case 23: {
                return this.getFlashExposureCompensationDescription();
            }
            case 24: {
                return this.getFlashBracketCompensationDescription();
            }
            case 28: {
                return this.getExposureTuningDescription();
            }
            case 139: {
                return this.getLensStopsDescription();
            }
            case 30: {
                return this.getColorSpaceDescription();
            }
            case 34: {
                return this.getActiveDLightingDescription();
            }
            case 42: {
                return this.getVignetteControlDescription();
            }
            case 2: {
                return this.getIsoSettingDescription();
            }
            case 134: {
                return this.getDigitalZoomDescription();
            }
            case 135: {
                return this.getFlashUsedDescription();
            }
            case 136: {
                return this.getAutoFocusPositionDescription();
            }
            case 1: {
                return this.getFirmwareVersionDescription();
            }
            case 131: {
                return this.getLensTypeDescription();
            }
            case 137: {
                return this.getShootingModeDescription();
            }
            case 147: {
                return this.getNEFCompressionDescription();
            }
            case 177: {
                return this.getHighISONoiseReductionDescription();
            }
            case 182: {
                return this.getPowerUpTimeDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getPowerUpTimeDescription() {
        Long value = ((NikonType2MakernoteDirectory)this._directory).getLongObject(182);
        if (value == null) {
            return null;
        }
        return new Date(value).toString();
    }

    @Nullable
    public String getHighISONoiseReductionDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(177);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Minimal";
            }
            case 2: {
                return "Low";
            }
            case 4: {
                return "Normal";
            }
            case 6: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashUsedDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(135);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Flash Not Used";
            }
            case 1: {
                return "Manual Flash";
            }
            case 3: {
                return "Flash Not Ready";
            }
            case 7: {
                return "External Flash";
            }
            case 8: {
                return "Fired, Commander Mode";
            }
            case 9: {
                return "Fired, TTL Mode";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getNEFCompressionDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(147);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Lossy (Type 1)";
            }
            case 3: {
                return "Uncompressed";
            }
            case 7: {
                return "Lossless";
            }
            case 8: {
                return "Lossy (Type 2)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getShootingModeDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(137);
        if (value == null) {
            return null;
        }
        ArrayList<String> bits = new ArrayList<String>();
        if ((value & 1) == 1) {
            bits.add("Continuous");
        } else {
            bits.add("Single Frame");
        }
        if ((value & 2) == 2) {
            bits.add("Delay");
        }
        if ((value & 8) == 8) {
            bits.add("PC Control");
        }
        if ((value & 0x10) == 16) {
            bits.add("Exposure Bracketing");
        }
        if ((value & 0x20) == 32) {
            bits.add("Auto ISO");
        }
        if ((value & 0x40) == 64) {
            bits.add("White-Balance Bracketing");
        }
        if ((value & 0x80) == 128) {
            bits.add("IR Control");
        }
        return StringUtil.join(bits, ", ");
    }

    @Nullable
    public String getLensTypeDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(131);
        if (value == null) {
            return null;
        }
        ArrayList<String> bits = new ArrayList<String>();
        if ((value & 1) == 1) {
            bits.add("MF");
        } else {
            bits.add("AF");
        }
        if ((value & 2) == 2) {
            bits.add("D");
        }
        if ((value & 4) == 4) {
            bits.add("G");
        }
        if ((value & 8) == 8) {
            bits.add("VR");
        }
        return StringUtil.join(bits, ", ");
    }

    @Nullable
    public String getColorSpaceDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(30);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "sRGB";
            }
            case 2: {
                return "Adobe RGB";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getActiveDLightingDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(34);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Light";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
            case 7: {
                return "Extra High";
            }
            case 65535: {
                return "Auto";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getVignetteControlDescription() {
        Integer value = ((NikonType2MakernoteDirectory)this._directory).getInteger(42);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Low";
            }
            case 3: {
                return "Normal";
            }
            case 5: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAutoFocusPositionDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(136);
        if (values == null) {
            return null;
        }
        if (values.length != 4 || values[0] != 0 || values[2] != 0 || values[3] != 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(136) + ")";
        }
        switch (values[1]) {
            case 0: {
                return "Centre";
            }
            case 1: {
                return "Top";
            }
            case 2: {
                return "Bottom";
            }
            case 3: {
                return "Left";
            }
            case 4: {
                return "Right";
            }
        }
        return "Unknown (" + values[1] + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Rational value = ((NikonType2MakernoteDirectory)this._directory).getRational(134);
        if (value == null) {
            return null;
        }
        return value.intValue() == 1 ? "No digital zoom" : value.toSimpleString(true) + "x digital zoom";
    }

    @Nullable
    public String getProgramShiftDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(13);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @Nullable
    public String getExposureDifferenceDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(14);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @NotNull
    public String getAutoFlashCompensationDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(18);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @NotNull
    public String getFlashExposureCompensationDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(23);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @NotNull
    public String getFlashBracketCompensationDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(24);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @NotNull
    public String getExposureTuningDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(28);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @NotNull
    public String getLensStopsDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(139);
        return NikonType2MakernoteDescriptor.getEVDescription(values);
    }

    @Nullable
    private static String getEVDescription(@Nullable int[] values) {
        if (values == null) {
            return null;
        }
        if (values.length < 3 || values[2] == 0) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        double ev = (double)(values[0] * values[1]) / (double)values[2];
        return decimalFormat.format(ev) + " EV";
    }

    @Nullable
    public String getIsoSettingDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(2);
        if (values == null) {
            return null;
        }
        if (values[0] != 0 || values[1] == 0) {
            return "Unknown (" + ((NikonType2MakernoteDirectory)this._directory).getString(2) + ")";
        }
        return "ISO " + values[1];
    }

    @Nullable
    public String getLensDescription() {
        Rational[] values = ((NikonType2MakernoteDirectory)this._directory).getRationalArray(132);
        if (values == null) {
            return null;
        }
        if (values.length < 4) {
            return ((NikonType2MakernoteDirectory)this._directory).getString(132);
        }
        StringBuilder description = new StringBuilder();
        description.append(values[0].intValue());
        description.append('-');
        description.append(values[1].intValue());
        description.append("mm f/");
        description.append(values[2].floatValue());
        description.append('-');
        description.append(values[3].floatValue());
        return description.toString();
    }

    @Nullable
    public String getHueAdjustmentDescription() {
        String value = ((NikonType2MakernoteDirectory)this._directory).getString(146);
        if (value == null) {
            return null;
        }
        return value + " degrees";
    }

    @Nullable
    public String getColorModeDescription() {
        String value = ((NikonType2MakernoteDirectory)this._directory).getString(141);
        if (value == null) {
            return null;
        }
        if (value.startsWith("MODE1")) {
            return "Mode I (sRGB)";
        }
        return value;
    }

    @Nullable
    public String getFirmwareVersionDescription() {
        int[] values = ((NikonType2MakernoteDirectory)this._directory).getIntArray(1);
        if (values == null) {
            return null;
        }
        return ExifSubIFDDescriptor.convertBytesToVersionString(values, 2);
    }
}

