# Generated by default/object.tt
package Paws::SecurityHub::AwsElasticsearchDomainServiceSoftwareOptions;
  use Moose;
  has AutomatedUpdateDate => (is => 'ro', isa => 'Str');
  has Cancellable => (is => 'ro', isa => 'Bool');
  has CurrentVersion => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has NewVersion => (is => 'ro', isa => 'Str');
  has UpdateAvailable => (is => 'ro', isa => 'Bool');
  has UpdateStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElasticsearchDomainServiceSoftwareOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElasticsearchDomainServiceSoftwareOptions object:

  $service_obj->Method(Att1 => { AutomatedUpdateDate => $value, ..., UpdateStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElasticsearchDomainServiceSoftwareOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->AutomatedUpdateDate

=head1 DESCRIPTION

Information about the state of the domain relative to the latest
service software.

=head1 ATTRIBUTES


=head2 AutomatedUpdateDate => Str

The epoch time when the deployment window closes for required updates.
After this time, Amazon Elasticsearch Service schedules the software
upgrade automatically.


=head2 Cancellable => Bool

Whether a request to update the domain can be canceled.


=head2 CurrentVersion => Str

The version of the service software that is currently installed on the
domain.


=head2 Description => Str

A more detailed description of the service software status.


=head2 NewVersion => Str

The most recent version of the service software.


=head2 UpdateAvailable => Bool

Whether a service software update is available for the domain.


=head2 UpdateStatus => Str

The status of the service software update.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

