# Generated by default/object.tt
package Paws::MediaLive::InputDeviceNetworkSettings;
  use Moose;
  has DnsAddresses => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'dnsAddresses', traits => ['NameInRequest']);
  has Gateway => (is => 'ro', isa => 'Str', request_name => 'gateway', traits => ['NameInRequest']);
  has IpAddress => (is => 'ro', isa => 'Str', request_name => 'ipAddress', traits => ['NameInRequest']);
  has IpScheme => (is => 'ro', isa => 'Str', request_name => 'ipScheme', traits => ['NameInRequest']);
  has SubnetMask => (is => 'ro', isa => 'Str', request_name => 'subnetMask', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::InputDeviceNetworkSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::InputDeviceNetworkSettings object:

  $service_obj->Method(Att1 => { DnsAddresses => $value, ..., SubnetMask => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::InputDeviceNetworkSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->DnsAddresses

=head1 DESCRIPTION

The network settings for the input device.

=head1 ATTRIBUTES


=head2 DnsAddresses => ArrayRef[Str|Undef]

The DNS addresses of the input device.


=head2 Gateway => Str

The network gateway IP address.


=head2 IpAddress => Str

The IP address of the input device.


=head2 IpScheme => Str

Specifies whether the input device has been configured (outside of
MediaLive) to use a dynamic IP address assignment (DHCP) or a static IP
address.


=head2 SubnetMask => Str

The subnet mask of the input device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

