# Generated by default/object.tt
package Paws::ComputeOptimizer::RecommendationExportJob;
  use Moose;
  has CreationTimestamp => (is => 'ro', isa => 'Str', request_name => 'creationTimestamp', traits => ['NameInRequest']);
  has Destination => (is => 'ro', isa => 'Paws::ComputeOptimizer::ExportDestination', request_name => 'destination', traits => ['NameInRequest']);
  has FailureReason => (is => 'ro', isa => 'Str', request_name => 'failureReason', traits => ['NameInRequest']);
  has JobId => (is => 'ro', isa => 'Str', request_name => 'jobId', traits => ['NameInRequest']);
  has LastUpdatedTimestamp => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedTimestamp', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ComputeOptimizer::RecommendationExportJob

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ComputeOptimizer::RecommendationExportJob object:

  $service_obj->Method(Att1 => { CreationTimestamp => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ComputeOptimizer::RecommendationExportJob object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTimestamp

=head1 DESCRIPTION

Describes a recommendation export job.

Use the C<DescribeRecommendationExportJobs> action to view your
recommendation export jobs.

Use the C<ExportAutoScalingGroupRecommendations> or
C<ExportEC2InstanceRecommendations> actions to request an export of
your recommendations.

=head1 ATTRIBUTES


=head2 CreationTimestamp => Str

The timestamp of when the export job was created.


=head2 Destination => L<Paws::ComputeOptimizer::ExportDestination>

An object that describes the destination of the export file.


=head2 FailureReason => Str

The reason for an export job failure.


=head2 JobId => Str

The identification number of the export job.


=head2 LastUpdatedTimestamp => Str

The timestamp of when the export job was last updated.


=head2 ResourceType => Str

The resource type of the exported recommendations.


=head2 Status => Str

The status of the export job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ComputeOptimizer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

