#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::GranularityLevelCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GranularityLevelCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::GranularityLevelCodeType

=head1 DESCRIPTION

Specifies a predefined subset of fields to return. The predefined set of fields
can vary for different calls. Only applicable to certain calls (see request types
that include a GranularityLevel property). For calls that support this filter, see
the eBay Web Services guide for a list of the output fields that are returned for
each level. Only one level can be specified at a time. For GetSellerList, use
DetailLevel or GranularityLevel in a given request, but not both. For
GetSellerList, if GranularityLevel is specified, DetailLevel is ignored.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 Coarse

(in) For each record in the response, retrieves less data than Medium.
See the eBay Web Services guide for a list of the output fields
that are returned when this level is specified.



=cut


use constant Coarse => scalar('Coarse');


=head2 Fine

For each record in the response, retrieves more data than Medium.
See the eBay Web Services guide for a list of the output fields
that are returned when this level is specified.



=cut


use constant Fine => scalar('Fine');


=head2 Medium

For each record in the response, retrieves more data than Coarse and less data
than Fine. See the eBay Web Services guide for a list of the output fields
that are returned when this level is specified.



=cut


use constant Medium => scalar('Medium');


=head2 CustomCode

=cut


use constant CustomCode => scalar('CustomCode');







1;   
