# DO NOT EDIT, PRETTY PLEASE!
# This file is automatically generated by wl-scanner.pl
#

use strict;
use warnings;
use utf8;

=encoding utf8
=cut


=head1 NAME

WL - Perl Wayland protocol binding

=head1 SYNOPSIS

  use WL;

=head1 DESCRIPTION

B<WL> is a package generated from Wayland protocol definition using
L<wl-scanner.pl>. It implements L<WL::Base> subclasses with wrappers for
requests, event processing and constants for enums.

It is not indended to be used directly. Instead, see L<WL::Connection> to see
how to obtain the object instances.

To see how to attach event callbacks and issue requests, please refer to
L<WL::Base> base class.

Until proper documentation is finished, please refer to documentation of C
bindings of the generated code (it is intended to be readable) to see what
arguments to give to requests and expect from events.

Please consider this an alpha quality code, whose API can change at any time,
until we reach version 1.0.

=cut

package WL;

our $VERSION = 0.90;

package WL::wl_display;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_display';

# Requests
use constant REQUEST_SYNC => 0;
use constant REQUEST_GET_REGISTRY => 1;

sub sync
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SYNC, pack ('L',
		($retval = new WL::wl_callback ($self->{conn}))->{id}), $file);

	return $retval;
}

sub get_registry
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_REGISTRY, pack ('L',
		($retval = new WL::wl_registry ($self->{conn}))->{id}), $file);

	return $retval;
}

# Events
use constant EVENT_ERROR => 0;
use constant EVENT_DELETE_ID => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_ERROR) {
		@_ = unpack ('L L L/ax!4', shift);
		return $self->error (new WL::Base ($self->{conn}, shift),
			shift,
			[shift =~ /(.*)./]->[0]);
	} elsif ($opcode == EVENT_DELETE_ID) {
		@_ = unpack ('L', shift);
		return $self->delete_id (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant ERROR_INVALID_OBJECT => 0;
use constant ERROR_INVALID_METHOD => 1;
use constant ERROR_NO_MEMORY => 2;

package WL::wl_registry;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_registry';

# Requests
use constant REQUEST_BIND => 0;

sub bind
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_BIND, pack ('L L/ax!4 L L',
		shift,
		$_[0]."\x00", delete $_[1], ($retval = ("WL::".shift)->new ($self->{conn}))->{id}), $file);

	return $retval;
}

# Events
use constant EVENT_GLOBAL => 0;
use constant EVENT_GLOBAL_REMOVE => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_GLOBAL) {
		@_ = unpack ('L L/ax!4 L', shift);
		return $self->global (shift,
			[shift =~ /(.*)./]->[0],
			shift);
	} elsif ($opcode == EVENT_GLOBAL_REMOVE) {
		@_ = unpack ('L', shift);
		return $self->global_remove (shift);
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_callback;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_callback';

# Events
use constant EVENT_DONE => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_DONE) {
		@_ = unpack ('L', shift);
		return $self->done (shift);
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_compositor;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_compositor';

# Requests
use constant REQUEST_CREATE_SURFACE => 0;
use constant REQUEST_CREATE_REGION => 1;

sub create_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CREATE_SURFACE, pack ('L',
		($retval = new WL::wl_surface ($self->{conn}))->{id}), $file);

	return $retval;
}

sub create_region
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CREATE_REGION, pack ('L',
		($retval = new WL::wl_region ($self->{conn}))->{id}), $file);

	return $retval;
}

package WL::wl_shm_pool;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_shm_pool';

# Requests
use constant REQUEST_CREATE_BUFFER => 0;
use constant REQUEST_DESTROY => 1;
use constant REQUEST_RESIZE => 2;

sub create_buffer
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CREATE_BUFFER, pack ('L l l l l L',
		($retval = new WL::wl_buffer ($self->{conn}))->{id},
		shift,
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

sub resize
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RESIZE, pack ('l',
		shift), $file);

	return $retval;
}

package WL::wl_shm;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_shm';

# Requests
use constant REQUEST_CREATE_POOL => 0;

sub create_pool
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CREATE_POOL, pack ('L l',
		($retval = new WL::wl_shm_pool ($self->{conn}))->{id},
		($file = shift, ()),
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_FORMAT => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_FORMAT) {
		@_ = unpack ('L', shift);
		return $self->format (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant ERROR_INVALID_FORMAT => 0;
use constant ERROR_INVALID_STRIDE => 1;
use constant ERROR_INVALID_FD => 2;
use constant FORMAT_ARGB8888 => 0;
use constant FORMAT_XRGB8888 => 1;
use constant FORMAT_C8 => 0x20203843;
use constant FORMAT_RGB332 => 0x38424752;
use constant FORMAT_BGR233 => 0x38524742;
use constant FORMAT_XRGB4444 => 0x32315258;
use constant FORMAT_XBGR4444 => 0x32314258;
use constant FORMAT_RGBX4444 => 0x32315852;
use constant FORMAT_BGRX4444 => 0x32315842;
use constant FORMAT_ARGB4444 => 0x32315241;
use constant FORMAT_ABGR4444 => 0x32314241;
use constant FORMAT_RGBA4444 => 0x32314152;
use constant FORMAT_BGRA4444 => 0x32314142;
use constant FORMAT_XRGB1555 => 0x35315258;
use constant FORMAT_XBGR1555 => 0x35314258;
use constant FORMAT_RGBX5551 => 0x35315852;
use constant FORMAT_BGRX5551 => 0x35315842;
use constant FORMAT_ARGB1555 => 0x35315241;
use constant FORMAT_ABGR1555 => 0x35314241;
use constant FORMAT_RGBA5551 => 0x35314152;
use constant FORMAT_BGRA5551 => 0x35314142;
use constant FORMAT_RGB565 => 0x36314752;
use constant FORMAT_BGR565 => 0x36314742;
use constant FORMAT_RGB888 => 0x34324752;
use constant FORMAT_BGR888 => 0x34324742;
use constant FORMAT_XBGR8888 => 0x34324258;
use constant FORMAT_RGBX8888 => 0x34325852;
use constant FORMAT_BGRX8888 => 0x34325842;
use constant FORMAT_ABGR8888 => 0x34324241;
use constant FORMAT_RGBA8888 => 0x34324152;
use constant FORMAT_BGRA8888 => 0x34324142;
use constant FORMAT_XRGB2101010 => 0x30335258;
use constant FORMAT_XBGR2101010 => 0x30334258;
use constant FORMAT_RGBX1010102 => 0x30335852;
use constant FORMAT_BGRX1010102 => 0x30335842;
use constant FORMAT_ARGB2101010 => 0x30335241;
use constant FORMAT_ABGR2101010 => 0x30334241;
use constant FORMAT_RGBA1010102 => 0x30334152;
use constant FORMAT_BGRA1010102 => 0x30334142;
use constant FORMAT_YUYV => 0x56595559;
use constant FORMAT_YVYU => 0x55595659;
use constant FORMAT_UYVY => 0x59565955;
use constant FORMAT_VYUY => 0x59555956;
use constant FORMAT_AYUV => 0x56555941;
use constant FORMAT_NV12 => 0x3231564e;
use constant FORMAT_NV21 => 0x3132564e;
use constant FORMAT_NV16 => 0x3631564e;
use constant FORMAT_NV61 => 0x3136564e;
use constant FORMAT_YUV410 => 0x39565559;
use constant FORMAT_YVU410 => 0x39555659;
use constant FORMAT_YUV411 => 0x31315559;
use constant FORMAT_YVU411 => 0x31315659;
use constant FORMAT_YUV420 => 0x32315559;
use constant FORMAT_YVU420 => 0x32315659;
use constant FORMAT_YUV422 => 0x36315559;
use constant FORMAT_YVU422 => 0x36315659;
use constant FORMAT_YUV444 => 0x34325559;
use constant FORMAT_YVU444 => 0x34325659;

package WL::wl_buffer;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_buffer';

# Requests
use constant REQUEST_DESTROY => 0;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_RELEASE => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_RELEASE) {
		return $self->release ();
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_data_offer;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_data_offer';

# Requests
use constant REQUEST_ACCEPT => 0;
use constant REQUEST_RECEIVE => 1;
use constant REQUEST_DESTROY => 2;

sub accept
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_ACCEPT, pack ('L L/ax!4',
		shift,
		shift."\x00"), $file);

	return $retval;
}

sub receive
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RECEIVE, pack ('L/ax!4',
		shift."\x00",
		($file = shift, ())), $file);

	return $retval;
}

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_OFFER => 0;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_OFFER) {
		@_ = unpack ('L/ax!4', shift);
		return $self->offer ([shift =~ /(.*)./]->[0]);
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_data_source;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_data_source';

# Requests
use constant REQUEST_OFFER => 0;
use constant REQUEST_DESTROY => 1;

sub offer
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_OFFER, pack ('L/ax!4',
		shift."\x00"), $file);

	return $retval;
}

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_TARGET => 0;
use constant EVENT_SEND => 1;
use constant EVENT_CANCELLED => 2;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_TARGET) {
		@_ = unpack ('L/ax!4', shift);
		return $self->target ([shift =~ /(.*)./]->[0]);
	} elsif ($opcode == EVENT_SEND) {
		@_ = unpack ('L/ax!4', shift);
		return $self->send ([shift =~ /(.*)./]->[0],
			shift);
	} elsif ($opcode == EVENT_CANCELLED) {
		return $self->cancelled ();
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_data_device;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_data_device';

# Requests
use constant REQUEST_START_DRAG => 0;
use constant REQUEST_SET_SELECTION => 1;

sub start_drag
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_START_DRAG, pack ('L L L L',
		shift->{id},
		shift->{id},
		shift->{id},
		shift), $file);

	return $retval;
}

sub set_selection
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_SELECTION, pack ('L L',
		shift->{id},
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_DATA_OFFER => 0;
use constant EVENT_ENTER => 1;
use constant EVENT_LEAVE => 2;
use constant EVENT_MOTION => 3;
use constant EVENT_DROP => 4;
use constant EVENT_SELECTION => 5;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_DATA_OFFER) {
		@_ = unpack ('L', shift);
		return $self->data_offer (new WL::wl_data_offer ($self->{conn}));
	} elsif ($opcode == EVENT_ENTER) {
		@_ = unpack ('L L L L L', shift);
		return $self->enter (shift,
			new WL::wl_surface ($self->{conn}, shift),
			$self->fixed2nv (shift),
			$self->fixed2nv (shift),
			new WL::wl_data_offer ($self->{conn}, shift));
	} elsif ($opcode == EVENT_LEAVE) {
		return $self->leave ();
	} elsif ($opcode == EVENT_MOTION) {
		@_ = unpack ('L L L', shift);
		return $self->motion (shift,
			$self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_DROP) {
		return $self->drop ();
	} elsif ($opcode == EVENT_SELECTION) {
		@_ = unpack ('L', shift);
		return $self->selection (new WL::wl_data_offer ($self->{conn}, shift));
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_data_device_manager;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_data_device_manager';

# Requests
use constant REQUEST_CREATE_DATA_SOURCE => 0;
use constant REQUEST_GET_DATA_DEVICE => 1;

sub create_data_source
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_CREATE_DATA_SOURCE, pack ('L',
		($retval = new WL::wl_data_source ($self->{conn}))->{id}), $file);

	return $retval;
}

sub get_data_device
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_DATA_DEVICE, pack ('L L',
		($retval = new WL::wl_data_device ($self->{conn}))->{id},
		shift->{id}), $file);

	return $retval;
}

package WL::wl_shell;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_shell';

# Requests
use constant REQUEST_GET_SHELL_SURFACE => 0;

sub get_shell_surface
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_SHELL_SURFACE, pack ('L L',
		($retval = new WL::wl_shell_surface ($self->{conn}))->{id},
		shift->{id}), $file);

	return $retval;
}

package WL::wl_shell_surface;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_shell_surface';

# Requests
use constant REQUEST_PONG => 0;
use constant REQUEST_MOVE => 1;
use constant REQUEST_RESIZE => 2;
use constant REQUEST_SET_TOPLEVEL => 3;
use constant REQUEST_SET_TRANSIENT => 4;
use constant REQUEST_SET_FULLSCREEN => 5;
use constant REQUEST_SET_POPUP => 6;
use constant REQUEST_SET_MAXIMIZED => 7;
use constant REQUEST_SET_TITLE => 8;
use constant REQUEST_SET_CLASS => 9;

sub pong
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_PONG, pack ('L',
		shift), $file);

	return $retval;
}

sub move
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_MOVE, pack ('L L',
		shift->{id},
		shift), $file);

	return $retval;
}

sub resize
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RESIZE, pack ('L L L',
		shift->{id},
		shift,
		shift), $file);

	return $retval;
}

sub set_toplevel
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_TOPLEVEL, pack ('',
		), $file);

	return $retval;
}

sub set_transient
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_TRANSIENT, pack ('L l l L',
		shift->{id},
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub set_fullscreen
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_FULLSCREEN, pack ('L L L',
		shift,
		shift,
		shift->{id}), $file);

	return $retval;
}

sub set_popup
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_POPUP, pack ('L L L l l L',
		shift->{id},
		shift,
		shift->{id},
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub set_maximized
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_MAXIMIZED, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub set_title
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_TITLE, pack ('L/ax!4',
		shift."\x00"), $file);

	return $retval;
}

sub set_class
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_CLASS, pack ('L/ax!4',
		shift."\x00"), $file);

	return $retval;
}

# Events
use constant EVENT_PING => 0;
use constant EVENT_CONFIGURE => 1;
use constant EVENT_POPUP_DONE => 2;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_PING) {
		@_ = unpack ('L', shift);
		return $self->ping (shift);
	} elsif ($opcode == EVENT_CONFIGURE) {
		@_ = unpack ('L l l', shift);
		return $self->configure (shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_POPUP_DONE) {
		return $self->popup_done ();
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant RESIZE_NONE => 0;
use constant RESIZE_TOP => 1;
use constant RESIZE_BOTTOM => 2;
use constant RESIZE_LEFT => 4;
use constant RESIZE_TOP_LEFT => 5;
use constant RESIZE_BOTTOM_LEFT => 6;
use constant RESIZE_RIGHT => 8;
use constant RESIZE_TOP_RIGHT => 9;
use constant RESIZE_BOTTOM_RIGHT => 10;
use constant TRANSIENT_INACTIVE => 0x1;
use constant FULLSCREEN_METHOD_DEFAULT => 0;
use constant FULLSCREEN_METHOD_SCALE => 1;
use constant FULLSCREEN_METHOD_DRIVER => 2;
use constant FULLSCREEN_METHOD_FILL => 3;

package WL::wl_surface;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_surface';

# Requests
use constant REQUEST_DESTROY => 0;
use constant REQUEST_ATTACH => 1;
use constant REQUEST_DAMAGE => 2;
use constant REQUEST_FRAME => 3;
use constant REQUEST_SET_OPAQUE_REGION => 4;
use constant REQUEST_SET_INPUT_REGION => 5;
use constant REQUEST_COMMIT => 6;
use constant REQUEST_SET_BUFFER_TRANSFORM => 7;
use constant REQUEST_SET_BUFFER_SCALE => 8;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

sub attach
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_ATTACH, pack ('L l l',
		shift->{id},
		shift,
		shift), $file);

	return $retval;
}

sub damage
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DAMAGE, pack ('l l l l',
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub frame
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_FRAME, pack ('L',
		($retval = new WL::wl_callback ($self->{conn}))->{id}), $file);

	return $retval;
}

sub set_opaque_region
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_OPAQUE_REGION, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub set_input_region
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_INPUT_REGION, pack ('L',
		shift->{id}), $file);

	return $retval;
}

sub commit
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_COMMIT, pack ('',
		), $file);

	return $retval;
}

sub set_buffer_transform
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_BUFFER_TRANSFORM, pack ('l',
		shift), $file);

	return $retval;
}

sub set_buffer_scale
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_BUFFER_SCALE, pack ('l',
		shift), $file);

	return $retval;
}

# Events
use constant EVENT_ENTER => 0;
use constant EVENT_LEAVE => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_ENTER) {
		@_ = unpack ('L', shift);
		return $self->enter (new WL::wl_output ($self->{conn}, shift));
	} elsif ($opcode == EVENT_LEAVE) {
		@_ = unpack ('L', shift);
		return $self->leave (new WL::wl_output ($self->{conn}, shift));
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_seat;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_seat';

# Requests
use constant REQUEST_GET_POINTER => 0;
use constant REQUEST_GET_KEYBOARD => 1;
use constant REQUEST_GET_TOUCH => 2;

sub get_pointer
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_POINTER, pack ('L',
		($retval = new WL::wl_pointer ($self->{conn}))->{id}), $file);

	return $retval;
}

sub get_keyboard
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_KEYBOARD, pack ('L',
		($retval = new WL::wl_keyboard ($self->{conn}))->{id}), $file);

	return $retval;
}

sub get_touch
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_GET_TOUCH, pack ('L',
		($retval = new WL::wl_touch ($self->{conn}))->{id}), $file);

	return $retval;
}

# Events
use constant EVENT_CAPABILITIES => 0;
use constant EVENT_NAME => 1;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_CAPABILITIES) {
		@_ = unpack ('L', shift);
		return $self->capabilities (shift);
	} elsif ($opcode == EVENT_NAME) {
		@_ = unpack ('L/ax!4', shift);
		return $self->name ([shift =~ /(.*)./]->[0]);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant CAPABILITY_POINTER => 1;
use constant CAPABILITY_KEYBOARD => 2;
use constant CAPABILITY_TOUCH => 4;

package WL::wl_pointer;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_pointer';

# Requests
use constant REQUEST_SET_CURSOR => 0;
use constant REQUEST_RELEASE => 1;

sub set_cursor
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SET_CURSOR, pack ('L L l l',
		shift,
		shift->{id},
		shift,
		shift), $file);

	return $retval;
}

sub release
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RELEASE, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_ENTER => 0;
use constant EVENT_LEAVE => 1;
use constant EVENT_MOTION => 2;
use constant EVENT_BUTTON => 3;
use constant EVENT_AXIS => 4;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_ENTER) {
		@_ = unpack ('L L L L', shift);
		return $self->enter (shift,
			new WL::wl_surface ($self->{conn}, shift),
			$self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_LEAVE) {
		@_ = unpack ('L L', shift);
		return $self->leave (shift,
			new WL::wl_surface ($self->{conn}, shift));
	} elsif ($opcode == EVENT_MOTION) {
		@_ = unpack ('L L L', shift);
		return $self->motion (shift,
			$self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_BUTTON) {
		@_ = unpack ('L L L L', shift);
		return $self->button (shift,
			shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_AXIS) {
		@_ = unpack ('L L L', shift);
		return $self->axis (shift,
			shift,
			$self->fixed2nv (shift));
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant BUTTON_STATE_RELEASED => 0;
use constant BUTTON_STATE_PRESSED => 1;
use constant AXIS_VERTICAL_SCROLL => 0;
use constant AXIS_HORIZONTAL_SCROLL => 1;

package WL::wl_keyboard;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_keyboard';

# Requests
use constant REQUEST_RELEASE => 0;

sub release
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RELEASE, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_KEYMAP => 0;
use constant EVENT_ENTER => 1;
use constant EVENT_LEAVE => 2;
use constant EVENT_KEY => 3;
use constant EVENT_MODIFIERS => 4;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_KEYMAP) {
		@_ = unpack ('L L', shift);
		return $self->keymap (shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_ENTER) {
		@_ = unpack ('L L L/ax!4', shift);
		return $self->enter (shift,
			new WL::wl_surface ($self->{conn}, shift),
			shift);
	} elsif ($opcode == EVENT_LEAVE) {
		@_ = unpack ('L L', shift);
		return $self->leave (shift,
			new WL::wl_surface ($self->{conn}, shift));
	} elsif ($opcode == EVENT_KEY) {
		@_ = unpack ('L L L L', shift);
		return $self->key (shift,
			shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_MODIFIERS) {
		@_ = unpack ('L L L L L', shift);
		return $self->modifiers (shift,
			shift,
			shift,
			shift,
			shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant KEYMAP_FORMAT_NO_KEYMAP => 0;
use constant KEYMAP_FORMAT_XKB_V1 => 1;
use constant KEY_STATE_RELEASED => 0;
use constant KEY_STATE_PRESSED => 1;

package WL::wl_touch;

our @ISA = qw/WL::Base/;
our $VERSION = 3;
our $INTERFACE = 'wl_touch';

# Requests
use constant REQUEST_RELEASE => 0;

sub release
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_RELEASE, pack ('',
		), $file);

	return $retval;
}

# Events
use constant EVENT_DOWN => 0;
use constant EVENT_UP => 1;
use constant EVENT_MOTION => 2;
use constant EVENT_FRAME => 3;
use constant EVENT_CANCEL => 4;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_DOWN) {
		@_ = unpack ('L L L l L L', shift);
		return $self->down (shift,
			shift,
			new WL::wl_surface ($self->{conn}, shift),
			shift,
			$self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_UP) {
		@_ = unpack ('L L l', shift);
		return $self->up (shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_MOTION) {
		@_ = unpack ('L l L L', shift);
		return $self->motion (shift,
			shift,
			$self->fixed2nv (shift),
			$self->fixed2nv (shift));
	} elsif ($opcode == EVENT_FRAME) {
		return $self->frame ();
	} elsif ($opcode == EVENT_CANCEL) {
		return $self->cancel ();
	} else {
		die 'Bad opcode';
	}
}

package WL::wl_output;

our @ISA = qw/WL::Base/;
our $VERSION = 2;
our $INTERFACE = 'wl_output';

# Events
use constant EVENT_GEOMETRY => 0;
use constant EVENT_MODE => 1;
use constant EVENT_DONE => 2;
use constant EVENT_SCALE => 3;

sub callback
{
	my $self = shift;
	my $opcode = shift;

	if ($opcode == EVENT_GEOMETRY) {
		@_ = unpack ('l l l l l L/ax!4 L/ax!4 l', shift);
		return $self->geometry (shift,
			shift,
			shift,
			shift,
			shift,
			[shift =~ /(.*)./]->[0],
			[shift =~ /(.*)./]->[0],
			shift);
	} elsif ($opcode == EVENT_MODE) {
		@_ = unpack ('L l l l', shift);
		return $self->mode (shift,
			shift,
			shift,
			shift);
	} elsif ($opcode == EVENT_DONE) {
		return $self->done ();
	} elsif ($opcode == EVENT_SCALE) {
		@_ = unpack ('l', shift);
		return $self->scale (shift);
	} else {
		die 'Bad opcode';
	}
}

# Enums
use constant SUBPIXEL_UNKNOWN => 0;
use constant SUBPIXEL_NONE => 1;
use constant SUBPIXEL_HORIZONTAL_RGB => 2;
use constant SUBPIXEL_HORIZONTAL_BGR => 3;
use constant SUBPIXEL_VERTICAL_RGB => 4;
use constant SUBPIXEL_VERTICAL_BGR => 5;
use constant TRANSFORM_NORMAL => 0;
use constant TRANSFORM_90 => 1;
use constant TRANSFORM_180 => 2;
use constant TRANSFORM_270 => 3;
use constant TRANSFORM_FLIPPED => 4;
use constant TRANSFORM_FLIPPED_90 => 5;
use constant TRANSFORM_FLIPPED_180 => 6;
use constant TRANSFORM_FLIPPED_270 => 7;
use constant MODE_CURRENT => 0x1;
use constant MODE_PREFERRED => 0x2;

package WL::wl_region;

our @ISA = qw/WL::Base/;
our $VERSION = 1;
our $INTERFACE = 'wl_region';

# Requests
use constant REQUEST_DESTROY => 0;
use constant REQUEST_ADD => 1;
use constant REQUEST_SUBTRACT => 2;

sub destroy
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_DESTROY, pack ('',
		), $file);

	return $retval;
}

sub add
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_ADD, pack ('l l l l',
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}

sub subtract
{
	my $self = shift;
	my $file;
	my $retval;

	$self->call (REQUEST_SUBTRACT, pack ('l l l l',
		shift,
		shift,
		shift,
		shift), $file);

	return $retval;
}


=head1 BUGS

The interface documentation for the bindings is lacking.

Only client part implemented, not server.

=head1 SEE ALSO

=over

=item *

L<http://wayland.freedesktop.org/> -- Wayland project web site

=item *

L<wl-demo.pl> -- Example Wayland client

=item *

L<wl-scanner.pl> -- Tool that generated this module

=item *

L<WL::Base> -- Base class for Wayland objects

=item *

L<WL::Connection> -- Estabilish a Wayland connection

=back

=head1 COPYRIGHT

Copyright 2013 Lubomir Rintel

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

Copyright notice from the protocol definition file:

Copyright © 2008-2011 Kristian Høgsberg
Copyright © 2010-2011 Intel Corporation

Permission to use, copy, modify, distribute, and sell this
software and its documentation for any purpose is hereby granted
without fee, provided that the above copyright notice appear in
all copies and that both that copyright notice and this permission
notice appear in supporting documentation, and that the name of
the copyright holders not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.  The copyright holders make no
representations about the suitability of this software for any
purpose.  It is provided "as is" without express or implied
warranty.

THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

=head1 AUTHORS

Lubomir Rintel C<lkundrak@v3.sk>

=cut

