#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);
use XML::TreePP;

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Task::NetDiscovery::Dictionary;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'extreme/summit300-24.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',
            SNMPHOSTNAME => 'xtb12-2',
            MAC          => '00:04:96:1f:91:50',
            MODEL        => 'Summit 300-24',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',
            SNMPHOSTNAME => 'xtb12-2',
            MAC          => '00:04:96:1f:91:50',
            MODEL        => 'Summit 300-24',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 300-24',
                COMMENTS     => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtb12-2',
                LOCATION     => 'PMF-B12',
                SERIAL       => '0518G-00029',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.9',
                        '192.168.254.72',
                    ],
                },
                MAC          => '00:04:96:1f:91:50',
                UPTIME       => '(447891453) 51 days, 20:08:34.53',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-24-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-24-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-24-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-24-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-24-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-24-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-24-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-24-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-24-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-24-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-24-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-24-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-24-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-24-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-24-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-24-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-24-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-24-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-24-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-24-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438821700) 50 days, 18:56:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '108729499',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304480573',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-24-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446914100) 51 days, 17:25:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '365076084',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2673085982',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-24-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432477100) 50 days, 1:19:31.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2230110099',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '2143937189',
                        IFOUTERRORS      => '125211',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-24-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-24-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-24-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-24-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1873901663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3791646090',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00003 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00004 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00005 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => 'rif0(192.168.100.9)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.9',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '961465250',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209642666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '88321595',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '151826622',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102001',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102002',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102102',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 300-24',
                COMMENTS     => 'Summit300-24 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:17:15',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtb12-2',
                LOCATION     => 'PMF-B12',
                SERIAL       => '0518G-00029',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.9',
                        '192.168.254.72',
                    ],
                },
                MAC          => '00:04:96:1f:91:50',
                UPTIME       => '(447891453) 51 days, 20:08:34.53',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-24-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-24-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-24-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-24-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-24-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-24-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-24-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-24-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-24-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-24-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-24-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-24-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-24-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-24-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-24-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-24-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-24-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-24-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-24-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-24-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438821700) 50 days, 18:56:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '108729499',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304480573',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-24-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446914100) 51 days, 17:25:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '365076084',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2673085982',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-24-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432477100) 50 days, 1:19:31.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2230110099',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '2143937189',
                        IFOUTERRORS      => '125211',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-24-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-24-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-24-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-24-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1873901663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3791646090',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00003 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00004 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00005 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => 'rif0(192.168.100.9)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.9',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '961465250',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1209642666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1f:91:50',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '88321595',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '151826622',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102001',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102002',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102102',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10200201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:db:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '6074133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10210201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c6:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '110875740',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit300-48.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',
            SNMPHOSTNAME => 'xtc13',
            MAC          => '00:04:96:1c:71:00',
            MODEL        => 'Summit 300-48',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',
            SNMPHOSTNAME => 'xtc13',
            MAC          => '00:04:96:1c:71:00',
            MODEL        => 'Summit 300-48',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 300-48',
                COMMENTS     => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtc13',
                LOCATION     => 'PMF-C13',
                SERIAL       => '04375-00303',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.7',
                        '192.168.254.72',
                    ],
                },
                MAC          => '00:04:96:1c:71:00',
                UPTIME       => '(447912326) 51 days, 20:12:03.26',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-48-Port 1001',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-48-Port 1002',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-48-Port 1003',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-48-Port 1004',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-48-Port 1005',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-48-Port 1006',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-48-Port 1007',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-48-Port 1008',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-48-Port 1009',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-48-Port 1010',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-48-Port 1011',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-48-Port 1012',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-48-Port 1013',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308730300) 35 days, 17:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14633490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '82988466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-48-Port 1014',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-48-Port 1015',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '340563827',
                        IFINERRORS       => '36',
                        IFOUTOCTETS      => '902415639',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-48-Port 1016',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3451688747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2978718322',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-48-Port 1017',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '30201160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-48-Port 1018',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-48-Port 1019',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-48-Port 1020',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9321530',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '163047911',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-48-Port 1021',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-48-Port 1022',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '366181779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2017260163',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-48-Port 1023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '35813197',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-48-Port 1024',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-48-Port 1025',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1567036194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244268335',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-48-Port 1026',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344904218',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4274000019',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit300-48-Port 1027',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107698894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1886542214',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit300-48-Port 1028',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit300-48-Port 1029',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit300-48-Port 1030',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit300-48-Port 1031',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '455443615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3361567846',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit300-48-Port 1032',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit300-48-Port 1033',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387283800) 44 days, 19:47:18.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19697501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419051189',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit300-48-Port 1034',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386086800) 44 days, 16:27:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10642349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1816803734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit300-48-Port 1035',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(419246300) 48 days, 12:34:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1096580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '210538077',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit300-48-Port 1036',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '293670410',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490433860',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit300-48-Port 1037',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '879558887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957696033',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit300-48-Port 1038',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit300-48-Port 1039',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4012106340',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4081915479',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit300-48-Port 1040',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit300-48-Port 1041',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432490800) 50 days, 1:21:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1799874401',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '811762229',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit300-48-Port 1042',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385836200) 44 days, 15:46:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '220132478',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '930468204',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit300-48-Port 1043',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17900) 0:02:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '122893507',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '359332156',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit300-48-Port 1044',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432489600) 50 days, 1:21:36.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2463779142',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '3044537282',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit300-48-Port 1045',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18100) 0:03:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '120048887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366798786',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit300-48-Port 1046',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit300-48-Port 1047',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit300-48-Port 1048',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit300-48-Port 1049',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit300-48-Port 1050',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => '1/51',
                        IFDESCR          => 'Summit300-48-Port 1051',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1052',
                        IFNAME           => '1/52',
                        IFDESCR          => 'Summit300-48-Port 1052',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1882067774',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '821330010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20002',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20003',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20004',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20006',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20007',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20008',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20009',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20010',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00005 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20011',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20012',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00006 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20013',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20014',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00007 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20015',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20016',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00008 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20017',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20018',
                        IFNAME           => 'pmf-miage',
                        IFDESCR          => 'VLAN 00009 (pmf-miage)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20019',
                        IFNAME           => '802.1Q Encapsulation Tag 0202',
                        IFDESCR          => '802.1Q Encapsulation Tag 0202',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20020',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20021',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20022',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00011 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20023',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20024',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00012 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20026',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00013 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20027',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20028',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20029',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20030',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20031',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20032',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20033',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20034',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20035',
                        IFNAME           => 'rif0(192.168.100.7)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.7',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1025541138',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '141678777',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20036',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '259451632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '424189761',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104201',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104202',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104301',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104302',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104501',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104502',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 300-48',
                COMMENTS     => 'Summit300-48 - Version 7.4e.2 (Build 6) by Release_Master 09/13/05 12:44:51',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtc13',
                LOCATION     => 'PMF-C13',
                SERIAL       => '04375-00303',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.7',
                        '192.168.254.72',
                    ],
                },
                MAC          => '00:04:96:1c:71:00',
                UPTIME       => '(447912326) 51 days, 20:12:03.26',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit300-48-Port 1001',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit300-48-Port 1002',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit300-48-Port 1003',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit300-48-Port 1004',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit300-48-Port 1005',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit300-48-Port 1006',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit300-48-Port 1007',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit300-48-Port 1008',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit300-48-Port 1009',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit300-48-Port 1010',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit300-48-Port 1011',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit300-48-Port 1012',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit300-48-Port 1013',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(308730300) 35 days, 17:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14633490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '82988466',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit300-48-Port 1014',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit300-48-Port 1015',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '340563827',
                        IFINERRORS       => '36',
                        IFOUTOCTETS      => '902415639',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit300-48-Port 1016',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3451688747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2978718322',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit300-48-Port 1017',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '30201160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit300-48-Port 1018',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit300-48-Port 1019',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit300-48-Port 1020',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9321530',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '163047911',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit300-48-Port 1021',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit300-48-Port 1022',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '366181779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2017260163',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit300-48-Port 1023',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '35813197',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit300-48-Port 1024',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit300-48-Port 1025',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1567036194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244268335',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit300-48-Port 1026',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344904218',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4274000019',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit300-48-Port 1027',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107698894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1886542214',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit300-48-Port 1028',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit300-48-Port 1029',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit300-48-Port 1030',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit300-48-Port 1031',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '455443615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3361567846',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit300-48-Port 1032',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit300-48-Port 1033',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387283800) 44 days, 19:47:18.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19697501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419051189',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit300-48-Port 1034',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386086800) 44 days, 16:27:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10642349',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1816803734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit300-48-Port 1035',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(419246300) 48 days, 12:34:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1096580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '210538077',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit300-48-Port 1036',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '293670410',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490433860',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit300-48-Port 1037',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '879558887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2957696033',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit300-48-Port 1038',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit300-48-Port 1039',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4012106340',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4081915479',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit300-48-Port 1040',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit300-48-Port 1041',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432490800) 50 days, 1:21:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1799874401',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '811762229',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit300-48-Port 1042',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385836200) 44 days, 15:46:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '220132478',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '930468204',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit300-48-Port 1043',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(17900) 0:02:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '122893507',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '359332156',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit300-48-Port 1044',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(432489600) 50 days, 1:21:36.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2463779142',
                        IFINERRORS       => '51740',
                        IFOUTOCTETS      => '3044537282',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit300-48-Port 1045',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(18100) 0:03:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '120048887',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366798786',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit300-48-Port 1046',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit300-48-Port 1047',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit300-48-Port 1048',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit300-48-Port 1049',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit300-48-Port 1050',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => '1/51',
                        IFDESCR          => 'Summit300-48-Port 1051',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '1052',
                        IFNAME           => '1/52',
                        IFDESCR          => 'Summit300-48-Port 1052',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1700) 0:00:17.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1882067774',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '821330010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20002',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20003',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20004',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20006',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20007',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20008',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20009',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20010',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00005 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20011',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20012',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00006 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20013',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20014',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00007 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20015',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20016',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00008 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20017',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20018',
                        IFNAME           => 'pmf-miage',
                        IFDESCR          => 'VLAN 00009 (pmf-miage)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20019',
                        IFNAME           => '802.1Q Encapsulation Tag 0202',
                        IFDESCR          => '802.1Q Encapsulation Tag 0202',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20020',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20021',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20022',
                        IFNAME           => 'pmf-sans-fil',
                        IFDESCR          => 'VLAN 00011 (pmf-sans-fil)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20023',
                        IFNAME           => '802.1Q Encapsulation Tag 0250',
                        IFDESCR          => '802.1Q Encapsulation Tag 0250',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20024',
                        IFNAME           => 'wlan-mgmt',
                        IFDESCR          => 'VLAN 00012 (wlan-mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20026',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00013 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20027',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20028',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20029',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20030',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20031',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20032',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20033',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20034',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20035',
                        IFNAME           => 'rif0(192.168.100.7)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.7',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1025541138',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '141678777',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20036',
                        IFNAME           => 'rif1(192.168.254.72)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.254.72',
                        MAC              => '00:04:96:1c:71:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '259451632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '424189761',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104201',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104202',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104301',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104302',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104501',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104502',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10420201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:c9:40',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66083659',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10430201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0c:f6:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '5820625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450101',
                        IFDESCR          => 'Wireless Interface 1: (802.11a)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10450201',
                        IFDESCR          => 'Wireless Interface 2: (802.11g)',
                        IFTYPE           => '71',
                        IFSPEED          => '54000000',
                        IFMTU            => '1596',
                        MAC              => '00:04:96:0d:bd:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3985693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit400-48t.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',
            SNMPHOSTNAME => 'xtc6',
            MAC          => '00:04:96:18:5b:61',
            MODEL        => 'Summit 400-48t',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',
            SNMPHOSTNAME => 'xtc6',
            MAC          => '00:04:96:18:5b:61',
            MODEL        => 'Summit 400-48t',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 400-48t',
                COMMENTS     => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtc6',
                LOCATION     => 'PMF - C6',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.5',
                    ],
                },
                MAC          => '00:04:96:18:5b:61',
                UPTIME       => '(364479986) 42 days, 4:26:39.86',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit400-48t-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit400-48t-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177076017',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3652478286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit400-48t-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1400) 0:00:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1757545224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849416595',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit400-48t-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(165095600) 19 days, 2:35:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2083495287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4110289924',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit400-48t-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit400-48t-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '402377290',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2266130369',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit400-48t-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '194026273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '846580434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit400-48t-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(20400) 0:03:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3425221527',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '773258660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit400-48t-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4281783881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4208070991',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit400-48t-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3438567034',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1202698565',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit400-48t-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit400-48t-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit400-48t-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit400-48t-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1596263611',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3251459626',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit400-48t-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '984958090',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3738069952',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit400-48t-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(337605300) 39 days, 1:47:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2028971',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118153031',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit400-48t-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38451479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '463318268',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit400-48t-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361680000) 41 days, 20:40:00.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8151757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '149331863',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit400-48t-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit400-48t-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3375401911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4264022983',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit400-48t-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit400-48t-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit400-48t-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6200) 0:01:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '181144241',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1366823973',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit400-48t-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4036993988',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1391749109',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit400-48t-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14110199',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '280764922',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit400-48t-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '251246470',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '192052830',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit400-48t-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364258200) 42 days, 3:49:42.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '370319219',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2628467813',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit400-48t-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4092542623',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '2426553853',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit400-48t-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit400-48t-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361620200) 41 days, 20:30:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81868301',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1139156676',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit400-48t-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2981615086',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1290225290',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit400-48t-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266569100) 30 days, 20:28:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376042996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1545759053',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit400-48t-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '646142851',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3441094674',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit400-48t-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(206567100) 23 days, 21:47:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5251689',
                        IFINERRORS       => '30',
                        IFOUTOCTETS      => '1475347312',
                        IFOUTERRORS      => '1',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit400-48t-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267443600) 30 days, 22:53:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8237991',
                        IFINERRORS       => '27',
                        IFOUTOCTETS      => '1482614003',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit400-48t-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266725600) 30 days, 20:54:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9165307',
                        IFINERRORS       => '29',
                        IFOUTOCTETS      => '1543895387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit400-48t-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit400-48t-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1296461',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1420896038',
                        IFOUTERRORS      => '4454605',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit400-48t-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266614100) 30 days, 20:35:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34427684',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '694437068',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit400-48t-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit400-48t-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit400-48t-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '195782904',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '2059780991',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit400-48t-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit400-48t-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit400-48t-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364114700) 42 days, 3:25:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '20222139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '114709844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit400-48t-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit400-48t-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361729400) 41 days, 20:48:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '77001898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '201455837',
                        IFOUTERRORS      => '17318',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit400-48t-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361808700) 41 days, 21:01:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174016118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362316793',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit400-48t-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit400-48t-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '51',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFALIAS          => 'MgmtPort',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'Mgmt',
                        IFDESCR          => 'VLAN 00003 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => '802.1Q Encapsulation Tag 4093',
                        IFDESCR          => '802.1Q Encapsulation Tag 4093',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00004 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00005 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00006 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00007 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00008 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00009 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00011 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00012 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00013 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00014 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00015 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'pmf-crous-monetique',
                        IFDESCR          => 'VLAN 00017 (pmf-crous-monetique)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 0298',
                        IFDESCR          => '802.1Q Encapsulation Tag 0298',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-lan-ls',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFNAME           => '802.1Q Encapsulation Tag 1020',
                        IFDESCR          => '802.1Q Encapsulation Tag 1020',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00019 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00020 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-invites',
                        IFDESCR          => 'VLAN 00021 (pmf-invites)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFNAME           => '802.1Q Encapsulation Tag 0232',
                        IFDESCR          => '802.1Q Encapsulation Tag 0232',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => 'pmf-sap-install',
                        IFDESCR          => 'VLAN 00022 (pmf-sap-install)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => '802.1Q Encapsulation Tag 1040',
                        IFDESCR          => '802.1Q Encapsulation Tag 1040',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFNAME           => 'pmf-mz-priv',
                        IFDESCR          => 'VLAN 00023 (pmf-mz-priv)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1013',
                        IFDESCR          => '802.1Q Encapsulation Tag 1013',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'mse-lan-td',
                        IFDESCR          => 'VLAN 00024 (mse-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFNAME           => '802.1Q Encapsulation Tag 1117',
                        IFDESCR          => '802.1Q Encapsulation Tag 1117',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00025 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFNAME           => 'pmf-lan-sap',
                        IFDESCR          => 'VLAN 00026 (pmf-lan-sap)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1011',
                        IFDESCR          => '802.1Q Encapsulation Tag 1011',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'pmf-crous-bornes',
                        IFDESCR          => 'VLAN 00027 (pmf-crous-bornes)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFNAME           => '802.1Q Encapsulation Tag 0297',
                        IFDESCR          => '802.1Q Encapsulation Tag 0297',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00028 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFNAME           => 'rif0(192.168.100.5)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.5',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1054022658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '67451927',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 400-48t',
                COMMENTS     => 'Summit400-48t - Version 7.2e.1 (Build 10) by Release_Master 03/26/04 18:29:56',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtc6',
                LOCATION     => 'PMF - C6',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.5',
                    ],
                },
                MAC          => '00:04:96:18:5b:61',
                UPTIME       => '(364479986) 42 days, 4:26:39.86',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit400-48t-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit400-48t-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177076017',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3652478286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit400-48t-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1400) 0:00:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1757545224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849416595',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit400-48t-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(165095600) 19 days, 2:35:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2083495287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4110289924',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit400-48t-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit400-48t-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '402377290',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2266130369',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit400-48t-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '194026273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '846580434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit400-48t-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(20400) 0:03:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3425221527',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '773258660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit400-48t-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4281783881',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4208070991',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit400-48t-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3438567034',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1202698565',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit400-48t-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit400-48t-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit400-48t-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit400-48t-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1596263611',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3251459626',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit400-48t-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '984958090',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3738069952',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit400-48t-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(337605300) 39 days, 1:47:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2028971',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118153031',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit400-48t-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38451479',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '463318268',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit400-48t-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361680000) 41 days, 20:40:00.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8151757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '149331863',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit400-48t-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit400-48t-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3375401911',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4264022983',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit400-48t-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit400-48t-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit400-48t-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6200) 0:01:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '181144241',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1366823973',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit400-48t-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1300) 0:00:13.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4036993988',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1391749109',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit400-48t-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14110199',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '280764922',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit400-48t-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '251246470',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '192052830',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit400-48t-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364258200) 42 days, 3:49:42.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '370319219',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2628467813',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit400-48t-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4092542623',
                        IFINERRORS       => '9',
                        IFOUTOCTETS      => '2426553853',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit400-48t-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit400-48t-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361620200) 41 days, 20:30:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81868301',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1139156676',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit400-48t-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2981615086',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1290225290',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit400-48t-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266569100) 30 days, 20:28:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376042996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1545759053',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit400-48t-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '646142851',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '3441094674',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit400-48t-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(206567100) 23 days, 21:47:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5251689',
                        IFINERRORS       => '30',
                        IFOUTOCTETS      => '1475347312',
                        IFOUTERRORS      => '1',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit400-48t-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267443600) 30 days, 22:53:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8237991',
                        IFINERRORS       => '27',
                        IFOUTOCTETS      => '1482614003',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit400-48t-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266725600) 30 days, 20:54:16.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9165307',
                        IFINERRORS       => '29',
                        IFOUTOCTETS      => '1543895387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit400-48t-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit400-48t-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1296461',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1420896038',
                        IFOUTERRORS      => '4454605',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit400-48t-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266614100) 30 days, 20:35:41.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34427684',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '694437068',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit400-48t-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit400-48t-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit400-48t-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1200) 0:00:12.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '195782904',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '2059780991',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit400-48t-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit400-48t-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit400-48t-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(364114700) 42 days, 3:25:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '20222139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '114709844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit400-48t-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit400-48t-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361729400) 41 days, 20:48:14.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '77001898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '201455837',
                        IFOUTERRORS      => '17318',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit400-48t-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361808700) 41 days, 21:01:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '174016118',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362316793',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit400-48t-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit400-48t-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1000) 0:00:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '51',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFALIAS          => 'MgmtPort',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'Mgmt',
                        IFDESCR          => 'VLAN 00003 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => '802.1Q Encapsulation Tag 4093',
                        IFDESCR          => '802.1Q Encapsulation Tag 4093',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00004 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00005 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00006 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00007 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00008 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00009 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00010 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00011 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00012 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00013 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => 'pmf-ls',
                        IFDESCR          => 'VLAN 00014 (pmf-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => '802.1Q Encapsulation Tag 0204',
                        IFDESCR          => '802.1Q Encapsulation Tag 0204',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00015 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'pmf-crous-monetique',
                        IFDESCR          => 'VLAN 00017 (pmf-crous-monetique)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 0298',
                        IFDESCR          => '802.1Q Encapsulation Tag 0298',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-lan-ls',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-ls)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFNAME           => '802.1Q Encapsulation Tag 1020',
                        IFDESCR          => '802.1Q Encapsulation Tag 1020',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00019 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00020 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-invites',
                        IFDESCR          => 'VLAN 00021 (pmf-invites)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFNAME           => '802.1Q Encapsulation Tag 0232',
                        IFDESCR          => '802.1Q Encapsulation Tag 0232',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => 'pmf-sap-install',
                        IFDESCR          => 'VLAN 00022 (pmf-sap-install)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => '802.1Q Encapsulation Tag 1040',
                        IFDESCR          => '802.1Q Encapsulation Tag 1040',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFNAME           => 'pmf-mz-priv',
                        IFDESCR          => 'VLAN 00023 (pmf-mz-priv)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1013',
                        IFDESCR          => '802.1Q Encapsulation Tag 1013',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'mse-lan-td',
                        IFDESCR          => 'VLAN 00024 (mse-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFNAME           => '802.1Q Encapsulation Tag 1117',
                        IFDESCR          => '802.1Q Encapsulation Tag 1117',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00025 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFNAME           => 'pmf-lan-sap',
                        IFDESCR          => 'VLAN 00026 (pmf-lan-sap)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1011',
                        IFDESCR          => '802.1Q Encapsulation Tag 1011',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'pmf-crous-bornes',
                        IFDESCR          => 'VLAN 00027 (pmf-crous-bornes)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFNAME           => '802.1Q Encapsulation Tag 0297',
                        IFDESCR          => '802.1Q Encapsulation Tag 0297',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00028 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFNAME           => 'rif0(192.168.100.5)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.5',
                        MAC              => '00:04:96:18:5b:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1054022658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '67451927',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit450.01.walk' => [
        {
            MANUFACTURER => 'Extrem Networks',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
            SNMPHOSTNAME => 'sw-bat02',
            MAC          => '00:04:96:34:60:9e',
            MODEL        => 'Summit x450e-48p',
        },
        {
            MANUFACTURER => 'Extrem Networks',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
            SNMPHOSTNAME => 'sw-bat02',
            MAC          => '00:04:96:34:60:9e',
            MODEL        => 'Summit x450e-48p',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extrem Networks',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit x450e-48p',
                COMMENTS     => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
                CONTACT      => 'noc-roc@inria.fr, +33 139 637 959',
                NAME         => 'sw-bat02',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => 'X450e-48p Port 1',
                        IFDESCR          => 'X450e-48p Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10800) 0:01:48.00',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => 'X450e-48p Port 2',
                        IFDESCR          => 'X450e-48p Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => 'X450e-48p Port 3',
                        IFDESCR          => 'X450e-48p Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => 'X450e-48p Port 4',
                        IFDESCR          => 'X450e-48p Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10600) 0:01:46.00',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => 'X450e-48p Port 5',
                        IFDESCR          => 'X450e-48p Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1958246000) 226 days, 15:34:20.00',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => 'X450e-48p Port 6',
                        IFDESCR          => 'X450e-48p Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => 'X450e-48p Port 7',
                        IFDESCR          => 'X450e-48p Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961084300) 226 days, 23:27:23.00',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => 'X450e-48p Port 8',
                        IFDESCR          => 'X450e-48p Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => 'X450e-48p Port 9',
                        IFDESCR          => 'X450e-48p Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961570100) 227 days, 0:48:21.00',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => 'X450e-48p Port 10',
                        IFDESCR          => 'X450e-48p Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => 'X450e-48p Port 11',
                        IFDESCR          => 'X450e-48p Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962199100) 227 days, 2:33:11.00',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => 'X450e-48p Port 12',
                        IFDESCR          => 'X450e-48p Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => 'X450e-48p Port 13',
                        IFDESCR          => 'X450e-48p Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1870264000) 216 days, 11:10:40.00',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => 'X450e-48p Port 14',
                        IFDESCR          => 'X450e-48p Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961002500) 226 days, 23:13:45.00',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => 'X450e-48p Port 15',
                        IFDESCR          => 'X450e-48p Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962148000) 227 days, 2:24:40.00',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => 'X450e-48p Port 16',
                        IFDESCR          => 'X450e-48p Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1860839400) 215 days, 8:59:54.00',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => 'X450e-48p Port 17',
                        IFDESCR          => 'X450e-48p Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => 'X450e-48p Port 18',
                        IFDESCR          => 'X450e-48p Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1937979600) 224 days, 7:16:36.00',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => 'X450e-48p Port 19',
                        IFDESCR          => 'X450e-48p Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1938610300) 224 days, 9:01:43.00',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => 'X450e-48p Port 20',
                        IFDESCR          => 'X450e-48p Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962433800) 227 days, 3:12:18.00',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => 'X450e-48p Port 21',
                        IFDESCR          => 'X450e-48p Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => 'X450e-48p Port 22',
                        IFDESCR          => 'X450e-48p Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => 'X450e-48p Port 23',
                        IFDESCR          => 'X450e-48p Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => 'X450e-48p Port 24',
                        IFDESCR          => 'X450e-48p Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => 'X450e-48p Port 25',
                        IFDESCR          => 'X450e-48p Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => 'X450e-48p Port 26',
                        IFDESCR          => 'X450e-48p Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => 'X450e-48p Port 27',
                        IFDESCR          => 'X450e-48p Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => 'X450e-48p Port 28',
                        IFDESCR          => 'X450e-48p Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => 'X450e-48p Port 29',
                        IFDESCR          => 'X450e-48p Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => 'X450e-48p Port 30',
                        IFDESCR          => 'X450e-48p Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => 'X450e-48p Port 31',
                        IFDESCR          => 'X450e-48p Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => 'X450e-48p Port 32',
                        IFDESCR          => 'X450e-48p Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => 'X450e-48p Port 33',
                        IFDESCR          => 'X450e-48p Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => 'X450e-48p Port 34',
                        IFDESCR          => 'X450e-48p Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => 'X450e-48p Port 35',
                        IFDESCR          => 'X450e-48p Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => 'X450e-48p Port 36',
                        IFDESCR          => 'X450e-48p Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => 'X450e-48p Port 37',
                        IFDESCR          => 'X450e-48p Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => 'X450e-48p Port 38',
                        IFDESCR          => 'X450e-48p Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => 'X450e-48p Port 39',
                        IFDESCR          => 'X450e-48p Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => 'X450e-48p Port 40',
                        IFDESCR          => 'X450e-48p Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => 'X450e-48p Port 41',
                        IFDESCR          => 'X450e-48p Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => 'X450e-48p Port 42',
                        IFDESCR          => 'X450e-48p Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => 'X450e-48p Port 43',
                        IFDESCR          => 'X450e-48p Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => 'X450e-48p Port 44',
                        IFDESCR          => 'X450e-48p Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => 'X450e-48p Port 45',
                        IFDESCR          => 'X450e-48p Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => 'X450e-48p Port 46',
                        IFDESCR          => 'X450e-48p Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => 'X450e-48p Port 47',
                        IFDESCR          => 'X450e-48p Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => 'X450e-48p Port 48',
                        IFDESCR          => 'X450e-48p Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => 'X450e-48p Port 49',
                        IFDESCR          => 'X450e-48p Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => 'X450e-48p Port 50',
                        IFDESCR          => 'X450e-48p Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000001',
                        IFNAME           => 'VirtualRouter0',
                        IFDESCR          => 'VirtualRouter0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000002',
                        IFNAME           => 'VirtualRouter2',
                        IFDESCR          => 'VirtualRouter2',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000003',
                        IFNAME           => 'VirtualRouter1',
                        IFDESCR          => 'VirtualRouter1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000004',
                        IFNAME           => 'VLAN 00001 (Default)',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000005',
                        IFNAME           => 'VLAN 04095 (Mgmt)',
                        IFDESCR          => 'VLAN 04095 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000006',
                        IFNAME           => 'VLAN 00002 (Admin)',
                        IFDESCR          => 'VLAN 00002 (Admin)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000007',
                        IFNAME           => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFDESCR          => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000008',
                        IFNAME           => 'VLAN 00003 (LAN-ROC)',
                        IFDESCR          => 'VLAN 00003 (LAN-ROC)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000009',
                        IFNAME           => 'VLAN 02432 (ToIP-Avaya)',
                        IFDESCR          => 'VLAN 02432 (ToIP-Avaya)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000010',
                        IFNAME           => 'VLAN 02144 (Guest-Rocq)',
                        IFDESCR          => 'VLAN 02144 (Guest-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000011',
                        IFNAME           => 'VLAN 02176 (VoIP-Rocq)',
                        IFDESCR          => 'VLAN 02176 (VoIP-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000013',
                        IFNAME           => 'rtif(192.168.3.2/21)',
                        IFDESCR          => 'rtif(192.168.3.2/21)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000014',
                        IFNAME           => 'VLAN 02992 (Wifi-Adm)',
                        IFDESCR          => 'VLAN 02992 (Wifi-Adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000015',
                        IFNAME           => 'VLAN 03008 (Wifi-Auth)',
                        IFDESCR          => 'VLAN 03008 (Wifi-Auth)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extrem Networks',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit x450e-48p',
                COMMENTS     => 'ExtremeXOS version 12.4.3.5 v1243b5-patch1-8 by release-manager on Mon Mar 28 13:15:22 PDT 2011',
                CONTACT      => 'noc-roc@inria.fr, +33 139 637 959',
                NAME         => 'sw-bat02',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1001',
                        IFNAME           => 'X450e-48p Port 1',
                        IFDESCR          => 'X450e-48p Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10800) 0:01:48.00',
                    },
                    {
                        IFNUMBER         => '1002',
                        IFNAME           => 'X450e-48p Port 2',
                        IFDESCR          => 'X450e-48p Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1003',
                        IFNAME           => 'X450e-48p Port 3',
                        IFDESCR          => 'X450e-48p Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1004',
                        IFNAME           => 'X450e-48p Port 4',
                        IFDESCR          => 'X450e-48p Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(10600) 0:01:46.00',
                    },
                    {
                        IFNUMBER         => '1005',
                        IFNAME           => 'X450e-48p Port 5',
                        IFDESCR          => 'X450e-48p Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1958246000) 226 days, 15:34:20.00',
                    },
                    {
                        IFNUMBER         => '1006',
                        IFNAME           => 'X450e-48p Port 6',
                        IFDESCR          => 'X450e-48p Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1007',
                        IFNAME           => 'X450e-48p Port 7',
                        IFDESCR          => 'X450e-48p Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961084300) 226 days, 23:27:23.00',
                    },
                    {
                        IFNUMBER         => '1008',
                        IFNAME           => 'X450e-48p Port 8',
                        IFDESCR          => 'X450e-48p Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1009',
                        IFNAME           => 'X450e-48p Port 9',
                        IFDESCR          => 'X450e-48p Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961570100) 227 days, 0:48:21.00',
                    },
                    {
                        IFNUMBER         => '1010',
                        IFNAME           => 'X450e-48p Port 10',
                        IFDESCR          => 'X450e-48p Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1011',
                        IFNAME           => 'X450e-48p Port 11',
                        IFDESCR          => 'X450e-48p Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962199100) 227 days, 2:33:11.00',
                    },
                    {
                        IFNUMBER         => '1012',
                        IFNAME           => 'X450e-48p Port 12',
                        IFDESCR          => 'X450e-48p Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1013',
                        IFNAME           => 'X450e-48p Port 13',
                        IFDESCR          => 'X450e-48p Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1870264000) 216 days, 11:10:40.00',
                    },
                    {
                        IFNUMBER         => '1014',
                        IFNAME           => 'X450e-48p Port 14',
                        IFDESCR          => 'X450e-48p Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1961002500) 226 days, 23:13:45.00',
                    },
                    {
                        IFNUMBER         => '1015',
                        IFNAME           => 'X450e-48p Port 15',
                        IFDESCR          => 'X450e-48p Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962148000) 227 days, 2:24:40.00',
                    },
                    {
                        IFNUMBER         => '1016',
                        IFNAME           => 'X450e-48p Port 16',
                        IFDESCR          => 'X450e-48p Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1860839400) 215 days, 8:59:54.00',
                    },
                    {
                        IFNUMBER         => '1017',
                        IFNAME           => 'X450e-48p Port 17',
                        IFDESCR          => 'X450e-48p Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(9300) 0:01:33.00',
                    },
                    {
                        IFNUMBER         => '1018',
                        IFNAME           => 'X450e-48p Port 18',
                        IFDESCR          => 'X450e-48p Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1937979600) 224 days, 7:16:36.00',
                    },
                    {
                        IFNUMBER         => '1019',
                        IFNAME           => 'X450e-48p Port 19',
                        IFDESCR          => 'X450e-48p Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1938610300) 224 days, 9:01:43.00',
                    },
                    {
                        IFNUMBER         => '1020',
                        IFNAME           => 'X450e-48p Port 20',
                        IFDESCR          => 'X450e-48p Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                        IFLASTCHANGE     => '(1962433800) 227 days, 3:12:18.00',
                    },
                    {
                        IFNUMBER         => '1021',
                        IFNAME           => 'X450e-48p Port 21',
                        IFDESCR          => 'X450e-48p Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1022',
                        IFNAME           => 'X450e-48p Port 22',
                        IFDESCR          => 'X450e-48p Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1023',
                        IFNAME           => 'X450e-48p Port 23',
                        IFDESCR          => 'X450e-48p Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1024',
                        IFNAME           => 'X450e-48p Port 24',
                        IFDESCR          => 'X450e-48p Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1025',
                        IFNAME           => 'X450e-48p Port 25',
                        IFDESCR          => 'X450e-48p Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1026',
                        IFNAME           => 'X450e-48p Port 26',
                        IFDESCR          => 'X450e-48p Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1027',
                        IFNAME           => 'X450e-48p Port 27',
                        IFDESCR          => 'X450e-48p Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1028',
                        IFNAME           => 'X450e-48p Port 28',
                        IFDESCR          => 'X450e-48p Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1029',
                        IFNAME           => 'X450e-48p Port 29',
                        IFDESCR          => 'X450e-48p Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1030',
                        IFNAME           => 'X450e-48p Port 30',
                        IFDESCR          => 'X450e-48p Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1031',
                        IFNAME           => 'X450e-48p Port 31',
                        IFDESCR          => 'X450e-48p Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1032',
                        IFNAME           => 'X450e-48p Port 32',
                        IFDESCR          => 'X450e-48p Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1033',
                        IFNAME           => 'X450e-48p Port 33',
                        IFDESCR          => 'X450e-48p Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1034',
                        IFNAME           => 'X450e-48p Port 34',
                        IFDESCR          => 'X450e-48p Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1035',
                        IFNAME           => 'X450e-48p Port 35',
                        IFDESCR          => 'X450e-48p Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1036',
                        IFNAME           => 'X450e-48p Port 36',
                        IFDESCR          => 'X450e-48p Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1037',
                        IFNAME           => 'X450e-48p Port 37',
                        IFDESCR          => 'X450e-48p Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1038',
                        IFNAME           => 'X450e-48p Port 38',
                        IFDESCR          => 'X450e-48p Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1039',
                        IFNAME           => 'X450e-48p Port 39',
                        IFDESCR          => 'X450e-48p Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1040',
                        IFNAME           => 'X450e-48p Port 40',
                        IFDESCR          => 'X450e-48p Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1041',
                        IFNAME           => 'X450e-48p Port 41',
                        IFDESCR          => 'X450e-48p Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1042',
                        IFNAME           => 'X450e-48p Port 42',
                        IFDESCR          => 'X450e-48p Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1043',
                        IFNAME           => 'X450e-48p Port 43',
                        IFDESCR          => 'X450e-48p Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1044',
                        IFNAME           => 'X450e-48p Port 44',
                        IFDESCR          => 'X450e-48p Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1045',
                        IFNAME           => 'X450e-48p Port 45',
                        IFDESCR          => 'X450e-48p Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1046',
                        IFNAME           => 'X450e-48p Port 46',
                        IFDESCR          => 'X450e-48p Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1047',
                        IFNAME           => 'X450e-48p Port 47',
                        IFDESCR          => 'X450e-48p Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1048',
                        IFNAME           => 'X450e-48p Port 48',
                        IFDESCR          => 'X450e-48p Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1049',
                        IFNAME           => 'X450e-48p Port 49',
                        IFDESCR          => 'X450e-48p Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1050',
                        IFNAME           => 'X450e-48p Port 50',
                        IFDESCR          => 'X450e-48p Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1051',
                        IFNAME           => 'Management Port',
                        IFDESCR          => 'Management Port',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000001',
                        IFNAME           => 'VirtualRouter0',
                        IFDESCR          => 'VirtualRouter0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000002',
                        IFNAME           => 'VirtualRouter2',
                        IFDESCR          => 'VirtualRouter2',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000003',
                        IFNAME           => 'VirtualRouter1',
                        IFDESCR          => 'VirtualRouter1',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                    },
                    {
                        IFNUMBER         => '1000004',
                        IFNAME           => 'VLAN 00001 (Default)',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000005',
                        IFNAME           => 'VLAN 04095 (Mgmt)',
                        IFDESCR          => 'VLAN 04095 (Mgmt)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000006',
                        IFNAME           => 'VLAN 00002 (Admin)',
                        IFDESCR          => 'VLAN 00002 (Admin)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000007',
                        IFNAME           => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFDESCR          => 'VLAN 04002 (Ctrl-Ring-02)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000008',
                        IFNAME           => 'VLAN 00003 (LAN-ROC)',
                        IFDESCR          => 'VLAN 00003 (LAN-ROC)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000009',
                        IFNAME           => 'VLAN 02432 (ToIP-Avaya)',
                        IFDESCR          => 'VLAN 02432 (ToIP-Avaya)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000010',
                        IFNAME           => 'VLAN 02144 (Guest-Rocq)',
                        IFDESCR          => 'VLAN 02144 (Guest-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000011',
                        IFNAME           => 'VLAN 02176 (VoIP-Rocq)',
                        IFDESCR          => 'VLAN 02176 (VoIP-Rocq)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000013',
                        IFNAME           => 'rtif(192.168.3.2/21)',
                        IFDESCR          => 'rtif(192.168.3.2/21)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:04:96:34:60:9e',
                    },
                    {
                        IFNUMBER         => '1000014',
                        IFNAME           => 'VLAN 02992 (Wifi-Adm)',
                        IFDESCR          => 'VLAN 02992 (Wifi-Adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '1000015',
                        IFNAME           => 'VLAN 03008 (Wifi-Auth)',
                        IFDESCR          => 'VLAN 03008 (Wifi-Auth)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.01.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',
            SNMPHOSTNAME => 'xt17t',
            MAC          => '00:01:30:12:a6:d0',
            MODEL        => 'Summit 48si',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',
            SNMPHOSTNAME => 'xt17t',
            MAC          => '00:01:30:12:a6:d0',
            MODEL        => 'Summit 48si',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xt17t',
                LOCATION     => '17-Tolbiac',
                IPS          => {
                    IP => [
                        '10.16.2.72',
                        '127.0.0.1',
                        '192.168.100.11',
                        '194.214.30.129',
                    ],
                },
                MAC          => '00:01:30:12:a6:d0',
                UPTIME       => '(2602571760) 301 days, 5:21:57.60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107135184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107146320',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121872',
                        IFLASTCHANGE     => '(2023887300) 234 days, 5:54:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '555322719',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '795501453',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107118416',
                        IFLASTCHANGE     => '(1030169000) 119 days, 5:34:50.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4437044',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '75757917',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107101648',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089744',
                        IFLASTCHANGE     => '(2567158700) 297 days, 2:59:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '16619775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '689914185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089616',
                        IFLASTCHANGE     => '(1637570900) 189 days, 12:48:29.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '70476207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '933230080',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107108048',
                        IFLASTCHANGE     => '(1711783500) 198 days, 2:57:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '280043059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2123917712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107137488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107104208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107148368',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093072',
                        IFLASTCHANGE     => '(2593175700) 300 days, 3:15:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1021873168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2903530650',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091024',
                        IFLASTCHANGE     => '(2602152900) 301 days, 4:12:09.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3984701198',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '708469827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107119184',
                        IFLASTCHANGE     => '(2504471800) 289 days, 20:51:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54419893',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459626351',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107097936',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107117776',
                        IFLASTCHANGE     => '(2576924400) 298 days, 6:07:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28600172',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '1163884310',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092560',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107143248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128400',
                        IFLASTCHANGE     => '(847306700) 98 days, 1:37:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '52423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4645',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092304',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107134544',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107109584',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107093200',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107088208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107133264',
                        IFLASTCHANGE     => '(1393500600) 161 days, 6:50:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3660274100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2021539045',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113040',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107136720',
                        IFLASTCHANGE     => '(1374511100) 159 days, 2:05:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '483758880',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4033595797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107095504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107103184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107130448',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107107792',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107122512',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113808',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107114064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107112912',
                        IFLASTCHANGE     => '(2602563200) 301 days, 5:20:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1938995348',
                        IFINERRORS       => '127898',
                        IFOUTOCTETS      => '2848850473',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107088592',
                        IFLASTCHANGE     => '(2291987900) 265 days, 6:37:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '158483339',
                        IFINERRORS       => '1510',
                        IFOUTOCTETS      => '807090182',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107128784',
                        IFLASTCHANGE     => '(2587170300) 299 days, 10:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1964612408',
                        IFINERRORS       => '203057',
                        IFOUTOCTETS      => '3552969330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106000',
                        IFLASTCHANGE     => '(2587167200) 299 days, 10:34:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '890047339',
                        IFINERRORS       => '203121',
                        IFOUTOCTETS      => '299457870',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106640',
                        IFLASTCHANGE     => '(2587172300) 299 days, 10:35:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1134037961',
                        IFINERRORS       => '203047',
                        IFOUTOCTETS      => '3687889861',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107099088',
                        IFLASTCHANGE     => '(2587168300) 299 days, 10:34:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1644450430',
                        IFINERRORS       => '203127',
                        IFOUTOCTETS      => '561681042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128144',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091536',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107105744',
                        IFLASTCHANGE     => '(2505373100) 289 days, 23:22:11.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2856331',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2824421182',
                        IFOUTERRORS      => '80',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107143760',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3778367721',
                        IFINERRORS       => '74628326',
                        IFOUTOCTETS      => '1616287003',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098960',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 51',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107141328',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107118928',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107094992',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'tolbiac-17',
                        IFDESCR          => 'VLAN 00003 (tolbiac-17)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107103056',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 't17-borne-sf',
                        IFDESCR          => 'VLAN 00004 (t17-borne-sf)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107151952',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 1602',
                        IFDESCR          => '802.1Q Encapsulation Tag 1602',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107150416',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121744',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '33172',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107145936',
                        IFLASTCHANGE     => '(1730752000) 200 days, 7:38:40.00',
                        IFINOCTETS       => '2280',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '213',
                        IFNAME           => 'rif0(192.168.100.11)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.11',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107146832',
                        IFLASTCHANGE     => '(2602574100) 301 days, 5:22:21.00',
                        IFINOCTETS       => '2444465160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581136371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '214',
                        IFNAME           => 'rif1(194.214.30.129)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '194.214.30.129',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093840',
                        IFLASTCHANGE     => '(2602568600) 301 days, 5:21:26.00',
                        IFINOCTETS       => '445450310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '102905561',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '215',
                        IFNAME           => 'rif2(10.16.2.72)',
                        IFDESCR          => 'rif2',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '10.16.2.72',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107129168',
                        IFLASTCHANGE     => '(2602574000) 301 days, 5:22:20.00',
                        IFINOCTETS       => '703779036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '251147751',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.0 (Build 61) by Release_Master 12/02/04 14:27:36',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xt17t',
                LOCATION     => '17-Tolbiac',
                IPS          => {
                    IP => [
                        '10.16.2.72',
                        '127.0.0.1',
                        '192.168.100.11',
                        '194.214.30.129',
                    ],
                },
                MAC          => '00:01:30:12:a6:d0',
                UPTIME       => '(2602571760) 301 days, 5:21:57.60',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107135184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107146320',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121872',
                        IFLASTCHANGE     => '(2023887300) 234 days, 5:54:33.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '555322719',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '795501453',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107118416',
                        IFLASTCHANGE     => '(1030169000) 119 days, 5:34:50.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4437044',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '75757917',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107101648',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089744',
                        IFLASTCHANGE     => '(2567158700) 297 days, 2:59:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '16619775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '689914185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089616',
                        IFLASTCHANGE     => '(1637570900) 189 days, 12:48:29.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '70476207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '933230080',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107108048',
                        IFLASTCHANGE     => '(1711783500) 198 days, 2:57:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '280043059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2123917712',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107137488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107104208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107148368',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093072',
                        IFLASTCHANGE     => '(2593175700) 300 days, 3:15:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1021873168',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2903530650',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091024',
                        IFLASTCHANGE     => '(2602152900) 301 days, 4:12:09.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '3984701198',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '708469827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107119184',
                        IFLASTCHANGE     => '(2504471800) 289 days, 20:51:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54419893',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459626351',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107097936',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107117776',
                        IFLASTCHANGE     => '(2576924400) 298 days, 6:07:24.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28600172',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '1163884310',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092560',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107143248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128400',
                        IFLASTCHANGE     => '(847306700) 98 days, 1:37:47.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '52423',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4645',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107092304',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127248',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107134544',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107109584',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107093200',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107088208',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107133264',
                        IFLASTCHANGE     => '(1393500600) 161 days, 6:50:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3660274100',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2021539045',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113040',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107136720',
                        IFLASTCHANGE     => '(1374511100) 159 days, 2:05:11.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '483758880',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4033595797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107095504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107103184',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107130448',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107107792',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107127504',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107122512',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107113808',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107114064',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107089488',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107112912',
                        IFLASTCHANGE     => '(2602563200) 301 days, 5:20:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1938995348',
                        IFINERRORS       => '127898',
                        IFOUTOCTETS      => '2848850473',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107088592',
                        IFLASTCHANGE     => '(2291987900) 265 days, 6:37:59.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '158483339',
                        IFINERRORS       => '1510',
                        IFOUTOCTETS      => '807090182',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107128784',
                        IFLASTCHANGE     => '(2587170300) 299 days, 10:35:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1964612408',
                        IFINERRORS       => '203057',
                        IFOUTOCTETS      => '3552969330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106000',
                        IFLASTCHANGE     => '(2587167200) 299 days, 10:34:32.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '890047339',
                        IFINERRORS       => '203121',
                        IFOUTOCTETS      => '299457870',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107106640',
                        IFLASTCHANGE     => '(2587172300) 299 days, 10:35:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1134037961',
                        IFINERRORS       => '203047',
                        IFOUTOCTETS      => '3687889861',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107099088',
                        IFLASTCHANGE     => '(2587168300) 299 days, 10:34:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1644450430',
                        IFINERRORS       => '203127',
                        IFOUTOCTETS      => '561681042',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107128144',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107091536',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107105744',
                        IFLASTCHANGE     => '(2505373100) 289 days, 23:22:11.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2856331',
                        IFINERRORS       => '6',
                        IFOUTOCTETS      => '2824421182',
                        IFOUTERRORS      => '80',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107143760',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3778367721',
                        IFINERRORS       => '74628326',
                        IFOUTOCTETS      => '1616287003',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107098960',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 51',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107141328',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107118928',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107094992',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'tolbiac-17',
                        IFDESCR          => 'VLAN 00003 (tolbiac-17)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107103056',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 't17-borne-sf',
                        IFDESCR          => 'VLAN 00004 (t17-borne-sf)',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107151952',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 1602',
                        IFDESCR          => '802.1Q Encapsulation Tag 1602',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107150416',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '-2107121744',
                        IFLASTCHANGE     => '(2133081072) 246 days, 21:13:30.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '33172',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107145936',
                        IFLASTCHANGE     => '(1730752000) 200 days, 7:38:40.00',
                        IFINOCTETS       => '2280',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '213',
                        IFNAME           => 'rif0(192.168.100.11)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.11',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107146832',
                        IFLASTCHANGE     => '(2602574100) 301 days, 5:22:21.00',
                        IFINOCTETS       => '2444465160',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581136371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '214',
                        IFNAME           => 'rif1(194.214.30.129)',
                        IFDESCR          => 'rif1',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '194.214.30.129',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107093840',
                        IFLASTCHANGE     => '(2602568600) 301 days, 5:21:26.00',
                        IFINOCTETS       => '445450310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '102905561',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '215',
                        IFNAME           => 'rif2(10.16.2.72)',
                        IFDESCR          => 'rif2',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '10.16.2.72',
                        MAC              => '00:01:30:12:a6:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '-2107129168',
                        IFLASTCHANGE     => '(2602574000) 301 days, 5:22:20.00',
                        IFINOCTETS       => '703779036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '251147751',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.02.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',
            SNMPHOSTNAME => 'xta6',
            MAC          => '00:01:30:12:a6:c0',
            MODEL        => 'Summit 48si',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',
            SNMPHOSTNAME => 'xta6',
            MAC          => '00:01:30:12:a6:c0',
            MODEL        => 'Summit 48si',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xta6',
                LOCATION     => 'PMF-A6',
                SERIAL       => '0312R-01206',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.3',
                    ],
                },
                MAC          => '00:01:30:12:a6:c0',
                UPTIME       => '(447894395) 51 days, 20:09:03.95',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5577500) 15:29:35.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1619650',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2789577159',
                        IFOUTERRORS      => '23',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(350179000) 40 days, 12:43:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3028756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729930085',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2532935211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3912579530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387813900) 44 days, 21:15:39.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8391335',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '618557153',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446784500) 51 days, 17:04:05.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '129458',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '525200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(377218000) 43 days, 15:49:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '137218196',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2313678216',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324724500) 37 days, 14:00:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '580596016',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1079484795',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324790300) 37 days, 14:11:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1714894688',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '252210557',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446890600) 51 days, 17:21:46.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '148196113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3050431762',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361540800) 41 days, 20:16:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3692887776',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3079207077',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1948024927',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3518623546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4164965589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926530949',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(351027400) 40 days, 15:04:34.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '461945',
                        IFINERRORS       => '5',
                        IFOUTOCTETS      => '838425',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431146100) 49 days, 21:37:41.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2294005345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2315857880',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2089190',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36973571',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(298110400) 34 days, 12:05:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '98806572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608258231',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '25288269',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419189697',
                        IFOUTERRORS      => '513',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447703300) 51 days, 19:37:13.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '94166742',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1028880306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26791553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '648042090',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '12958006',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '747534797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '94904184',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3531347771',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '817778670',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '484811170',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9870825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '723271546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447864800) 51 days, 20:04:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352911303',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1902397373',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2939363508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1539479146',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00007 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00008 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00009 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00010 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00011 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00012 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00013 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'pmf-lan-periph',
                        IFDESCR          => 'VLAN 00014 (pmf-lan-periph)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => '802.1Q Encapsulation Tag 1030',
                        IFDESCR          => '802.1Q Encapsulation Tag 1030',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'rif0(192.168.100.3)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.3',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1212371217',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123275965',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.3.2 (Build 3) by Release_Master 02/21/05 16:35:08',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xta6',
                LOCATION     => 'PMF-A6',
                SERIAL       => '0312R-01206',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.3',
                    ],
                },
                MAC          => '00:01:30:12:a6:c0',
                UPTIME       => '(447894395) 51 days, 20:09:03.95',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5577500) 15:29:35.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1619650',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '2789577159',
                        IFOUTERRORS      => '23',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(350179000) 40 days, 12:43:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3028756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729930085',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2532935211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3912579530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387813900) 44 days, 21:15:39.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '8391335',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '618557153',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446784500) 51 days, 17:04:05.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '129458',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '525200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(377218000) 43 days, 15:49:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '137218196',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2313678216',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324724500) 37 days, 14:00:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '580596016',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1079484795',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324790300) 37 days, 14:11:43.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1714894688',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '252210557',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446890600) 51 days, 17:21:46.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '148196113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3050431762',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(361540800) 41 days, 20:16:48.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3692887776',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3079207077',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1948024927',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3518623546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4164965589',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '926530949',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(351027400) 40 days, 15:04:34.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '461945',
                        IFINERRORS       => '5',
                        IFOUTOCTETS      => '838425',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431146100) 49 days, 21:37:41.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '2294005345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2315857880',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2089190',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36973571',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(298110400) 34 days, 12:05:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '98806572',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608258231',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '25288269',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3419189697',
                        IFOUTERRORS      => '513',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447703300) 51 days, 19:37:13.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '94166742',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1028880306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500) 0:00:05.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26791553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '648042090',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '12958006',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '747534797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '94904184',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3531347771',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(600) 0:00:06.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '817778670',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '484811170',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324750100) 37 days, 14:05:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9870825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '723271546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447864800) 51 days, 20:04:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352911303',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1902397373',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2939363508',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1539479146',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '53',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '56',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '59',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '62',
                        IFNAME           => 'pmf-bup1pub',
                        IFDESCR          => 'VLAN 00007 (pmf-bup1pub)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0221',
                        IFDESCR          => '802.1Q Encapsulation Tag 0221',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00008 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00009 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00010 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00011 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00012 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFNAME           => 'pmf-sip',
                        IFDESCR          => 'VLAN 00013 (pmf-sip)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0201',
                        IFDESCR          => '802.1Q Encapsulation Tag 0201',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'pmf-lan-periph',
                        IFDESCR          => 'VLAN 00014 (pmf-lan-periph)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFNAME           => '802.1Q Encapsulation Tag 1030',
                        IFDESCR          => '802.1Q Encapsulation Tag 1030',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFNAME           => 'rif0(192.168.100.3)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.3',
                        MAC              => '00:01:30:12:a6:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1212371217',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123275965',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'extreme/summit48si.03.walk' => [
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',
            SNMPHOSTNAME => 'xtb12-1',
            MAC          => '00:01:30:12:91:80',
            MODEL        => 'Summit 48si',
        },
        {
            MANUFACTURER => 'Extreme',
            TYPE         => 'NETWORKING',
            DESCRIPTION  => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',
            SNMPHOSTNAME => 'xtb12-1',
            MAC          => '00:01:30:12:91:80',
            MODEL        => 'Summit 48si',
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtb12-1',
                LOCATION     => 'PMF-B12',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.6',
                    ],
                },
                MAC          => '00:01:30:12:91:80',
                UPTIME       => '(447894875) 51 days, 20:09:08.75',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438798800) 50 days, 18:53:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51459175',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '624206988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13645608',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1165108025',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438949800) 50 days, 19:18:18.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '10359391',
                        IFINERRORS       => '11883',
                        IFOUTOCTETS      => '791491706',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(360574500) 41 days, 17:35:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9519747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8043603',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447869200) 51 days, 20:04:52.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '17630567',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1347982097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445694100) 51 days, 14:02:21.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90949422',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '844686721',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446153300) 51 days, 15:18:53.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644817930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '98726208',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2960876979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3776225281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(444947800) 51 days, 11:57:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '316906751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2620095600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732175943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2495978711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422093300) 48 days, 20:28:53.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4262916',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '20491664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438784000) 50 days, 18:50:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15887247',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323560384',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431377500) 49 days, 22:16:15.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '298253440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3211959663',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438152300) 50 days, 17:05:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '44479918',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '583219117',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6900) 0:01:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177442977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1775635520',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292477000) 33 days, 20:26:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36593901',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476315387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438778900) 50 days, 18:49:49.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37910746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '495726371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438785100) 50 days, 18:50:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39504370',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '533393140',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292476100) 33 days, 20:26:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36161125',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '475876102',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(116590300) 13 days, 11:51:43.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '15952459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154152485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445049400) 51 days, 12:14:54.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '175358663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1084311319',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1471169108',
                        IFINERRORS       => '150994',
                        IFOUTOCTETS      => '2820742352',
                        IFOUTERRORS      => '1661377',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438422700) 50 days, 17:50:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '84056914',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '871927228',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2600) 0:00:26.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '11109366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1801736449',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421202059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1285712057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445050700) 51 days, 12:15:07.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1431954',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361041589',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10394538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1733056324',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(315813900) 36 days, 13:15:39.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '110830791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '496907920',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446920000) 51 days, 17:26:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21310051',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '121889157',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424134400) 49 days, 2:09:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3137600162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '733909303',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00007 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00008 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00009 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00010 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00011 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00012 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00013 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00017 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => 'rif0(192.168.100.6)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.6',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1192161775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83712995',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
        {
            INFO => {
                ID           => undef,
                MANUFACTURER => 'Extreme',
                TYPE         => 'NETWORKING',
                MODEL        => 'Summit 48si',
                COMMENTS     => 'Summit48si - Version 7.0.1 (Build 11) by Release_Master 03/28/03 02:09:23',
                CONTACT      => 'support@extremenetworks.com, +1 888 257 3000',
                NAME         => 'xtb12-1',
                LOCATION     => 'PMF-B12',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '192.168.100.6',
                    ],
                },
                MAC          => '00:01:30:12:91:80',
                UPTIME       => '(447894875) 51 days, 20:09:08.75',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1/1',
                        IFDESCR          => 'Summit48si-Port 1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '1/2',
                        IFDESCR          => 'Summit48si-Port 2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '1/3',
                        IFDESCR          => 'Summit48si-Port 3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438798800) 50 days, 18:53:08.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '51459175',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '624206988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '1/4',
                        IFDESCR          => 'Summit48si-Port 4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '1/5',
                        IFDESCR          => 'Summit48si-Port 5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '1/6',
                        IFDESCR          => 'Summit48si-Port 6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '1/7',
                        IFDESCR          => 'Summit48si-Port 7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13645608',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1165108025',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '1/8',
                        IFDESCR          => 'Summit48si-Port 8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438949800) 50 days, 19:18:18.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '10359391',
                        IFINERRORS       => '11883',
                        IFOUTOCTETS      => '791491706',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '1/9',
                        IFDESCR          => 'Summit48si-Port 9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '1/10',
                        IFDESCR          => 'Summit48si-Port 10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '1/11',
                        IFDESCR          => 'Summit48si-Port 11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(360574500) 41 days, 17:35:45.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '9519747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8043603',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '1/12',
                        IFDESCR          => 'Summit48si-Port 12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '1/13',
                        IFDESCR          => 'Summit48si-Port 13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '1/14',
                        IFDESCR          => 'Summit48si-Port 14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447869200) 51 days, 20:04:52.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '17630567',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1347982097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '1/15',
                        IFDESCR          => 'Summit48si-Port 15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445694100) 51 days, 14:02:21.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90949422',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '844686721',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '1/16',
                        IFDESCR          => 'Summit48si-Port 16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446153300) 51 days, 15:18:53.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644817930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '98726208',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '1/17',
                        IFDESCR          => 'Summit48si-Port 17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '1/18',
                        IFDESCR          => 'Summit48si-Port 18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2960876979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3776225281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '1/19',
                        IFDESCR          => 'Summit48si-Port 19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(444947800) 51 days, 11:57:58.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '316906751',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2620095600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '1/20',
                        IFDESCR          => 'Summit48si-Port 20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732175943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2495978711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '1/21',
                        IFDESCR          => 'Summit48si-Port 21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422093300) 48 days, 20:28:53.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '4262916',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '20491664',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '1/22',
                        IFDESCR          => 'Summit48si-Port 22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '1/23',
                        IFDESCR          => 'Summit48si-Port 23',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438784000) 50 days, 18:50:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15887247',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323560384',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '1/24',
                        IFDESCR          => 'Summit48si-Port 24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(431377500) 49 days, 22:16:15.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '298253440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3211959663',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '1/25',
                        IFDESCR          => 'Summit48si-Port 25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438152300) 50 days, 17:05:23.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '44479918',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '583219117',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '1/26',
                        IFDESCR          => 'Summit48si-Port 26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6900) 0:01:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177442977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1775635520',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '1/27',
                        IFDESCR          => 'Summit48si-Port 27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292477000) 33 days, 20:26:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36593901',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476315387',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '1/28',
                        IFDESCR          => 'Summit48si-Port 28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '1/29',
                        IFDESCR          => 'Summit48si-Port 29',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438778900) 50 days, 18:49:49.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37910746',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '495726371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '1/30',
                        IFDESCR          => 'Summit48si-Port 30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438785100) 50 days, 18:50:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39504370',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '533393140',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '1/31',
                        IFDESCR          => 'Summit48si-Port 31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292476100) 33 days, 20:26:01.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36161125',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '475876102',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '1/32',
                        IFDESCR          => 'Summit48si-Port 32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(116590300) 13 days, 11:51:43.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '15952459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154152485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '1/33',
                        IFDESCR          => 'Summit48si-Port 33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445049400) 51 days, 12:14:54.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '175358663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1084311319',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '1/34',
                        IFDESCR          => 'Summit48si-Port 34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '1471169108',
                        IFINERRORS       => '150994',
                        IFOUTOCTETS      => '2820742352',
                        IFOUTERRORS      => '1661377',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '1/35',
                        IFDESCR          => 'Summit48si-Port 35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '1/36',
                        IFDESCR          => 'Summit48si-Port 36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(438422700) 50 days, 17:50:27.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '84056914',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '871927228',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '1/37',
                        IFDESCR          => 'Summit48si-Port 37',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '1/38',
                        IFDESCR          => 'Summit48si-Port 38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2600) 0:00:26.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '11109366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1801736449',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '1/39',
                        IFDESCR          => 'Summit48si-Port 39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421202059',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1285712057',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '1/40',
                        IFDESCR          => 'Summit48si-Port 40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(445050700) 51 days, 12:15:07.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1431954',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361041589',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '1/41',
                        IFDESCR          => 'Summit48si-Port 41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(900) 0:00:09.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10394538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1733056324',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '1/42',
                        IFDESCR          => 'Summit48si-Port 42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '1/43',
                        IFDESCR          => 'Summit48si-Port 43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '1/44',
                        IFDESCR          => 'Summit48si-Port 44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '1/45',
                        IFDESCR          => 'Summit48si-Port 45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '1/46',
                        IFDESCR          => 'Summit48si-Port 46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '1/47',
                        IFDESCR          => 'Summit48si-Port 47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(315813900) 36 days, 13:15:39.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '110830791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '496907920',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '1/48',
                        IFDESCR          => 'Summit48si-Port 48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(446920000) 51 days, 17:26:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21310051',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '121889157',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '1/49',
                        IFDESCR          => 'Summit48si-Port 49',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFPORTDUPLEX     => '1',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '1/50',
                        IFDESCR          => 'Summit48si-Port 50',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424134400) 49 days, 2:09:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3137600162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '733909303',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'Default',
                        IFDESCR          => 'VLAN 00001 (Default)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '54',
                        IFNAME           => '802.1Q Encapsulation Tag 0001',
                        IFDESCR          => '802.1Q Encapsulation Tag 0001',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '55',
                        IFNAME           => 'pmf-scipre',
                        IFDESCR          => 'VLAN 00003 (pmf-scipre)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '57',
                        IFNAME           => '802.1Q Encapsulation Tag 0200',
                        IFDESCR          => '802.1Q Encapsulation Tag 0200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '58',
                        IFNAME           => 'pmf-divetud',
                        IFDESCR          => 'VLAN 00004 (pmf-divetud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '60',
                        IFNAME           => '802.1Q Encapsulation Tag 0203',
                        IFDESCR          => '802.1Q Encapsulation Tag 0203',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '61',
                        IFNAME           => 'divers-etud',
                        IFDESCR          => 'VLAN 00005 (divers-etud)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFNAME           => '802.1Q Encapsulation Tag 0205',
                        IFDESCR          => '802.1Q Encapsulation Tag 0205',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFNAME           => 'pmf-mse-doc',
                        IFDESCR          => 'VLAN 00006 (pmf-mse-doc)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '66',
                        IFNAME           => '802.1Q Encapsulation Tag 0220',
                        IFDESCR          => '802.1Q Encapsulation Tag 0220',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFNAME           => 'pmf-adm',
                        IFDESCR          => 'VLAN 00007 (pmf-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFNAME           => '802.1Q Encapsulation Tag 0230',
                        IFDESCR          => '802.1Q Encapsulation Tag 0230',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFNAME           => 'pmf-vacadm',
                        IFDESCR          => 'VLAN 00008 (pmf-vacadm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFNAME           => '802.1Q Encapsulation Tag 0231',
                        IFDESCR          => '802.1Q Encapsulation Tag 0231',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFNAME           => 'pmf-imps',
                        IFDESCR          => 'VLAN 00009 (pmf-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFNAME           => '802.1Q Encapsulation Tag 0240',
                        IFDESCR          => '802.1Q Encapsulation Tag 0240',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFNAME           => 'tmp',
                        IFDESCR          => 'VLAN 00010 (tmp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFNAME           => 'pmf-crous-adm',
                        IFDESCR          => 'VLAN 00011 (pmf-crous-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFNAME           => '802.1Q Encapsulation Tag 0299',
                        IFDESCR          => '802.1Q Encapsulation Tag 0299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFNAME           => 'pmf-lan-crir',
                        IFDESCR          => 'VLAN 00012 (pmf-lan-crir)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '84',
                        IFNAME           => '802.1Q Encapsulation Tag 1010',
                        IFDESCR          => '802.1Q Encapsulation Tag 1010',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFNAME           => 'pmf-testgp',
                        IFDESCR          => 'VLAN 00013 (pmf-testgp)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFNAME           => '802.1Q Encapsulation Tag 0209',
                        IFDESCR          => '802.1Q Encapsulation Tag 0209',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFNAME           => 'pmf-borne-sf',
                        IFDESCR          => 'VLAN 00014 (pmf-borne-sf)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFNAME           => '802.1Q Encapsulation Tag 1610',
                        IFDESCR          => '802.1Q Encapsulation Tag 1610',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFNAME           => 'pmf-lan-imps',
                        IFDESCR          => 'VLAN 00015 (pmf-lan-imps)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFNAME           => '802.1Q Encapsulation Tag 1042',
                        IFDESCR          => '802.1Q Encapsulation Tag 1042',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFNAME           => 'pmf-lan-adm',
                        IFDESCR          => 'VLAN 00016 (pmf-lan-adm)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '96',
                        IFNAME           => '802.1Q Encapsulation Tag 1016',
                        IFDESCR          => '802.1Q Encapsulation Tag 1016',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFNAME           => 'pmf-lan-td',
                        IFDESCR          => 'VLAN 00017 (pmf-lan-td)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFNAME           => '802.1Q Encapsulation Tag 1021',
                        IFDESCR          => '802.1Q Encapsulation Tag 1021',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFNAME           => 'pmf-lan-re',
                        IFDESCR          => 'VLAN 00018 (pmf-lan-re)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFNAME           => '802.1Q Encapsulation Tag 1017',
                        IFDESCR          => '802.1Q Encapsulation Tag 1017',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFNAME           => 'MacVlanDiscover',
                        IFDESCR          => 'VLAN 00002 (MacVlanDiscover)',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '4096',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => 'rif0(192.168.100.6)',
                        IFDESCR          => 'rif0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.100.6',
                        MAC              => '00:01:30:12:91:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(100) 0:00:01.00',
                        IFINOCTETS       => '1192161775',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83712995',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
);

plan skip_all => 'SNMP walks database required'
    if !$ENV{SNMPWALK_DATABASE};
plan tests => 4 * scalar keys %tests;

my ($dictionary, $index);
if ($ENV{SNMPMODELS_DICTIONARY}) {
    $dictionary = FusionInventory::Agent::Task::NetDiscovery::Dictionary->new(
        file => $ENV{SNMPMODELS_DICTIONARY}
    );
}
if ($ENV{SNMPMODELS_INDEX}) {
    $index = XML::TreePP->new()->parsefile($ENV{SNMPMODELS_INDEX});
}

foreach my $test (sort keys %tests) {
    my $snmp  = FusionInventory::Agent::SNMP::Mock->new(
        file => "$ENV{SNMPWALK_DATABASE}/$test"
    );

    # first test: discovery without dictionary
    my %device1 = getDeviceInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        \%device1,
        $tests{$test}->[0],
        "$test: discovery, without dictionary"
    );

    # second test: discovery, with dictipnary
    SKIP: {
        skip "SNMP dictionary required, skipping", 1 unless $dictionary;

        my %device2 = getDeviceInfo(
            snmp       => $snmp,
            datadir    => './share',
            dictionary => $dictionary,
        );
        cmp_deeply(
            \%device2,
            $tests{$test}->[1],
            "$test: discovery, with dictionary"
        );
    };

    # third test: inventory without model
    my $device3 = getDeviceFullInfo(
        snmp    => $snmp,
        datadir => './share'
    );
    cmp_deeply(
        $device3,
        $tests{$test}->[2],
        "$test: inventory, without model"
    );

    # fourth test: inventory, with model
    SKIP: {
        my $model_id = $tests{$test}->[1]->{MODELSNMP};
        skip "SNMP models index required, skipping", 1 unless $index;
        skip "No model associated, skipping", 1 unless $model_id;
        my $model = loadModel($index->{$model_id});

        my $device4 = getDeviceFullInfo(
            snmp    => $snmp,
            datadir => './share',
            model   => $model
        );
        cmp_deeply(
            $device4,
            $tests{$test}->[3],
            "$test: inventory, with model"
        );
    };
}
