BEGIN {
    if ($ENV{PERL_CORE}) {
	chdir 't' if -d 't';
	@INC = ("../lib", "lib/compress");
    }
}

use lib qw(t t/compress);
use strict;
use warnings;
use bytes;

use Test::More ;
use CompTestUtils;


BEGIN {
    # use Test::NoWarnings, if available
    my $extra = 0 ;
    $extra = 1
        if eval { require Test::NoWarnings ;  import Test::NoWarnings; 1 };

    plan tests => 355 + $extra ;
}


{
    use Compress::Raw::Zlib;
    
    my @all = @Compress::Raw::Zlib::DEFLATE_CONSTANTS;
    my $pkg = 1;
   
    for my $module ( qw( Adapter::Deflate RawDeflate Deflate Gzip Zip )) 
    {
        ++ $pkg ; 
        eval <<EOM;
            package P$pkg;
            use Test::More ;
            use CompTestUtils;
        
            use IO::Compress::$module () ;
        
            ::title "IO::Compress::$module - no import" ;       
EOM
        is $@, "", "create package P$pkg";
        for my $symbol (@Compress::Raw::Zlib::DEFLATE_CONSTANTS)
        {
            eval "package P$pkg; defined IO::Compress::${module}::$symbol ;";            
            is $@, "", "  has $symbol";
        }        
    }    
    
    for my $module ( qw( Adapter::Deflate RawDeflate Deflate Gzip Zip )) 
    {
        for my $label (keys %Compress::Raw::Zlib::DEFLATE_CONSTANTS)
        {
            ++ $pkg ; 

            eval <<EOM;
                package P$pkg;
                use Test::More ;
                use CompTestUtils;
            
                use IO::Compress::$module qw(:$label) ;
            
                ::title "IO::Compress::$module - import :$label" ; 
          
EOM
            is $@, "", "create package P$pkg";
            
            for my $symbol (@{ $Compress::Raw::Zlib::DEFLATE_CONSTANTS{$label} } )
            {
                 eval "package P$pkg; defined $symbol ;";               
                 is $@, "", "  has $symbol";
               
            }   
        }     
    }       
    
}

