package Color::Library::Dictionary::X11;

use strict;
use warnings;

use base qw/Color::Library::Dictionary/;

__PACKAGE__->_register_dictionary;

package Color::Library::Dictionary::X11;

=pod

=head1 NAME

Color::Library::Dictionary::X11 - (X11) Colors for the X11 Window System (rgb.txt)

=head1 DESCRIPTION

X11/rgb.txt (often /usr/X11R6/lib/X11/rgb.txt) from the X11 Window System distribution.

=head1 COLORS

	aliceblue              aliceblue            #f0f8ff

	alice blue             aliceblue            #f0f8ff

	antiquewhite           antiquewhite         #faebd7

	antique white          antiquewhite         #faebd7

	antiquewhite1          antiquewhite1        #ffefdb

	antiquewhite2          antiquewhite2        #eedfcc

	antiquewhite3          antiquewhite3        #cdc0b0

	antiquewhite4          antiquewhite4        #8b8378

	aquamarine             aquamarine           #7fffd4

	aquamarine1            aquamarine1          #7fffd4

	aquamarine2            aquamarine2          #76eec6

	aquamarine3            aquamarine3          #66cdaa

	aquamarine4            aquamarine4          #458b74

	azure                  azure                #f0ffff

	azure1                 azure1               #f0ffff

	azure2                 azure2               #e0eeee

	azure3                 azure3               #c1cdcd

	azure4                 azure4               #838b8b

	beige                  beige                #f5f5dc

	bisque                 bisque               #ffe4c4

	bisque1                bisque1              #ffe4c4

	bisque2                bisque2              #eed5b7

	bisque3                bisque3              #cdb79e

	bisque4                bisque4              #8b7d6b

	black                  black                #000000

	blanched almond        blanchedalmond       #ffebcd

	blanchedalmond         blanchedalmond       #ffebcd

	blue                   blue                 #0000ff

	blue1                  blue1                #0000ff

	blue2                  blue2                #0000ee

	blue3                  blue3                #0000cd

	blue4                  blue4                #00008b

	blueviolet             blueviolet           #8a2be2

	blue violet            blueviolet           #8a2be2

	brown                  brown                #a52a2a

	brown1                 brown1               #ff4040

	brown2                 brown2               #ee3b3b

	brown3                 brown3               #cd3333

	brown4                 brown4               #8b2323

	burlywood              burlywood            #deb887

	burlywood1             burlywood1           #ffd39b

	burlywood2             burlywood2           #eec591

	burlywood3             burlywood3           #cdaa7d

	burlywood4             burlywood4           #8b7355

	cadetblue              cadetblue            #5f9ea0

	cadet blue             cadetblue            #5f9ea0

	cadetblue1             cadetblue1           #98f5ff

	cadetblue2             cadetblue2           #8ee5ee

	cadetblue3             cadetblue3           #7ac5cd

	cadetblue4             cadetblue4           #53868b

	chartreuse             chartreuse           #7fff00

	chartreuse1            chartreuse1          #7fff00

	chartreuse2            chartreuse2          #76ee00

	chartreuse3            chartreuse3          #66cd00

	chartreuse4            chartreuse4          #458b00

	chocolate              chocolate            #d2691e

	chocolate1             chocolate1           #ff7f24

	chocolate2             chocolate2           #ee7621

	chocolate3             chocolate3           #cd661d

	chocolate4             chocolate4           #8b4513

	coral                  coral                #ff7f50

	coral1                 coral1               #ff7256

	coral2                 coral2               #ee6a50

	coral3                 coral3               #cd5b45

	coral4                 coral4               #8b3e2f

	cornflower blue        cornflowerblue       #6495ed

	cornflowerblue         cornflowerblue       #6495ed

	cornsilk               cornsilk             #fff8dc

	cornsilk1              cornsilk1            #fff8dc

	cornsilk2              cornsilk2            #eee8cd

	cornsilk3              cornsilk3            #cdc8b1

	cornsilk4              cornsilk4            #8b8878

	cyan                   cyan                 #00ffff

	cyan1                  cyan1                #00ffff

	cyan2                  cyan2                #00eeee

	cyan3                  cyan3                #00cdcd

	cyan4                  cyan4                #008b8b

	dark blue              darkblue             #00008b

	darkblue               darkblue             #00008b

	darkcyan               darkcyan             #008b8b

	dark cyan              darkcyan             #008b8b

	darkgoldenrod          darkgoldenrod        #b8860b

	dark goldenrod         darkgoldenrod        #b8860b

	darkgoldenrod1         darkgoldenrod1       #ffb90f

	darkgoldenrod2         darkgoldenrod2       #eead0e

	darkgoldenrod3         darkgoldenrod3       #cd950c

	darkgoldenrod4         darkgoldenrod4       #8b6508

	dark gray              darkgray             #a9a9a9

	darkgray               darkgray             #a9a9a9

	darkgreen              darkgreen            #006400

	dark green             darkgreen            #006400

	dark grey              darkgrey             #a9a9a9

	darkgrey               darkgrey             #a9a9a9

	dark khaki             darkkhaki            #bdb76b

	darkkhaki              darkkhaki            #bdb76b

	dark magenta           darkmagenta          #8b008b

	darkmagenta            darkmagenta          #8b008b

	dark olive green       darkolivegreen       #556b2f

	darkolivegreen         darkolivegreen       #556b2f

	darkolivegreen1        darkolivegreen1      #caff70

	darkolivegreen2        darkolivegreen2      #bcee68

	darkolivegreen3        darkolivegreen3      #a2cd5a

	darkolivegreen4        darkolivegreen4      #6e8b3d

	dark orange            darkorange           #ff8c00

	darkorange             darkorange           #ff8c00

	darkorange1            darkorange1          #ff7f00

	darkorange2            darkorange2          #ee7600

	darkorange3            darkorange3          #cd6600

	darkorange4            darkorange4          #8b4500

	darkorchid             darkorchid           #9932cc

	dark orchid            darkorchid           #9932cc

	darkorchid1            darkorchid1          #bf3eff

	darkorchid2            darkorchid2          #b23aee

	darkorchid3            darkorchid3          #9a32cd

	darkorchid4            darkorchid4          #68228b

	dark red               darkred              #8b0000

	darkred                darkred              #8b0000

	dark salmon            darksalmon           #e9967a

	darksalmon             darksalmon           #e9967a

	dark sea green         darkseagreen         #8fbc8f

	darkseagreen           darkseagreen         #8fbc8f

	darkseagreen1          darkseagreen1        #c1ffc1

	darkseagreen2          darkseagreen2        #b4eeb4

	darkseagreen3          darkseagreen3        #9bcd9b

	darkseagreen4          darkseagreen4        #698b69

	dark slate blue        darkslateblue        #483d8b

	darkslateblue          darkslateblue        #483d8b

	dark slate gray        darkslategray        #2f4f4f

	darkslategray          darkslategray        #2f4f4f

	darkslategray1         darkslategray1       #97ffff

	darkslategray2         darkslategray2       #8deeee

	darkslategray3         darkslategray3       #79cdcd

	darkslategray4         darkslategray4       #528b8b

	dark slate grey        darkslategrey        #2f4f4f

	darkslategrey          darkslategrey        #2f4f4f

	darkslategrey1         darkslategrey1       #97ffff

	darkslategrey2         darkslategrey2       #8deeee

	darkslategrey3         darkslategrey3       #79cdcd

	darkslategrey4         darkslategrey4       #528b8b

	dark turquoise         darkturquoise        #00ced1

	darkturquoise          darkturquoise        #00ced1

	darkviolet             darkviolet           #9400d3

	dark violet            darkviolet           #9400d3

	deep pink              deeppink             #ff1493

	deeppink               deeppink             #ff1493

	deeppink1              deeppink1            #ff1493

	deeppink2              deeppink2            #ee1289

	deeppink3              deeppink3            #cd1076

	deeppink4              deeppink4            #8b0a50

	deepskyblue            deepskyblue          #00bfff

	deep sky blue          deepskyblue          #00bfff

	deepskyblue1           deepskyblue1         #00bfff

	deepskyblue2           deepskyblue2         #00b2ee

	deepskyblue3           deepskyblue3         #009acd

	deepskyblue4           deepskyblue4         #00688b

	dimgray                dimgray              #696969

	dim gray               dimgray              #696969

	dim grey               dimgrey              #696969

	dimgrey                dimgrey              #696969

	dodger blue            dodgerblue           #1e90ff

	dodgerblue             dodgerblue           #1e90ff

	dodgerblue1            dodgerblue1          #1e90ff

	dodgerblue2            dodgerblue2          #1c86ee

	dodgerblue3            dodgerblue3          #1874cd

	dodgerblue4            dodgerblue4          #104e8b

	firebrick              firebrick            #b22222

	firebrick1             firebrick1           #ff3030

	firebrick2             firebrick2           #ee2c2c

	firebrick3             firebrick3           #cd2626

	firebrick4             firebrick4           #8b1a1a

	floral white           floralwhite          #fffaf0

	floralwhite            floralwhite          #fffaf0

	forestgreen            forestgreen          #228b22

	forest green           forestgreen          #228b22

	gainsboro              gainsboro            #dcdcdc

	ghostwhite             ghostwhite           #f8f8ff

	ghost white            ghostwhite           #f8f8ff

	gold                   gold                 #ffd700

	gold1                  gold1                #ffd700

	gold2                  gold2                #eec900

	gold3                  gold3                #cdad00

	gold4                  gold4                #8b7500

	goldenrod              goldenrod            #daa520

	goldenrod1             goldenrod1           #ffc125

	goldenrod2             goldenrod2           #eeb422

	goldenrod3             goldenrod3           #cd9b1d

	goldenrod4             goldenrod4           #8b6914

	gray                   gray                 #bebebe

	gray0                  gray0                #000000

	gray1                  gray1                #030303

	gray10                 gray10               #1a1a1a

	gray100                gray100              #ffffff

	gray11                 gray11               #1c1c1c

	gray12                 gray12               #1f1f1f

	gray13                 gray13               #212121

	gray14                 gray14               #242424

	gray15                 gray15               #262626

	gray16                 gray16               #292929

	gray17                 gray17               #2b2b2b

	gray18                 gray18               #2e2e2e

	gray19                 gray19               #303030

	gray2                  gray2                #050505

	gray20                 gray20               #333333

	gray21                 gray21               #363636

	gray22                 gray22               #383838

	gray23                 gray23               #3b3b3b

	gray24                 gray24               #3d3d3d

	gray25                 gray25               #404040

	gray26                 gray26               #424242

	gray27                 gray27               #454545

	gray28                 gray28               #474747

	gray29                 gray29               #4a4a4a

	gray3                  gray3                #080808

	gray30                 gray30               #4d4d4d

	gray31                 gray31               #4f4f4f

	gray32                 gray32               #525252

	gray33                 gray33               #545454

	gray34                 gray34               #575757

	gray35                 gray35               #595959

	gray36                 gray36               #5c5c5c

	gray37                 gray37               #5e5e5e

	gray38                 gray38               #616161

	gray39                 gray39               #636363

	gray4                  gray4                #0a0a0a

	gray40                 gray40               #666666

	gray41                 gray41               #696969

	gray42                 gray42               #6b6b6b

	gray43                 gray43               #6e6e6e

	gray44                 gray44               #707070

	gray45                 gray45               #737373

	gray46                 gray46               #757575

	gray47                 gray47               #787878

	gray48                 gray48               #7a7a7a

	gray49                 gray49               #7d7d7d

	gray5                  gray5                #0d0d0d

	gray50                 gray50               #7f7f7f

	gray51                 gray51               #828282

	gray52                 gray52               #858585

	gray53                 gray53               #878787

	gray54                 gray54               #8a8a8a

	gray55                 gray55               #8c8c8c

	gray56                 gray56               #8f8f8f

	gray57                 gray57               #919191

	gray58                 gray58               #949494

	gray59                 gray59               #969696

	gray6                  gray6                #0f0f0f

	gray60                 gray60               #999999

	gray61                 gray61               #9c9c9c

	gray62                 gray62               #9e9e9e

	gray63                 gray63               #a1a1a1

	gray64                 gray64               #a3a3a3

	gray65                 gray65               #a6a6a6

	gray66                 gray66               #a8a8a8

	gray67                 gray67               #ababab

	gray68                 gray68               #adadad

	gray69                 gray69               #b0b0b0

	gray7                  gray7                #121212

	gray70                 gray70               #b3b3b3

	gray71                 gray71               #b5b5b5

	gray72                 gray72               #b8b8b8

	gray73                 gray73               #bababa

	gray74                 gray74               #bdbdbd

	gray75                 gray75               #bfbfbf

	gray76                 gray76               #c2c2c2

	gray77                 gray77               #c4c4c4

	gray78                 gray78               #c7c7c7

	gray79                 gray79               #c9c9c9

	gray8                  gray8                #141414

	gray80                 gray80               #cccccc

	gray81                 gray81               #cfcfcf

	gray82                 gray82               #d1d1d1

	gray83                 gray83               #d4d4d4

	gray84                 gray84               #d6d6d6

	gray85                 gray85               #d9d9d9

	gray86                 gray86               #dbdbdb

	gray87                 gray87               #dedede

	gray88                 gray88               #e0e0e0

	gray89                 gray89               #e3e3e3

	gray9                  gray9                #171717

	gray90                 gray90               #e5e5e5

	gray91                 gray91               #e8e8e8

	gray92                 gray92               #ebebeb

	gray93                 gray93               #ededed

	gray94                 gray94               #f0f0f0

	gray95                 gray95               #f2f2f2

	gray96                 gray96               #f5f5f5

	gray97                 gray97               #f7f7f7

	gray98                 gray98               #fafafa

	gray99                 gray99               #fcfcfc

	green                  green                #00ff00

	green1                 green1               #00ff00

	green2                 green2               #00ee00

	green3                 green3               #00cd00

	green4                 green4               #008b00

	green yellow           greenyellow          #adff2f

	greenyellow            greenyellow          #adff2f

	grey                   grey                 #bebebe

	grey0                  grey0                #000000

	grey1                  grey1                #030303

	grey10                 grey10               #1a1a1a

	grey100                grey100              #ffffff

	grey11                 grey11               #1c1c1c

	grey12                 grey12               #1f1f1f

	grey13                 grey13               #212121

	grey14                 grey14               #242424

	grey15                 grey15               #262626

	grey16                 grey16               #292929

	grey17                 grey17               #2b2b2b

	grey18                 grey18               #2e2e2e

	grey19                 grey19               #303030

	grey2                  grey2                #050505

	grey20                 grey20               #333333

	grey21                 grey21               #363636

	grey22                 grey22               #383838

	grey23                 grey23               #3b3b3b

	grey24                 grey24               #3d3d3d

	grey25                 grey25               #404040

	grey26                 grey26               #424242

	grey27                 grey27               #454545

	grey28                 grey28               #474747

	grey29                 grey29               #4a4a4a

	grey3                  grey3                #080808

	grey30                 grey30               #4d4d4d

	grey31                 grey31               #4f4f4f

	grey32                 grey32               #525252

	grey33                 grey33               #545454

	grey34                 grey34               #575757

	grey35                 grey35               #595959

	grey36                 grey36               #5c5c5c

	grey37                 grey37               #5e5e5e

	grey38                 grey38               #616161

	grey39                 grey39               #636363

	grey4                  grey4                #0a0a0a

	grey40                 grey40               #666666

	grey41                 grey41               #696969

	grey42                 grey42               #6b6b6b

	grey43                 grey43               #6e6e6e

	grey44                 grey44               #707070

	grey45                 grey45               #737373

	grey46                 grey46               #757575

	grey47                 grey47               #787878

	grey48                 grey48               #7a7a7a

	grey49                 grey49               #7d7d7d

	grey5                  grey5                #0d0d0d

	grey50                 grey50               #7f7f7f

	grey51                 grey51               #828282

	grey52                 grey52               #858585

	grey53                 grey53               #878787

	grey54                 grey54               #8a8a8a

	grey55                 grey55               #8c8c8c

	grey56                 grey56               #8f8f8f

	grey57                 grey57               #919191

	grey58                 grey58               #949494

	grey59                 grey59               #969696

	grey6                  grey6                #0f0f0f

	grey60                 grey60               #999999

	grey61                 grey61               #9c9c9c

	grey62                 grey62               #9e9e9e

	grey63                 grey63               #a1a1a1

	grey64                 grey64               #a3a3a3

	grey65                 grey65               #a6a6a6

	grey66                 grey66               #a8a8a8

	grey67                 grey67               #ababab

	grey68                 grey68               #adadad

	grey69                 grey69               #b0b0b0

	grey7                  grey7                #121212

	grey70                 grey70               #b3b3b3

	grey71                 grey71               #b5b5b5

	grey72                 grey72               #b8b8b8

	grey73                 grey73               #bababa

	grey74                 grey74               #bdbdbd

	grey75                 grey75               #bfbfbf

	grey76                 grey76               #c2c2c2

	grey77                 grey77               #c4c4c4

	grey78                 grey78               #c7c7c7

	grey79                 grey79               #c9c9c9

	grey8                  grey8                #141414

	grey80                 grey80               #cccccc

	grey81                 grey81               #cfcfcf

	grey82                 grey82               #d1d1d1

	grey83                 grey83               #d4d4d4

	grey84                 grey84               #d6d6d6

	grey85                 grey85               #d9d9d9

	grey86                 grey86               #dbdbdb

	grey87                 grey87               #dedede

	grey88                 grey88               #e0e0e0

	grey89                 grey89               #e3e3e3

	grey9                  grey9                #171717

	grey90                 grey90               #e5e5e5

	grey91                 grey91               #e8e8e8

	grey92                 grey92               #ebebeb

	grey93                 grey93               #ededed

	grey94                 grey94               #f0f0f0

	grey95                 grey95               #f2f2f2

	grey96                 grey96               #f5f5f5

	grey97                 grey97               #f7f7f7

	grey98                 grey98               #fafafa

	grey99                 grey99               #fcfcfc

	honeydew               honeydew             #f0fff0

	honeydew1              honeydew1            #f0fff0

	honeydew2              honeydew2            #e0eee0

	honeydew3              honeydew3            #c1cdc1

	honeydew4              honeydew4            #838b83

	hot pink               hotpink              #ff69b4

	hotpink                hotpink              #ff69b4

	hotpink1               hotpink1             #ff6eb4

	hotpink2               hotpink2             #ee6aa7

	hotpink3               hotpink3             #cd6090

	hotpink4               hotpink4             #8b3a62

	indianred              indianred            #cd5c5c

	indian red             indianred            #cd5c5c

	indianred1             indianred1           #ff6a6a

	indianred2             indianred2           #ee6363

	indianred3             indianred3           #cd5555

	indianred4             indianred4           #8b3a3a

	ivory                  ivory                #fffff0

	ivory1                 ivory1               #fffff0

	ivory2                 ivory2               #eeeee0

	ivory3                 ivory3               #cdcdc1

	ivory4                 ivory4               #8b8b83

	khaki                  khaki                #f0e68c

	khaki1                 khaki1               #fff68f

	khaki2                 khaki2               #eee685

	khaki3                 khaki3               #cdc673

	khaki4                 khaki4               #8b864e

	lavender               lavender             #e6e6fa

	lavenderblush          lavenderblush        #fff0f5

	lavender blush         lavenderblush        #fff0f5

	lavenderblush1         lavenderblush1       #fff0f5

	lavenderblush2         lavenderblush2       #eee0e5

	lavenderblush3         lavenderblush3       #cdc1c5

	lavenderblush4         lavenderblush4       #8b8386

	lawn green             lawngreen            #7cfc00

	lawngreen              lawngreen            #7cfc00

	lemonchiffon           lemonchiffon         #fffacd

	lemon chiffon          lemonchiffon         #fffacd

	lemonchiffon1          lemonchiffon1        #fffacd

	lemonchiffon2          lemonchiffon2        #eee9bf

	lemonchiffon3          lemonchiffon3        #cdc9a5

	lemonchiffon4          lemonchiffon4        #8b8970

	lightblue              lightblue            #add8e6

	light blue             lightblue            #add8e6

	lightblue1             lightblue1           #bfefff

	lightblue2             lightblue2           #b2dfee

	lightblue3             lightblue3           #9ac0cd

	lightblue4             lightblue4           #68838b

	lightcoral             lightcoral           #f08080

	light coral            lightcoral           #f08080

	lightcyan              lightcyan            #e0ffff

	light cyan             lightcyan            #e0ffff

	lightcyan1             lightcyan1           #e0ffff

	lightcyan2             lightcyan2           #d1eeee

	lightcyan3             lightcyan3           #b4cdcd

	lightcyan4             lightcyan4           #7a8b8b

	lightgoldenrod         lightgoldenrod       #eedd82

	light goldenrod        lightgoldenrod       #eedd82

	lightgoldenrod1        lightgoldenrod1      #ffec8b

	lightgoldenrod2        lightgoldenrod2      #eedc82

	lightgoldenrod3        lightgoldenrod3      #cdbe70

	lightgoldenrod4        lightgoldenrod4      #8b814c

	lightgoldenrodyellow   lightgoldenrodyellow #fafad2

	light goldenrod yellow lightgoldenrodyellow #fafad2

	lightgray              lightgray            #d3d3d3

	light gray             lightgray            #d3d3d3

	light green            lightgreen           #90ee90

	lightgreen             lightgreen           #90ee90

	lightgrey              lightgrey            #d3d3d3

	light grey             lightgrey            #d3d3d3

	lightpink              lightpink            #ffb6c1

	light pink             lightpink            #ffb6c1

	lightpink1             lightpink1           #ffaeb9

	lightpink2             lightpink2           #eea2ad

	lightpink3             lightpink3           #cd8c95

	lightpink4             lightpink4           #8b5f65

	light salmon           lightsalmon          #ffa07a

	lightsalmon            lightsalmon          #ffa07a

	lightsalmon1           lightsalmon1         #ffa07a

	lightsalmon2           lightsalmon2         #ee9572

	lightsalmon3           lightsalmon3         #cd8162

	lightsalmon4           lightsalmon4         #8b5742

	light sea green        lightseagreen        #20b2aa

	lightseagreen          lightseagreen        #20b2aa

	light sky blue         lightskyblue         #87cefa

	lightskyblue           lightskyblue         #87cefa

	lightskyblue1          lightskyblue1        #b0e2ff

	lightskyblue2          lightskyblue2        #a4d3ee

	lightskyblue3          lightskyblue3        #8db6cd

	lightskyblue4          lightskyblue4        #607b8b

	light slate blue       lightslateblue       #8470ff

	lightslateblue         lightslateblue       #8470ff

	light slate gray       lightslategray       #778899

	lightslategray         lightslategray       #778899

	light slate grey       lightslategrey       #778899

	lightslategrey         lightslategrey       #778899

	lightsteelblue         lightsteelblue       #b0c4de

	light steel blue       lightsteelblue       #b0c4de

	lightsteelblue1        lightsteelblue1      #cae1ff

	lightsteelblue2        lightsteelblue2      #bcd2ee

	lightsteelblue3        lightsteelblue3      #a2b5cd

	lightsteelblue4        lightsteelblue4      #6e7b8b

	lightyellow            lightyellow          #ffffe0

	light yellow           lightyellow          #ffffe0

	lightyellow1           lightyellow1         #ffffe0

	lightyellow2           lightyellow2         #eeeed1

	lightyellow3           lightyellow3         #cdcdb4

	lightyellow4           lightyellow4         #8b8b7a

	lime green             limegreen            #32cd32

	limegreen              limegreen            #32cd32

	linen                  linen                #faf0e6

	magenta                magenta              #ff00ff

	magenta1               magenta1             #ff00ff

	magenta2               magenta2             #ee00ee

	magenta3               magenta3             #cd00cd

	magenta4               magenta4             #8b008b

	maroon                 maroon               #b03060

	maroon1                maroon1              #ff34b3

	maroon2                maroon2              #ee30a7

	maroon3                maroon3              #cd2990

	maroon4                maroon4              #8b1c62

	mediumaquamarine       mediumaquamarine     #66cdaa

	medium aquamarine      mediumaquamarine     #66cdaa

	mediumblue             mediumblue           #0000cd

	medium blue            mediumblue           #0000cd

	medium orchid          mediumorchid         #ba55d3

	mediumorchid           mediumorchid         #ba55d3

	mediumorchid1          mediumorchid1        #e066ff

	mediumorchid2          mediumorchid2        #d15fee

	mediumorchid3          mediumorchid3        #b452cd

	mediumorchid4          mediumorchid4        #7a378b

	medium purple          mediumpurple         #9370db

	mediumpurple           mediumpurple         #9370db

	mediumpurple1          mediumpurple1        #ab82ff

	mediumpurple2          mediumpurple2        #9f79ee

	mediumpurple3          mediumpurple3        #8968cd

	mediumpurple4          mediumpurple4        #5d478b

	medium sea green       mediumseagreen       #3cb371

	mediumseagreen         mediumseagreen       #3cb371

	mediumslateblue        mediumslateblue      #7b68ee

	medium slate blue      mediumslateblue      #7b68ee

	mediumspringgreen      mediumspringgreen    #00fa9a

	medium spring green    mediumspringgreen    #00fa9a

	medium turquoise       mediumturquoise      #48d1cc

	mediumturquoise        mediumturquoise      #48d1cc

	mediumvioletred        mediumvioletred      #c71585

	medium violet red      mediumvioletred      #c71585

	midnight blue          midnightblue         #191970

	midnightblue           midnightblue         #191970

	mint cream             mintcream            #f5fffa

	mintcream              mintcream            #f5fffa

	misty rose             mistyrose            #ffe4e1

	mistyrose              mistyrose            #ffe4e1

	mistyrose1             mistyrose1           #ffe4e1

	mistyrose2             mistyrose2           #eed5d2

	mistyrose3             mistyrose3           #cdb7b5

	mistyrose4             mistyrose4           #8b7d7b

	moccasin               moccasin             #ffe4b5

	navajowhite            navajowhite          #ffdead

	navajo white           navajowhite          #ffdead

	navajowhite1           navajowhite1         #ffdead

	navajowhite2           navajowhite2         #eecfa1

	navajowhite3           navajowhite3         #cdb38b

	navajowhite4           navajowhite4         #8b795e

	navy                   navy                 #000080

	navyblue               navyblue             #000080

	navy blue              navyblue             #000080

	oldlace                oldlace              #fdf5e6

	old lace               oldlace              #fdf5e6

	olivedrab              olivedrab            #6b8e23

	olive drab             olivedrab            #6b8e23

	olivedrab1             olivedrab1           #c0ff3e

	olivedrab2             olivedrab2           #b3ee3a

	olivedrab3             olivedrab3           #9acd32

	olivedrab4             olivedrab4           #698b22

	orange                 orange               #ffa500

	orange1                orange1              #ffa500

	orange2                orange2              #ee9a00

	orange3                orange3              #cd8500

	orange4                orange4              #8b5a00

	orange red             orangered            #ff4500

	orangered              orangered            #ff4500

	orangered1             orangered1           #ff4500

	orangered2             orangered2           #ee4000

	orangered3             orangered3           #cd3700

	orangered4             orangered4           #8b2500

	orchid                 orchid               #da70d6

	orchid1                orchid1              #ff83fa

	orchid2                orchid2              #ee7ae9

	orchid3                orchid3              #cd69c9

	orchid4                orchid4              #8b4789

	palegoldenrod          palegoldenrod        #eee8aa

	pale goldenrod         palegoldenrod        #eee8aa

	palegreen              palegreen            #98fb98

	pale green             palegreen            #98fb98

	palegreen1             palegreen1           #9aff9a

	palegreen2             palegreen2           #90ee90

	palegreen3             palegreen3           #7ccd7c

	palegreen4             palegreen4           #548b54

	pale turquoise         paleturquoise        #afeeee

	paleturquoise          paleturquoise        #afeeee

	paleturquoise1         paleturquoise1       #bbffff

	paleturquoise2         paleturquoise2       #aeeeee

	paleturquoise3         paleturquoise3       #96cdcd

	paleturquoise4         paleturquoise4       #668b8b

	pale violet red        palevioletred        #db7093

	palevioletred          palevioletred        #db7093

	palevioletred1         palevioletred1       #ff82ab

	palevioletred2         palevioletred2       #ee799f

	palevioletred3         palevioletred3       #cd6889

	palevioletred4         palevioletred4       #8b475d

	papayawhip             papayawhip           #ffefd5

	papaya whip            papayawhip           #ffefd5

	peachpuff              peachpuff            #ffdab9

	peach puff             peachpuff            #ffdab9

	peachpuff1             peachpuff1           #ffdab9

	peachpuff2             peachpuff2           #eecbad

	peachpuff3             peachpuff3           #cdaf95

	peachpuff4             peachpuff4           #8b7765

	peru                   peru                 #cd853f

	pink                   pink                 #ffc0cb

	pink1                  pink1                #ffb5c5

	pink2                  pink2                #eea9b8

	pink3                  pink3                #cd919e

	pink4                  pink4                #8b636c

	plum                   plum                 #dda0dd

	plum1                  plum1                #ffbbff

	plum2                  plum2                #eeaeee

	plum3                  plum3                #cd96cd

	plum4                  plum4                #8b668b

	powder blue            powderblue           #b0e0e6

	powderblue             powderblue           #b0e0e6

	purple                 purple               #a020f0

	purple1                purple1              #9b30ff

	purple2                purple2              #912cee

	purple3                purple3              #7d26cd

	purple4                purple4              #551a8b

	red                    red                  #ff0000

	red1                   red1                 #ff0000

	red2                   red2                 #ee0000

	red3                   red3                 #cd0000

	red4                   red4                 #8b0000

	rosybrown              rosybrown            #bc8f8f

	rosy brown             rosybrown            #bc8f8f

	rosybrown1             rosybrown1           #ffc1c1

	rosybrown2             rosybrown2           #eeb4b4

	rosybrown3             rosybrown3           #cd9b9b

	rosybrown4             rosybrown4           #8b6969

	royalblue              royalblue            #4169e1

	royal blue             royalblue            #4169e1

	royalblue1             royalblue1           #4876ff

	royalblue2             royalblue2           #436eee

	royalblue3             royalblue3           #3a5fcd

	royalblue4             royalblue4           #27408b

	saddlebrown            saddlebrown          #8b4513

	saddle brown           saddlebrown          #8b4513

	salmon                 salmon               #fa8072

	salmon1                salmon1              #ff8c69

	salmon2                salmon2              #ee8262

	salmon3                salmon3              #cd7054

	salmon4                salmon4              #8b4c39

	sandybrown             sandybrown           #f4a460

	sandy brown            sandybrown           #f4a460

	sea green              seagreen             #2e8b57

	seagreen               seagreen             #2e8b57

	seagreen1              seagreen1            #54ff9f

	seagreen2              seagreen2            #4eee94

	seagreen3              seagreen3            #43cd80

	seagreen4              seagreen4            #2e8b57

	seashell               seashell             #fff5ee

	seashell1              seashell1            #fff5ee

	seashell2              seashell2            #eee5de

	seashell3              seashell3            #cdc5bf

	seashell4              seashell4            #8b8682

	sienna                 sienna               #a0522d

	sienna1                sienna1              #ff8247

	sienna2                sienna2              #ee7942

	sienna3                sienna3              #cd6839

	sienna4                sienna4              #8b4726

	sky blue               skyblue              #87ceeb

	skyblue                skyblue              #87ceeb

	skyblue1               skyblue1             #87ceff

	skyblue2               skyblue2             #7ec0ee

	skyblue3               skyblue3             #6ca6cd

	skyblue4               skyblue4             #4a708b

	slateblue              slateblue            #6a5acd

	slate blue             slateblue            #6a5acd

	slateblue1             slateblue1           #836fff

	slateblue2             slateblue2           #7a67ee

	slateblue3             slateblue3           #6959cd

	slateblue4             slateblue4           #473c8b

	slategray              slategray            #708090

	slate gray             slategray            #708090

	slategray1             slategray1           #c6e2ff

	slategray2             slategray2           #b9d3ee

	slategray3             slategray3           #9fb6cd

	slategray4             slategray4           #6c7b8b

	slategrey              slategrey            #708090

	slate grey             slategrey            #708090

	slategrey1             slategrey1           #c6e2ff

	slategrey2             slategrey2           #b9d3ee

	slategrey3             slategrey3           #9fb6cd

	slategrey4             slategrey4           #6c7b8b

	snow                   snow                 #fffafa

	snow1                  snow1                #fffafa

	snow2                  snow2                #eee9e9

	snow3                  snow3                #cdc9c9

	snow4                  snow4                #8b8989

	springgreen            springgreen          #00ff7f

	spring green           springgreen          #00ff7f

	springgreen1           springgreen1         #00ff7f

	springgreen2           springgreen2         #00ee76

	springgreen3           springgreen3         #00cd66

	springgreen4           springgreen4         #008b45

	steel blue             steelblue            #4682b4

	steelblue              steelblue            #4682b4

	steelblue1             steelblue1           #63b8ff

	steelblue2             steelblue2           #5cacee

	steelblue3             steelblue3           #4f94cd

	steelblue4             steelblue4           #36648b

	tan                    tan                  #d2b48c

	tan1                   tan1                 #ffa54f

	tan2                   tan2                 #ee9a49

	tan3                   tan3                 #cd853f

	tan4                   tan4                 #8b5a2b

	thistle                thistle              #d8bfd8

	thistle1               thistle1             #ffe1ff

	thistle2               thistle2             #eed2ee

	thistle3               thistle3             #cdb5cd

	thistle4               thistle4             #8b7b8b

	tomato                 tomato               #ff6347

	tomato1                tomato1              #ff6347

	tomato2                tomato2              #ee5c42

	tomato3                tomato3              #cd4f39

	tomato4                tomato4              #8b3626

	turquoise              turquoise            #40e0d0

	turquoise1             turquoise1           #00f5ff

	turquoise2             turquoise2           #00e5ee

	turquoise3             turquoise3           #00c5cd

	turquoise4             turquoise4           #00868b

	violet                 violet               #ee82ee

	violet red             violetred            #d02090

	violetred              violetred            #d02090

	violetred1             violetred1           #ff3e96

	violetred2             violetred2           #ee3a8c

	violetred3             violetred3           #cd3278

	violetred4             violetred4           #8b2252

	wheat                  wheat                #f5deb3

	wheat1                 wheat1               #ffe7ba

	wheat2                 wheat2               #eed8ae

	wheat3                 wheat3               #cdba96

	wheat4                 wheat4               #8b7e66

	white                  white                #ffffff

	white smoke            whitesmoke           #f5f5f5

	whitesmoke             whitesmoke           #f5f5f5

	yellow                 yellow               #ffff00

	yellow1                yellow1              #ffff00

	yellow2                yellow2              #eeee00

	yellow3                yellow3              #cdcd00

	yellow4                yellow4              #8b8b00

	yellow green           yellowgreen          #9acd32

	yellowgreen            yellowgreen          #9acd32


=cut

sub _load_color_list() {
    return [
['x11:aliceblue','aliceblue','aliceblue',[240,248,255],'f0f8ff',15792383],
['x11:aliceblue','aliceblue','alice blue',[240,248,255],'f0f8ff',15792383],
['x11:antiquewhite','antiquewhite','antiquewhite',[250,235,215],'faebd7',16444375],
['x11:antiquewhite','antiquewhite','antique white',[250,235,215],'faebd7',16444375],
['x11:antiquewhite1','antiquewhite1','antiquewhite1',[255,239,219],'ffefdb',16773083],
['x11:antiquewhite2','antiquewhite2','antiquewhite2',[238,223,204],'eedfcc',15654860],
['x11:antiquewhite3','antiquewhite3','antiquewhite3',[205,192,176],'cdc0b0',13484208],
['x11:antiquewhite4','antiquewhite4','antiquewhite4',[139,131,120],'8b8378',9143160],
['x11:aquamarine','aquamarine','aquamarine',[127,255,212],'7fffd4',8388564],
['x11:aquamarine1','aquamarine1','aquamarine1',[127,255,212],'7fffd4',8388564],
['x11:aquamarine2','aquamarine2','aquamarine2',[118,238,198],'76eec6',7794374],
['x11:aquamarine3','aquamarine3','aquamarine3',[102,205,170],'66cdaa',6737322],
['x11:aquamarine4','aquamarine4','aquamarine4',[69,139,116],'458b74',4557684],
['x11:azure','azure','azure',[240,255,255],'f0ffff',15794175],
['x11:azure1','azure1','azure1',[240,255,255],'f0ffff',15794175],
['x11:azure2','azure2','azure2',[224,238,238],'e0eeee',14741230],
['x11:azure3','azure3','azure3',[193,205,205],'c1cdcd',12701133],
['x11:azure4','azure4','azure4',[131,139,139],'838b8b',8620939],
['x11:beige','beige','beige',[245,245,220],'f5f5dc',16119260],
['x11:bisque','bisque','bisque',[255,228,196],'ffe4c4',16770244],
['x11:bisque1','bisque1','bisque1',[255,228,196],'ffe4c4',16770244],
['x11:bisque2','bisque2','bisque2',[238,213,183],'eed5b7',15652279],
['x11:bisque3','bisque3','bisque3',[205,183,158],'cdb79e',13481886],
['x11:bisque4','bisque4','bisque4',[139,125,107],'8b7d6b',9141611],
['x11:black','black','black',[0,0,0],'000000',0],
['x11:blanchedalmond','blanchedalmond','blanched almond',[255,235,205],'ffebcd',16772045],
['x11:blanchedalmond','blanchedalmond','blanchedalmond',[255,235,205],'ffebcd',16772045],
['x11:blue','blue','blue',[0,0,255],'0000ff',255],
['x11:blue1','blue1','blue1',[0,0,255],'0000ff',255],
['x11:blue2','blue2','blue2',[0,0,238],'0000ee',238],
['x11:blue3','blue3','blue3',[0,0,205],'0000cd',205],
['x11:blue4','blue4','blue4',[0,0,139],'00008b',139],
['x11:blueviolet','blueviolet','blueviolet',[138,43,226],'8a2be2',9055202],
['x11:blueviolet','blueviolet','blue violet',[138,43,226],'8a2be2',9055202],
['x11:brown','brown','brown',[165,42,42],'a52a2a',10824234],
['x11:brown1','brown1','brown1',[255,64,64],'ff4040',16728128],
['x11:brown2','brown2','brown2',[238,59,59],'ee3b3b',15612731],
['x11:brown3','brown3','brown3',[205,51,51],'cd3333',13447987],
['x11:brown4','brown4','brown4',[139,35,35],'8b2323',9118499],
['x11:burlywood','burlywood','burlywood',[222,184,135],'deb887',14596231],
['x11:burlywood1','burlywood1','burlywood1',[255,211,155],'ffd39b',16765851],
['x11:burlywood2','burlywood2','burlywood2',[238,197,145],'eec591',15648145],
['x11:burlywood3','burlywood3','burlywood3',[205,170,125],'cdaa7d',13478525],
['x11:burlywood4','burlywood4','burlywood4',[139,115,85],'8b7355',9139029],
['x11:cadetblue','cadetblue','cadetblue',[95,158,160],'5f9ea0',6266528],
['x11:cadetblue','cadetblue','cadet blue',[95,158,160],'5f9ea0',6266528],
['x11:cadetblue1','cadetblue1','cadetblue1',[152,245,255],'98f5ff',10024447],
['x11:cadetblue2','cadetblue2','cadetblue2',[142,229,238],'8ee5ee',9364974],
['x11:cadetblue3','cadetblue3','cadetblue3',[122,197,205],'7ac5cd',8046029],
['x11:cadetblue4','cadetblue4','cadetblue4',[83,134,139],'53868b',5473931],
['x11:chartreuse','chartreuse','chartreuse',[127,255,0],'7fff00',8388352],
['x11:chartreuse1','chartreuse1','chartreuse1',[127,255,0],'7fff00',8388352],
['x11:chartreuse2','chartreuse2','chartreuse2',[118,238,0],'76ee00',7794176],
['x11:chartreuse3','chartreuse3','chartreuse3',[102,205,0],'66cd00',6737152],
['x11:chartreuse4','chartreuse4','chartreuse4',[69,139,0],'458b00',4557568],
['x11:chocolate','chocolate','chocolate',[210,105,30],'d2691e',13789470],
['x11:chocolate1','chocolate1','chocolate1',[255,127,36],'ff7f24',16744228],
['x11:chocolate2','chocolate2','chocolate2',[238,118,33],'ee7621',15627809],
['x11:chocolate3','chocolate3','chocolate3',[205,102,29],'cd661d',13461021],
['x11:chocolate4','chocolate4','chocolate4',[139,69,19],'8b4513',9127187],
['x11:coral','coral','coral',[255,127,80],'ff7f50',16744272],
['x11:coral1','coral1','coral1',[255,114,86],'ff7256',16740950],
['x11:coral2','coral2','coral2',[238,106,80],'ee6a50',15624784],
['x11:coral3','coral3','coral3',[205,91,69],'cd5b45',13458245],
['x11:coral4','coral4','coral4',[139,62,47],'8b3e2f',9125423],
['x11:cornflowerblue','cornflowerblue','cornflower blue',[100,149,237],'6495ed',6591981],
['x11:cornflowerblue','cornflowerblue','cornflowerblue',[100,149,237],'6495ed',6591981],
['x11:cornsilk','cornsilk','cornsilk',[255,248,220],'fff8dc',16775388],
['x11:cornsilk1','cornsilk1','cornsilk1',[255,248,220],'fff8dc',16775388],
['x11:cornsilk2','cornsilk2','cornsilk2',[238,232,205],'eee8cd',15657165],
['x11:cornsilk3','cornsilk3','cornsilk3',[205,200,177],'cdc8b1',13486257],
['x11:cornsilk4','cornsilk4','cornsilk4',[139,136,120],'8b8878',9144440],
['x11:cyan','cyan','cyan',[0,255,255],'00ffff',65535],
['x11:cyan1','cyan1','cyan1',[0,255,255],'00ffff',65535],
['x11:cyan2','cyan2','cyan2',[0,238,238],'00eeee',61166],
['x11:cyan3','cyan3','cyan3',[0,205,205],'00cdcd',52685],
['x11:cyan4','cyan4','cyan4',[0,139,139],'008b8b',35723],
['x11:darkblue','darkblue','dark blue',[0,0,139],'00008b',139],
['x11:darkblue','darkblue','darkblue',[0,0,139],'00008b',139],
['x11:darkcyan','darkcyan','darkcyan',[0,139,139],'008b8b',35723],
['x11:darkcyan','darkcyan','dark cyan',[0,139,139],'008b8b',35723],
['x11:darkgoldenrod','darkgoldenrod','darkgoldenrod',[184,134,11],'b8860b',12092939],
['x11:darkgoldenrod','darkgoldenrod','dark goldenrod',[184,134,11],'b8860b',12092939],
['x11:darkgoldenrod1','darkgoldenrod1','darkgoldenrod1',[255,185,15],'ffb90f',16759055],
['x11:darkgoldenrod2','darkgoldenrod2','darkgoldenrod2',[238,173,14],'eead0e',15641870],
['x11:darkgoldenrod3','darkgoldenrod3','darkgoldenrod3',[205,149,12],'cd950c',13473036],
['x11:darkgoldenrod4','darkgoldenrod4','darkgoldenrod4',[139,101,8],'8b6508',9135368],
['x11:darkgray','darkgray','dark gray',[169,169,169],'a9a9a9',11119017],
['x11:darkgray','darkgray','darkgray',[169,169,169],'a9a9a9',11119017],
['x11:darkgreen','darkgreen','darkgreen',[0,100,0],'006400',25600],
['x11:darkgreen','darkgreen','dark green',[0,100,0],'006400',25600],
['x11:darkgrey','darkgrey','dark grey',[169,169,169],'a9a9a9',11119017],
['x11:darkgrey','darkgrey','darkgrey',[169,169,169],'a9a9a9',11119017],
['x11:darkkhaki','darkkhaki','dark khaki',[189,183,107],'bdb76b',12433259],
['x11:darkkhaki','darkkhaki','darkkhaki',[189,183,107],'bdb76b',12433259],
['x11:darkmagenta','darkmagenta','dark magenta',[139,0,139],'8b008b',9109643],
['x11:darkmagenta','darkmagenta','darkmagenta',[139,0,139],'8b008b',9109643],
['x11:darkolivegreen','darkolivegreen','dark olive green',[85,107,47],'556b2f',5597999],
['x11:darkolivegreen','darkolivegreen','darkolivegreen',[85,107,47],'556b2f',5597999],
['x11:darkolivegreen1','darkolivegreen1','darkolivegreen1',[202,255,112],'caff70',13303664],
['x11:darkolivegreen2','darkolivegreen2','darkolivegreen2',[188,238,104],'bcee68',12381800],
['x11:darkolivegreen3','darkolivegreen3','darkolivegreen3',[162,205,90],'a2cd5a',10669402],
['x11:darkolivegreen4','darkolivegreen4','darkolivegreen4',[110,139,61],'6e8b3d',7244605],
['x11:darkorange','darkorange','dark orange',[255,140,0],'ff8c00',16747520],
['x11:darkorange','darkorange','darkorange',[255,140,0],'ff8c00',16747520],
['x11:darkorange1','darkorange1','darkorange1',[255,127,0],'ff7f00',16744192],
['x11:darkorange2','darkorange2','darkorange2',[238,118,0],'ee7600',15627776],
['x11:darkorange3','darkorange3','darkorange3',[205,102,0],'cd6600',13460992],
['x11:darkorange4','darkorange4','darkorange4',[139,69,0],'8b4500',9127168],
['x11:darkorchid','darkorchid','darkorchid',[153,50,204],'9932cc',10040012],
['x11:darkorchid','darkorchid','dark orchid',[153,50,204],'9932cc',10040012],
['x11:darkorchid1','darkorchid1','darkorchid1',[191,62,255],'bf3eff',12533503],
['x11:darkorchid2','darkorchid2','darkorchid2',[178,58,238],'b23aee',11680494],
['x11:darkorchid3','darkorchid3','darkorchid3',[154,50,205],'9a32cd',10105549],
['x11:darkorchid4','darkorchid4','darkorchid4',[104,34,139],'68228b',6824587],
['x11:darkred','darkred','dark red',[139,0,0],'8b0000',9109504],
['x11:darkred','darkred','darkred',[139,0,0],'8b0000',9109504],
['x11:darksalmon','darksalmon','dark salmon',[233,150,122],'e9967a',15308410],
['x11:darksalmon','darksalmon','darksalmon',[233,150,122],'e9967a',15308410],
['x11:darkseagreen','darkseagreen','dark sea green',[143,188,143],'8fbc8f',9419919],
['x11:darkseagreen','darkseagreen','darkseagreen',[143,188,143],'8fbc8f',9419919],
['x11:darkseagreen1','darkseagreen1','darkseagreen1',[193,255,193],'c1ffc1',12713921],
['x11:darkseagreen2','darkseagreen2','darkseagreen2',[180,238,180],'b4eeb4',11857588],
['x11:darkseagreen3','darkseagreen3','darkseagreen3',[155,205,155],'9bcd9b',10210715],
['x11:darkseagreen4','darkseagreen4','darkseagreen4',[105,139,105],'698b69',6916969],
['x11:darkslateblue','darkslateblue','dark slate blue',[72,61,139],'483d8b',4734347],
['x11:darkslateblue','darkslateblue','darkslateblue',[72,61,139],'483d8b',4734347],
['x11:darkslategray','darkslategray','dark slate gray',[47,79,79],'2f4f4f',3100495],
['x11:darkslategray','darkslategray','darkslategray',[47,79,79],'2f4f4f',3100495],
['x11:darkslategray1','darkslategray1','darkslategray1',[151,255,255],'97ffff',9961471],
['x11:darkslategray2','darkslategray2','darkslategray2',[141,238,238],'8deeee',9301742],
['x11:darkslategray3','darkslategray3','darkslategray3',[121,205,205],'79cdcd',7982541],
['x11:darkslategray4','darkslategray4','darkslategray4',[82,139,139],'528b8b',5409675],
['x11:darkslategrey','darkslategrey','dark slate grey',[47,79,79],'2f4f4f',3100495],
['x11:darkslategrey','darkslategrey','darkslategrey',[47,79,79],'2f4f4f',3100495],
['x11:darkslategrey1','darkslategrey1','darkslategrey1',[151,255,255],'97ffff',9961471],
['x11:darkslategrey2','darkslategrey2','darkslategrey2',[141,238,238],'8deeee',9301742],
['x11:darkslategrey3','darkslategrey3','darkslategrey3',[121,205,205],'79cdcd',7982541],
['x11:darkslategrey4','darkslategrey4','darkslategrey4',[82,139,139],'528b8b',5409675],
['x11:darkturquoise','darkturquoise','dark turquoise',[0,206,209],'00ced1',52945],
['x11:darkturquoise','darkturquoise','darkturquoise',[0,206,209],'00ced1',52945],
['x11:darkviolet','darkviolet','darkviolet',[148,0,211],'9400d3',9699539],
['x11:darkviolet','darkviolet','dark violet',[148,0,211],'9400d3',9699539],
['x11:deeppink','deeppink','deep pink',[255,20,147],'ff1493',16716947],
['x11:deeppink','deeppink','deeppink',[255,20,147],'ff1493',16716947],
['x11:deeppink1','deeppink1','deeppink1',[255,20,147],'ff1493',16716947],
['x11:deeppink2','deeppink2','deeppink2',[238,18,137],'ee1289',15602313],
['x11:deeppink3','deeppink3','deeppink3',[205,16,118],'cd1076',13439094],
['x11:deeppink4','deeppink4','deeppink4',[139,10,80],'8b0a50',9112144],
['x11:deepskyblue','deepskyblue','deepskyblue',[0,191,255],'00bfff',49151],
['x11:deepskyblue','deepskyblue','deep sky blue',[0,191,255],'00bfff',49151],
['x11:deepskyblue1','deepskyblue1','deepskyblue1',[0,191,255],'00bfff',49151],
['x11:deepskyblue2','deepskyblue2','deepskyblue2',[0,178,238],'00b2ee',45806],
['x11:deepskyblue3','deepskyblue3','deepskyblue3',[0,154,205],'009acd',39629],
['x11:deepskyblue4','deepskyblue4','deepskyblue4',[0,104,139],'00688b',26763],
['x11:dimgray','dimgray','dimgray',[105,105,105],'696969',6908265],
['x11:dimgray','dimgray','dim gray',[105,105,105],'696969',6908265],
['x11:dimgrey','dimgrey','dim grey',[105,105,105],'696969',6908265],
['x11:dimgrey','dimgrey','dimgrey',[105,105,105],'696969',6908265],
['x11:dodgerblue','dodgerblue','dodger blue',[30,144,255],'1e90ff',2003199],
['x11:dodgerblue','dodgerblue','dodgerblue',[30,144,255],'1e90ff',2003199],
['x11:dodgerblue1','dodgerblue1','dodgerblue1',[30,144,255],'1e90ff',2003199],
['x11:dodgerblue2','dodgerblue2','dodgerblue2',[28,134,238],'1c86ee',1869550],
['x11:dodgerblue3','dodgerblue3','dodgerblue3',[24,116,205],'1874cd',1602765],
['x11:dodgerblue4','dodgerblue4','dodgerblue4',[16,78,139],'104e8b',1068683],
['x11:firebrick','firebrick','firebrick',[178,34,34],'b22222',11674146],
['x11:firebrick1','firebrick1','firebrick1',[255,48,48],'ff3030',16724016],
['x11:firebrick2','firebrick2','firebrick2',[238,44,44],'ee2c2c',15608876],
['x11:firebrick3','firebrick3','firebrick3',[205,38,38],'cd2626',13444646],
['x11:firebrick4','firebrick4','firebrick4',[139,26,26],'8b1a1a',9116186],
['x11:floralwhite','floralwhite','floral white',[255,250,240],'fffaf0',16775920],
['x11:floralwhite','floralwhite','floralwhite',[255,250,240],'fffaf0',16775920],
['x11:forestgreen','forestgreen','forestgreen',[34,139,34],'228b22',2263842],
['x11:forestgreen','forestgreen','forest green',[34,139,34],'228b22',2263842],
['x11:gainsboro','gainsboro','gainsboro',[220,220,220],'dcdcdc',14474460],
['x11:ghostwhite','ghostwhite','ghostwhite',[248,248,255],'f8f8ff',16316671],
['x11:ghostwhite','ghostwhite','ghost white',[248,248,255],'f8f8ff',16316671],
['x11:gold','gold','gold',[255,215,0],'ffd700',16766720],
['x11:gold1','gold1','gold1',[255,215,0],'ffd700',16766720],
['x11:gold2','gold2','gold2',[238,201,0],'eec900',15649024],
['x11:gold3','gold3','gold3',[205,173,0],'cdad00',13479168],
['x11:gold4','gold4','gold4',[139,117,0],'8b7500',9139456],
['x11:goldenrod','goldenrod','goldenrod',[218,165,32],'daa520',14329120],
['x11:goldenrod1','goldenrod1','goldenrod1',[255,193,37],'ffc125',16761125],
['x11:goldenrod2','goldenrod2','goldenrod2',[238,180,34],'eeb422',15643682],
['x11:goldenrod3','goldenrod3','goldenrod3',[205,155,29],'cd9b1d',13474589],
['x11:goldenrod4','goldenrod4','goldenrod4',[139,105,20],'8b6914',9136404],
['x11:gray','gray','gray',[190,190,190],'bebebe',12500670],
['x11:gray0','gray0','gray0',[0,0,0],'000000',0],
['x11:gray1','gray1','gray1',[3,3,3],'030303',197379],
['x11:gray10','gray10','gray10',[26,26,26],'1a1a1a',1710618],
['x11:gray100','gray100','gray100',[255,255,255],'ffffff',16777215],
['x11:gray11','gray11','gray11',[28,28,28],'1c1c1c',1842204],
['x11:gray12','gray12','gray12',[31,31,31],'1f1f1f',2039583],
['x11:gray13','gray13','gray13',[33,33,33],'212121',2171169],
['x11:gray14','gray14','gray14',[36,36,36],'242424',2368548],
['x11:gray15','gray15','gray15',[38,38,38],'262626',2500134],
['x11:gray16','gray16','gray16',[41,41,41],'292929',2697513],
['x11:gray17','gray17','gray17',[43,43,43],'2b2b2b',2829099],
['x11:gray18','gray18','gray18',[46,46,46],'2e2e2e',3026478],
['x11:gray19','gray19','gray19',[48,48,48],'303030',3158064],
['x11:gray2','gray2','gray2',[5,5,5],'050505',328965],
['x11:gray20','gray20','gray20',[51,51,51],'333333',3355443],
['x11:gray21','gray21','gray21',[54,54,54],'363636',3552822],
['x11:gray22','gray22','gray22',[56,56,56],'383838',3684408],
['x11:gray23','gray23','gray23',[59,59,59],'3b3b3b',3881787],
['x11:gray24','gray24','gray24',[61,61,61],'3d3d3d',4013373],
['x11:gray25','gray25','gray25',[64,64,64],'404040',4210752],
['x11:gray26','gray26','gray26',[66,66,66],'424242',4342338],
['x11:gray27','gray27','gray27',[69,69,69],'454545',4539717],
['x11:gray28','gray28','gray28',[71,71,71],'474747',4671303],
['x11:gray29','gray29','gray29',[74,74,74],'4a4a4a',4868682],
['x11:gray3','gray3','gray3',[8,8,8],'080808',526344],
['x11:gray30','gray30','gray30',[77,77,77],'4d4d4d',5066061],
['x11:gray31','gray31','gray31',[79,79,79],'4f4f4f',5197647],
['x11:gray32','gray32','gray32',[82,82,82],'525252',5395026],
['x11:gray33','gray33','gray33',[84,84,84],'545454',5526612],
['x11:gray34','gray34','gray34',[87,87,87],'575757',5723991],
['x11:gray35','gray35','gray35',[89,89,89],'595959',5855577],
['x11:gray36','gray36','gray36',[92,92,92],'5c5c5c',6052956],
['x11:gray37','gray37','gray37',[94,94,94],'5e5e5e',6184542],
['x11:gray38','gray38','gray38',[97,97,97],'616161',6381921],
['x11:gray39','gray39','gray39',[99,99,99],'636363',6513507],
['x11:gray4','gray4','gray4',[10,10,10],'0a0a0a',657930],
['x11:gray40','gray40','gray40',[102,102,102],'666666',6710886],
['x11:gray41','gray41','gray41',[105,105,105],'696969',6908265],
['x11:gray42','gray42','gray42',[107,107,107],'6b6b6b',7039851],
['x11:gray43','gray43','gray43',[110,110,110],'6e6e6e',7237230],
['x11:gray44','gray44','gray44',[112,112,112],'707070',7368816],
['x11:gray45','gray45','gray45',[115,115,115],'737373',7566195],
['x11:gray46','gray46','gray46',[117,117,117],'757575',7697781],
['x11:gray47','gray47','gray47',[120,120,120],'787878',7895160],
['x11:gray48','gray48','gray48',[122,122,122],'7a7a7a',8026746],
['x11:gray49','gray49','gray49',[125,125,125],'7d7d7d',8224125],
['x11:gray5','gray5','gray5',[13,13,13],'0d0d0d',855309],
['x11:gray50','gray50','gray50',[127,127,127],'7f7f7f',8355711],
['x11:gray51','gray51','gray51',[130,130,130],'828282',8553090],
['x11:gray52','gray52','gray52',[133,133,133],'858585',8750469],
['x11:gray53','gray53','gray53',[135,135,135],'878787',8882055],
['x11:gray54','gray54','gray54',[138,138,138],'8a8a8a',9079434],
['x11:gray55','gray55','gray55',[140,140,140],'8c8c8c',9211020],
['x11:gray56','gray56','gray56',[143,143,143],'8f8f8f',9408399],
['x11:gray57','gray57','gray57',[145,145,145],'919191',9539985],
['x11:gray58','gray58','gray58',[148,148,148],'949494',9737364],
['x11:gray59','gray59','gray59',[150,150,150],'969696',9868950],
['x11:gray6','gray6','gray6',[15,15,15],'0f0f0f',986895],
['x11:gray60','gray60','gray60',[153,153,153],'999999',10066329],
['x11:gray61','gray61','gray61',[156,156,156],'9c9c9c',10263708],
['x11:gray62','gray62','gray62',[158,158,158],'9e9e9e',10395294],
['x11:gray63','gray63','gray63',[161,161,161],'a1a1a1',10592673],
['x11:gray64','gray64','gray64',[163,163,163],'a3a3a3',10724259],
['x11:gray65','gray65','gray65',[166,166,166],'a6a6a6',10921638],
['x11:gray66','gray66','gray66',[168,168,168],'a8a8a8',11053224],
['x11:gray67','gray67','gray67',[171,171,171],'ababab',11250603],
['x11:gray68','gray68','gray68',[173,173,173],'adadad',11382189],
['x11:gray69','gray69','gray69',[176,176,176],'b0b0b0',11579568],
['x11:gray7','gray7','gray7',[18,18,18],'121212',1184274],
['x11:gray70','gray70','gray70',[179,179,179],'b3b3b3',11776947],
['x11:gray71','gray71','gray71',[181,181,181],'b5b5b5',11908533],
['x11:gray72','gray72','gray72',[184,184,184],'b8b8b8',12105912],
['x11:gray73','gray73','gray73',[186,186,186],'bababa',12237498],
['x11:gray74','gray74','gray74',[189,189,189],'bdbdbd',12434877],
['x11:gray75','gray75','gray75',[191,191,191],'bfbfbf',12566463],
['x11:gray76','gray76','gray76',[194,194,194],'c2c2c2',12763842],
['x11:gray77','gray77','gray77',[196,196,196],'c4c4c4',12895428],
['x11:gray78','gray78','gray78',[199,199,199],'c7c7c7',13092807],
['x11:gray79','gray79','gray79',[201,201,201],'c9c9c9',13224393],
['x11:gray8','gray8','gray8',[20,20,20],'141414',1315860],
['x11:gray80','gray80','gray80',[204,204,204],'cccccc',13421772],
['x11:gray81','gray81','gray81',[207,207,207],'cfcfcf',13619151],
['x11:gray82','gray82','gray82',[209,209,209],'d1d1d1',13750737],
['x11:gray83','gray83','gray83',[212,212,212],'d4d4d4',13948116],
['x11:gray84','gray84','gray84',[214,214,214],'d6d6d6',14079702],
['x11:gray85','gray85','gray85',[217,217,217],'d9d9d9',14277081],
['x11:gray86','gray86','gray86',[219,219,219],'dbdbdb',14408667],
['x11:gray87','gray87','gray87',[222,222,222],'dedede',14606046],
['x11:gray88','gray88','gray88',[224,224,224],'e0e0e0',14737632],
['x11:gray89','gray89','gray89',[227,227,227],'e3e3e3',14935011],
['x11:gray9','gray9','gray9',[23,23,23],'171717',1513239],
['x11:gray90','gray90','gray90',[229,229,229],'e5e5e5',15066597],
['x11:gray91','gray91','gray91',[232,232,232],'e8e8e8',15263976],
['x11:gray92','gray92','gray92',[235,235,235],'ebebeb',15461355],
['x11:gray93','gray93','gray93',[237,237,237],'ededed',15592941],
['x11:gray94','gray94','gray94',[240,240,240],'f0f0f0',15790320],
['x11:gray95','gray95','gray95',[242,242,242],'f2f2f2',15921906],
['x11:gray96','gray96','gray96',[245,245,245],'f5f5f5',16119285],
['x11:gray97','gray97','gray97',[247,247,247],'f7f7f7',16250871],
['x11:gray98','gray98','gray98',[250,250,250],'fafafa',16448250],
['x11:gray99','gray99','gray99',[252,252,252],'fcfcfc',16579836],
['x11:green','green','green',[0,255,0],'00ff00',65280],
['x11:green1','green1','green1',[0,255,0],'00ff00',65280],
['x11:green2','green2','green2',[0,238,0],'00ee00',60928],
['x11:green3','green3','green3',[0,205,0],'00cd00',52480],
['x11:green4','green4','green4',[0,139,0],'008b00',35584],
['x11:greenyellow','greenyellow','green yellow',[173,255,47],'adff2f',11403055],
['x11:greenyellow','greenyellow','greenyellow',[173,255,47],'adff2f',11403055],
['x11:grey','grey','grey',[190,190,190],'bebebe',12500670],
['x11:grey0','grey0','grey0',[0,0,0],'000000',0],
['x11:grey1','grey1','grey1',[3,3,3],'030303',197379],
['x11:grey10','grey10','grey10',[26,26,26],'1a1a1a',1710618],
['x11:grey100','grey100','grey100',[255,255,255],'ffffff',16777215],
['x11:grey11','grey11','grey11',[28,28,28],'1c1c1c',1842204],
['x11:grey12','grey12','grey12',[31,31,31],'1f1f1f',2039583],
['x11:grey13','grey13','grey13',[33,33,33],'212121',2171169],
['x11:grey14','grey14','grey14',[36,36,36],'242424',2368548],
['x11:grey15','grey15','grey15',[38,38,38],'262626',2500134],
['x11:grey16','grey16','grey16',[41,41,41],'292929',2697513],
['x11:grey17','grey17','grey17',[43,43,43],'2b2b2b',2829099],
['x11:grey18','grey18','grey18',[46,46,46],'2e2e2e',3026478],
['x11:grey19','grey19','grey19',[48,48,48],'303030',3158064],
['x11:grey2','grey2','grey2',[5,5,5],'050505',328965],
['x11:grey20','grey20','grey20',[51,51,51],'333333',3355443],
['x11:grey21','grey21','grey21',[54,54,54],'363636',3552822],
['x11:grey22','grey22','grey22',[56,56,56],'383838',3684408],
['x11:grey23','grey23','grey23',[59,59,59],'3b3b3b',3881787],
['x11:grey24','grey24','grey24',[61,61,61],'3d3d3d',4013373],
['x11:grey25','grey25','grey25',[64,64,64],'404040',4210752],
['x11:grey26','grey26','grey26',[66,66,66],'424242',4342338],
['x11:grey27','grey27','grey27',[69,69,69],'454545',4539717],
['x11:grey28','grey28','grey28',[71,71,71],'474747',4671303],
['x11:grey29','grey29','grey29',[74,74,74],'4a4a4a',4868682],
['x11:grey3','grey3','grey3',[8,8,8],'080808',526344],
['x11:grey30','grey30','grey30',[77,77,77],'4d4d4d',5066061],
['x11:grey31','grey31','grey31',[79,79,79],'4f4f4f',5197647],
['x11:grey32','grey32','grey32',[82,82,82],'525252',5395026],
['x11:grey33','grey33','grey33',[84,84,84],'545454',5526612],
['x11:grey34','grey34','grey34',[87,87,87],'575757',5723991],
['x11:grey35','grey35','grey35',[89,89,89],'595959',5855577],
['x11:grey36','grey36','grey36',[92,92,92],'5c5c5c',6052956],
['x11:grey37','grey37','grey37',[94,94,94],'5e5e5e',6184542],
['x11:grey38','grey38','grey38',[97,97,97],'616161',6381921],
['x11:grey39','grey39','grey39',[99,99,99],'636363',6513507],
['x11:grey4','grey4','grey4',[10,10,10],'0a0a0a',657930],
['x11:grey40','grey40','grey40',[102,102,102],'666666',6710886],
['x11:grey41','grey41','grey41',[105,105,105],'696969',6908265],
['x11:grey42','grey42','grey42',[107,107,107],'6b6b6b',7039851],
['x11:grey43','grey43','grey43',[110,110,110],'6e6e6e',7237230],
['x11:grey44','grey44','grey44',[112,112,112],'707070',7368816],
['x11:grey45','grey45','grey45',[115,115,115],'737373',7566195],
['x11:grey46','grey46','grey46',[117,117,117],'757575',7697781],
['x11:grey47','grey47','grey47',[120,120,120],'787878',7895160],
['x11:grey48','grey48','grey48',[122,122,122],'7a7a7a',8026746],
['x11:grey49','grey49','grey49',[125,125,125],'7d7d7d',8224125],
['x11:grey5','grey5','grey5',[13,13,13],'0d0d0d',855309],
['x11:grey50','grey50','grey50',[127,127,127],'7f7f7f',8355711],
['x11:grey51','grey51','grey51',[130,130,130],'828282',8553090],
['x11:grey52','grey52','grey52',[133,133,133],'858585',8750469],
['x11:grey53','grey53','grey53',[135,135,135],'878787',8882055],
['x11:grey54','grey54','grey54',[138,138,138],'8a8a8a',9079434],
['x11:grey55','grey55','grey55',[140,140,140],'8c8c8c',9211020],
['x11:grey56','grey56','grey56',[143,143,143],'8f8f8f',9408399],
['x11:grey57','grey57','grey57',[145,145,145],'919191',9539985],
['x11:grey58','grey58','grey58',[148,148,148],'949494',9737364],
['x11:grey59','grey59','grey59',[150,150,150],'969696',9868950],
['x11:grey6','grey6','grey6',[15,15,15],'0f0f0f',986895],
['x11:grey60','grey60','grey60',[153,153,153],'999999',10066329],
['x11:grey61','grey61','grey61',[156,156,156],'9c9c9c',10263708],
['x11:grey62','grey62','grey62',[158,158,158],'9e9e9e',10395294],
['x11:grey63','grey63','grey63',[161,161,161],'a1a1a1',10592673],
['x11:grey64','grey64','grey64',[163,163,163],'a3a3a3',10724259],
['x11:grey65','grey65','grey65',[166,166,166],'a6a6a6',10921638],
['x11:grey66','grey66','grey66',[168,168,168],'a8a8a8',11053224],
['x11:grey67','grey67','grey67',[171,171,171],'ababab',11250603],
['x11:grey68','grey68','grey68',[173,173,173],'adadad',11382189],
['x11:grey69','grey69','grey69',[176,176,176],'b0b0b0',11579568],
['x11:grey7','grey7','grey7',[18,18,18],'121212',1184274],
['x11:grey70','grey70','grey70',[179,179,179],'b3b3b3',11776947],
['x11:grey71','grey71','grey71',[181,181,181],'b5b5b5',11908533],
['x11:grey72','grey72','grey72',[184,184,184],'b8b8b8',12105912],
['x11:grey73','grey73','grey73',[186,186,186],'bababa',12237498],
['x11:grey74','grey74','grey74',[189,189,189],'bdbdbd',12434877],
['x11:grey75','grey75','grey75',[191,191,191],'bfbfbf',12566463],
['x11:grey76','grey76','grey76',[194,194,194],'c2c2c2',12763842],
['x11:grey77','grey77','grey77',[196,196,196],'c4c4c4',12895428],
['x11:grey78','grey78','grey78',[199,199,199],'c7c7c7',13092807],
['x11:grey79','grey79','grey79',[201,201,201],'c9c9c9',13224393],
['x11:grey8','grey8','grey8',[20,20,20],'141414',1315860],
['x11:grey80','grey80','grey80',[204,204,204],'cccccc',13421772],
['x11:grey81','grey81','grey81',[207,207,207],'cfcfcf',13619151],
['x11:grey82','grey82','grey82',[209,209,209],'d1d1d1',13750737],
['x11:grey83','grey83','grey83',[212,212,212],'d4d4d4',13948116],
['x11:grey84','grey84','grey84',[214,214,214],'d6d6d6',14079702],
['x11:grey85','grey85','grey85',[217,217,217],'d9d9d9',14277081],
['x11:grey86','grey86','grey86',[219,219,219],'dbdbdb',14408667],
['x11:grey87','grey87','grey87',[222,222,222],'dedede',14606046],
['x11:grey88','grey88','grey88',[224,224,224],'e0e0e0',14737632],
['x11:grey89','grey89','grey89',[227,227,227],'e3e3e3',14935011],
['x11:grey9','grey9','grey9',[23,23,23],'171717',1513239],
['x11:grey90','grey90','grey90',[229,229,229],'e5e5e5',15066597],
['x11:grey91','grey91','grey91',[232,232,232],'e8e8e8',15263976],
['x11:grey92','grey92','grey92',[235,235,235],'ebebeb',15461355],
['x11:grey93','grey93','grey93',[237,237,237],'ededed',15592941],
['x11:grey94','grey94','grey94',[240,240,240],'f0f0f0',15790320],
['x11:grey95','grey95','grey95',[242,242,242],'f2f2f2',15921906],
['x11:grey96','grey96','grey96',[245,245,245],'f5f5f5',16119285],
['x11:grey97','grey97','grey97',[247,247,247],'f7f7f7',16250871],
['x11:grey98','grey98','grey98',[250,250,250],'fafafa',16448250],
['x11:grey99','grey99','grey99',[252,252,252],'fcfcfc',16579836],
['x11:honeydew','honeydew','honeydew',[240,255,240],'f0fff0',15794160],
['x11:honeydew1','honeydew1','honeydew1',[240,255,240],'f0fff0',15794160],
['x11:honeydew2','honeydew2','honeydew2',[224,238,224],'e0eee0',14741216],
['x11:honeydew3','honeydew3','honeydew3',[193,205,193],'c1cdc1',12701121],
['x11:honeydew4','honeydew4','honeydew4',[131,139,131],'838b83',8620931],
['x11:hotpink','hotpink','hot pink',[255,105,180],'ff69b4',16738740],
['x11:hotpink','hotpink','hotpink',[255,105,180],'ff69b4',16738740],
['x11:hotpink1','hotpink1','hotpink1',[255,110,180],'ff6eb4',16740020],
['x11:hotpink2','hotpink2','hotpink2',[238,106,167],'ee6aa7',15624871],
['x11:hotpink3','hotpink3','hotpink3',[205,96,144],'cd6090',13459600],
['x11:hotpink4','hotpink4','hotpink4',[139,58,98],'8b3a62',9124450],
['x11:indianred','indianred','indianred',[205,92,92],'cd5c5c',13458524],
['x11:indianred','indianred','indian red',[205,92,92],'cd5c5c',13458524],
['x11:indianred1','indianred1','indianred1',[255,106,106],'ff6a6a',16738922],
['x11:indianred2','indianred2','indianred2',[238,99,99],'ee6363',15623011],
['x11:indianred3','indianred3','indianred3',[205,85,85],'cd5555',13456725],
['x11:indianred4','indianred4','indianred4',[139,58,58],'8b3a3a',9124410],
['x11:ivory','ivory','ivory',[255,255,240],'fffff0',16777200],
['x11:ivory1','ivory1','ivory1',[255,255,240],'fffff0',16777200],
['x11:ivory2','ivory2','ivory2',[238,238,224],'eeeee0',15658720],
['x11:ivory3','ivory3','ivory3',[205,205,193],'cdcdc1',13487553],
['x11:ivory4','ivory4','ivory4',[139,139,131],'8b8b83',9145219],
['x11:khaki','khaki','khaki',[240,230,140],'f0e68c',15787660],
['x11:khaki1','khaki1','khaki1',[255,246,143],'fff68f',16774799],
['x11:khaki2','khaki2','khaki2',[238,230,133],'eee685',15656581],
['x11:khaki3','khaki3','khaki3',[205,198,115],'cdc673',13485683],
['x11:khaki4','khaki4','khaki4',[139,134,78],'8b864e',9143886],
['x11:lavender','lavender','lavender',[230,230,250],'e6e6fa',15132410],
['x11:lavenderblush','lavenderblush','lavenderblush',[255,240,245],'fff0f5',16773365],
['x11:lavenderblush','lavenderblush','lavender blush',[255,240,245],'fff0f5',16773365],
['x11:lavenderblush1','lavenderblush1','lavenderblush1',[255,240,245],'fff0f5',16773365],
['x11:lavenderblush2','lavenderblush2','lavenderblush2',[238,224,229],'eee0e5',15655141],
['x11:lavenderblush3','lavenderblush3','lavenderblush3',[205,193,197],'cdc1c5',13484485],
['x11:lavenderblush4','lavenderblush4','lavenderblush4',[139,131,134],'8b8386',9143174],
['x11:lawngreen','lawngreen','lawn green',[124,252,0],'7cfc00',8190976],
['x11:lawngreen','lawngreen','lawngreen',[124,252,0],'7cfc00',8190976],
['x11:lemonchiffon','lemonchiffon','lemonchiffon',[255,250,205],'fffacd',16775885],
['x11:lemonchiffon','lemonchiffon','lemon chiffon',[255,250,205],'fffacd',16775885],
['x11:lemonchiffon1','lemonchiffon1','lemonchiffon1',[255,250,205],'fffacd',16775885],
['x11:lemonchiffon2','lemonchiffon2','lemonchiffon2',[238,233,191],'eee9bf',15657407],
['x11:lemonchiffon3','lemonchiffon3','lemonchiffon3',[205,201,165],'cdc9a5',13486501],
['x11:lemonchiffon4','lemonchiffon4','lemonchiffon4',[139,137,112],'8b8970',9144688],
['x11:lightblue','lightblue','lightblue',[173,216,230],'add8e6',11393254],
['x11:lightblue','lightblue','light blue',[173,216,230],'add8e6',11393254],
['x11:lightblue1','lightblue1','lightblue1',[191,239,255],'bfefff',12578815],
['x11:lightblue2','lightblue2','lightblue2',[178,223,238],'b2dfee',11722734],
['x11:lightblue3','lightblue3','lightblue3',[154,192,205],'9ac0cd',10141901],
['x11:lightblue4','lightblue4','lightblue4',[104,131,139],'68838b',6849419],
['x11:lightcoral','lightcoral','lightcoral',[240,128,128],'f08080',15761536],
['x11:lightcoral','lightcoral','light coral',[240,128,128],'f08080',15761536],
['x11:lightcyan','lightcyan','lightcyan',[224,255,255],'e0ffff',14745599],
['x11:lightcyan','lightcyan','light cyan',[224,255,255],'e0ffff',14745599],
['x11:lightcyan1','lightcyan1','lightcyan1',[224,255,255],'e0ffff',14745599],
['x11:lightcyan2','lightcyan2','lightcyan2',[209,238,238],'d1eeee',13758190],
['x11:lightcyan3','lightcyan3','lightcyan3',[180,205,205],'b4cdcd',11849165],
['x11:lightcyan4','lightcyan4','lightcyan4',[122,139,139],'7a8b8b',8031115],
['x11:lightgoldenrod','lightgoldenrod','lightgoldenrod',[238,221,130],'eedd82',15654274],
['x11:lightgoldenrod','lightgoldenrod','light goldenrod',[238,221,130],'eedd82',15654274],
['x11:lightgoldenrod1','lightgoldenrod1','lightgoldenrod1',[255,236,139],'ffec8b',16772235],
['x11:lightgoldenrod2','lightgoldenrod2','lightgoldenrod2',[238,220,130],'eedc82',15654018],
['x11:lightgoldenrod3','lightgoldenrod3','lightgoldenrod3',[205,190,112],'cdbe70',13483632],
['x11:lightgoldenrod4','lightgoldenrod4','lightgoldenrod4',[139,129,76],'8b814c',9142604],
['x11:lightgoldenrodyellow','lightgoldenrodyellow','lightgoldenrodyellow',[250,250,210],'fafad2',16448210],
['x11:lightgoldenrodyellow','lightgoldenrodyellow','light goldenrod yellow',[250,250,210],'fafad2',16448210],
['x11:lightgray','lightgray','lightgray',[211,211,211],'d3d3d3',13882323],
['x11:lightgray','lightgray','light gray',[211,211,211],'d3d3d3',13882323],
['x11:lightgreen','lightgreen','light green',[144,238,144],'90ee90',9498256],
['x11:lightgreen','lightgreen','lightgreen',[144,238,144],'90ee90',9498256],
['x11:lightgrey','lightgrey','lightgrey',[211,211,211],'d3d3d3',13882323],
['x11:lightgrey','lightgrey','light grey',[211,211,211],'d3d3d3',13882323],
['x11:lightpink','lightpink','lightpink',[255,182,193],'ffb6c1',16758465],
['x11:lightpink','lightpink','light pink',[255,182,193],'ffb6c1',16758465],
['x11:lightpink1','lightpink1','lightpink1',[255,174,185],'ffaeb9',16756409],
['x11:lightpink2','lightpink2','lightpink2',[238,162,173],'eea2ad',15639213],
['x11:lightpink3','lightpink3','lightpink3',[205,140,149],'cd8c95',13470869],
['x11:lightpink4','lightpink4','lightpink4',[139,95,101],'8b5f65',9133925],
['x11:lightsalmon','lightsalmon','light salmon',[255,160,122],'ffa07a',16752762],
['x11:lightsalmon','lightsalmon','lightsalmon',[255,160,122],'ffa07a',16752762],
['x11:lightsalmon1','lightsalmon1','lightsalmon1',[255,160,122],'ffa07a',16752762],
['x11:lightsalmon2','lightsalmon2','lightsalmon2',[238,149,114],'ee9572',15635826],
['x11:lightsalmon3','lightsalmon3','lightsalmon3',[205,129,98],'cd8162',13468002],
['x11:lightsalmon4','lightsalmon4','lightsalmon4',[139,87,66],'8b5742',9131842],
['x11:lightseagreen','lightseagreen','light sea green',[32,178,170],'20b2aa',2142890],
['x11:lightseagreen','lightseagreen','lightseagreen',[32,178,170],'20b2aa',2142890],
['x11:lightskyblue','lightskyblue','light sky blue',[135,206,250],'87cefa',8900346],
['x11:lightskyblue','lightskyblue','lightskyblue',[135,206,250],'87cefa',8900346],
['x11:lightskyblue1','lightskyblue1','lightskyblue1',[176,226,255],'b0e2ff',11592447],
['x11:lightskyblue2','lightskyblue2','lightskyblue2',[164,211,238],'a4d3ee',10802158],
['x11:lightskyblue3','lightskyblue3','lightskyblue3',[141,182,205],'8db6cd',9287373],
['x11:lightskyblue4','lightskyblue4','lightskyblue4',[96,123,139],'607b8b',6323083],
['x11:lightslateblue','lightslateblue','light slate blue',[132,112,255],'8470ff',8679679],
['x11:lightslateblue','lightslateblue','lightslateblue',[132,112,255],'8470ff',8679679],
['x11:lightslategray','lightslategray','light slate gray',[119,136,153],'778899',7833753],
['x11:lightslategray','lightslategray','lightslategray',[119,136,153],'778899',7833753],
['x11:lightslategrey','lightslategrey','light slate grey',[119,136,153],'778899',7833753],
['x11:lightslategrey','lightslategrey','lightslategrey',[119,136,153],'778899',7833753],
['x11:lightsteelblue','lightsteelblue','lightsteelblue',[176,196,222],'b0c4de',11584734],
['x11:lightsteelblue','lightsteelblue','light steel blue',[176,196,222],'b0c4de',11584734],
['x11:lightsteelblue1','lightsteelblue1','lightsteelblue1',[202,225,255],'cae1ff',13296127],
['x11:lightsteelblue2','lightsteelblue2','lightsteelblue2',[188,210,238],'bcd2ee',12374766],
['x11:lightsteelblue3','lightsteelblue3','lightsteelblue3',[162,181,205],'a2b5cd',10663373],
['x11:lightsteelblue4','lightsteelblue4','lightsteelblue4',[110,123,139],'6e7b8b',7240587],
['x11:lightyellow','lightyellow','lightyellow',[255,255,224],'ffffe0',16777184],
['x11:lightyellow','lightyellow','light yellow',[255,255,224],'ffffe0',16777184],
['x11:lightyellow1','lightyellow1','lightyellow1',[255,255,224],'ffffe0',16777184],
['x11:lightyellow2','lightyellow2','lightyellow2',[238,238,209],'eeeed1',15658705],
['x11:lightyellow3','lightyellow3','lightyellow3',[205,205,180],'cdcdb4',13487540],
['x11:lightyellow4','lightyellow4','lightyellow4',[139,139,122],'8b8b7a',9145210],
['x11:limegreen','limegreen','lime green',[50,205,50],'32cd32',3329330],
['x11:limegreen','limegreen','limegreen',[50,205,50],'32cd32',3329330],
['x11:linen','linen','linen',[250,240,230],'faf0e6',16445670],
['x11:magenta','magenta','magenta',[255,0,255],'ff00ff',16711935],
['x11:magenta1','magenta1','magenta1',[255,0,255],'ff00ff',16711935],
['x11:magenta2','magenta2','magenta2',[238,0,238],'ee00ee',15597806],
['x11:magenta3','magenta3','magenta3',[205,0,205],'cd00cd',13435085],
['x11:magenta4','magenta4','magenta4',[139,0,139],'8b008b',9109643],
['x11:maroon','maroon','maroon',[176,48,96],'b03060',11546720],
['x11:maroon1','maroon1','maroon1',[255,52,179],'ff34b3',16725171],
['x11:maroon2','maroon2','maroon2',[238,48,167],'ee30a7',15610023],
['x11:maroon3','maroon3','maroon3',[205,41,144],'cd2990',13445520],
['x11:maroon4','maroon4','maroon4',[139,28,98],'8b1c62',9116770],
['x11:mediumaquamarine','mediumaquamarine','mediumaquamarine',[102,205,170],'66cdaa',6737322],
['x11:mediumaquamarine','mediumaquamarine','medium aquamarine',[102,205,170],'66cdaa',6737322],
['x11:mediumblue','mediumblue','mediumblue',[0,0,205],'0000cd',205],
['x11:mediumblue','mediumblue','medium blue',[0,0,205],'0000cd',205],
['x11:mediumorchid','mediumorchid','medium orchid',[186,85,211],'ba55d3',12211667],
['x11:mediumorchid','mediumorchid','mediumorchid',[186,85,211],'ba55d3',12211667],
['x11:mediumorchid1','mediumorchid1','mediumorchid1',[224,102,255],'e066ff',14706431],
['x11:mediumorchid2','mediumorchid2','mediumorchid2',[209,95,238],'d15fee',13721582],
['x11:mediumorchid3','mediumorchid3','mediumorchid3',[180,82,205],'b452cd',11817677],
['x11:mediumorchid4','mediumorchid4','mediumorchid4',[122,55,139],'7a378b',8009611],
['x11:mediumpurple','mediumpurple','medium purple',[147,112,219],'9370db',9662683],
['x11:mediumpurple','mediumpurple','mediumpurple',[147,112,219],'9370db',9662683],
['x11:mediumpurple1','mediumpurple1','mediumpurple1',[171,130,255],'ab82ff',11240191],
['x11:mediumpurple2','mediumpurple2','mediumpurple2',[159,121,238],'9f79ee',10451438],
['x11:mediumpurple3','mediumpurple3','mediumpurple3',[137,104,205],'8968cd',9005261],
['x11:mediumpurple4','mediumpurple4','mediumpurple4',[93,71,139],'5d478b',6113163],
['x11:mediumseagreen','mediumseagreen','medium sea green',[60,179,113],'3cb371',3978097],
['x11:mediumseagreen','mediumseagreen','mediumseagreen',[60,179,113],'3cb371',3978097],
['x11:mediumslateblue','mediumslateblue','mediumslateblue',[123,104,238],'7b68ee',8087790],
['x11:mediumslateblue','mediumslateblue','medium slate blue',[123,104,238],'7b68ee',8087790],
['x11:mediumspringgreen','mediumspringgreen','mediumspringgreen',[0,250,154],'00fa9a',64154],
['x11:mediumspringgreen','mediumspringgreen','medium spring green',[0,250,154],'00fa9a',64154],
['x11:mediumturquoise','mediumturquoise','medium turquoise',[72,209,204],'48d1cc',4772300],
['x11:mediumturquoise','mediumturquoise','mediumturquoise',[72,209,204],'48d1cc',4772300],
['x11:mediumvioletred','mediumvioletred','mediumvioletred',[199,21,133],'c71585',13047173],
['x11:mediumvioletred','mediumvioletred','medium violet red',[199,21,133],'c71585',13047173],
['x11:midnightblue','midnightblue','midnight blue',[25,25,112],'191970',1644912],
['x11:midnightblue','midnightblue','midnightblue',[25,25,112],'191970',1644912],
['x11:mintcream','mintcream','mint cream',[245,255,250],'f5fffa',16121850],
['x11:mintcream','mintcream','mintcream',[245,255,250],'f5fffa',16121850],
['x11:mistyrose','mistyrose','misty rose',[255,228,225],'ffe4e1',16770273],
['x11:mistyrose','mistyrose','mistyrose',[255,228,225],'ffe4e1',16770273],
['x11:mistyrose1','mistyrose1','mistyrose1',[255,228,225],'ffe4e1',16770273],
['x11:mistyrose2','mistyrose2','mistyrose2',[238,213,210],'eed5d2',15652306],
['x11:mistyrose3','mistyrose3','mistyrose3',[205,183,181],'cdb7b5',13481909],
['x11:mistyrose4','mistyrose4','mistyrose4',[139,125,123],'8b7d7b',9141627],
['x11:moccasin','moccasin','moccasin',[255,228,181],'ffe4b5',16770229],
['x11:navajowhite','navajowhite','navajowhite',[255,222,173],'ffdead',16768685],
['x11:navajowhite','navajowhite','navajo white',[255,222,173],'ffdead',16768685],
['x11:navajowhite1','navajowhite1','navajowhite1',[255,222,173],'ffdead',16768685],
['x11:navajowhite2','navajowhite2','navajowhite2',[238,207,161],'eecfa1',15650721],
['x11:navajowhite3','navajowhite3','navajowhite3',[205,179,139],'cdb38b',13480843],
['x11:navajowhite4','navajowhite4','navajowhite4',[139,121,94],'8b795e',9140574],
['x11:navy','navy','navy',[0,0,128],'000080',128],
['x11:navyblue','navyblue','navyblue',[0,0,128],'000080',128],
['x11:navyblue','navyblue','navy blue',[0,0,128],'000080',128],
['x11:oldlace','oldlace','oldlace',[253,245,230],'fdf5e6',16643558],
['x11:oldlace','oldlace','old lace',[253,245,230],'fdf5e6',16643558],
['x11:olivedrab','olivedrab','olivedrab',[107,142,35],'6b8e23',7048739],
['x11:olivedrab','olivedrab','olive drab',[107,142,35],'6b8e23',7048739],
['x11:olivedrab1','olivedrab1','olivedrab1',[192,255,62],'c0ff3e',12648254],
['x11:olivedrab2','olivedrab2','olivedrab2',[179,238,58],'b3ee3a',11791930],
['x11:olivedrab3','olivedrab3','olivedrab3',[154,205,50],'9acd32',10145074],
['x11:olivedrab4','olivedrab4','olivedrab4',[105,139,34],'698b22',6916898],
['x11:orange','orange','orange',[255,165,0],'ffa500',16753920],
['x11:orange1','orange1','orange1',[255,165,0],'ffa500',16753920],
['x11:orange2','orange2','orange2',[238,154,0],'ee9a00',15636992],
['x11:orange3','orange3','orange3',[205,133,0],'cd8500',13468928],
['x11:orange4','orange4','orange4',[139,90,0],'8b5a00',9132544],
['x11:orangered','orangered','orange red',[255,69,0],'ff4500',16729344],
['x11:orangered','orangered','orangered',[255,69,0],'ff4500',16729344],
['x11:orangered1','orangered1','orangered1',[255,69,0],'ff4500',16729344],
['x11:orangered2','orangered2','orangered2',[238,64,0],'ee4000',15613952],
['x11:orangered3','orangered3','orangered3',[205,55,0],'cd3700',13448960],
['x11:orangered4','orangered4','orangered4',[139,37,0],'8b2500',9118976],
['x11:orchid','orchid','orchid',[218,112,214],'da70d6',14315734],
['x11:orchid1','orchid1','orchid1',[255,131,250],'ff83fa',16745466],
['x11:orchid2','orchid2','orchid2',[238,122,233],'ee7ae9',15629033],
['x11:orchid3','orchid3','orchid3',[205,105,201],'cd69c9',13461961],
['x11:orchid4','orchid4','orchid4',[139,71,137],'8b4789',9127817],
['x11:palegoldenrod','palegoldenrod','palegoldenrod',[238,232,170],'eee8aa',15657130],
['x11:palegoldenrod','palegoldenrod','pale goldenrod',[238,232,170],'eee8aa',15657130],
['x11:palegreen','palegreen','palegreen',[152,251,152],'98fb98',10025880],
['x11:palegreen','palegreen','pale green',[152,251,152],'98fb98',10025880],
['x11:palegreen1','palegreen1','palegreen1',[154,255,154],'9aff9a',10157978],
['x11:palegreen2','palegreen2','palegreen2',[144,238,144],'90ee90',9498256],
['x11:palegreen3','palegreen3','palegreen3',[124,205,124],'7ccd7c',8179068],
['x11:palegreen4','palegreen4','palegreen4',[84,139,84],'548b54',5540692],
['x11:paleturquoise','paleturquoise','pale turquoise',[175,238,238],'afeeee',11529966],
['x11:paleturquoise','paleturquoise','paleturquoise',[175,238,238],'afeeee',11529966],
['x11:paleturquoise1','paleturquoise1','paleturquoise1',[187,255,255],'bbffff',12320767],
['x11:paleturquoise2','paleturquoise2','paleturquoise2',[174,238,238],'aeeeee',11464430],
['x11:paleturquoise3','paleturquoise3','paleturquoise3',[150,205,205],'96cdcd',9883085],
['x11:paleturquoise4','paleturquoise4','paleturquoise4',[102,139,139],'668b8b',6720395],
['x11:palevioletred','palevioletred','pale violet red',[219,112,147],'db7093',14381203],
['x11:palevioletred','palevioletred','palevioletred',[219,112,147],'db7093',14381203],
['x11:palevioletred1','palevioletred1','palevioletred1',[255,130,171],'ff82ab',16745131],
['x11:palevioletred2','palevioletred2','palevioletred2',[238,121,159],'ee799f',15628703],
['x11:palevioletred3','palevioletred3','palevioletred3',[205,104,137],'cd6889',13461641],
['x11:palevioletred4','palevioletred4','palevioletred4',[139,71,93],'8b475d',9127773],
['x11:papayawhip','papayawhip','papayawhip',[255,239,213],'ffefd5',16773077],
['x11:papayawhip','papayawhip','papaya whip',[255,239,213],'ffefd5',16773077],
['x11:peachpuff','peachpuff','peachpuff',[255,218,185],'ffdab9',16767673],
['x11:peachpuff','peachpuff','peach puff',[255,218,185],'ffdab9',16767673],
['x11:peachpuff1','peachpuff1','peachpuff1',[255,218,185],'ffdab9',16767673],
['x11:peachpuff2','peachpuff2','peachpuff2',[238,203,173],'eecbad',15649709],
['x11:peachpuff3','peachpuff3','peachpuff3',[205,175,149],'cdaf95',13479829],
['x11:peachpuff4','peachpuff4','peachpuff4',[139,119,101],'8b7765',9140069],
['x11:peru','peru','peru',[205,133,63],'cd853f',13468991],
['x11:pink','pink','pink',[255,192,203],'ffc0cb',16761035],
['x11:pink1','pink1','pink1',[255,181,197],'ffb5c5',16758213],
['x11:pink2','pink2','pink2',[238,169,184],'eea9b8',15641016],
['x11:pink3','pink3','pink3',[205,145,158],'cd919e',13472158],
['x11:pink4','pink4','pink4',[139,99,108],'8b636c',9134956],
['x11:plum','plum','plum',[221,160,221],'dda0dd',14524637],
['x11:plum1','plum1','plum1',[255,187,255],'ffbbff',16759807],
['x11:plum2','plum2','plum2',[238,174,238],'eeaeee',15642350],
['x11:plum3','plum3','plum3',[205,150,205],'cd96cd',13473485],
['x11:plum4','plum4','plum4',[139,102,139],'8b668b',9135755],
['x11:powderblue','powderblue','powder blue',[176,224,230],'b0e0e6',11591910],
['x11:powderblue','powderblue','powderblue',[176,224,230],'b0e0e6',11591910],
['x11:purple','purple','purple',[160,32,240],'a020f0',10494192],
['x11:purple1','purple1','purple1',[155,48,255],'9b30ff',10170623],
['x11:purple2','purple2','purple2',[145,44,238],'912cee',9514222],
['x11:purple3','purple3','purple3',[125,38,205],'7d26cd',8201933],
['x11:purple4','purple4','purple4',[85,26,139],'551a8b',5577355],
['x11:red','red','red',[255,0,0],'ff0000',16711680],
['x11:red1','red1','red1',[255,0,0],'ff0000',16711680],
['x11:red2','red2','red2',[238,0,0],'ee0000',15597568],
['x11:red3','red3','red3',[205,0,0],'cd0000',13434880],
['x11:red4','red4','red4',[139,0,0],'8b0000',9109504],
['x11:rosybrown','rosybrown','rosybrown',[188,143,143],'bc8f8f',12357519],
['x11:rosybrown','rosybrown','rosy brown',[188,143,143],'bc8f8f',12357519],
['x11:rosybrown1','rosybrown1','rosybrown1',[255,193,193],'ffc1c1',16761281],
['x11:rosybrown2','rosybrown2','rosybrown2',[238,180,180],'eeb4b4',15643828],
['x11:rosybrown3','rosybrown3','rosybrown3',[205,155,155],'cd9b9b',13474715],
['x11:rosybrown4','rosybrown4','rosybrown4',[139,105,105],'8b6969',9136489],
['x11:royalblue','royalblue','royalblue',[65,105,225],'4169e1',4286945],
['x11:royalblue','royalblue','royal blue',[65,105,225],'4169e1',4286945],
['x11:royalblue1','royalblue1','royalblue1',[72,118,255],'4876ff',4749055],
['x11:royalblue2','royalblue2','royalblue2',[67,110,238],'436eee',4419310],
['x11:royalblue3','royalblue3','royalblue3',[58,95,205],'3a5fcd',3825613],
['x11:royalblue4','royalblue4','royalblue4',[39,64,139],'27408b',2572427],
['x11:saddlebrown','saddlebrown','saddlebrown',[139,69,19],'8b4513',9127187],
['x11:saddlebrown','saddlebrown','saddle brown',[139,69,19],'8b4513',9127187],
['x11:salmon','salmon','salmon',[250,128,114],'fa8072',16416882],
['x11:salmon1','salmon1','salmon1',[255,140,105],'ff8c69',16747625],
['x11:salmon2','salmon2','salmon2',[238,130,98],'ee8262',15630946],
['x11:salmon3','salmon3','salmon3',[205,112,84],'cd7054',13463636],
['x11:salmon4','salmon4','salmon4',[139,76,57],'8b4c39',9129017],
['x11:sandybrown','sandybrown','sandybrown',[244,164,96],'f4a460',16032864],
['x11:sandybrown','sandybrown','sandy brown',[244,164,96],'f4a460',16032864],
['x11:seagreen','seagreen','sea green',[46,139,87],'2e8b57',3050327],
['x11:seagreen','seagreen','seagreen',[46,139,87],'2e8b57',3050327],
['x11:seagreen1','seagreen1','seagreen1',[84,255,159],'54ff9f',5570463],
['x11:seagreen2','seagreen2','seagreen2',[78,238,148],'4eee94',5172884],
['x11:seagreen3','seagreen3','seagreen3',[67,205,128],'43cd80',4443520],
['x11:seagreen4','seagreen4','seagreen4',[46,139,87],'2e8b57',3050327],
['x11:seashell','seashell','seashell',[255,245,238],'fff5ee',16774638],
['x11:seashell1','seashell1','seashell1',[255,245,238],'fff5ee',16774638],
['x11:seashell2','seashell2','seashell2',[238,229,222],'eee5de',15656414],
['x11:seashell3','seashell3','seashell3',[205,197,191],'cdc5bf',13485503],
['x11:seashell4','seashell4','seashell4',[139,134,130],'8b8682',9143938],
['x11:sienna','sienna','sienna',[160,82,45],'a0522d',10506797],
['x11:sienna1','sienna1','sienna1',[255,130,71],'ff8247',16745031],
['x11:sienna2','sienna2','sienna2',[238,121,66],'ee7942',15628610],
['x11:sienna3','sienna3','sienna3',[205,104,57],'cd6839',13461561],
['x11:sienna4','sienna4','sienna4',[139,71,38],'8b4726',9127718],
['x11:skyblue','skyblue','sky blue',[135,206,235],'87ceeb',8900331],
['x11:skyblue','skyblue','skyblue',[135,206,235],'87ceeb',8900331],
['x11:skyblue1','skyblue1','skyblue1',[135,206,255],'87ceff',8900351],
['x11:skyblue2','skyblue2','skyblue2',[126,192,238],'7ec0ee',8306926],
['x11:skyblue3','skyblue3','skyblue3',[108,166,205],'6ca6cd',7120589],
['x11:skyblue4','skyblue4','skyblue4',[74,112,139],'4a708b',4878475],
['x11:slateblue','slateblue','slateblue',[106,90,205],'6a5acd',6970061],
['x11:slateblue','slateblue','slate blue',[106,90,205],'6a5acd',6970061],
['x11:slateblue1','slateblue1','slateblue1',[131,111,255],'836fff',8613887],
['x11:slateblue2','slateblue2','slateblue2',[122,103,238],'7a67ee',8021998],
['x11:slateblue3','slateblue3','slateblue3',[105,89,205],'6959cd',6904269],
['x11:slateblue4','slateblue4','slateblue4',[71,60,139],'473c8b',4668555],
['x11:slategray','slategray','slategray',[112,128,144],'708090',7372944],
['x11:slategray','slategray','slate gray',[112,128,144],'708090',7372944],
['x11:slategray1','slategray1','slategray1',[198,226,255],'c6e2ff',13034239],
['x11:slategray2','slategray2','slategray2',[185,211,238],'b9d3ee',12178414],
['x11:slategray3','slategray3','slategray3',[159,182,205],'9fb6cd',10467021],
['x11:slategray4','slategray4','slategray4',[108,123,139],'6c7b8b',7109515],
['x11:slategrey','slategrey','slategrey',[112,128,144],'708090',7372944],
['x11:slategrey','slategrey','slate grey',[112,128,144],'708090',7372944],
['x11:slategrey1','slategrey1','slategrey1',[198,226,255],'c6e2ff',13034239],
['x11:slategrey2','slategrey2','slategrey2',[185,211,238],'b9d3ee',12178414],
['x11:slategrey3','slategrey3','slategrey3',[159,182,205],'9fb6cd',10467021],
['x11:slategrey4','slategrey4','slategrey4',[108,123,139],'6c7b8b',7109515],
['x11:snow','snow','snow',[255,250,250],'fffafa',16775930],
['x11:snow1','snow1','snow1',[255,250,250],'fffafa',16775930],
['x11:snow2','snow2','snow2',[238,233,233],'eee9e9',15657449],
['x11:snow3','snow3','snow3',[205,201,201],'cdc9c9',13486537],
['x11:snow4','snow4','snow4',[139,137,137],'8b8989',9144713],
['x11:springgreen','springgreen','springgreen',[0,255,127],'00ff7f',65407],
['x11:springgreen','springgreen','spring green',[0,255,127],'00ff7f',65407],
['x11:springgreen1','springgreen1','springgreen1',[0,255,127],'00ff7f',65407],
['x11:springgreen2','springgreen2','springgreen2',[0,238,118],'00ee76',61046],
['x11:springgreen3','springgreen3','springgreen3',[0,205,102],'00cd66',52582],
['x11:springgreen4','springgreen4','springgreen4',[0,139,69],'008b45',35653],
['x11:steelblue','steelblue','steel blue',[70,130,180],'4682b4',4620980],
['x11:steelblue','steelblue','steelblue',[70,130,180],'4682b4',4620980],
['x11:steelblue1','steelblue1','steelblue1',[99,184,255],'63b8ff',6535423],
['x11:steelblue2','steelblue2','steelblue2',[92,172,238],'5cacee',6073582],
['x11:steelblue3','steelblue3','steelblue3',[79,148,205],'4f94cd',5215437],
['x11:steelblue4','steelblue4','steelblue4',[54,100,139],'36648b',3564683],
['x11:tan','tan','tan',[210,180,140],'d2b48c',13808780],
['x11:tan1','tan1','tan1',[255,165,79],'ffa54f',16753999],
['x11:tan2','tan2','tan2',[238,154,73],'ee9a49',15637065],
['x11:tan3','tan3','tan3',[205,133,63],'cd853f',13468991],
['x11:tan4','tan4','tan4',[139,90,43],'8b5a2b',9132587],
['x11:thistle','thistle','thistle',[216,191,216],'d8bfd8',14204888],
['x11:thistle1','thistle1','thistle1',[255,225,255],'ffe1ff',16769535],
['x11:thistle2','thistle2','thistle2',[238,210,238],'eed2ee',15651566],
['x11:thistle3','thistle3','thistle3',[205,181,205],'cdb5cd',13481421],
['x11:thistle4','thistle4','thistle4',[139,123,139],'8b7b8b',9141131],
['x11:tomato','tomato','tomato',[255,99,71],'ff6347',16737095],
['x11:tomato1','tomato1','tomato1',[255,99,71],'ff6347',16737095],
['x11:tomato2','tomato2','tomato2',[238,92,66],'ee5c42',15621186],
['x11:tomato3','tomato3','tomato3',[205,79,57],'cd4f39',13455161],
['x11:tomato4','tomato4','tomato4',[139,54,38],'8b3626',9123366],
['x11:turquoise','turquoise','turquoise',[64,224,208],'40e0d0',4251856],
['x11:turquoise1','turquoise1','turquoise1',[0,245,255],'00f5ff',62975],
['x11:turquoise2','turquoise2','turquoise2',[0,229,238],'00e5ee',58862],
['x11:turquoise3','turquoise3','turquoise3',[0,197,205],'00c5cd',50637],
['x11:turquoise4','turquoise4','turquoise4',[0,134,139],'00868b',34443],
['x11:violet','violet','violet',[238,130,238],'ee82ee',15631086],
['x11:violetred','violetred','violet red',[208,32,144],'d02090',13639824],
['x11:violetred','violetred','violetred',[208,32,144],'d02090',13639824],
['x11:violetred1','violetred1','violetred1',[255,62,150],'ff3e96',16727702],
['x11:violetred2','violetred2','violetred2',[238,58,140],'ee3a8c',15612556],
['x11:violetred3','violetred3','violetred3',[205,50,120],'cd3278',13447800],
['x11:violetred4','violetred4','violetred4',[139,34,82],'8b2252',9118290],
['x11:wheat','wheat','wheat',[245,222,179],'f5deb3',16113331],
['x11:wheat1','wheat1','wheat1',[255,231,186],'ffe7ba',16771002],
['x11:wheat2','wheat2','wheat2',[238,216,174],'eed8ae',15653038],
['x11:wheat3','wheat3','wheat3',[205,186,150],'cdba96',13482646],
['x11:wheat4','wheat4','wheat4',[139,126,102],'8b7e66',9141862],
['x11:white','white','white',[255,255,255],'ffffff',16777215],
['x11:whitesmoke','whitesmoke','white smoke',[245,245,245],'f5f5f5',16119285],
['x11:whitesmoke','whitesmoke','whitesmoke',[245,245,245],'f5f5f5',16119285],
['x11:yellow','yellow','yellow',[255,255,0],'ffff00',16776960],
['x11:yellow1','yellow1','yellow1',[255,255,0],'ffff00',16776960],
['x11:yellow2','yellow2','yellow2',[238,238,0],'eeee00',15658496],
['x11:yellow3','yellow3','yellow3',[205,205,0],'cdcd00',13487360],
['x11:yellow4','yellow4','yellow4',[139,139,0],'8b8b00',9145088],
['x11:yellowgreen','yellowgreen','yellow green',[154,205,50],'9acd32',10145074],
['x11:yellowgreen','yellowgreen','yellowgreen',[154,205,50],'9acd32',10145074]
    ];
}

sub _description {
    return {
          'subtitle' => 'Colors for the X11 Window System (rgb.txt)',
          'title' => 'X11',
          'description' => 'X11/rgb.txt (often /usr/X11R6/lib/X11/rgb.txt) from the X11 Window System distribution.
'
        }

}

1;
