use strict;
use warnings;

use Wurm qw(let);
use Plack::Builder;

sub _html() {<<EOT
<doctype html>
<html>
<head>
  <title>Wurm Plack/PSGI Debug</title>
  <meta charset="utf-8">
</head>
<body>
</body>
</html>
EOT
}

my $grub = Wurm::let->new
->gate(sub {
  my $meal = shift;
  return Wurm::_200('text/html', _html());
})
;

my $app = Wurm::wrapp($grub->molt);
builder {
  enable 'SimpleLogger';
  enable 'ReverseProxy';
  enable 'Debug', panels => [qw(DBITrace Environment Memory Parameters Response Timer)];
  $app
};
