
package Paws::SageMaker::DeleteAssociation;
  use Moose;
  has DestinationArn => (is => 'ro', isa => 'Str', required => 1);
  has SourceArn => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DeleteAssociation');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::SageMaker::DeleteAssociationResponse');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::DeleteAssociation - Arguments for method DeleteAssociation on L<Paws::SageMaker>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DeleteAssociation on the
L<Amazon SageMaker Service|Paws::SageMaker> service. Use the attributes of this class
as arguments to method DeleteAssociation.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DeleteAssociation.

=head1 SYNOPSIS

    my $api.sagemaker = Paws->service('SageMaker');
    my $DeleteAssociationResponse = $api . sagemaker->DeleteAssociation(
      DestinationArn => 'MyAssociationEntityArn',
      SourceArn      => 'MyAssociationEntityArn',

    );

    # Results:
    my $DestinationArn = $DeleteAssociationResponse->DestinationArn;
    my $SourceArn      = $DeleteAssociationResponse->SourceArn;

    # Returns a L<Paws::SageMaker::DeleteAssociationResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/api.sagemaker/DeleteAssociation>

=head1 ATTRIBUTES


=head2 B<REQUIRED> DestinationArn => Str

The Amazon Resource Name (ARN) of the destination.



=head2 B<REQUIRED> SourceArn => Str

The ARN of the source.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DeleteAssociation in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

