# Generated by default/object.tt
package Paws::SSM::ReviewInformation;
  use Moose;
  has ReviewedTime => (is => 'ro', isa => 'Str');
  has Reviewer => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::ReviewInformation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::ReviewInformation object:

  $service_obj->Method(Att1 => { ReviewedTime => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::ReviewInformation object:

  $result = $service_obj->Method(...);
  $result->Att1->ReviewedTime

=head1 DESCRIPTION

Information about the result of a document review request.

=head1 ATTRIBUTES


=head2 ReviewedTime => Str

The time that the reviewer took action on the document review request.


=head2 Reviewer => Str

The reviewer assigned to take action on the document review request.


=head2 Status => Str

The current status of the document review request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

