/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.applet.Applet;
import java.lang.reflect.Method;
import net.sourceforge.htmlunit.corejs.javascript.BaseFunction;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;

@JsxClass(domClass=HtmlApplet.class)
public class HTMLAppletElement
extends HTMLElement {
    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode.getPage().getWebClient().getOptions().isAppletEnabled()) {
            try {
                this.createAppletMethodAndProperties();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAppletMethodAndProperties() throws Exception {
        HtmlApplet appletNode = (HtmlApplet)this.getDomNodeOrDie();
        final Applet applet = appletNode.getApplet();
        if (applet == null) {
            return;
        }
        for (final Method method : applet.getClass().getMethods()) {
            BaseFunction f = new BaseFunction(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    for (int i = 0; i < realArgs.length; ++i) {
                        Object arg = i > args.length ? null : Context.jsToJava((Object)args[i], method.getParameterTypes()[i]);
                        realArgs[i] = arg;
                    }
                    try {
                        return method.invoke((Object)applet, realArgs);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx((Throwable)e);
                    }
                }
            };
            ScriptableObject.defineProperty((Scriptable)this, (String)method.getName(), (Object)f, (int)1);
        }
    }

    @JsxGetter
    public String getAlt() {
        String alt = this.getDomNodeOrDie().getAttribute("alt");
        return alt;
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.IE)})
    public String getBorder() {
        String border = this.getDomNodeOrDie().getAttribute("border");
        return border;
    }

    @JsxSetter(value={@WebBrowser(value=BrowserName.IE)})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }
}

