/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class EncodingPrintWriter {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static PrintWriter cachedErrWriter;
    private static String cachedErrEncoding;
    private static PrintWriter cachedOutWriter;
    private static String cachedOutEncoding;

    private EncodingPrintWriter() {
    }

    static {
        cachedErrEncoding = "";
        cachedOutEncoding = "";
    }

    public static class out {
        private out() {
        }

        private static void setupOutWriter(String encoding) {
            if (encoding == null) {
                encoding = EncodingPrintWriter.DEFAULT_ENCODING;
            }
            if (cachedOutWriter == null || !cachedOutEncoding.equals(encoding)) {
                try {
                    cachedOutWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
                    cachedOutEncoding = encoding;
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("Error " + e + "Printing as default encoding.");
                    cachedOutWriter = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
                    cachedOutEncoding = "";
                }
            }
        }

        public static void println(String o, String encoding) {
            out.setupOutWriter(encoding);
            cachedOutWriter.println(o);
        }

        public static void print(String o, String encoding) {
            out.setupOutWriter(encoding);
            cachedOutWriter.print(o);
            cachedOutWriter.flush();
        }

        public static void println(String o) {
            out.println(o, null);
        }

        public static void print(String o) {
            out.print(o, null);
        }
    }

    public static class err {
        private err() {
        }

        private static void setupErrWriter(String encoding) {
            if (encoding == null) {
                encoding = EncodingPrintWriter.DEFAULT_ENCODING;
            }
            if (cachedErrWriter == null || !cachedErrEncoding.equals(encoding)) {
                try {
                    cachedErrWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, encoding), true);
                    cachedErrEncoding = encoding;
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("Error " + e + "Printing as default encoding.");
                    cachedErrWriter = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
                    cachedErrEncoding = "";
                }
            }
        }

        public static void println(String o, String encoding) {
            err.setupErrWriter(encoding);
            cachedErrWriter.println(o);
        }

        public static void print(String o, String encoding) {
            err.setupErrWriter(encoding);
            cachedErrWriter.print(o);
            cachedErrWriter.flush();
        }

        public static void println(String o) {
            err.println(o, null);
        }

        public static void print(String o) {
            err.print(o, null);
        }
    }
}

