/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.AugmenterProvider;
import org.openqa.selenium.remote.BaseAugmenter;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.InterfaceImplementation;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Augmenter
extends BaseAugmenter {
    private static final Logger logger = Logger.getLogger(Augmenter.class.getName());

    @Override
    protected <X> X create(RemoteWebDriver driver, Map<String, AugmenterProvider> augmentors, X objectToAugment) {
        CompoundHandler handler = this.determineAugmentation(driver, augmentors, objectToAugment);
        X augmented = this.performAugmentation(handler, objectToAugment);
        this.copyFields(objectToAugment.getClass(), objectToAugment, augmented);
        return augmented;
    }

    @Override
    protected RemoteWebDriver extractRemoteWebDriver(WebDriver driver) {
        if (driver.getClass().isAnnotationPresent(Augmentable.class)) {
            return (RemoteWebDriver)driver;
        }
        logger.warning("Augmenter should be applied to the instances of @Augmentable classes or previously augmented instances only (instance class was: " + driver.getClass() + ")");
        return null;
    }

    private void copyFields(Class<?> clazz, Object source, Object target) {
        if (Object.class.equals(clazz)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            this.copyField(source, target, field);
        }
        this.copyFields(clazz.getSuperclass(), source, target);
    }

    private void copyField(Object source, Object target, Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            return;
        }
        try {
            field.setAccessible(true);
            Object value = field.get(source);
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private CompoundHandler determineAugmentation(RemoteWebDriver driver, Map<String, AugmenterProvider> augmentors, Object objectToAugment) {
        Map<String, ?> capabilities = driver.getCapabilities().asMap();
        CompoundHandler handler = new CompoundHandler(driver, objectToAugment);
        for (Map.Entry<String, ?> capabilityName : capabilities.entrySet()) {
            Object value;
            AugmenterProvider augmenter = augmentors.get(capabilityName.getKey());
            if (augmenter == null || (value = capabilityName.getValue()) instanceof Boolean && !((Boolean)value).booleanValue()) continue;
            handler.addCapabilityHander(augmenter.getDescribedInterface(), augmenter.getImplementation(value));
        }
        return handler;
    }

    protected <X> X performAugmentation(CompoundHandler handler, X from) {
        if (handler.isNeedingApplication()) {
            Class<?> superClass = from.getClass();
            Class<?> loaded = new ByteBuddy().subclass(superClass).implement((List<Type>)ImmutableList.copyOf(handler.getInterfaces())).annotateType(AnnotationDescription.Builder.ofType(Augmentable.class).build()).method(ElementMatchers.any()).intercept(InvocationHandlerAdapter.of(handler)).method(ElementMatchers.named("isAugmented")).intercept(FixedValue.value(true)).make().load(superClass.getClassLoader()).getLoaded().asSubclass(from.getClass());
            try {
                return (X)loaded.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to create subclass", e);
            }
        }
        return from;
    }

    private class CompoundHandler
    implements InvocationHandler {
        private final ExecuteMethod execute;
        private final Object originalInstance;
        private final Map<Method, InterfaceImplementation> handlers = new HashMap<Method, InterfaceImplementation>();
        private final Set<Class<?>> interfaces = new HashSet();

        private CompoundHandler(RemoteWebDriver driver, Object originalInstance) {
            this.execute = new RemoteExecuteMethod(driver);
            this.originalInstance = originalInstance;
        }

        void addCapabilityHander(Class<?> fromInterface, InterfaceImplementation handledBy) {
            if (fromInterface.isInterface()) {
                this.interfaces.add(fromInterface);
            }
            for (Method method : fromInterface.getDeclaredMethods()) {
                this.handlers.put(method, handledBy);
            }
        }

        Set<Class<?>> getInterfaces() {
            return this.interfaces;
        }

        boolean isNeedingApplication() {
            return !this.handlers.isEmpty();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InterfaceImplementation handler = this.handlers.get(method);
            if (handler == null) {
                try {
                    return method.invoke(this.originalInstance, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            return handler.invoke(this.execute, proxy, method, args);
        }
    }
}

