package App::Yath::Schema::Overlay::Event;
our $VERSION = '2.000002'; # TRIAL

package
    App::Yath::Schema::Result::Event;
use utf8;
use strict;
use warnings;

use App::Yath::Schema::ImportModes();
use App::Yath::Renderer::Default::Composer();

use Carp qw/confess/;
confess "You must first load a App::Yath::Schema::NAME module"
    unless $App::Yath::Schema::LOADED;

__PACKAGE__->inflate_column(
    rendered => {
        inflate => DBIx::Class::InflateColumn::Serializer::JSON->get_unfreezer('rendered', {}),
        deflate => DBIx::Class::InflateColumn::Serializer::JSON->get_freezer('rendered', {}),
    },
);

__PACKAGE__->inflate_column(
    facets => {
        inflate => DBIx::Class::InflateColumn::Serializer::JSON->get_unfreezer('facets', {}),
        deflate => DBIx::Class::InflateColumn::Serializer::JSON->get_freezer('facets', {}),
    },
);

sub run  { shift->job->run }
sub user { shift->job->run->user }

sub in_mode {
    my $self = shift;
    return App::Yath::Schema::ImportModes::event_in_mode(event => $self, @_);
}

sub TO_JSON {
    my $self = shift;
    my %cols = $self->get_all_fields;
    return \%cols;
}

sub st_line_data {
    my $self = shift;

    my $out = $self->line_data;

    $out->{loading_subtest} = 1;

    return $out;
}

sub line_data {
    my $self = shift;
    my %cols = $self->get_all_fields;
    my %out;

    my $has_facets = $cols{has_facets} ? 1 : 0;
    my $is_orphan = $cols{is_orphan} ? 1 : 0;
    my $has_binary = $cols{has_binary} ? 1 : 0;
    my $is_parent  = $cols{is_subtest} ? 1 : 0;
    my $causes_fail = $cols{causes_fail} ? 1 : 0;

    $out{lines} = $self->rendered // [];

    if ($has_binary) {
        for my $binary ($self->binaries) {
            my $filename = $binary->filename;

            push @{$out{lines}} => [
                'binary',
                $binary->is_image ? 'IMAGE' : 'BINARY',
                $filename,
                $binary->binary_id,
            ];
        }
    }

    $out{facets}    = $has_facets;
    $out{orphan}    = $is_orphan;
    $out{is_parent} = $is_parent;
    $out{is_fail}   = $causes_fail;

    if ($cols{parent_id}) {
        $out{parent_id} = $cols{parent_id};
        $out{parent_uuid} = ref($cols{parent_uuid}) ? $cols{parent_uuid}->event_uuid : $cols{parent_uuid};
    }

    $out{nested} = $cols{nested} // 0;

    $out{event_id} = $cols{event_id};
    $out{event_uuid} = $cols{event_uuid};

    return \%out;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Yath::Schema::Overlay::Event - Overlay for Event result class.

=head1 DESCRIPTION

This is where custom (not autogenerated) code for the Event result class lives.

=head1 SOURCE

The source code repository for Test2-Harness can be found at
L<http://github.com/Test-More/Test2-Harness/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See L<http://dev.perl.org/licenses/>

=cut
