/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.opera.OperaDriverService;

public class OperaDriverInfo
implements WebDriverInfo {
    @Override
    public String getDisplayName() {
        return "Opera";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", "operablink");
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return "operablink".equals(capabilities.getBrowserName()) || "opera".equals(capabilities.getBrowserName());
    }

    @Override
    public boolean isAvailable() {
        try {
            OperaDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return Runtime.getRuntime().availableProcessors() + 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.of(new OperaDriver(capabilities));
    }
}

