/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.lang.reflect.Type;
import java.util.UUID;
import java.util.function.BiFunction;
import org.openqa.selenium.json.JsonException;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.PropertySetting;
import org.openqa.selenium.json.TypeCoercer;

class UuidCoercer
extends TypeCoercer<UUID> {
    UuidCoercer() {
    }

    @Override
    public boolean test(Class<?> type) {
        return UUID.class.isAssignableFrom(type);
    }

    @Override
    public BiFunction<JsonInput, PropertySetting, UUID> apply(Type type) {
        return (jsonInput, propertySetting) -> {
            String toCoerce;
            switch (jsonInput.peek()) {
                case NAME: {
                    toCoerce = jsonInput.nextName();
                    break;
                }
                case STRING: {
                    toCoerce = jsonInput.nextString();
                    break;
                }
                default: {
                    throw new JsonException("Unable to coerce type to URL: " + (Object)((Object)jsonInput.peek()));
                }
            }
            return UUID.fromString(toCoerce);
        };
    }
}

