/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.tokenize.TokenSampleStream;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

public class TokenSampleStreamFactory
extends LanguageSampleStreamFactory<TokenSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(TokenSample.class, "opennlp", new TokenSampleStreamFactory(Parameters.class));
    }

    protected <P> TokenSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<TokenSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        InputStreamFactory sampleDataIn = CmdLineUtil.createInputStreamFactory(params.getData());
        PlainTextByLineStream lineStream = null;
        try {
            lineStream = new PlainTextByLineStream(sampleDataIn, params.getEncoding());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new TokenSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

