/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.io;

import net.arnx.jsonic.io.InputSource;

public class CharSequenceInputSource
implements InputSource {
    private int lines = 1;
    private int columns = 0;
    private int offset = 0;
    private int start = 0;
    int mark = -1;
    private final CharSequence cs;

    public CharSequenceInputSource(CharSequence charSequence) {
        if (charSequence == null) {
            throw new NullPointerException();
        }
        this.cs = charSequence;
    }

    public int next() {
        int n = -1;
        if (this.start < this.cs.length()) {
            n = this.cs.charAt(this.start++);
            ++this.offset;
            if (n == 13) {
                ++this.lines;
                this.columns = 0;
            } else if (n == 10) {
                if (this.offset < 2 || this.cs.charAt(this.offset - 2) != '\r') {
                    ++this.lines;
                    this.columns = 0;
                }
            } else {
                ++this.columns;
            }
        } else {
            ++this.start;
            return -1;
        }
        return n;
    }

    public void back() {
        if (this.start == 0) {
            throw new IllegalStateException("no backup charcter");
        }
        --this.start;
        if (this.start < this.cs.length()) {
            --this.offset;
            --this.columns;
        }
    }

    public long getLineNumber() {
        return this.lines;
    }

    public long getColumnNumber() {
        return this.columns;
    }

    public long getOffset() {
        return this.offset;
    }

    public String toString() {
        int n = 0;
        int n2 = Math.min(this.start - 1, this.cs.length() - 1);
        int n3 = 0;
        for (int i = 0; i < n2 + 1 && i < 20; ++i) {
            char c = this.cs.charAt(n2 - i);
            if (c == '\r' || c == '\n' && (n2 - i - 1 < 0 || this.cs.charAt(n2 - i - 1) != '\r')) {
                if (n3 <= 0) continue;
                break;
            }
            if (c == '\n') continue;
            n = n2 - i;
            ++n3;
        }
        return n <= n2 ? ((Object)this.cs.subSequence(n, n2 + 1)).toString() : "";
    }
}

