# Generated by default/object.tt
package Paws::Glue::PartitionIndex;
  use Moose;
  has IndexName => (is => 'ro', isa => 'Str', required => 1);
  has Keys => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::PartitionIndex

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::PartitionIndex object:

  $service_obj->Method(Att1 => { IndexName => $value, ..., Keys => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::PartitionIndex object:

  $result = $service_obj->Method(...);
  $result->Att1->IndexName

=head1 DESCRIPTION

A structure for a partition index.

=head1 ATTRIBUTES


=head2 B<REQUIRED> IndexName => Str

The name of the partition index.


=head2 B<REQUIRED> Keys => ArrayRef[Str|Undef]

The keys for the partition index.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

