# Generated by default/object.tt
package Paws::Athena::WorkGroupSummary;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has EngineVersion => (is => 'ro', isa => 'Paws::Athena::EngineVersion');
  has Name => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Athena::WorkGroupSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Athena::WorkGroupSummary object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Athena::WorkGroupSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

The summary information for the workgroup, which includes its name,
state, description, and the date and time it was created.

=head1 ATTRIBUTES


=head2 CreationTime => Str

The workgroup creation date and time.


=head2 Description => Str

The workgroup description.


=head2 EngineVersion => L<Paws::Athena::EngineVersion>

The engine version setting for all queries on the workgroup. Queries on
the C<AmazonAthenaPreviewFunctionality> workgroup run on the preview
engine regardless of this setting.


=head2 Name => Str

The name of the workgroup.


=head2 State => Str

The state of the workgroup.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Athena>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

