/*                                                                
**  Copyright (C) 1996,2013  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pget.c
**/
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"


int
main(int argc, char *argv[])
{
		ParamFile		pfile;
		int			i;
		int	 mode = HMODE|HHMODE;
		short arg_start;

	if ( argc <= 2 ) {
		fprintf(stderr, "usage: pget [-abort] pfile param1 [param2 ...]\n");
		exit(1);
	}


	if ( strcmp( argv[1], "-abort" ) == 0 ) {
	  if ( argc <=3 ) {
	    fprintf(stderr, "usage: pget [-abort] pfile param1 [param2 ...]\n");
	    exit(1);
	  }
	  mode = HMODE|HHMODE;
	  arg_start = 2;
	

	} else {
	  mode = HMODE;
	  arg_start =1;
	}

	if ( (pfile = (ParamFile) paramopen(argv[arg_start], NULL, 0, "r")) == NULL ) {
	    fprintf(stderr, "pget: can't open parameter file : %s\n", argv[arg_start]);
		exit(1);
	}

	arg_start++;
	paramunlock(pfile);

	for ( i = arg_start; i < argc; i++ ) {
			void	*value;


		if ( (value = ParamGetX(pfile, argv[i], StringType, &mode)) )
		  	fprintf(stdout, "%s\n", (char*) value);
		else 
			paramerr(1, "pget", argv[i]);
	}


	paramclose(pfile);
	return 0;

}

