Article 12454 of comp.lang.perl:
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!gatech!europa.eng.gtefsd.com!library.ucla.edu!ihnp4.ucsd.edu!news.cerf.net!netlabs!lwall
From: lwall@netlabs.com (Larry Wall)
Subject: Re: Module scoping
Message-ID: <1994Apr8.232210.5869@netlabs.com>
Organization: NetLabs, Inc.
References: <MAUI.94Apr6215725@guilder.mit.edu>
Date: Fri, 8 Apr 1994 23:22:10 GMT
Lines: 46

In article <MAUI.94Apr6215725@guilder.mit.edu> maui@guilder.mit.edu (Mark A Uhrmacher) writes:
: Is there some way in Perl 4 to scope the procedures in a module so they
: may only be called within the module?  I'm not sure if module is the
: correct Perl term, perhaps package is more correct.
: 
: I'm looking for something similar to what "static" does to procedure
: declaration in C.

Usually it's done with a comment like

    # Do not call the functions below.  If you do, I'll rename them
    # on purpose just to blow up your code.  Grrr!!!!

:-)

Howsomever, this being Perl, there is also a programmatic way to do it:

    #!/usr/bin/perl

    package foo;

    sub private {
	&static;
	print "Private\n";
    }

    sub public {
	print "Public\n";
	&private;
	print "Back to Public\n";
    }

    sub static {
	local($pack,$file,$line) = caller(1);
	die "Access denied at $file line $line\n" unless $pack eq 'foo';
    }

    package main;

    &foo'public;		# Succeeds.
    &foo'private;		# Fails.

Doubtless there's a better way to do it in Perl 5, but I haven't
discovered it yet.

Larry


