#!/usr/local/bin/perl

# This perl script does two fairly different things.  If is invoked
# with the environmental variable PATH_INFO set to "ismap" then it
# prints out the X and Y coordinates which it obtains from the
# environment variable QUERY_STRING.  Otherwise it assumes it has been
# invoked to handle an HTML form (via the GET or POST method) and
# processes and prints out the values and variables set in that form.

# hacked by wjm@metronet.com to handle the comments from the perl5 page

$maintainer="wjm";
#select(STDOUT);$|=1;
print "Content-type: text/html\n\n";
print "<HTML>\n<HEAD>\n";

$GN_ARG = $ENV{PATH_INFO};  # Get the argument from the URL
$GN_QUERY = $ENV{QUERY_STRING};
$GN_QUERY =~ s/\+/ /g;		# Change +'s to spaces

if ( $GN_ARG =~ /ismap/) {          # Print the X,Y coords from QUERY_STRING
	($x, $y) = split( /,/, $GN_QUERY);
	print( "Here are the X and Y coordinates of the point\n");
	print( "on which you clicked: ");
	print( "X = ", $x, ", Y = ", $y, "\n");
	exit( 0);
}




if ( $ENV{REQUEST_METHOD} eq "GET") {

# It's the GET method, so assume it is a form with QUERY_STRING a string
# of the form"param1=value1&param2=value2&param3=value3..." and create an
# associative array with keys the params.


	@QUERY_LIST = split( /&/, $GN_QUERY);

	foreach $item (@QUERY_LIST) {
        	($param, $value) = split( /=/, $item);
		 $QUERY_ARRAY{$param} .= $value;
		 $QUERY_ARRAY{$param} .= " ";
	}

print <<EOF;
        Here are the parameters and their values which were
        sent to &lt;wjm@metronet.com&gt; by your form:

EOF

	foreach $param ( sort( keys(%QUERY_ARRAY))) {
		print( $param, " = ", $QUERY_ARRAY{$param}, "\n");
	}
}


if ( $ENV{REQUEST_METHOD} eq "POST") {
	
# It's the POST method, so print content length and coded input from
# STDIN.  Then decode it and print again.

	$len = $ENV{CONTENT_LENGTH};
	$postinput = <STDIN>;
	$undecoded=$postinput;
	$postinput =~ s/&/\n/g;
	$postinput =~ s/\+/ /g;
	$postinput =~ s/%([\da-f]{1,2})/pack(C,hex($1))/eig;
	print "</HEAD><BODY><h3>Posted input content-length = $len </h3>\n";
	print "Your comment: has been sent, thanks alot.\n<p>\nBill<p>\n";
	print "</BODY>\n</HTML>\n\n";

	# now mail it 
	@mykeys=("HTTP_ACCEPT","REMOTE_ADDR","CONTENT_LENGTH","REMOTE_HOST");
	open(MAIL,"|/usr/lib/sendmail -t");
	open(COMMENT,">>/usr/pub/perlinfo/perl5/forms/comment.out");
	print MAIL "To: $maintainer\n";
	print MAIL "Subject: Perl5 WWW page comment\n\n\n\n";
	print MAIL "\n\nEnvironment variables\n";
	print COMMENT "\n\nEnvironment variables\n";
	foreach $val (@mykeys){
		print MAIL "$val = $ENV{$val}\n";
		print COMMENT "$val = $ENV{$val}\n";
	}
	print MAIL "\n\nPosted input content-length = $len \n";
	print COMMENT "\n\nPosted input content-length = $len \n";
	print MAIL "Decoded posted input:\n$postinput\n";
	print COMMENT "Decoded posted input:\n$postinput\n";
	print MAIL "End of entry\n\n";
	print COMMENT "End of entry\n\n";
	close(MAIL);
	close(COMMENT);

}

