Article: 1764 of comp.lang.perl
Xref: feenix.metronet.com comp.lang.perl:1764
Path: feenix.metronet.com!news.utdallas.edu!tamsun.tamu.edu!cs.utexas.edu!asuvax!chnews!ornews.intel.com!ornews.intel.com!merlyn
From: merlyn@ora.com (Randal L. Schwartz)
Newsgroups: comp.lang.perl
#Subject: Re: Need example of pipe & fork (probable FAQ)
Date: 23 Mar 93 10:08:32
Organization: Stonehenge Consulting Services; Portland, Oregon, USA
Lines: 42
Message-ID: <MERLYN.93Mar23100832@kandinsky.intel.com>
References: <cardinal.732865822@pts>
NNTP-Posting-Host: kandinsky.intel.com
In-reply-to: cardinal@informix.com's message of 23 Mar 93 05:50:22 GMT

>>>>> In article <cardinal.732865822@pts>, cardinal@informix.com (Edward Cardinal) writes:

Edward> I want to avoid writing to an intermediate file; I want to do the whole
Edward> thing in memory if possible.  My best shot so far is to use backticks
Edward> around an echo that pipes into the filter, catching the output into a
Edward> variable:

Edward> $fred = `echo \"$list\" | sort -u`;

Well, that'd be something like (quickly, off the top of my head):

$sortpid = open(SORT, "-|");
die "forking sort errors: $!" unless defined $sortpid;
unless ($sortpid) { # main child (sort) does this:
	$pumppid = open(PUMP,"-|");
	die "forking pump errors: $!" unless defined $pumppid;
	unless ($pumppid) { # sort child (pump) does this:
		print $list; # to my stdout
		exit 0;
	}
	open(STDIN,"<&PUMP") || die "No dup?";
	close(PUMP);
	exec "sort -u";
	die "Cannot exec sort -u: $!";
}

$fred = join("",<SORT>); # or undef $/, or whatever
close(SORT);

Yeah, you can probably wrap this up into a sub.  But here it is
in all of its glory.

But even with this method, all you're trading off is a perl fork vs.
a shell fork.  Probably not worth the effort unless your $list is
HUGE and won't fit into the argument list size.

# (somebody's been playing with Karma Manager(tm)... :-)
$_ = "wftedskaebjgdpjgidbsmnjgc"; tr/a-z/oh, turtleneck Phrase Jar!/; print
--
Randal L. Schwartz / Stonehenge Consulting Services (503)777-0095
merlyn@ora.com (semi-permanent) merlyn@kandinsky.intel.com (temp)
factoid: "Portland, Oregon, home of the California Raisins and Lone-Star Beer!"


