# vim:set filetype=perl sw=4 et:
# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 14.t'

#########################

use Test::More tests => 290;
use Carp;

BEGIN {use_ok 'Lingua::Zompist::Verdurian', 'noun', 'adj'; }

sub noun_form_ok {
    croak 'usage: noun_form_ok($noun, $is, $should)' unless @_ == 3;
    my($noun, $is, $should) = @_;

    is($is->[0], $should->[0], "nom.sg. of $noun");
    is($is->[1], $should->[1], "gen.sg. of $noun");
    is($is->[2], $should->[2], "acc.sg. of $noun");
    is($is->[3], $should->[3], "dat.sg. of $noun");
    is($is->[4], $should->[4], "nom.pl. of $noun");
    is($is->[5], $should->[5], "gen.pl. of $noun");
    is($is->[6], $should->[6], "acc.pl. of $noun");
    is($is->[7], $should->[7], "dat.pl. of $noun");
}

sub adj_form_ok {
    croak 'usage: adj_form_ok($adj, $is, $should)' unless @_ == 3;
    my($adj, $is, $should) = @_;

    is($is->[0][0], $should->[0][0], "masc.nom.sg. of $adj");
    is($is->[0][1], $should->[0][1], "masc.gen.sg. of $adj");
    is($is->[0][2], $should->[0][2], "masc.acc.sg. of $adj");
    is($is->[0][3], $should->[0][3], "masc.dat.sg. of $adj");
    is($is->[0][4], $should->[0][4], "masc.nom.pl. of $adj");
    is($is->[0][5], $should->[0][5], "masc.gen.pl. of $adj");
    is($is->[0][6], $should->[0][6], "masc.acc.pl. of $adj");
    is($is->[0][7], $should->[0][7], "masc.dat.pl. of $adj");
    is($is->[1][0], $should->[1][0], "fem.nom.sg. of $adj");
    is($is->[1][1], $should->[1][1], "fem.gen.sg. of $adj");
    is($is->[1][2], $should->[1][2], "fem.acc.sg. of $adj");
    is($is->[1][3], $should->[1][3], "fem.dat.sg. of $adj");
    is($is->[1][4], $should->[1][4], "fem.nom.pl. of $adj");
    is($is->[1][5], $should->[1][5], "fem.gen.pl. of $adj");
    is($is->[1][6], $should->[1][6], "fem.acc.pl. of $adj");
    is($is->[1][7], $should->[1][7], "fem.dat.pl. of $adj");
}

# Test default (should be on)

is($Lingua::Zompist::Verdurian::keep_accents, 1, 'keep_accents == 1');

noun_form_ok('lavsia', noun('lavsia'), [ qw( lavsia lavs lavsiam lavsian
                                               lavsi lavsi lavsem lavsen ) ]);
noun_form_ok('barsc', noun('barsc'), [ qw( barsc barscei barsc barsucn
                                             barss barssi barssi barssin ) ]);
noun_form_ok('ecelg', noun('ecelg'), [ qw( ecelg ecelgei ecelg ecelogn
                                             ecelzhi ecelzhi ecelzhi ecelzhin ) ]);
noun_form_ok('etalg', noun('etalg'), [ qw( etalg etalgei etalg etalogn
                                             etalzhi etalzhi etalzhi etalzhin ) ]);
noun_form_ok('p', noun('p'), [ qw( p pi p pn p pi pm pn ) ]);
noun_form_ok('akn', noun('akn'), [ qw( akn akni aknm aknn
                                         akni akno aknm aknin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi gggm gggn
                                         gggi gggo gggm gggin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi gggm gggn
                                         ggg gggu gggm gggin ) ]);
noun_form_ok('gggy', noun('gggy'), [ qw( gggy gggi gggim gggin
                                           ggg ggg gggom ggguin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi ggg gggn
                                         ggg gggi gggm gggn ) ]);
adj_form_ok('munn', adj('munn'), [ [ qw( munn munni munn munenn
                                             munni munn munenm munnin ) ],
                                       [ qw( munna munne munna munnan
                                             munn munni munnem munnen ) ] ]);


# explicit keep on

$Lingua::Zompist::Verdurian::keep_accents = 1;

noun_form_ok('lavsia', noun('lavsia'), [ qw( lavsia lavs lavsiam lavsian
                                               lavsi lavsi lavsem lavsen ) ]);
noun_form_ok('barsc', noun('barsc'), [ qw( barsc barscei barsc barsucn
                                             barss barssi barssi barssin ) ]);
noun_form_ok('ecelg', noun('ecelg'), [ qw( ecelg ecelgei ecelg ecelogn
                                             ecelzhi ecelzhi ecelzhi ecelzhin ) ]);
noun_form_ok('etalg', noun('etalg'), [ qw( etalg etalgei etalg etalogn
                                             etalzhi etalzhi etalzhi etalzhin ) ]);
noun_form_ok('p', noun('p'), [ qw( p pi p pn p pi pm pn ) ]);
noun_form_ok('akn', noun('akn'), [ qw( akn akni aknm aknn
                                         akni akno aknm aknin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi gggm gggn
                                         gggi gggo gggm gggin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi gggm gggn
                                         ggg gggu gggm gggin ) ]);
noun_form_ok('gggy', noun('gggy'), [ qw( gggy gggi gggim gggin
                                           ggg ggg gggom ggguin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggi ggg gggn
                                         ggg gggi gggm gggn ) ]);
adj_form_ok('munn', adj('munn'), [ [ qw( munn munni munn munenn
                                             munni munn munenm munnin ) ],
                                       [ qw( munna munne munna munnan
                                             munn munni munnem munnen ) ] ]);

# explicit keep off

$Lingua::Zompist::Verdurian::keep_accents = 0;

noun_form_ok('lavsia', noun('lavsia'), [ qw( lavsia lavs lavsiam lavsian
                                               lavsi lavsi lavisem lavisen ) ]);
noun_form_ok('barsc', noun('barsc'), [ qw( barsc barscei barsc barsucn
                                             barsus barssi barsusi barsusin ) ]);
noun_form_ok('ecelg', noun('ecelg'), [ qw( ecelg ecelgei ecelg ecelogn
                                             ecelozhi ecelzhi ecelozhi ecelozhin ) ]);
noun_form_ok('etalg', noun('etalg'), [ qw( etalg etalgei etalg etalogn
                                             etalozhi etalzhi etalozhi etalozhin ) ]);
noun_form_ok('p', noun('p'), [ qw( p pei p pn p pi pm pn ) ]);
noun_form_ok('akn', noun('akn'), [ qw( akn aknei aknm aknn
                                         aknoi akno aknm aknoin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggei gggm gggn
                                         gggoi gggo gggm gggoin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggui gggm gggn
                                         ggg gggu gggm ggguin ) ]);
noun_form_ok('gggy', noun('gggy'), [ qw( gggy gggii gggiim gggin
                                           gggi ggg gggiom ggguin ) ]);
noun_form_ok('ggg', noun('ggg'), [ qw( ggg gggei ggg gggn
                                         ggg gggi gggm gggn ) ]);
adj_form_ok('munn', adj('munn'), [ [ qw( munn munni munn munenn
                                             munni munn munenm munnin ) ],
                                       [ qw( munena munene munena munenan
                                             munen munni munenem munenen ) ] ]);
