/*
 * $Id: chkxls.c,v 1.4 1992/07/29 07:55:20 proj Exp $
 */
/*
 * X11R5 Input Method Test Program
 * chkxls.c v 1.0   Mon Mar 11 14:27:45 JST 1991
 */

/*
 * Copyright 1991, 1992 by OMRON Corporation
 *
 *      Author: Takashi Inoue    OMRON Corporation
 *                               takashi@ari.ncl.omron.co.jp
 */

#include <stdio.h>
#include "exvalue.h"
#include "func.h"

void	xlstr(ic, event)
XIC	ic;
XEvent	*event;
{
    int		res;
    int		cnt;
    char	mbbuf[MAX_BUF];
    wchar_t	wcbuf[MAX_BUF];
    KeySym	ksret;
    Status	stret;

    if (strflag == MB) {
	res = XmbLookupString(ic, event, mbbuf, sizeof(mbbuf),
			      &ksret, &stret);
    } else if (strflag == WC) {
	res = XwcLookupString(ic, event, wcbuf, sizeof(wcbuf),
			      &ksret, &stret);
    }
    cls(prdisp);
    switch (stret) {
      case XLookupBoth:
      case XLookupKeySym:
	prprint("Key Symbol returned.\n");
	fprintf(icfp, "returned Key Symbol : 0x%X\n", ksret);
	if (stret == XLookupKeySym)
	    prprint("\nCheck your own eyes on the test window.\n\n");
	    break;
      case XLookupChars:
	prprint("Character returned.\n");
	prprint("\nCheck your own eyes on the test window.\n\n");
	for (cnt = 0; cnt < res; cnt++) 
	    if (strflag == MB) {
		fprintf(icfp, "returned character code : 0x%X\n", mbbuf[cnt]);
	    } else if (strflag == WC) {
		fprintf(icfp, "returned character code : 0x%X\n", wcbuf[cnt]);
	    }
	fprintf(icfp, "\n");
	break;
      case XLookupNone:
	prprint("returned status : XLookupNone\n\n");
	fprintf(icfp, "returned status : XLookupNone\n\n");
	break;
      case XBufferOverflow:
	prprint("returned status : XBufferOverflow\n\n");
	fprintf(icfp, "returned status : XBufferOverflow\n\n");
	break;
      default:
	prprint("returned status : Unknown Value\n\n");
	fprintf(icfp, "returned status : Unknown Value\n\n");
	break;
    }
}
