/*
  Drag and drop TeX.
  Change the name of executable file as ddrp-platex.exe,
  ddrp-ptex.exe, ddrp-pdftex.exe, etc. The name after "ddrp-"
  is adopted as a TeX command to be invoked.
  (Kanji path name is allowed for pTeX and its friends.)
  This program is ABSOLUTELY free.

  Changed to enable options for Command. 2001/09/02 --ak
  ( related file : Command.opt )
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <process.h>
#include <windows.h>

#define SBUF 256
#define OPTSUFFIX  ".opt"

/*
Names of programs which are not TeX compilers though they end with 'tex'.
*/

char *Nottexprg[] = {
"bibtex",
"jbibtex",
"chktex",
"detex",
"glosstex",
NULL
};

/*
Names of TeX programs which do not end with 'tex' or 'tex209'.
*/

char *Texprg[] = {
"aleph",
"gamma",
"omega",
"omegaj",
"lambda",
"lambdaj",
"lamed",
"lmj209",
"ptexold",
"ptexsis",
"texsis",
NULL
};


/*
  Return long file name of name[]
*/

char *getlongfilename(char *name)
{
  HANDLE hnd;
  WIN32_FIND_DATA ffd;

  char *path;
  char *fp;

  path = (char *)malloc(SBUF);

  if(!GetFullPathName(name, SBUF, path, &fp)) {
    fprintf(stderr, "%s is not found!\n", name);
    exit(100);
  }

  if ((hnd = FindFirstFile(path, &ffd)) == NULL) {
    fprintf(stderr,"%s is not found!\n",name);
    exit(100);
  }
  FindClose(hnd);
  strcpy(path, ffd.cFileName);
  return path;
}

/*
  Is first byte of sjis ?
*/

int iskj(unsigned c)
{
  c &= 0xff;
  return (((c) >= 0x81 && (c) <= 0x9f) || ((c) >= 0xe0 && (c) <= 0xfc));
}

int main(int ac, char **av)
{
  int current_drive, tgt_drive, len;
  FILE *fopt = NULL;
  char opt[1024];
  char optfile[256];
  char buff[256];
  char bname[256];
  char jobname[256];
  char texcmd[256];
  char *p;
  char *pp;
  char *ppp;
  int  knjfile;
  int  istex, i;

  istex = 0;

  if(ac != 2) {
    fprintf(stderr, "Argument error.\n");
    exit(100);
  }

/*
  change dirctory separator to /
*/
  for(p = av[0]; *p; p++) {
    if(iskj(*p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }

  for(p = av[1]; *p; p++) {
    if(iskj(*p)) {
      p++;
      continue;
    }
    if(*p == '\\') *p = '/';
  }

  p = getlongfilename(av[0]);
  pp = p;

  p = strrchr(pp, '.');
  if(p && !stricmp(p, ".exe"))
    *p = '\0';
  p = pp;

  if((strnicmp(p, "ddrp-", 5))) {
    fprintf(stderr, "My name should begin with \"ddrp-\".");
    exit(100);
  }
  else
    p += 5;
  strcpy(texcmd, p);
  
  i = strlen(p);
  if(i > 2) {
    p = texcmd + i - 3;
    if(!stricmp(p, "tex")) istex = 1;
  }
  if(i > 5) {
    p = texcmd + i - 6;
    if(!stricmp(p, "tex209")) istex = 1;
  }

  for(i=0; Texprg[i]; i++)
    if(!stricmp(texcmd, Texprg[i])) istex = 1;

  for(i=0; Nottexprg[i]; i++)
    if(!stricmp(texcmd, Nottexprg[i])) istex = 0;

  p = pp;
  p += 5;

/*
  file Command.opt for options
*/
  strcpy(optfile, p);
  p = strrchr(optfile, '.');
  if(p) *p = '\0';
  strcat(optfile, OPTSUFFIX);

  strcpy(buff, av[1]);
  p = getlongfilename(av[1]);
  ppp = p;

  strcpy(bname, "\"");
  strcat(bname, p);
  strcat(bname, "\"");
  strcpy(jobname, "--jobname=");
  strcat(jobname, "\"\\\"");
  strcat(jobname, p);
  if((p = strrchr(jobname, '.'))) {
    *p = '\0';
    strcat(jobname, "\"\\\"");
  }
  else
    strcat(jobname, "\"\\\"");

  knjfile = 0;
  for(p = bname; *p; p++) {
    if(iskj(*p)) {
      knjfile=1;
      break;
    }
  }

  if((p = strrchr(buff, '/'))) {
    *p = '\0';
    if(*(p-1) == ':') {
      *p = '/';
      *(p+1) = '\0';
    }
  }
  else {
    fprintf(stderr, "Bad path name.\n");
    exit (100);
  }

/*
  save current drive
*/
  current_drive = _getdrive();

  if(*(buff + 1) == ':') {
    tgt_drive = tolower(*buff) + 1 - 'a';
    _chdrive(tgt_drive);
  }

  _chdir(buff);

/*
  enable options for Command
  by reading Command.opt
*/
  *opt = '\0';

  fopt = fopen(optfile, "r");
  if(fopt) {
    do {
      fgets(opt, 256, fopt);
    } while(*opt == '\n' || *opt == '#' || *opt == '%');
    fclose(fopt);
    len = strlen(opt);
    if(opt[len-1] == '\n')
      opt[len-1] = '\0';
  }

/*
  call command
*/
  if(*opt) {
    if(knjfile && istex)
      spawnlp(P_WAIT, texcmd, texcmd, jobname, opt, bname, NULL);
    else
      spawnlp(P_WAIT, texcmd, texcmd, opt, bname, NULL);
  }
  else {
    if(knjfile && istex)
      spawnlp(P_WAIT, texcmd, texcmd, jobname, bname, NULL);
    else
      spawnlp(P_WAIT, texcmd, texcmd, bname, NULL);
  }

/*
  return to the original drive
*/
  _chdrive(current_drive);

  fprintf(stderr,"Hit x and Enter key to exit.\n");

  free(pp);
  free(ppp);

  while(1) {
    len = getchar();
    if(len == 'x') break;
  }

  return (0);
}
