/*
 Command line loader of acrodist.exe.
 distill.c (for distill.exe) 2003/02 --ak
 acrodist.exe should be found in the command PATH.

----------------------
 How to describe in dvipdfm.cfg and dvipdfmx.cfg:
 ...
 D "distill -o%o %i"
 ...
----------------------

Usage   : distill [Options] file[.ps]
Options : -oOutput_Name
                 space is not allowed between -o and Output_Name
          -Jjob_option
                 set Job option
                 space is not allowed between -J and path name
          -w
                 wait for the distiller
          -N
                 run a new acrodist
          -N -Q
                 run a new acrodist and terminate it
          -V
                 open the created pdf by a default viewer

The -V option cannot be used with the -o option.
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include <process.h>
#include <direct.h>
#include <windows.h>

#define MBUF   128
#define SBUF   256
#define LBUF   1024
#define DIST   1
#define DISTIL "acrodist.exe"

#define R_OK   4
#define QT     0x22

#define TMP_EPS_NAME  "tmp-_eps-_name-_10-_63-_74-_bcz.eps"
#define TMP_PDF_NAME  "tmp-_eps-_name-_10-_63-_74-_bcz.pdf"
#define TMP_LOG_NAME  "tmp-_eps-_name-_10-_63-_74-_bcz.log"

void erasetmp(void)
{
  FILE *ff;
  ff = fopen(TMP_PDF_NAME, "rb");
  if(ff) {
    fclose(ff);
    remove(TMP_PDF_NAME);
  }
  ff = fopen(TMP_EPS_NAME, "rb");
  if(ff) {
    fclose(ff);
    remove(TMP_EPS_NAME);
  }
  ff = fopen(TMP_LOG_NAME, "rb");
  if(ff) {
    fclose(ff);
    remove(TMP_LOG_NAME);
  }
}

int main(int argc, char **argv)
{
  HANDLE hnd;
  WIN32_FIND_DATA ffd;
  char  name[MBUF];
  char path[SBUF];
  char path2[SBUF];
  char path3[SBUF];
  char job[SBUF];
  char *fp;
  char cmd[LBUF];
  int  i, j;

  char outname[MBUF];
  int  setoutname = 0;
  int  wait = 0;
  FILE *ff;

  erasetmp();
  job[0] = '\0';
  strcpy(argv[0], "distill");
  if(argc == 1) {
    printf("Usage   : %s [Options] file[.ps]\n", argv[0]);
    printf("Options : -oOutput_Name\n");
    printf("                 space is not allowed between -o and Output_Name\n");
    printf("          -Jjob_option\n");
    printf("                 set Job option\n");
    printf("                 space is not allowed between -J and job_option\n");
    printf("          -w\n");
    printf("                 wait for the distiller\n");
    printf("          -N\n");
    printf("                 run a new acrodist\n");
    printf("          -N -Q\n");
    printf("                 run a new acrodist and terminate it\n");
    printf("          -V\n");
    printf("                 open the created pdf by a default viewer\n");
    printf("\n");
    printf("job_option : one of the following.\n");
    printf("          \"High Quality Print\"     \"MAGAZINE Ad 2006 JPN\"\n");
    printf("          \"Oversized Pages\"        \"PDFA1b 2005 CMYK\"\n");
    printf("          \"PDFA1b 2005 RGB\"        \"PDFX1a 2001 JPN\"\n");
    printf("          \"PDFX1a 2001\"            \"PDFX3 2002 JPN\"\n");
    printf("          \"PDFX3 2002\"             \"Press Quality\"\n");
    printf("          \"Smallest File Size\"     \"Standard\" (default)\n");
    return 0;
  }

  strcpy(name, argv[argc-1]);
  fp = strrchr(name, '.');
  if(fp == NULL)
    strcat(name, ".ps");

  if(!GetFullPathName(name, SBUF, path, &fp)) {
    fprintf(stderr, "%s is not found!\n", name);
    return 100;
  }

  cmd[0] = '\0';
  for(i=1; i < argc-1; i++) {
    if(strnicmp(argv[i], "-w", 2) == 0) {
      wait = 1;
    } else if(strnicmp(argv[i], "-o", 2) == 0) {
      if(*(argv[i] + 2) == '\0') {
	fprintf(stderr, "Argument error\n");
	return 200;
      }
      strcpy(outname, argv[i] + 2);
      setoutname = 1;
    } else if(strnicmp(argv[i], "-J", 2) == 0) {
      if(*(argv[i] + 2) == '\0') {
	fprintf(stderr, "Argument error\n");
	return 200;
      }
/*
      to support path names for Job option including spaces
*/
      strcpy(job, "-J");
      job[2] = QT;
      job[3] = '\0';
      strcat(job, argv[i] + 2);
      j = strlen(job);
      job[j] = QT;
      job[j+1] = '\0';
      strcat(cmd, job);
    }
    else
      strcat(cmd, argv[i]);
    if(i != (argc - 2))
      strcat(cmd, " ");
  }

  if(job[0] == '\0')
    strcat(cmd, " -JStandard");
  if(access(path, R_OK)) {
    fprintf(stderr, "Check the file name.\n");
    return 100;
  }

/*
When called by dvipdfm(x), acrodist cannot read the original file,
so I copy the file to the temporary one.
*/
  if(setoutname) {
    (void)_getcwd(path3, 256);
    i = strlen(path3);
    if(path3[i-1] != '/' && path3[i-1] != '\\') {
      path3[i] = '\\'; path3[i+1] = '\0';
    }
    strcat(path3, TMP_EPS_NAME);
    CopyFile(path, path3, FALSE);
  }

/*
to support path names including spaces:
*/
  path2[0] = QT;
  path2[1] = '\0';
  if(setoutname)
    strcat(path2, path3);
  else
    strcat(path2, path);
  j = strlen(path2);
  path2[j] = QT;
  path2[j+1] = '\0';

/* Debug
printf("%s", cmd);
printf("\n");
printf("%s", path2);
*/

  if(setoutname && wait) {
    (void)_spawnlp(P_WAIT, DISTIL, DISTIL, cmd, path2, NULL);
    Sleep(500);
    CopyFile(TMP_PDF_NAME, outname, FALSE);
    erasetmp();
  } else if(setoutname && !wait) {
    (void)_spawnlp(P_NOWAIT, DISTIL, DISTIL, cmd, path2, NULL);
    Sleep(500);
    while(1) {
      ff = fopen(TMP_PDF_NAME, "rb");
      if(ff) {
	fclose(ff);
	break;
      }
    }
    Sleep(500);
    CopyFile(TMP_PDF_NAME, outname, FALSE);
    erasetmp();
  } else if(!setoutname && wait) 
    (void)_spawnlp(P_WAIT, DISTIL, DISTIL, cmd, path2, NULL);
  else
    (void)_spawnlp(P_NOWAIT, DISTIL, DISTIL, cmd, path2, NULL);
  erasetmp();
  return 0;
}
