/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossaryEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.NewGlossaryEntry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class GlossariesSty
extends LaTeXSty {
    private HashMap<String, GlossaryEntry> entries = new HashMap();
    private HashMap<String, Glossary> glossaries = new HashMap();
    private Vector<String> glossaryTypes = new Vector();
    private Vector<String> ignoredGlossaryTypes = new Vector();
    private boolean createMain = true;
    private boolean expandFields = true;
    private HashMap<String, Boolean> expandField = new HashMap();
    public static final String GLOSSARY_NOT_DEFINED = "glossaries.glossary.not.defined";
    public static final String ENTRY_NOT_DEFINED = "glossaries.entry.not.defined";
    public static final String GLOSSARY_EXISTS = "glossaries.glossary.exists";
    public static final String ENTRY_EXISTS = "glossaries.entry.exists";

    public GlossariesSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        this(keyValList, "glossaries", laTeXParserListener, bl);
    }

    public GlossariesSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
        this.expandField.put("name", Boolean.FALSE);
        this.expandField.put("description", Boolean.FALSE);
        this.expandField.put("descriptionplural", Boolean.FALSE);
        this.expandField.put("symbol", Boolean.FALSE);
        this.expandField.put("symbolplural", Boolean.FALSE);
        this.expandField.put("sort", Boolean.FALSE);
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new GenericCommand("glsdefaulttype", null, this.getListener().createString("main")));
        this.registerControlSequence(new GenericCommand("glossaryname", null, this.getListener().createString("Glossary")));
        this.registerControlSequence(new NewGlossaryEntry(this));
    }

    @Override
    protected void postOptions() throws IOException {
        if (this.createMain) {
            this.createGlossary("main", new TeXCsRef("glossaryname"));
        }
    }

    public GlossaryEntry getEntry(String string) {
        return this.entries.get(string);
    }

    public boolean isEntryDefined(String string) {
        return this.entries.containsKey(string);
    }

    public boolean isGlossaryDefined(String string) {
        return this.glossaries.containsKey(string);
    }

    public Glossary getGlossary(GlossaryEntry glossaryEntry) {
        return this.getGlossary(glossaryEntry.getType());
    }

    public Glossary getGlossary(String string) {
        return this.glossaries.get(string);
    }

    public void createGlossary(String string, TeXObject teXObject) throws TeXSyntaxException {
        this.createGlossary(string, teXObject, false);
    }

    public void createGlossary(String string, TeXObject teXObject, boolean bl) throws TeXSyntaxException {
        if (this.isGlossaryDefined(string)) {
            throw new LaTeXSyntaxException(this.getParser(), GLOSSARY_EXISTS, string);
        }
        Glossary glossary = new Glossary(string, teXObject);
        this.glossaries.put(string, glossary);
        if (bl) {
            this.ignoredGlossaryTypes.add(string);
        } else {
            this.glossaryTypes.add(string);
        }
    }

    public void addEntry(byte by, GlossaryEntry glossaryEntry) throws TeXSyntaxException {
        Glossary glossary;
        String string = glossaryEntry.getLabel();
        if (this.isEntryDefined(string)) {
            switch (by) {
                case 0: {
                    throw new LaTeXSyntaxException(this.getParser(), ENTRY_EXISTS, string);
                }
                case 2: {
                    return;
                }
            }
        }
        if ((glossary = this.getGlossary(glossaryEntry)) == null) {
            throw new LaTeXSyntaxException(this.getParser(), GLOSSARY_NOT_DEFINED, glossaryEntry.getType());
        }
        glossary.add(string);
        this.entries.put(string, glossaryEntry);
    }

    public boolean isFieldExpansionOn(String string) {
        Boolean bl = this.expandField.get(string);
        if (bl != null) {
            return bl;
        }
        return this.expandFields;
    }
}

