/*							dviout for Windows
 *
 *								WinMain
 *						1996, written by SHIMA & Otobe
 */
#include <windows.h>   // Win32APIgp
#include <ddeml.h>	   // DDEMLCugp
#include <commctrl.h>
// #include <shlwapi.h>	  // DllGetVersion() ...
#include <io.h>
#include <HtmlHelp.h>
#include "resource.h"  // ؿ`̧قǂݍ
#include "root.h"	   // ع݌ŗL̒萔
#include "inter.h"
#include "option.h"
#include "err.h"
#include "dviadd.h"
#include <shlobj.h> // IShellLink, IPersistFile
#include "floatwnd.h"
#ifdef USE_KPATHSEA
#include "kpseutil.h"
#endif

#define MAXCLIP	0x10000	// maximal text size (to Clipboard)

//	VC 6.0	<shlwapi.h>

typedef struct _DllVersionInfo
{
		DWORD cbSize;
		DWORD dwMajorVersion;					// Major version
		DWORD dwMinorVersion;					// Minor version
		DWORD dwBuildNumber;					// Build number
		DWORD dwPlatformID;						// DLLVER_PLATFORM_*
} DLLVERSIONINFO;

#define DLLVER_PLATFORM_WINDOWS			0x00000001		// Windows 95
#define DLLVER_PLATFORM_NT				0x00000002		// Windows NT

typedef HRESULT (CALLBACK* DLLGETVERSIONPROC)(DLLVERSIONINFO *);


#ifdef USE_INTELLI_MOUSE
UINT uMSH_MOUSEWHEEL = 0;
UINT WheelScrollLines = 0;
void InitIntelliMouse( void );
UINT GetNumScrollLines(void);
#endif // USE_INTELLI_MOUSE

#ifndef ICC_WIN95_CLASSES
//#error	Require new <commctrl.h>
#define ICC_WIN95_CLASSES	 0x000000FF
#define ICC_COOL_CLASSES	 0x00000400 // rebar (coolbar) control
typedef struct tagINITCOMMONCONTROLSEX {
	DWORD dwSize;			  // size of this structure
	DWORD dwICC;			  // flags indicating which classes to be initialized
} INITCOMMONCONTROLSEX, *LPINITCOMMONCONTROLSEX;
#endif

/* [U[`bZ[WƂɗނ萔 */
#define WM_USER_INITIATE (WM_USER + 1)	   // [U[bZ[W
#define WM_USER_ALREADY_EXIST (WM_USER +2) // AvĂыN悤
										   // Ƃɑ
#define	SHOW_IS_MODAL	1
#define SEARCH_DVIOUT	1
#define	FILE_FONT_CASH	0
#define NUMSTATUS		4
#define	INIT_TEXPK	"TEXROOT=^T\\fonts TEXPK=^r\\tfm\\\\^s^tfm;^r\\pk\\\\^s.^dpk;^r\\vf\\\\^s.vf;^r\\ovf\\\\^s.ovf;^r\\tfm\\\\^s.tfm"

static BOOL CALLBACK EnumProc( HWND, LPARAM );
static void TellToOpen( void );
static void SetFile2Menu(void);
static void LoadPathCash(void);

char *marea(unsigned int);
void Free(void *);

///////////////////////////////////////////////////////////////////////////
//		   AvP[VCX^X̒萔ƕϐ						 //
///////////////////////////////////////////////////////////////////////////
DVIWIN		 g_winData;
char		 g_szFileName[MAX_PATH*2];	  // dvi-file (with  #...)
char		 g_szFileName2[MAX_PATH];	  // 2nd dvi-file
char		 g_szPrevFileName[MAX_PATH];  // O dvi-file
char		 g_szSaveName[MAX_PATH];
char		 g_szCfgName[MAX_PATH];
char		 g_szParaName[MAX_PATH];
char		 g_szCoverName[MAX_PATH];
char		 *exec_src_sp;
char		 *exec_gsrc_sp;
char		 *ToEdit;
int			 PrevPage;
static int	 f_src_sp;

OPENFILENAME g_OpenFileName;			// OPENFILENAME\
DDESTRUCT	 g_ddeData;
HANDLE		 g_hAccel;					  // ANZ[^nh

OSVERSIONINFO	osvi;

short	   g_nxIndent = 0;				 // x̗]
short	   g_nyIndent = 20;				 // y̗]
int		   multi_dviout;

// int		  max_message = 30;			   // message ̍ős
char	   *log_file;
BOOL	   f_log;
BOOL	   f_fkeep = TRUE;
BOOL	   f_English;
BOOL	   f_dstop;
int		   f_osversion;
int 	   view_back;

int g_cyToolBar = G_CYTOOLBAR;	// the height of toolbar
// int	g_cyToolBar0;
int g_cyStatusBar =G_CYSTATUSBAR; // the height of status bar
int g_cyStatusBar0;
int g_cxSlider = 32;	// the width of slider
int g_cyShowMessage; // the height of showing message window
// int g_cxSlider0;
int CYSHOWMESSAGE = 160;
extern int f_comctlversion;
extern int f_shellversion;

BOOL f_HandMouse; // if true, mouse cursor is "hand" mode.
BOOL f_HandMoving; // if true, mouse is dragging to scroll.
BOOL f_CoverMoving; // if true, mouse is dragging to scroll cover.
BOOL f_Capturing;  // if true, mouse is capturing.
BOOL f_ShowCursor = TRUE; // if true, mouse cursor is shown
BOOL f_Loupe;	   // if true, loupe window is shown.

extern BOOL f_flatscroll;
extern int  f_background;
extern int	gray_number;
extern int f_b_bcolor;
extern int f_rpcolor;
extern int pick_source;
extern char *exec_para;

VIEWCTRL g_view;
extern BOOL f_presenmenu;
extern int f_pmenu;
extern int f_cover;
extern int f_coverH;
extern int f_coverB;
extern BOOL f_coverP;
extern BOOL f_coverM;
extern int cover_xpos;
extern int cover_ypos;

extern BOOL f_rectcut;
extern RECT rectcut;

extern unsigned char *pDibPen;

int DVIOUT_Count;
static int DVIOUT_Exist;
static HWND DVIOUT_PRE_WND;

extern FARPROC g_FlatSB_SetScrollRange;
extern FARPROC g_FlatSB_SetScrollPos;
extern FARPROC g_FlatSB_SetScrollProp;
extern FARPROC g_InitializeFlatSB;
extern HINSTANCE g_hDVIOUTSR;
HANDLE g_hWait = NULL;
///////////////////////////////////////////////////////////////////////////
//					 DDEŎgp萔ƕϐ							 //
///////////////////////////////////////////////////////////////////////////

/* W argc, argv 𗘗p\ɂ邽߂̐錾 */

#ifdef	__BORLANDC__
#define argc _argc
#define argv _argv
#else
#define argc __argc
#define argv __argv
#endif // __BORLANDC__

extern int	argc;		 // argument counter
extern char **argv;		 // argument vector


#include <stdio.h>

static char inipath[MAX_PATH];
static int dviext;
static BOOL f_message;
HINSTANCE g_hCCdll;

int draw_color;
int	draw_style;

static void GetDvioutIni(void)
{
	int		len;

	GetModuleName(inipath);
	len = strlen(inipath)-4;
	if(len < 0)
		len = 0;
	if(inipath[len] != '.'){
		while(inipath[len] != '.' && inipath[len])
			len++;
		inipath[len] = '.';
	}
	dviext=len+1;
	strcpy(inipath + dviext, "par");
	if(access(inipath, 0) == 0
		|| ( strcpy(inipath + dviext, "ini"), access(inipath, 0) == 0 ) ){
			set_config(inipath);
			return;
	}
	GetWindowsDirectory(common_work, MAX_PATH);
	strcat(common_work, "\\dviout.par");
	if(access(common_work, 0) == 0
	  || ( strcpy(common_work + strlen(common_work) - 3, "ini"),
		   access(common_work, 0) == 0 ) )
		set_config(common_work);
}


static int SetFromRegistry(void)
{
	int pos;
	for(pos = 1; pos < argc; pos++){
		if(*argv[pos] != '-')
			break;
		if(strcmp(argv[pos] + 1, "NULL") == 0)
			return FALSE;
	}
	RestoreRegistry();
	return TRUE;
}

BOOL Install2Reg(char *name)
{
	char para_buf[0x1000];
	FILE *fp;
	int	len;
	FILE *fopenf(char *, char *);

	if( (fp = fopenf(name, "r")) != NULL ){
		len = fread(para_buf, 1, 0xfff, fp);
		if(len > 0){
			para_buf[len] = 0;
			SetPara(para_buf, SAVE_REG);
			return TRUE;
		}
	}
	return FALSE;
}

static void CheckTeXPK(void)
{
	char *texpk;
	char install_path[MAX_PATH];

	texpk = GetParaString("TEXPK");
	if(texpk && *texpk)
		return;
	strcpy(install_path, inipath);
	strcpy(install_path+GetNamePos(inipath), "install.par");
	Install2Reg(install_path);
}

void ChangeLinkToReal( char* lnk_name )
{
   IShellLink* psl;
   IPersistFile* ppf;
   WORD wsz[MAX_PATH]; // For unicode, which is needed for COM.
   char  sz[MAX_PATH]; // for ``ASCII''(Shift-JIS) character, both temporary.
   HRESULT hres;
   CLSID ci; // In "C", REFCLSID (reference to CLSID in C++ sense) -> CLSID*
   IID iid;  // In "C", REFIID (reference to DID in C++ sense) -> IID*
   WIN32_FIND_DATA wfd;
 
   ci = CLSID_ShellLink;
   iid = IID_IShellLink;
   hres = CoCreateInstance( &ci, NULL, CLSCTX_INPROC_SERVER, &iid, (void**)&psl );
   if( !SUCCEEDED(hres) ) return;  // get IShellLink interface.

   iid = IID_IPersistFile;
   hres = psl->lpVtbl->QueryInterface( psl, &iid, (void**)&ppf );
   if( !SUCCEEDED(hres) ) goto error_psl;  // get IPersistFile interface.

   MultiByteToWideChar( CP_ACP, 0, lnk_name, -1, wsz, MAX_PATH );
   hres = ppf->lpVtbl->Load( ppf, wsz, STGM_READ );
   if( !SUCCEEDED(hres) ) goto error_ppf; // load lnk_name shortcut resource

   lstrcpy( sz, lnk_name );
   hres = psl->lpVtbl->GetPath( psl, sz, MAX_PATH, &wfd, 0 );
   if( !SUCCEEDED(hres) ) goto error_ppf; // get path related to shortcut

   ppf->lpVtbl->Release( ppf );
   psl->lpVtbl->Release( psl ); // release system resources

   lstrcpy( lnk_name, sz ); // copy it!
   return;

error_ppf:
    ppf->lpVtbl->Release( ppf );
error_psl:
    psl->lpVtbl->Release( psl );
   return;
}


int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
								LPSTR lpszCmdParam, int nCmdShow )
{
	MSG			msg;
	char		*tmp;
	char		ch;
	int			def_multi, len;
	static	char m_name[7] = "dviout0";

	g_winData.szAppName = m_name;
	g_ddeData.szService = "dviout";	  // T[rX

    g_szFileName[0] = g_szFileName2[0] = g_szPrevFileName[0] = '\0';

	SetParaSection( RestoreInt("Settings", "mode", 0) );
	if( !(def_multi = RestoreInt( "Settings", "cmulti", 0)) )
		def_multi = RestoreIntPara( "multi", 4 );
	if((multi_dviout = RestoreInt("Settings", "multi", 0)) == 0)
		multi_dviout = def_multi;
	if(multi_dviout < 1)
		multi_dviout = 1;
	 if(argc > 1 && argv[1][0]== '-'
	 	&& argv[1][1] >= '1' && argv[1][1] <= '5' && argv[1][2] == 0){
		multi_dviout = argv[1][1] - '0';
	}
#if	0
	ReadHistory(GetOutPath(F_HIST_EXT));
#else
	ReadHistory("FILE");				// Read FILE history
#endif // 0
	for(ch = '0'; ch++ < multi_dviout + '0'; ){
		g_winData.szAppName[6] = (ch == '1')?0:ch;
		g_winData.szClassName 
		  = g_winData.szWindowTitle 
		  = g_winData.szAppName; // ׽߼݁عݖ

		/* I check whether DVIOUT has already existed.
		If DVIOUT(s) has already exist, DVIOUT_Exist flag will be TRUE,
	   and more, DVIOUT_PRE_WND has its window handle.
		*/

		DVIOUT_Exist = FALSE;
		EnumWindows( EnumProc, SEARCH_DVIOUT );

		if( !DVIOUT_Exist )
			break;
		DVIOUT_Count++;
		if(ch == multi_dviout + '0'){
			if( (tmp = (char *)def_dvifile(argc, argv, g_szFileName2)) != NULL
				&& strcmp("?  ?.dvi", tmp) ){
				DefineDVIFileName( tmp );
				TellToOpen();
			}else
				MessageBox( NULL, (tmp == NULL)?
					"No more dviout is opened.":"Cannot find in history.", 
					NULL, MB_OK);
			return 0;
		}
	}

	if(ch == '1'){					// the first dviout doesn't exist.
		ReserveInt("Settings", "multi", 0);
		ReserveInt("Settings", "cmulti", 0);
		def_multi = 0;
	}
	CoInitialize( NULL );

	/* We have to initialize common control library before using it. */
	if( GetVersionLevel() > 0 )
	{
		FARPROC f;
		f = GetProcAddress( g_hCCdll, "InitCommonControlsEx" );
		if( f )
		{
			INITCOMMONCONTROLSEX icex;
			icex.dwSize = sizeof(INITCOMMONCONTROLSEX);
			icex.dwICC = ICC_WIN95_CLASSES | ICC_COOL_CLASSES;
			/*
			ICC_WIN95_CLASSES:	standards
			ICC_COOL_CLASSES: rebar
			*/
			f( &icex );
		}
	}
	else
		InitCommonControls();
	GetVersionLevel(); // dummy call;
	/* Get Windows Version number */
	f_osversion = GetVersion();

	if(argc){
		len = strlen(argv[0]);
		if(len >= 11){
			if(!strcmp(argv[0]-11, "dvioutj.exe"))
				Language(2);
			else if(!strcmp(argv[0]-11, "dvioute.exe"))
				Language(3);
		}
	}

	/* ĂяoύXĂ͂ȂȂBˑ֌WB*/
	InitMainWindow( hInstance, nCmdShow );
	InitViewWindow();
	InitLoupeWindow();
	InitDDE();
	#ifdef USE_INTELLI_MOUSE
	InitIntelliMouse();
	#endif

	ReserveKeyTable();
	StartDviout();						// Initialize parameters
	GetDvioutIni();						// Read dviout.par/dviout.ini
	if((ch = SetFromRegistry()) == TRUE){	// Read from Regisotry
		if(SetParaSection(-1) == 0)			// if not -NULL
			CheckTeXPK();				// install.par
	}
	if(def_multi)
		multi_dviout = def_multi;
	if((tmp = (char *)def_dvifile(argc, argv, g_szFileName2)) != NULL )
		DefineDVIFileName( tmp );		// DVI file in commond line
	if( (tmp = strrchr(g_szFileName, '.')) != NULL && lstrcmpi(tmp+1,"lnk")
== 0 )
		ChangeLinkToReal( g_szFileName );

	g_hAccel = LoadAccelerators( hInstance, MAKEINTRESOURCE(IDR_ACCELERATOR) );

	/* ĂяoʒuύXȂƁBׂ̏̏ĂɈˑĂB*/
										// Initlialize Windows parameters
	tmp = GetParaString("TEXPK");
	if(ch == TRUE && (tmp == NULL || !*tmp)){
		if(getenv("TEXMF") != NULL || getenv("TEXMFMAIN") != NULL)
			SetPara(INIT_TEXPK, SET_OPTION);
		if( MessageBox( g_winData.hMainWnd, 
				"Font path is not set.\n"
				"Install fundamental parameters?",
				"Warning",
				MB_YESNO|MB_ICONEXCLAMATION) == IDYES )
			PostMessage( g_winData.hWnd, WM_COMMAND, ID_INSTALL, 0 );
	}
																				// Initlializee Windows parameters
	SendMessage( g_winData.hMainWnd, WM_USER_INITIATE, 0, 0L );
	SetFile2Menu();			// file history
	ArrangeMenuString();	// arrange menu
	if(ch == TRUE)
		LoadPathCash();
	else
		f_fkeep = FALSE;
	// bZ[W[v
	while( GetMessage( &msg, NULL, 0, 0 ) )
	{

		if( g_winData.hWndFind && IsDialogMessage(g_winData.hWndFind, &msg))
			continue;
		if( g_winData.hWndShow && IsDialogMessage(g_winData.hWndShow, &msg) )
			continue;
		if( g_winData.hWndPick && IsDialogMessage(g_winData.hWndPick, &msg) )
			continue;
		if( g_winData.hWndPresenMenu && IsDialogMessage(g_winData.hWndPresenMenu, &msg) )
			continue;
		
		if( !g_hAccel || !TranslateAccelerator(g_winData.hWnd, g_hAccel, &msg))
		{
			TranslateMessage( &msg ); // ްүނ̕ϊ
			DispatchMessage( &msg );  // үނ̳޳ۼެւި߯
		}
	}

	/* I */
	if( g_hCCdll ) FreeLibrary( g_hCCdll );
	if( g_hDVIOUTSR ) FreeLibrary( g_hDVIOUTSR );
	SetFont( 0, NULL, NULL, FALSE ); // free fonts list.
	CoUninitialize();

	DdeUninitialize( g_ddeData.idInst ); // DDEMLI
	return msg.wParam;
}

// #define	SHOW_HISTORY_BUF		0x8000
#define	SHOW_H_MAX				32		// should be an integer power of 2

struct SHOW_HISTORY {
	char *t;
	char *s;
	int size;
	int pos;
} showHistory[SHOW_H_MAX];

static int show_pos;

void Copy2Clipboad(HWND hdwnd, char *t)
{
	HGLOBAL hg;
	PTSTR strMem;

	hg = GlobalAlloc(GHND | GMEM_SHARE , strlen(t)+1);
	if(!OpenClipboard(hdwnd)){
		GlobalFree(hg);
		return;
	}
	EmptyClipboard();
	strMem = (PTSTR)GlobalLock(hg);
	lstrcpy(strMem , TEXT(t));
	GlobalUnlock(hg);
	SetClipboardData(CF_TEXT , hg);
	CloseClipboard();
}

HWND GetTop(HWND hwnd)
{
	HWND TWnd;

	while(TWnd = GetParent(hwnd))
		hwnd = TWnd;
	return hwnd;
}

void Copy2Editor(HWND hdwnd, char *t, int mode)
{
	int i;
	static HWND EditWnd;
    static HWND MWnd;

	if(!MWnd)
		MWnd = GetTop(g_winData.hMainWnd);
	if(EditWnd != NULL && 
		(mode  || !IsWindow(EditWnd) || !IsWindowVisible(EditWnd)) )
		EditWnd = NULL;
rep:
	i = 0;
	while(!EditWnd && i++ < 100){
		EditWnd = GetTop(GetForegroundWindow());
		if(EditWnd == MWnd || IsIconic(EditWnd))
			EditWnd = NULL;
		if(i==1)
			DisplayWinMessage(g_winData.hMainWnd, "Activate the Editor to be copied (within 5 sec)!");
		Sleep(50);
	}
	if(i)
		DisplayWinMessage(g_winData.hMainWnd, NULL);
	if(EditWnd){
		if(SetForegroundWindow(EditWnd)){
#if 1
			char *s;

			s = (ToEdit==NULL || !*ToEdit)?"^c^V":ToEdit;
			for(;*s;s++){
				if(*s == '^'){
					if(*++s == 'c'){
						Copy2Clipboad(hdwnd, t);
						Sleep(150);
					}else if(*s == 'e'){
						for(i = 0; t[i]; i++)
							SendMessage(EditWnd,WM_CHAR,t[i],0);
					}else if(*s == '^'){
						goto key;
					}else if(!*s){
						s--;
						goto key;
					}else{
						keybd_event(VK_CONTROL,(BYTE)MapVirtualKey(VK_SHIFT,0),0,0);
						keybd_event(*s,(BYTE)MapVirtualKey(*s,0),0,0);
						keybd_event(*s,(BYTE)MapVirtualKey(*s,0),KEYEVENTF_KEYUP,0);
						keybd_event(VK_CONTROL,(BYTE)MapVirtualKey(VK_SHIFT,0),KEYEVENTF_KEYUP,0);
					}	
				}else{
key:        		keybd_event(*s,(BYTE)MapVirtualKey(*s,0),0,0);
        			keybd_event(*s,(BYTE)MapVirtualKey(*s,0),KEYEVENTF_KEYUP,0);
        		}
			}
#else
			Copy2Clipboad(hdwnd, t);
			Sleep(150);
        	keybd_event(VK_CONTROL,(BYTE)MapVirtualKey(VK_SHIFT,0),0,0);
        	keybd_event('V',(BYTE)MapVirtualKey('V',0),0,0);
        	keybd_event('V',(BYTE)MapVirtualKey('V',0),KEYEVENTF_KEYUP,0);
        	keybd_event(VK_CONTROL,(BYTE)MapVirtualKey(VK_SHIFT,0),KEYEVENTF_KEYUP,0);
//#else
			// This doesn't work for Word/notepad
			for(i = 0; t[i]; i++)
				SendMessage(EditWnd,WM_CHAR,t[i],0);
#endif
		}else{
			EditWnd = NULL;
			if(!i)
				goto rep;
		}
	}
}

void Add2Clipboad(HWND hdwnd, char *t)
{
	int size;
	HGLOBAL hg0, hg;
	PTSTR strClip, strMem;

	if (!OpenClipboard(hdwnd))
		return;
	if(!(hg0 = GetClipboardData(CF_TEXT))){
		CloseClipboard();
		Copy2Clipboad(hdwnd, t);
		return;
	}
	strClip = GlobalLock(hg0);
	size = GlobalSize(hg0) + strlen(t) + 1;
	if(size > MAXCLIP)
		goto quit;
	hg = GlobalAlloc(GHND | GMEM_SHARE, size);
	strMem = (PTSTR)GlobalLock(hg);
	lstrcpy(strMem, strClip);
	EmptyClipboard();
	lstrcat(strMem, t);
	SetClipboardData(CF_TEXT , hg);
quit:
	GlobalUnlock(hg0);
	CloseClipboard();
}

void AdjustShowMessage( HWND hwnd )
{
	HWND hEdit;
	RECT rc;
	int x, y;

	hEdit = GetDlgItem( hwnd, IDC_MES_LIST );
	if( hEdit != NULL )
	{
		HWND hw;
		int dy;
#define	W_TITLE	17

		/* necessary, since japanese font information may be used. */
		hw = GetDlgItem( hwnd, ID_TITLE);
		if( IsJapanese() ){
			SetFont( 9, hEdit, "lr SVbN", TRUE );
			SetFont( 9, hw, "lr SVbN", TRUE );
		}
		y = g_cyShowMessage/4;
		dy = (g_cyShowMessage - 3*y)/4;
		GetClientRect( g_winData.hMainWnd, &rc );
		x = rc.right - rc.left - 160;
		MoveWindow( hw, 4, 0, x-4, W_TITLE, TRUE);
		MoveWindow( hEdit, 0, W_TITLE, x, g_cyShowMessage-W_TITLE, TRUE );
		hw = GetDlgItem( hwnd, IDC_BACK );
		x += 6;
		if( hw != NULL ) MoveWindow( hw, x+4, dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, IDC_FORTH );
		if( hw != NULL ) MoveWindow( hw, x+4, y+2*dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, ID_SAVE );
		if( hw != NULL ) MoveWindow( hw, x+80, dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, ID_CLIP );
		if( hw != NULL ) MoveWindow( hw, x+80, y+2*dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, IDC_L1 );
		if( hw != NULL ){
			MoveWindow( hw, x+4, 2*y+3*dy, 33, y, TRUE );
			EnableWindow(hw, CYSHOWMESSAGE != MINI_INFO);
		}
		hw = GetDlgItem( hwnd, IDC_L2 );
		if( hw != NULL ){
			MoveWindow( hw, x+39, 2*y+3*dy, 33, y, TRUE );
			EnableWindow(hw, CYSHOWMESSAGE != MINI_INFO*4);
		}
		hw = GetDlgItem( hwnd, ID_HIS_CANCEL );
		if( hw != NULL ) MoveWindow( hw, x+80, 2*y+3*dy, 68, y, TRUE );
	}
	return;
}

void DestroyShowMessage( HWND hwnd )
{
	HWND hEdit;
	
	hEdit = GetDlgItem( hwnd, IDC_MES_LIST );
	if( hEdit != NULL )
	{
		SetFont( IsJapanese()?9:0, hEdit, NULL, TRUE );
		SetFont( IsJapanese()?9:0, GetDlgItem(hwnd, ID_TITLE), NULL, TRUE );
	}
	SetFocus( g_winData.hWnd );
}

// CallBack from File/Page History Dialog
BOOL CALLBACK DlgMFunct( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	static char *s, *buf;
	static int show_his, f_busy;
	char *p, ch;
	int pos, lpos, loc, size;
	char title[200];
#define	SHOW_BUF_SIZE	0x8000		// 32K buffer

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case ID_HIS_CANCEL:
				case IDCANCEL:
					if(buf != NULL)
					GlobalFree(buf);
					buf = NULL;
#if	SHOW_IS_MODAL
					DestroyWindow(hdwnd);
					g_winData.hWndShow = NULL;
					if( g_winData.hWndShow == NULL && g_winData.hWndPick == NULL )
						g_cyShowMessage = 0;
					ResizeAllWindows();
					f_busy = 0;
#else
					EndDialog(hdwnd, 0);
#endif // SHOW_IS_MODAL
					return 1;

				case IDC_L1:
					if(CYSHOWMESSAGE == MINI_INFO*2){
						loc = ID_INF_SMALL;
chgsize:				PostMessage(g_winData.hWnd, WM_COMMAND, loc, 0);
					}else if(CYSHOWMESSAGE == MINI_INFO*4){
						loc = ID_INF_MEDIUM;
						goto chgsize;
					}
					return 0;
				case IDC_L2:
					if(CYSHOWMESSAGE == MINI_INFO){
						loc = ID_INF_MEDIUM;
						goto chgsize;
					}else if(CYSHOWMESSAGE == MINI_INFO*2){
						loc = ID_INF_LARGE;
						goto chgsize;
					}
					return 0;
				case IDC_BACK:
					if(show_his > 0 && show_his > show_pos - SHOW_H_MAX
					  && !(f_busy & 2) ){
						f_busy |= 2;
						show_his--;
						goto history;
					}
					return 0;

				case IDC_FORTH:
					if(show_his < show_pos - 1 && !(f_busy & 2)){
						f_busy |= 2;
						show_his++;
						goto history;
					}
					return 0;

				case ID_CLIP:
					GetDlgItemText(hdwnd, IDC_MES_LIST, common_work,
						0x3f00);
					Copy2Clipboad(hdwnd, common_work);
					return 0;

				case ID_SAVE:
					if(!f_log)
						MessageBox( g_winData.hMainWnd,
						  "Open Log file (ALT+F L) before saving!", "Warning", 
						  MB_OK | MB_ICONSTOP );
					else{
						GetDlgItemText(hdwnd, IDC_MES_LIST, common_work,
							0x3f00);
						ShowMessage(common_work,
						  showHistory[show_his & (SHOW_H_MAX - 1)].t, 
						  SM_LOG);
					}
					return 0;

			}
			break;

		case WM_SIZE:
			/*
			GetClientRect( g_winData.hMainWnd, &rc );
			x = rc.right - rc.left; // - g_cxSlider;
			y = rc.bottom - rc.top - g_cyToolBar - g_cyStatusBar;
			MoveWindow( g_winData.hWndShow,
				0, y - g_cyShowMessage + g_cyToolBar,
				x, g_cyShowMessage, TRUE );
			*/
		case WM_PAINT:
			AdjustShowMessage( hdwnd );
			return 0;
		
		case WM_INITDIALOG:
			if(f_busy & 2)
				return 0;
			f_busy |= 2;
			if( g_winData.hWndPick )
				SendMessage( g_winData.hWndPick, WM_COMMAND, ID_HIS_CANCEL, 0 );
			AdjustShowMessage( hdwnd );
			show_his = show_pos++;
			if(!(f_busy & 1)){
				if(show_his <= 0)
					return 0;
				show_his--;
			}
history:	buf = GlobalAlloc( GPTR, SHOW_BUF_SIZE );
			if(buf == NULL){
				f_busy = 0;
				return 0;
			}
			SetFocus(g_winData.hWndShow);
			p = showHistory[show_his & (SHOW_H_MAX-1)].s;

			EnableWindow( GetDlgItem( hdwnd, IDC_FORTH ),
				(show_his < show_pos - 1)?TRUE:FALSE);
			EnableWindow( GetDlgItem( hdwnd, IDC_BACK ),
				(show_his > 0 && show_his > show_pos - SHOW_H_MAX)?
					TRUE:FALSE);
			lpos = 0;
			pos = -1;
			ch = 1;
			while(ch && pos++ < SHOW_BUF_SIZE-16 ){
				ch = buf[pos] = *p++;
				if(ch == 0)
					break;
				if(ch == '\n'){
					buf[pos] = 0x0d;
					buf[++pos] = 0x0a;
					lpos = pos + 1;
				}else if(ch == '\t'){
					do{
						buf[pos++] = ' ';
					}while( ((pos - lpos)& 7) != 0 );
					pos--;
				}
			}
			buf[pos+1] = 0;
			strncpy(title, showHistory[show_his & (SHOW_H_MAX-1)].t, 160);
			title[160] = 0;
			wsprintf(title + strlen(title), "(%d/%d)",
				show_his+1, show_pos);
#if 0
			SetWindowText(hdwnd,title);
#else
			SetDlgItemText(hdwnd, ID_TITLE, title);
#endif
			SetDlgItemText(hdwnd, IDC_MES_LIST, buf);
			GlobalFree(buf);
			buf = NULL;
			f_busy = 0;
			return 1;

		case WM_USER_INITIATE:
			switch(wParam){
				case 0:
				case 2:
					if(f_busy & 1)
						return 0;
					s = (char *)lParam;		// this should be the first
					return 1;
				case 1:						// this should be the second
				case 3:
					pos	 = show_pos & (SHOW_H_MAX-1);
					if(showHistory[pos].t != NULL
					  && showHistory[pos].pos == -1)
						GlobalFree(showHistory[pos].t);

					for(lpos = show_pos - 1; lpos >= 0
					  && (loc = (lpos & (SHOW_H_MAX-1))) != pos; lpos--){
						if(showHistory[loc].pos >= 0)
							continue;
						if(	 strcmp(showHistory[loc].s, s) == 0
						  && strcmp(showHistory[loc].t, (char *)lParam) == 0 ){
							showHistory[pos].s = showHistory[loc].s;
							showHistory[pos].t = showHistory[loc].t;
							showHistory[pos].size = showHistory[loc].size;
							showHistory[pos].pos = -1;
							showHistory[loc].pos = pos;
							f_busy |= 1;
							return 1;
						}
					}
					size = (loc = strlen( (char*)lParam )) + strlen(s) + 2;
					if((showHistory[pos].t = GlobalAlloc( GPTR, size ))
					   == NULL){
						f_busy &= ~1;
						return 0;
					}
					f_busy |= 1;
					strcpy(showHistory[pos].t, (char*)lParam);
					strcpy(showHistory[pos].s = showHistory[pos].t + loc + 1,
						s);
					showHistory[pos].size = size;
					showHistory[pos].pos = -1;
					if(wParam == 3){
						f_busy = 0;
						show_pos++;
					}
					return 1;
			}
		case WM_DESTROY:
			DestroyShowMessage( hdwnd );
			break;
	}
	return 0;
}


static char *szDMmsg;
static HWND hdDMwnd;

BOOL CALLBACK DlgDMFunct( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	static HWND hWndEdit = NULL;
	switch(message){
		case WM_INITDIALOG:
			/* Use SetWindowText() instead for it draws the text
			using DrawText() with DT_WORDBREAK. */
//			SetDlgItemText(hdwnd, IDC_MESSAGE, szDMmsg);
			hWndEdit = GetDlgItem(hdwnd,IDC_MESSAGE);
			SetWindowText(hWndEdit, szDMmsg );
			hdDMwnd = hdwnd;
			return TRUE;
		case WM_USER_INITIATE:
//			SetDlgItemText(hdwnd, IDC_MESSAGE, (char*)lParam);
			SetWindowText(hWndEdit, (const char*)lParam );
			return FALSE;
		case WM_SIZE:
			MoveWindow(hWndEdit,0,0,LOWORD(lParam),HIWORD(lParam),TRUE);
			return TRUE;
		default:
			break;
	}
	return FALSE;
}

#define	MAX_PICK_TITLE 128
static char *szPickmsg;
// static HWND hdPickWnd;
static char pick_title[MAX_PICK_TITLE];

static int DdeSrcSpecial(char *s)
{
	char 		*p, *q, *r;
	HSZ			hszTopic;
	HSZ			hszService;
	HCONV		hConv;
	int 		ret = 0;

	for(p = s; *p && *p != ' '; p++);
	if(!*p)
		goto er2;
	for(q = p+1; *++q && *q != ' '; );
	if(!*q){
er2:	error(WARNING, "Bad DDE command \"%s\"", s);
		return 2;
	}
	*p++ = *q++ = 0;
#if 0
error(14, "[%s] [%s] [%s]", s, p, q);
#endif
	hszService = DdeCreateStringHandle( g_ddeData.idInst, s, CP_WINANSI);
	hszTopic = DdeCreateStringHandle( g_ddeData.idInst, p, CP_WINANSI);
	hConv = DdeConnect( g_ddeData.idInst, hszService, hszTopic, NULL );
	if(!hConv){
		ret = 1;
		goto quit;
	}
rep:
	for(r = q; *r && *r != '|'; r++);
	if(*r){
		*r++ = 0;
	}
	if(!DdeClientTransaction(q, strlen(q)+1, hConv, 0L, 0, XTYP_EXECUTE, 
		20000, NULL)){
			error(WARNING, 
				"Cannot XTYP_EXECUTE in DDE\n"
				"Service:\t\"%s\"\nTopic:\t\t\"%s\"\nTransaction:\t\"%s\"",
				s, p, q);
			ret = 3;
	}
	if(!ret && *r){
		q = r;
		goto rep;
	}
quit:
	DdeFreeStringHandle(g_ddeData.idInst, hszService);
	DdeFreeStringHandle(g_ddeData.idInst, hszTopic);
	return ret;
}

BOOL ToGSource(char *fname)
{
	int i;
	char *ext, *pt, *s;
	LPSTR lpPart;
	HINSTANCE hShell;

	for(ext = fname+strlen(fname); *(--ext) != '.' && ext > fname;);
	if(ext <= fname || !exec_gsrc_sp || !exec_gsrc_sp[0])
		return FALSE;
	ToDviDir();
	/* check extension */
	pt = exec_gsrc_sp;
nxt:
	for(i=0; tolower(ext[i]) == tolower(pt[i]); i++){
		if(!pt[i])
			return FALSE;
	}
	if(ext[i] || (pt[i] != '=' && pt[i] != '.')){	/* doesn't match */
		for( ; ; i++){
			if(!pt[i])
				return FALSE;
			if(pt[i] == '.' && i > 0){	/* next extension */
				pt += i;
				goto nxt;
			}
			if(pt[i] == '='){		/* skip definition */
				while(pt[++i] != ';' && pt[i] != '.'){
					if(!pt[i])
						return FALSE;
				}
				pt += i;
				goto nxt;
			}
		}
	}
	for(pt += i; *pt++ != '=';){
		if(!*pt)
			return FALSE;
	}
	if(GetFullPathName(fname, MAX_PATH-1, common_work + 0x1000, &lpPart))
		fname = common_work + 0x1000;	// get full path name

		/* generate command */
	s = common_work;
	do{
		*s++ = *pt++;
		if(pt[-1] == '%'){
			if(*pt == 's' || *pt == 'n'){
				strcpy(s-1, fname);
				s += strlen(s);
				if(*pt == 'n')
					s-= strlen(ext);	// cut extension
				pt++;
			}
		}
	}while( *pt && (*pt != ';' || (pt[1] != '.' && pt[1] != 0) ) );
	*s = 0;
	if((s = StrStr(common_work, "^s")) != NULL){	// devide parameters
		*s = 0;
		exec_para = s + 2;
	}
		/* execute command*/
	sprintf(common_work+0x1400, 
		"%s  \n\nExecute %s for the above?", fname, common_work);
	if(AskYes(common_work+0x1400, "Pointed Graphic")){
		hShell = ExecHref(g_winData.hMainWnd, common_work);
			if((UINT)hShell < 32)
			error(WARNING, "Cannot execute : %s", common_work);
	}
	return TRUE;
}

BOOL ToSource(char **s, int l)
{
	int len, flag, flag2, rep;
	char *t, *exe, *exec_src;
	HINSTANCE hShell;
	LPSTR lpPart;
	int f_icon;

	ToDviDir();
	if(GetFullPathName(*s, MAX_PATH-1, common_work + 0x1000, &lpPart))
		*s = common_work + 0x1000;					// get full path name

	sprintf(common_work, "srctex srctex %s: %d", *s, l);
	if(exec_src_sp == NULL || !*exec_src_sp){
		if((exec_src = getenv("TEXEDIT")) == NULL)
no_set:		return DdeSrcSpecial(common_work)?FALSE:TRUE;
		strcpy(t = common_work + 0x1400, exec_src);
		if(*t == '\"'){
			while(*++t != '\"'){	/* get program name */
				if(!*t)
					goto sp;
			}
			for(exe = common_work + 0x1401; exe != t; exe++)
				*(exe-1) = *exe;
			t[-1] = '^';
			t[0] = 's';
		}else{
sp:			while(*t != ' '){		/* search space */
				if(!*t++)
					goto no_set;
			}
			*t = '^';
			len = 's';
			do{
				rep = len;
				len = *++t;
				*t = rep;
			}while(rep);
		}
		exec_src = common_work + 0x1400;
	}else
		exec_src = exec_src_sp;
	if(*exec_src == '<'){
		f_icon = 1;
		exec_src++;
	}else
		f_icon = 0;
	rep = 0;
rep0:
	flag = 0;
	if(*(exe = exec_src) == '`'){
		while(*++exe && *exe != '`');
		if(*exe++){
			flag = 1;
			if(*exe == '`'){
				exe++;
				flag = 2;
			}
		}else
			exe = exec_src;
	}
	if(flag){
		strcpy(common_work + 0x800, exec_src + 1);
		common_work[exe - exec_src - flag + 0x7ff] = 0;
	}else{
		if(!DdeSrcSpecial(common_work))
			goto OK;
rep1:	strcpy(common_work + 0x800, exe);
	}
	t = StrStr(common_work + 0x800, "%s");					// substitute %s
	if(t != NULL)
		strcpy(t, *s);
	else if((t = StrStr(common_work + 0x800, "%n")) != NULL){ // substitute %n
		strcpy(t, *s);
		len = strlen(common_work+0x800)+0x800;
		while(--len > 0x800){
			if(common_work[len] == '.'){
				common_work[len] = 0;
				break;
			}
			if(common_work[len] == '\\' || common_work[len] == ':')
				break;
		}
	}else if(!rep)
		return FALSE;
	strcat(common_work + 0x800, 
		(flag?(exec_src+1):exe) + (t - common_work - 0x7fe));

	if(flag){
		for(t = common_work + 0x800; *t; t++)
			if(*t == '`'){
				*t = 0;
				break;
			}
	}
	strcpy(common_work, common_work + 0x800);
	t = StrStr(common_work, "%d");					// substitute %d
	if(t == NULL){
		if(!rep)
			return FALSE;
	}else
		sprintf(t, "%d", l);
	strcat(common_work, t + 0x802);
	if(flag){										// Use DDE
		strcpy(common_work + 0x800, common_work);
		if(DdeSrcSpecial(common_work) != 1)
			goto OK;
 		if(rep != 0){
			error(WARNING, "Cannot execute DDE :%s", common_work + 0x800);
			return TRUE;
		}
		flag2 = flag;
		flag = 0;
		rep = 1;
		goto rep1;
	}

	if((t = StrStr(common_work, "^s")) != NULL){	// devide parameters
		*t = 0;
		exec_para = t + 2;
	}
	hShell = ExecHref(g_winData.hMainWnd, common_work);
	if((UINT)hShell < 32)
		error(WARNING, "Cannot execute source special: %s", 
			rep?exec_src:common_work);
	else if(rep++ == 1 && flag2 == 2)
		goto rep0;
	else{ 
OK:		if(f_icon)
		ShowWindow(g_winData.hMainWnd, SW_MINIMIZE);
	}
	return TRUE;
}

void AdjustPickup( HWND hwnd )
{
	HWND hEdit;
	RECT rc;
	int x, y;

	hEdit = GetDlgItem( hwnd, IDC_MES_LIST );
	if( hEdit != NULL )
	{
		HWND hw;
		int dy;

		if( IsJapanese() )
			SetFont( 9, hEdit, "lr SVbN", TRUE );
		y = g_cyShowMessage/4;
		dy = (g_cyShowMessage - 3*y)/4;
		GetClientRect( g_winData.hMainWnd, &rc );
		x = rc.right - rc.left - 160;
		MoveWindow( hEdit, 0, 0, x, g_cyShowMessage, TRUE );

		hw = GetDlgItem( hwnd, IDC_BACK );
		x += 6;
		if( hw != NULL ) MoveWindow( hw, x+4, dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, IDC_FORTH );
		if( hw != NULL ) MoveWindow( hw, x+4, y+2*dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, ID_GETALL );
		if( hw != NULL ) MoveWindow( hw, x+4, 2*y+3*dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, ID_CLIP );
		if( hw != NULL ) MoveWindow( hw, x+80, dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, IDC_EXECUTE );
		if( hw != NULL ) MoveWindow( hw, x+80, y+2*dy, 68, y, TRUE );
		hw = GetDlgItem( hwnd, ID_HIS_CANCEL );
		if( hw != NULL ) MoveWindow( hw, x+80, 2*y+3*dy, 68, y, TRUE );
	}
	return;
}

void DestroyPickup( HWND hwnd )
{
	HWND hEdit;
	hEdit = GetDlgItem( hwnd, IDC_MES_LIST );
	if( hEdit != NULL )
	{
		SetFont( IsJapanese()?9:0, hEdit, NULL, TRUE );
	}
	SetFocus( g_winData.hWnd );
}


static BOOL CALLBACK DlgPickFunct( HWND hdwnd, UINT message, 
	UINT wParam, LONG lParam)
{
#if	0
	SCROLLINFO si;
	HWND hw;
#endif // 0
	HINSTANCE hShell;
	static char *pt, *pt1, *pt2, *source;
	static int line;
	char *s, *t;
	int	ret, l;
	RECT rc;
	int x, y;

	switch(message){
		case WM_SIZE:
			GetClientRect( g_winData.hMainWnd, &rc );
			x = rc.right - rc.left; // - g_cxSlider;
			y = rc.bottom - rc.top - g_cyToolBar - g_cyStatusBar;
			MoveWindow( hdwnd,
				0, y - g_cyShowMessage + g_cyToolBar,
				x, g_cyShowMessage, TRUE );
		case WM_PAINT:
			AdjustPickup( hdwnd );
			return 0;

		case WM_INITDIALOG:
			if( g_winData.hWndShow )
				SendMessage( g_winData.hWndShow, WM_COMMAND, ID_HIS_CANCEL, 0 );
			AdjustPickup( hdwnd );
			for(pt = szPickmsg; *pt && *pt != '\t'-1 && *pt != '\t'; pt++);
			s = pt2 = pt1 = pt;
			if(*s){
				while(*++s){
					if(*s == '\t'-1 || *s == '\t')
						pt2 = s;
				}
			}
			ret = TRUE;
			SetWindowText(hdwnd, pick_title);
			if(pick_source != 0 && f_srcspecial)
				source =  GetDPos2Source(pick_source, &line);
			else
				source = NULL;
			SetDlgItemText(hdwnd, IDC_EXECUTE, 
				(source != NULL)?"->&Src":"&Execute");
show:		EnableWindow( GetDlgItem( hdwnd, IDC_BACK ),
				(pt == pt1 && *pt1)?FALSE:TRUE);
			EnableWindow( GetDlgItem( hdwnd, IDC_FORTH ),
				(pt2 > pt1)?TRUE:FALSE);
			EnableWindow( GetDlgItem( hdwnd, ID_GETALL ),
				(pt2 > pt1)?TRUE:FALSE);
			for(s = szPickmsg, t = common_work; s < pt; s++){
				if(*s == '\t'-1)
					*t++ = ' ';
				else if(*s != '\t')
					*t++ = *s;
			}
			*t = 0;
show_src:	SetDlgItemText(hdwnd, IDC_MES_LIST, common_work);
			l = SendDlgItemMessage(hdwnd, IDC_MES_LIST, EM_GETLINECOUNT, 0, 0)
				- 5;
			if(l > 0)
				SendDlgItemMessage(hdwnd, IDC_MES_LIST, EM_LINESCROLL, 0, l); 
			return ret;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case ID_CLIP:
					GetDlgItemText(hdwnd, IDC_MES_LIST, common_work, 0x1000);
					Copy2Clipboad(hdwnd, common_work);
					return 0; // OK?
					
				case ID_HIS_CANCEL:
				case IDCANCEL:
quit:				if(szPickmsg)
						Free0(szPickmsg);
					szPickmsg = NULL;
					DestroyWindow(hdwnd);
					g_winData.hWndPick = NULL;
					if( g_winData.hWndShow == NULL
						&& g_winData.hWndPick == NULL ) g_cyShowMessage = 0;
					ResizeAllWindows();
					return TRUE;

				case ID_GETALL:
					s = pt2;
					goto show0;

				case IDC_BACK:
					if(!*pt1){
						SetDlgItemText(hdwnd, IDC_MES_LIST, "");
						break;
					}
					s = pt;
					while(--s >= szPickmsg && *s != '\t'-1 && *s != '\t');
show0:				if(s >= pt1 && s <= pt2)
						pt = s;
					ret = 0;
					goto show;

				case IDC_FORTH:
					if(pt == pt2){
						s = pt1;
						goto show0;
					}
					s = pt;
					while(++s <= pt2 && *s != '\t'-1 && *s != '\t');
					goto show0;

				case IDC_EXECUTE:
					if(source != NULL){
						s = source;
						if(ToSource(&s, line))
							goto quit;
						sprintf(common_work, "%s : %d ", s, line);
						ret = 0;
						goto show_src;
					}
					GetDlgItemText(hdwnd, IDC_MES_LIST, common_work, 0x200);
					if(	 strlen(common_work) < 0x100
					  && MessageCBox(g_winData.hMainWnd, 
						"Execute the above Hyper Jump?", common_work,
						  MB_YESNO|MB_ICONQUESTION) == IDYES){
						hShell = ExecHref(g_winData.hMainWnd, common_work);
						if((UINT)hShell < 32)
							error(WARNING, "Cannot resolve href %s", 
								common_work);
					}
					break;
			}
			break;
		case WM_DESTROY:
			DestroyPickup( hdwnd );
			break;
	}
	return 0;
}

void DisplayWinMessage(HWND hwnd, char *s)
{
	static HWND hDlg;
	RECT rc;
	int cx;
	int sw[NUMSTATUS];
	int sw1;
	static BOOL b;
	
	GetClientRect( g_winData.hMainWnd, &rc );
	cx = rc.right - rc.left;
	
	sw1 = -1;
	sw[0] = cx*6/23;
	sw[1] = cx*11/23;
	sw[2] = cx*16/23;
	sw[3] = -1;
	
	if( s != NULL )
	{
		b = g_view.f_StatusBar;
		if( b == FALSE ){
#if 0
			g_view.f_StatusBar = TRUE;
#else
			if(hDlg == NULL){
				szDMmsg = s;
				hDlg = CreateDialogInFloatWindow( MAKEINTRESOURCE(IDD_MESSAGE),DlgDMFunct);
				SetFloatingWindowSize( 240, 64 );
				SetFloatingKeepTime( 0 );
/*
				hDlg = CreateDialog( g_winData.hInstance,
						MAKEINTRESOURCE(IDD_MESSAGE),
						(hwnd==NULL)?g_winData.hMainWnd:hwnd, 
						DlgDMFunct);
*/
			}else{
				SendMessage( hDlg, WM_USER_INITIATE, 0, (LONG)s );
//				DlgDMFunct( hdDMwnd, WM_USER_INITIATE, 0, (LONG)s);
			}
			DisplayFloatingWindow();

		}else
#endif
		{
			ResizeAllWindows();
			SendMessage( g_winData.hWndStatus, SB_SETPARTS, 1, (LPARAM)(&sw1) );
			SendMessage( g_winData.hWndStatus, SB_SETTEXT, 0, (LPARAM)s );
		}
	}
	else if(!f_message)
	{
		if( b == FALSE ){
#if 0
			g_view.f_StatusBar = FALSE;
#else
			if(hDlg){
				DelayedDestroyFloatingWindow(&hDlg);
//				DestroyWindow(hDlg);
				// hDlg = NULL;
			}
			return;
#endif
		}
		SendMessage( g_winData.hWndStatus, SB_SETPARTS, NUMSTATUS, (LPARAM)sw );
		SetStatusWindow();
		ResizeAllWindows();
	}
	
/*
	if(s == NULL){
		if(hDlg){
			DestroyWindow(hDlg);
			hDlg = NULL;
		}
		return;
	}
	if(hDlg == NULL){
		szDMmsg = s;
		hDlg = CreateDialog( g_winData.hInstance,
					MAKEINTRESOURCE(IDD_MESSAGE),
					(hwnd==NULL)?g_winData.hMainWnd:hwnd, 
					DlgDMFunct);
	}else
		DlgDMFunct( hdDMwnd, WM_USER_INITIATE, 0, (LONG)s);
*/
}

void DisplayMessage(char *s)
{
	DisplayWinMessage(g_winData.hMainWnd, s);
}

void MessagePage(int page)
{
	char tmp[0x40];

	if(page > 0){
		f_message = TRUE;
		sprintf(tmp, "Scanning page %d", page);
		DisplayMessage(tmp);
	}else if(!page){
		f_message = FALSE;
		DisplayMessage(NULL);
	}else
		f_message = TRUE;
}


BOOL AskYes(char *msg, char *title)
{
	return (MessageCBox( g_winData.hMainWnd, msg, title, 
		MB_YESNO|MB_ICONQUESTION) == IDYES)?TRUE:FALSE;
}

void ShowPickedString(char *s, char *t)
{
	if(szPickmsg)
		Free0(szPickmsg);
	strncpy(pick_title, (t)?t:"Picked Strings", MAX_PICK_TITLE -1);
	szPickmsg = dup_string(s);
	if(g_winData.hWndPick == NULL){
		RECT rc;
		int client_x, client_y;

		g_cyShowMessage = CYSHOWMESSAGE;
		GetClientRect( g_winData.hMainWnd, &rc );
		client_x = rc.right - rc.left; // - g_cxSlider;
		client_y = rc.bottom - rc.top - g_cyToolBar - g_cyStatusBar;
		ResizeAllWindows();
		g_winData.hWndPick = CreateDialog( g_winData.hInstance,
			MAKEINTRESOURCE(IDD_PICKUPSTRING),
			g_winData.hMainWnd, 
			DlgPickFunct);
		MoveWindow( g_winData.hWndPick,
			0, client_y - g_cyShowMessage + g_cyToolBar,
			client_x,
			g_cyShowMessage,
			TRUE );
		ShowWindow( g_winData.hWndPick, SW_SHOW );
		UpdateWindow( g_winData.hWndPick );
		ResizeAllWindows();
/*
		g_winData.hWndPick = CreateDialog( g_winData.hInstance, 
			MAKEINTRESOURCE(IDD_PICKUPSTRING),
			g_winData.hMainWnd, DlgPickFunct);
*/
	}else
		DlgPickFunct(g_winData.hWndPick, WM_INITDIALOG, 0, 0);
}

int ShowMessage(char *s, char *t, int type)
{
	char *p;
	static char *old_path;
	static FILE *fp;

	FILE *fopenf(char *, char *);


	if(fp != NULL && strcmp(old_path, log_file)){
		fclose(fp);
		fp = NULL;
	}
	if(fp == NULL && 
	  (f_log || (log_file != NULL && fp == NULL && *log_file != '-')) ){
		if(log_file == NULL)
			log_file = dup_string("+");
		fp = fopenf(p = (!*log_file || *log_file == '+')?
			GetOutPath(F_LOG_EXT):log_file, "w");
		if(fp == NULL){
			MessageCBox( g_winData.hMainWnd, "Cannot open log file",
			p, MB_OK | MB_ICONSTOP);
			*log_file = '-';
			f_log = FALSE;
		}else{
			Free0(old_path);
			old_path = dup_string(log_file);
		}
	}
	if(fp && f_log && (type & SM_LOG)){
		fprintf(fp, "[%s]\n", t);
		for(p=s; *p; p++){
			if(*p == 0x0d)
				continue;
			fputc(*p, fp);
		}
	}
	switch(type & 0xf){
		case (SM_ABREIG & 0xf):
			switch(MessageCBox( g_winData.hMainWnd, s, t, 
			  MB_ABORTRETRYIGNORE | MB_ICONEXCLAMATION | MB_DEFBUTTON3)){
				case IDABORT:	return 2;
				case IDRETRY:	return 1;
				default		:	return 0;
			}
		case (SM_YESNO & 0xf):
			switch(MessageCBox( g_winData.hMainWnd, s, t, 
			  MB_YESNO | MB_ICONEXCLAMATION | MB_DEFBUTTON3)){
				case IDYES  :	return 1;
				default		:	return 0;
			}
		case (SM_OKEXIT & 0xf):
			MessageCBox( g_winData.hMainWnd, s, t, MB_OK | MB_ICONSTOP );
			exit(1);

		case SM_EDIT:
sm_edit:
			DlgMFunct(NULL, WM_USER_INITIATE, 0, (LPARAM)s);
			DlgMFunct(NULL, WM_USER_INITIATE, 1, (LPARAM)t);
#if	SHOW_IS_MODAL
			if(g_winData.hWndShow == NULL){
				RECT rc;
				int client_x, client_y;
				g_cyShowMessage = CYSHOWMESSAGE;
				GetClientRect( g_winData.hMainWnd, &rc );
				client_x = rc.right - rc.left; // - g_cxSlider;
				client_y = rc.bottom - rc.top - g_cyToolBar - g_cyStatusBar;
				ResizeAllWindows();
				g_winData.hWndShow = CreateDialog( g_winData.hInstance,
					MAKEINTRESOURCE(IDD_LISTMESSAGE),
					g_winData.hMainWnd, 
					DlgMFunct);
				MoveWindow( g_winData.hWndShow,
					0, client_y - g_cyShowMessage + g_cyToolBar,
					client_x,
					g_cyShowMessage,
					TRUE );
				ShowWindow( g_winData.hWndShow, SW_SHOW );
				UpdateWindow( g_winData.hWndShow );
				ResizeAllWindows();
			}else
				SendMessage( g_winData.hWndShow, WM_INITDIALOG, 0, 0 );
#else
			DialogBox( g_winData.hInstance,
				MAKEINTRESOURCE(IDD_LISTMESSAGE),
				g_winData.hMainWnd, 
				DlgMFunct);
#endif // SHOW_IS_MODAL
			UpdateWindow( g_winData.hWndShow );
			return 0;

		case SM_NOEDIT:
			if(g_winData.hWndShow != NULL)
				goto sm_edit;
			DlgMFunct(NULL, WM_USER_INITIATE, 2, (LPARAM)s);
			DlgMFunct(NULL, WM_USER_INITIATE, 3, (LPARAM)t);
			return 0;

		case SM_OKCONT:
			MessageCBox( g_winData.hMainWnd, s, t, 
				MB_OK | MB_ICONEXCLAMATION );

		default:
			break;
	}
	return 0;
}


static void InitMainWindow( HANDLE hInstance, int nCmdShow )
{
	WNDCLASS wc;
	int x0, y0, x1, y1;
	int xPos, yPos, cWidth, cHeight;

	if(	 argc > 1
	  && sscanf(argv[1], "-NULL=(%d,%d)-(%d,%d)", &x0, &y0, &x1, &y1) == 4
	  && x1 > x0 && y1 > y0){
		xPos = x0;
		yPos = y0;
		cWidth = x1 - x0;
		cHeight = y1 - y0;
		f_quit = 1;
	}else{
		x0 = GetSystemMetrics(SM_CXSCREEN);
		x1 = RestoreInt( "Settings", "xPos", 0 );
		y0 = GetSystemMetrics(SM_CYSCREEN);
		y1 = RestoreInt( "Settings", "yPos", 0 ); 
		xPos = (DVIOUT_Count || x1 > x0)?CW_USEDEFAULT:x1;
		yPos = (DVIOUT_Count || y1 > y0)?CW_USEDEFAULT:y1;
 
		cWidth = RestoreInt( "Settings", "Width", CW_USEDEFAULT );
		if(cWidth <= 0)
			cWidth = CW_USEDEFAULT;
		if(cWidth != CW_USEDEFAULT){
			if(cWidth > x0)
				cWidth = GetSystemMetrics(SM_CXMAXIMIZED);
			else if(xPos + cWidth <= 0)
				xPos = CW_USEDEFAULT;
		}

		cHeight = RestoreInt( "Settings", "Height", CW_USEDEFAULT );
		if(cHeight <= 0)
			cHeight = CW_USEDEFAULT;

		if(cHeight != CW_USEDEFAULT){
			if(cHeight > y0)
				cHeight = GetSystemMetrics(SM_CYMAXIMIZED);
			else if(yPos + cHeight <= 0)
				xPos = CW_USEDEFAULT;
		}
	}

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc	 = MainWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInstance;
	wc.hIcon		 = LoadIcon( hInstance, MAKEINTRESOURCE(IDI_ICON) );
	wc.hCursor		 = NULL;
	wc.hbrBackground = (HBRUSH)(COLOR_WINDOWFRAME + 1);
//COLOR_APPWORKSPACE + 1);
	wc.lpszMenuName	 = MAKEINTRESOURCE(IDR_MAINMENU);
	wc.lpszClassName = g_winData.szClassName;
	RegisterClass( &wc );

	g_winData.hMainWnd = CreateWindowEx( 0L, //WS_EX_OVERLAPPEDWINDOW,
					g_winData.szClassName,
					g_winData.szWindowTitle,
					WS_OVERLAPPEDWINDOW, // | WS_CLIPCHILDREN,
					xPos, yPos,			 // position
					cWidth, cHeight,	 // size
					NULL,
					NULL,
					hInstance,
					NULL );
	if( g_winData.hMainWnd == NULL )
	{
		MessageBox( NULL, "Creation Main window failed.", NULL, MB_OK );
		exit( 1 );
	}
	g_winData.hInstance = hInstance;
	g_winData.hNormalCursor = LoadCursor( NULL, IDC_ARROW );
	g_winData.hWaitCursor = LoadCursor( NULL, IDC_WAIT );
	g_winData.hHandCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_NHAND ) );
	g_winData.hMoveHandCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_MOVEHAND ) );
	g_winData.hPointCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_POINT ) );
	g_winData.hPointPushCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_POINT_PUSH ) );
	g_winData.hNSCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_NSARROW ) );
	g_winData.hWECursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_WEARROW ) );
	g_winData.hALLCursor = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_ALLARROW ) );
	g_winData.hLaserPointer = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_CURSOR_LASER_POINTER ) );
	g_winData.hLaserHand = LoadCursor( hInstance,
									MAKEINTRESOURCE( IDC_CURSOR_LASER_HAND ) );
	SetCursor( g_winData.hNormalCursor );
	ShowWindow( g_winData.hMainWnd, nCmdShow ); // 쐬޳\
	UpdateWindow( g_winData.hMainWnd );
	return;
}

static void InitViewWindow( void )
{
	RECT rcMain;
	WNDCLASS wc;
	DWORD dwStyle;

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc	 = WndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = g_winData.hInstance;
	wc.hIcon		 = LoadIcon( NULL, IDI_APPLICATION );
	wc.hCursor		 = LoadCursor( NULL, IDC_ARROW );
	f_background = RestoreInt( "Settings", "Background", 0 );
	if(!(f_background & 0x100))
		f_presenmenu = TRUE;
	f_pmenu = (f_background >> 4) & 0x0f;
	f_pmenu ^= 0x8;
	f_background &= 0x0f;
	f_coverH = RestoreInt( "Settings", "CoverSheet", 0x4001 );
	f_coverB = f_coverH/0x100000;
	if(f_coverH & 0x1000)
		f_cover = 1;
	if(f_coverH & 0x2000)
		f_coverP = TRUE;
	if(f_coverH & 0x4000)
		f_coverM = TRUE;
	if(f_coverH & 0x8000)
		f_dvioutspecial = FALSE;
	if(f_coverH & 0x10000)
		f_srcspecial = FALSE;
	if(f_coverH & 0x20000)
		f_use_etf = FALSE;
	if(f_coverH & 0x40000)
		f_hypertex = FALSE;
	f_coverH &= 0xfff;
	if(!(f_coverH & 7))
		f_coverH = 1;
	view_back = RestoreInt( "Settings", "ViewBack", -1);
	if(view_back == -1)
		wc.hbrBackground = (HBRUSH)(COLOR_APPWORKSPACE + 1);
	else if(!view_back)
		wc.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	else
		wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName	 = NULL;
	wc.lpszClassName = "DVIVIEW";
	if( RegisterClass( &wc ) == 0 )
	{
		MessageBox( NULL, "RegisterClass for DVIVIEW failed.", NULL, MB_OK );
		return;
	}

	if( f_flatscroll && GetVersionLevel() > 0 )
		dwStyle = 0L;
	else
		dwStyle = WS_EX_CLIENTEDGE;
	GetClientRect( g_winData.hMainWnd, &rcMain );
	g_winData.hWnd = CreateWindowEx( dwStyle,
					"DVIVIEW",
					NULL,
					WS_CHILD | WS_VSCROLL | WS_HSCROLL | WS_VISIBLE, // | WS_BORDER, for Windows XP
					0, 0, // g_cyToolBar,					  // position
					rcMain.right - rcMain.left,// - g_cxSlider, // window width
					rcMain.bottom - rcMain.top, // - g_cyToolBar - g_cyStatusBar,
					g_winData.hMainWnd,
					(HMENU)ID_VIEWWINDOW,
					g_winData.hInstance,
					NULL );
	if( g_winData.hWnd == NULL )
	{
		MessageBox( g_winData.hMainWnd, "Creation Child Window Failed.", NULL, MB_OK );
		exit( 1 );
	}
	ShowWindow( g_winData.hWnd, SW_SHOWNORMAL );
	UpdateWindow( g_winData.hWnd );
	return;
}

static void InitDDE( void )
{
	/* DDȄsȂBsƏI */
	if( DdeInitialize( &(g_ddeData.idInst), DdeCallback, CBF_FAIL_POKES |
					   CBF_SKIP_REGISTRATIONS | CBF_SKIP_UNREGISTRATIONS, 0L ) 
		!= DMLERR_NO_ERROR )
	{
		MessageBox( g_winData.hMainWnd, "Fails to initialize",
					g_winData.szAppName, MB_ICONSTOP | MB_OK );
		DestroyWindow( g_winData.hMainWnd );
		exit( 1 );
	}
	return;
}

static void QueryFileSub( void )
{
	memset( &g_OpenFileName, 0, sizeof(OPENFILENAME) );
	g_OpenFileName.lStructSize = sizeof(OPENFILENAME);
	g_OpenFileName.nMaxFile = MAX_PATH;
	g_OpenFileName.lpstrFileTitle = NULL;	   /* ̧قق󂯎߲ */
	g_OpenFileName.hwndOwner	  = g_winData.hMainWnd;

}

char *QuerySaveName( void )
{
	int size, ext;

	char szFilter[] = "BMP Files(*.bmp)\0*.bmp\0"
					  "EMF Files(*.emf)\0*.emf\0"
					  "BMC Files(*.bmc)\0*.bmc\0"
					  "PNG Files(*.png)\0*.png\0"
					  "PDF Files(*.pdf)\0*.pdf\0"
					  "EPS Files(*.eps)\0*.eps\0"
					  "All files(*.*)\0*.*\0";
	QueryFileSub();
	g_OpenFileName.lpstrFilter = szFilter; /* tB^[ */
	g_OpenFileName.lpstrFile   = g_szSaveName; /* "̧ٖ" ɕ\̧ٖ */
	g_szSaveName[0] = 0;
	g_OpenFileName.lpstrTitle  = "save the current page as a BMP/EMF/BMC/PNG/EPS/... file"; 
		/* ^Cgo[ */
	g_OpenFileName.lpstrDefExt = NULL; /* ftHg̊gq */
	g_OpenFileName.Flags	   = OFN_HIDEREADONLY;
	if(!GetSaveFileName( &g_OpenFileName ))
		return NULL;
	size = strlen(g_szSaveName);
	for(ext = size - 1; ext > 0 && ext >= size - 5; ext--){
		switch(g_szSaveName[ext]){
			case '.':
 				return	g_szSaveName;
			case '\\':
				ext = -1;
				break;
		}
	}
	switch(g_OpenFileName.nFilterIndex){
		case 1:
			strcat(g_szSaveName, ".bmp");
			break;

		case 2:
			strcat(g_szSaveName, ".emf");
			break;
			
		case 3:
			strcat(g_szSaveName, ".bmc");
			break;
			
		case 4:
			strcat(g_szSaveName, ".png");
			break;

		case 5:
			strcat(g_szSaveName, ".pdf");
			break;

		case 6:
			strcat(g_szSaveName, ".eps");
			break;
	} 
	return g_szSaveName;
}

#ifdef	RAWOUT
char *QueryPrnName( void )
{
	char szFilter[] = "Output files(*.prn)\0*.prn\0All files(*.*)\0*.*\0";

	QueryFileSub();
	g_OpenFileName.lpstrFilter = szFilter; /* tB^[ */
	g_OpenFileName.lpstrFile   = g_szSaveName; /* "̧ٖ" ɕ\̧ٖ */
	g_OpenFileName.lpstrTitle	  = "output to a file"; 
		/* ^Cgo[ */
	g_OpenFileName.lpstrDefExt	  = "prn"; /* ftHg̊gq */
	g_OpenFileName.Flags		  = OFN_HIDEREADONLY;
	return (GetSaveFileName( &g_OpenFileName ))?
		g_szSaveName:NULL;
}

char *QueryCfgName( void )
{ /* ̧ٖ̓͂߂܂ */
	char InitDir[MAX_PATH];
	char szFilter[] = "Printer Configuration files(*.cfg)\0*.cfg\0All files(*.*)\0*.*\0";
	// ̧ٵݥ޲۸ނ쐬邽߂̍\̏(OPENFILENAME\̎Q)

	QueryFileSub();
	strncpy(InitDir, GetOutPath("exe"), MAX_PATH);
	InitDir[GetNamePos(InitDir)] = 0;
	g_OpenFileName.lpstrFile   = g_szCfgName; /* "̧ٖ" ɕ\̧ٖ */
	g_OpenFileName.lpstrFilter = szFilter; /* tB^[ */
	g_OpenFileName.lpstrTitle	  = "open a parameter file"; /* ^Cgo[ */
	g_OpenFileName.lpstrDefExt	  = "cfg"; /* ftHg̊gq */
	g_OpenFileName.lpstrInitialDir = InitDir;
	g_OpenFileName.Flags		  = OFN_FILEMUSTEXIST
								  | OFN_HIDEREADONLY
								  | OFN_PATHMUSTEXIST;
	return (GetOpenFileName( &g_OpenFileName ))?
		g_szCfgName:NULL;
}
#endif // RAWOUT

char *QueryGeneralName( char *title, char *file, char *ext )
{ /* ̧ٖ̓͂߂܂ */
	char szFilter[128] = "Search file(*.*)\0*.*\0";
	static char g_szName[MAX_PATH];
	char g_szName0[MAX_PATH];
	int len;
	// ̧ٵݥ޲۸ނ쐬邽߂̍\̏(OPENFILENAME\̎Q)

	g_szName0[0] = 0;
	if(file != NULL){
		strncpy(szFilter, file, 64);
		szFilter[64] = 0;
		len = strlen(file);
		strncpy(szFilter+len+1, ext, 30);
		szFilter[100] = 0;
		len += strlen(ext) + 2;
		strcpy(szFilter + len, "All files(*.*)");
		strcpy(szFilter + len + 15, "*.*");
		szFilter[len + 19] = 0;
	}
	QueryFileSub();
	g_OpenFileName.lpstrFile   = g_szName0;		/* "̧ٖ" ɕ\̧ٖ */
	g_OpenFileName.lpstrFilter = szFilter;	/* tB^[ */
	g_OpenFileName.lpstrTitle	  = title;	/* ^Cgo[ */
	g_OpenFileName.lpstrDefExt	  = NULL;	/* ftHg̊gq */
	g_OpenFileName.lpstrInitialDir = NULL;
	g_OpenFileName.Flags		  = OFN_FILEMUSTEXIST
								  | OFN_HIDEREADONLY
								  | OFN_PATHMUSTEXIST;
	if(!GetOpenFileName( &g_OpenFileName ))
		return NULL;
	if(strchr(g_szName0, ' ') == NULL)
		strcpy(g_szName, g_szName0);
	else
		GetShortPathName(g_szName0, g_szName, MAX_PATH);
	return g_szName;
}

char *QueryParaName( void )
{ /* ̧ٖ̓͂߂܂ */
	int len;
	char InitDir[MAX_PATH];
	char szFilter[] = "Parameter files(*.par)\0*.par\0All files(*.*)\0*.*\0";
	// ̧ٵݥ޲۸ނ쐬邽߂̍\̏(OPENFILENAME\̎Q)

	QueryFileSub();
	strncpy(InitDir, GetOutPath("exe"), MAX_PATH);
	len = GetNamePos(InitDir);
	strcpy(InitDir+len, "\\par");
	if(access(InitDir, 0))
		InitDir[len] = 0;
	g_OpenFileName.lpstrFile   = g_szParaName; /* "̧ٖ" ɕ\̧ٖ */
	g_OpenFileName.lpstrFilter = szFilter; /* tB^[ */
	g_OpenFileName.lpstrTitle	  = "open a parameter file"; /* ^Cgo[ */
	g_OpenFileName.lpstrDefExt	  = "par"; /* ftHg̊gq */
	g_OpenFileName.lpstrInitialDir = InitDir;
	g_OpenFileName.Flags		  = OFN_FILEMUSTEXIST
								  | OFN_HIDEREADONLY
								  | OFN_PATHMUSTEXIST;
	return (GetOpenFileName( &g_OpenFileName ))?
		g_szParaName:NULL;
}

BOOL QueryFileName(char *path)
{ /* ̧ٖ̓͂߂܂ */
	int f_renew_old;
	BOOL result;
	char szFilter[] = "DVI files(*.dvi)\0*.dvi\0"
			"TAR files(*.tar)\0*.tar\0"
			"All files(*.*)\0*.*\0";
	static char InitDir[MAX_PATH];

	// ̧ٵݥ޲۸ނ쐬邽߂̍\̏(OPENFILENAME\̎Q)

	if(path != NULL && strlen(path) < MAX_PATH)
		strcpy(InitDir, path);
	f_renew_old = f_renew;
	f_renew = 0;
	QueryFileSub();
	g_OpenFileName.lpstrFile   = g_szFileName; /* "̧ٖ" ɕ\̧ٖ */
	g_OpenFileName.lpstrFilter = szFilter; /* tB^[ */
	g_OpenFileName.lpstrTitle	  = "open a dvi file"; /* ^Cgo[ */
	g_OpenFileName.lpstrDefExt	  = "dvi"; /* ftHg̊gq */
	g_OpenFileName.lpstrInitialDir = InitDir;
	g_OpenFileName.Flags		  = OFN_FILEMUSTEXIST
								  | OFN_HIDEREADONLY
								  | OFN_PATHMUSTEXIST;
	result = GetOpenFileName( &g_OpenFileName );
	f_renew = f_renew_old;
	return result;
}

#ifdef	WMF
void DisplayMetaFile(HDC hdc, BYTE *pBMP, 
	int x_pos, int y_pos, int x_size, int y_size, int type)
{
	RECT rcc;

	rcc.left = x_pos;
	rcc.right = x_pos + x_size;
	rcc.top = y_pos;
	rcc.bottom = y_pos + y_size;
	PlayEnhMetaFile( hdc, (HENHMETAFILE)pBMP, &rcc );
}
#endif // WMF

void Page2EMF(char *name)
{
	HDC hdc, hdcref;
	HENHMETAFILE hmeta;
	char head[0x200];
	RECT rect;
	int kf_rpcolor;
	int iWidthMM, iHeightMM;
	int iWidthPels, iHeightPels;

	f_dstop |= 4;
	kf_rpcolor = f_rpcolor;
	f_rpcolor = 5;

	hdcref = GetDC(g_winData.hWnd);
	iWidthMM	= GetDeviceCaps(hdcref, HORZSIZE);
	iHeightMM	= GetDeviceCaps(hdcref, VERTSIZE);
	iWidthPels	= GetDeviceCaps(hdcref, HORZRES);
	iHeightPels = GetDeviceCaps(hdcref, VERTRES);
	rect.top = rect.left = 0;
	rect.right = GetTextXSize()*iWidthMM*100/iWidthPels/GetXGray();
	rect.bottom = GetTextYSize()*iHeightMM*100/iHeightPels/GetYGray();

	sprintf(head, "dviout\0%s %d\0", current_name, 
		TransPage(GetCurrentPage()));
	hdc = CreateEnhMetaFile(hdcref, name, &rect, head);
	SetStretchBltMode( hdc, COLORONCOLOR );
	ClearhBitmap();
	hBitmap = CreateCompatibleBitmap(hdc, MAX_FSIZE, MAX_FSIZE);
	hMemDC	= CreateCompatibleDC(hdc);
	SelectObject(hMemDC, hBitmap);
	if((f_bcolor & 0xffffff) != 0xffffff){
		HBRUSH hbrBackground;
		hbrBackground = CreateSolidBrush(
			RGB((f_bcolor>>16) & 0xff, (f_bcolor>>8) & 0xff, f_bcolor & 0xff));
		FillRect(hdc, &rect, hbrBackground);
		DeleteObject(hbrBackground);
	} else if( f_b_bcolor == 0 ) {
		FillRect(hdc, &rect, GetStockObject(BLACK_BRUSH));
	}/*   I think EMF MUST be a print image...
	else
		FillRect(hdc, &rect, 
			GetStockObject((SetGamma(0)<0)?BLACK_BRUSH:WHITE_BRUSH));
*/
	ClearKeepBMP();
	InitTTOut(hdc, 0, 0, GetXGray(), GetYGray());
	ExpandPage0();
	InitTTOut(NULL, 0, 0, 1, 1);
	ClearhBitmap();
	hmeta = CloseEnhMetaFile(hdc);
	if(name == NULL){
		OpenClipboard(g_winData.hMainWnd);
		EmptyClipboard();
		SetClipboardData(CF_ENHMETAFILE, hmeta);
		CloseClipboard();
	}
	DeleteEnhMetaFile(hmeta);
	ReleaseDC(g_winData.hWnd, hdcref);
	f_dstop &= ~4;
	f_rpcolor = kf_rpcolor;
	return;
}


/*
    Draw lines in presentation mode
    keep_pt[]: data of the vertices
 */

static struct KEEP_POINT
{
	short int x;
	short int y;
	unsigned char col;
	unsigned char mode;
} *keep_pt;

static int n_keep_pt;
static int id_old_point;

void GetLastPoint(int *x, int *y)
{
	if(n_keep_pt){
		*x = keep_pt[n_keep_pt-1].x;
		*y = keep_pt[n_keep_pt-1].y;
	}else
		*x=*y=0;
}

int SetPoint(int x, int y, int type)
{
#define	MAX_K_PT	0x200
	int i, j, k, size;

	if(type == -1){			// clear points
		i = n_keep_pt;
		if(keep_pt){
			Free(keep_pt);
			keep_pt = NULL;
			n_keep_pt = 0;
		}
		return i;
	}
	if(type == -2){			// clear the last point
		if(n_keep_pt > 0)
			n_keep_pt--;
		return n_keep_pt;
	}
	if(type == -3){			// shift one page for multi-page (continuous) mode
		for(i = 0; i < n_keep_pt; i++){
			keep_pt[i].x += x;
			keep_pt[i].y += y;
		}
		size = 2*y;
		if(size < 0)
			size = -size;
		for(i = j = 0; i < n_keep_pt; ){
			if(!(keep_pt[i].mode&0x0f)){		// starting point
				if(keep_pt[i].y >= 0 && keep_pt[i].y <= size){		// keep points
keep:				do{
						keep_pt[j].x = keep_pt[i].x;
						keep_pt[j].y = keep_pt[i].y;
						keep_pt[j].col = keep_pt[i].col;
						keep_pt[j++].mode = keep_pt[i++].mode;
					}while(i < n_keep_pt && (keep_pt[i].mode&0x0f));
				}else{
					for(k=i+1; ; k++){
						if(k >= n_keep_pt || !(keep_pt[k].mode&0x0f)){	// skip
							i = k;
							break;
						}
						if(keep_pt[k].y > 0 && keep_pt[k].y < size)
							goto keep;	// keep points
					}
				}
			}else
				i++;
		}
		n_keep_pt = j;
		id_old_point = id_page;
		return n_keep_pt;
	}
	if(keep_pt == NULL){
		keep_pt = (struct KEEP_POINT *)marea(sizeof(struct KEEP_POINT)*MAX_K_PT);
		id_old_point = id_page;
	}
	if(id_old_point != id_page){
		n_keep_pt = 0;
		id_old_point = id_page;
	}
	if(n_keep_pt >= MAX_K_PT)
		return -1;
	if(type & 0x80){	// change a point
		for(i = n_keep_pt -1; i >= 0; i--){
			if(!(keep_pt[i].mode)){
				if(type&0xf)
					continue;
			}else if(!(type&0xf))
				continue;
			keep_pt[i].x = x;
			keep_pt[i].y = y;
			break;
		}
	}else{
		type &= 0x0f;
		if(n_keep_pt > 0 || !type){
			keep_pt[n_keep_pt].x = x;
			keep_pt[n_keep_pt].y = y;
			keep_pt[n_keep_pt].mode = (type)?(type|(draw_style<<1)):0;
			keep_pt[n_keep_pt++].col =  draw_color;
		}
	}
	return n_keep_pt;
}

void ViewBmpFile( BYTE* pDib, WORD nHscrollPos, WORD nVscrollPos )
{
	HDC hdc;		/* ޲÷ */
	PAINTSTRUCT ps; /* ߲č\ */
	BYTE* pDibBits;
	short cxDib;	/* DIB ̕ */
	short cyDib;	/* DIB ̍ */
	short cxIndent;
	short cyIndent;
//	short cxClient;
//	short cyClient;
	int count;
	BYTE *pBMP;
	int x_pos, y_pos, x_size, y_size, x_org, y_org, x_div, y_div;
	int x_cut1, x_cut2, y_cut1, y_cut2, x_cutsize, y_cutsize, type, f_and;
	int wd, hd, ws, hs;
	HPEN hPen, hOldPen, hCutPen;
	BOOL f_CurOff = FALSE;
#if	0
	RECT rc;
	HBRUSH hbrBackground;
#endif // 0

	/* ̍œKɔĂ(^_^;) */
//	int	  nyPaintBeg; /* `JnW */
//	int	  nyPaintEnd; /* `IW */
//	int	  nxPaintBeg; /* `JnW */
//	int	  nxPaintEnd; /* `IW */
#if 0
	RECT  rectClient;
#endif
	HRGN  hRegion=NULL;
	POINT pt;
	BYTE *pDib0;

#ifdef	DOUBLE_PAGE
	int xshift=0;
	int yshift=0;
	int f_disp=0;
#else
#define	xshift 0
#define yshift 0
#endif // DOUBLE_PAGE
	if(!f_HandMoving && f_ShowCursor){
		ShowCursor( FALSE );
		f_CurOff = TRUE;
	}
	hdc = BeginPaint( g_winData.hWnd, &ps );
	if(f_dstop)
		goto end2;
	f_dstop |= 2;
	hCutPen = NULL;
//	cxClient = rectClient.right - rectClient.left;
//	cyClient = rectClient.bottom - rectClient.top;
	{
#ifdef	DOUBLE_PAGE
		if(f_2page)
			AddKeepBMP(0);
#endif // DOUBLE_PAGE
		SetStretchBltMode( hdc, COLORONCOLOR ); /* ĕ`悵 */
again:
#ifdef	DOUBLE_PAGE
		count = (xshift|yshift)?1:0;
		if(IS_2DIB2)
			count++;
		if(IS_2REV)
			count++;
#endif // DOUBLE_PAGE
		if((pDib0 =
#ifdef	DOUBLE_PAGE
			(count&1)?pDib2:
#endif // DOUBLE_PAGE
			pDib) == NULL){
			cxDib=cyDib=0;
			goto end_page;
		}
#ifdef	DOUBLE_PAGE
		f_disp |= (xshift|yshift)?2:1;
#endif // DOUBLE_PAGE
		pDibBits = GetDibBitsAddress( pDib0 );
		cxDib	 = GetDibWidth( pDib );
		cyDib	 = GetDibHeight( pDib );
		cxIndent = g_nxIndent - nHscrollPos;
		cyIndent = g_nyIndent - nVscrollPos;

#ifdef	DOUBLE_PAGE
		if(IS_2VERT)
			cyIndent += yshift;
		else
			cxIndent += xshift;
#endif // DOUBLE_PAGE

		if( (f_rpcolor == 5 || (b_presentation_mode && (f_cover == 1))) 
		  && !f_2page ){
			RECT rc;

			rc.left = cxIndent;
			rc.right = cxIndent + cxDib + 2;
			rc.top = cyIndent;
			rc.bottom = cyIndent + cyDib + 2;

			if((f_bcolor & 0xffffff) != 0xffffff){
				HBRUSH hbrBackground;
				hbrBackground = CreateSolidBrush(
					RGB((f_bcolor>>16) & 0xff, (f_bcolor>>8) & 0xff, 
						f_bcolor & 0xff));
				FillRect(hdc, &rc, hbrBackground);
				DeleteObject(hbrBackground);
			} else if( f_b_bcolor == 0 ) {
				FillRect(hdc, &rc, 
					GetStockObject((SetGamma(0)<0)?WHITE_BRUSH:BLACK_BRUSH));
			}else{
				FillRect(hdc, &rc, 
					GetStockObject((SetGamma(0)<0)?BLACK_BRUSH:WHITE_BRUSH));
			}
		}
		hRegion = CreateRectRgn(cxIndent, cyIndent,
			cxIndent + cxDib + 2, cyIndent + cyDib + 2);
		SelectClipRgn(hdc, hRegion);
		if(b_presentation_mode && f_cover == 1 && !f_2page){
			if(f_coverH & 2){
			  ExcludeClipRect(hdc, 
				cxIndent + cover_xpos/GetXGray()+1,
				cyIndent + cover_ypos/GetYGray()+1,
				cxIndent + cxDib + 2,
				cyIndent + cyDib + 2);
			}else{
			  ExcludeClipRect(hdc, 
				cxIndent,
				cyIndent + cover_ypos/GetYGray()+1,
				cxIndent + (GetTextXSize() - cover_xpos)/GetXGray()+1,
				cyIndent + cyDib + 2);
			}
		}
		ClearhBitmap();
		if(bmp_pt > 0 || (f_rpcolor & 4)){
			hBitmap = CreateCompatibleBitmap(hdc, MAX_FSIZE, MAX_FSIZE);
			hMemDC	= CreateCompatibleDC(hdc);
			SelectObject(hMemDC, hBitmap);
		}
		if((f_rpcolor == 5 && !f_2page)){		// patch2 mode
			ClearKeepBMP();
			InitTTOut(hdc, cxIndent, cyIndent, GetXGray(), GetYGray());
			ExpandPage();
			DeleteObject(hRegion);
			goto end;
		}
#ifdef	DOUBLE_PAGE
		if(!IS_MPAGE)
#endif // DOUBLE_PAGE
		SetDIBitsToDevice( /*DIB޲÷Ăɋ`] */
					hdc, /* ޲÷ */
					cxIndent, /* ]`W */
					cyIndent, /* ]`W */
					cxDib,/* ]`̕ */
					cyDib,/* ]`̍ */
					0,	  /* ]`W */
					0,	  /* ]`W */
					0, /* z̍ŏ̑s */
					cyDib,/* s̐ */ 
					(LPSTR)pDibBits,/* rbg̔z̃AhX */
					(LPBITMAPINFO)pDib, /* ޯϯߏi[\̱ڽ */
					DIB_RGB_COLORS );	/* RGB܂گĲޯ */
		for(count = (pDib0==pDib)?0:last_bmp; ; ){
			type = 1;
			pBMP = (BYTE *)GetBMPdata(count++, &x_pos, &y_pos, 
				&x_size, &y_size, &type);
			if(	 pBMP == NULL
#ifdef	DOUBLE_PAGE
			 || (IS_2PAGE && pDib0 == pDib && count > last_bmp) 
#endif // DOUBLE_PAGE
			 )
				break;
			x_div = GetXGray();
			y_div = GetYGray();
#ifdef	WMF
			if(type == F_WMF || type == F_EMF){
				DisplayMetaFile(hdc, pBMP, 
					cxIndent + x_pos/x_div, cyIndent + y_pos/y_div,
					x_size/x_div, y_size/y_div, type);
				continue;
			}
#endif // WMF
			x_cut1 = (x_pos >= 0)?0:-x_pos;
			x_cut2 = x_pos + x_size - cxDib*x_div;
			if(x_cut2 < 0)
				x_cut2 = 0;
			y_cut1 = (y_pos >= 0)?0:-y_pos;
			y_cut2 = y_pos + y_size - cyDib*y_div;
			if(y_cut2 < 0)
				y_cut2 = 0;
			if(	 (x_cutsize = x_size - x_cut1 - x_cut2) <= 0
			  || (y_cutsize = y_size - y_cut1 - y_cut2) <= 0)
				continue;
			x_org	= GetDibWidth( pBMP );
			y_org	= GetDibHeight( pBMP );
			if(type == 1)
				 f_and = SRCCOPY;
			else  if(SetGamma(0) >= 0)
				 f_and = (type > -3)?SRCAND:SRCPAINT;
			else f_and = (type > -3)?SRCPAINT:SRCAND;
			wd = (x_cutsize + x_div-1)/x_div;
			hd = (y_cutsize + y_div-1)/y_div;
			ws = x_org*x_cutsize/x_size;
			hs = y_org*y_cutsize/y_size;
			PrintKeepBMP(hdc, hMemDC, pBMP, type, f_and,
				cxIndent + (x_cut1 + x_pos)/x_div,
				cyIndent + (y_cut1 + y_pos)/y_div,
				wd, hd,
				x_cut1*x_org/x_size, y_cut2*y_org/y_size, ws, hs, y_org);
		}
		if(pDibPen)
			StretchDIBits( hdc,
				cxIndent, cyIndent, cxDib, cyDib, 
				0, 0, 
				((BITMAPINFOHEADER*)pDibPen)->biWidth,
				((BITMAPINFOHEADER*)pDibPen)->biHeight,
				GetDibBitsAddress( pDibPen ), (BITMAPINFO*)pDibPen, DIB_RGB_COLORS, (SetGamma(0)>0)?SRCAND:SRCPAINT);

end_page:
		if(hRegion)
			DeleteObject(hRegion);
		hRegion = NULL;
#ifdef	DOUBLE_PAGE
		if(IS_2PAGE && !xshift && !yshift){
			if(IS_2VERT)
				yshift = cyDib + 1;
			else
				xshift = cxDib + 1;
			goto again;
		}
#endif // DOUBLE_PAGE
#ifdef	DOUBLE_PAGE
		if(f_disp==0)
			goto end;
		if( IS_2PAGE && !(f_disp & 2)){
			cxDib = cyDib = 0;
			if(IS_2VERT)
				cyIndent += yshift;
			else
				cxIndent += xshift;
		}
		hRegion = CreateRectRgn(cxIndent-xshift, cyIndent-yshift, 
			cxIndent + cxDib + 2, cyIndent + cyDib + 2);
		SelectClipRgn(hdc, hRegion);
#endif // DOUBLE_PAGE
		hPen = (HPEN)GetStockObject( 
		  ((f_bcolor & 0xffffff) == 0 || 
		  ((f_bcolor & 0xffffff) == 0xffffff && f_b_bcolor && SetGamma(0)<0))?
			WHITE_PEN:BLACK_PEN );
		hOldPen = (HPEN)SelectObject( hdc, hPen );
#ifdef DOUBLE_PAGE
		if(IS_MPAGE){
			count = (IS_16PAGE)?4:2;
			for(x_pos = 1; x_pos < count; x_pos++){
				MoveToEx( hdc, cxIndent + x_pos*cxDib/count + 1, 
					cyIndent, &pt );
				LineTo( hdc,  cxIndent + x_pos*cxDib/count + 1, 
					cyIndent + cyDib);
				MoveToEx( hdc, cxIndent, cyIndent + x_pos*cyDib/count + 1, 
					&pt );
				LineTo( hdc,  cxIndent + cxDib, 
					cyIndent + x_pos*cyDib/count + 1);
			}
		}
#endif // DOUBLE_PAGE
		if(b_presentation_mode){
			if(id_old_point != id_page)
				n_keep_pt = 0;
			else if(n_keep_pt){
				int d_color, d_blush;

				d_color = -1;
				x_div = GetXGray();
				y_div = GetYGray();
				cxIndent -= xshift;
				cyIndent -= yshift;

				for(count = 0; count < n_keep_pt; count++){
					switch(keep_pt[count].mode){
						int xx, yy, xxx, yyy;

						case 0:			// starting point
						case 2:
							if(d_color != keep_pt[count].col){		// define/change color
								switch((d_color = keep_pt[count].col) & 7){
									default:
									case 0:		// red
										d_blush = 0x0000ff;
										break;
									case 1:		// black
										d_blush = 0x010101;
										break;
									case 2:		// blue
										d_blush = 0xff0000;
										break;
									case 3:		// green
										d_blush = 0x00ff00;
										break;
								}
								if(hCutPen)
									DeleteObject(hCutPen);
								hCutPen = CreatePen(PS_SOLID, (d_color&F_DTHICK)?4:1, d_blush);
								SelectObject(hdc, hCutPen);
							}
							if(count < n_keep_pt - 1)
								MoveToEx( hdc, 
									cxIndent + keep_pt[count].x/x_div,
									cyIndent + keep_pt[count].y/y_div, &pt);
							else{
								xx = cxIndent + keep_pt[count].x/x_div;
								yy = cyIndent + keep_pt[count].y/y_div;
								MoveToEx(hdc, xx-2, yy, &pt);
								LineTo(hdc, xx+3, yy);
								MoveToEx(hdc, xx, yy-2, &pt);
								LineTo(hdc, xx, yy+3);
							}
							break;

						case 1:				// draw line
							LineTo( hdc, 
								cxIndent + keep_pt[count].x/x_div, 
								cyIndent + keep_pt[count].y/y_div);
							break;

						case 3:				// draw box
							if(count > 0){
								MoveToEx(hdc,
									xx = cxIndent + keep_pt[count].x/x_div, 
									yy = cyIndent + keep_pt[count].y/y_div, &pt);
								LineTo( hdc,
									xxx = cxIndent + keep_pt[count-1].x/x_div, yy);
								LineTo( hdc, xxx, 
									yyy = cyIndent + keep_pt[count-1].y/y_div);
								LineTo( hdc, xx, yyy );
								LineTo( hdc, xx, yy );
							}
						default:
							break;
					}
				}
				if(d_color >= 0){
					SelectObject(hdc, hOldPen);
					if(hCutPen){
						DeleteObject(hCutPen);
						hCutPen = NULL;
					}
				}
				cxIndent += xshift;
				cyIndent += yshift;
			}
			if(f_background > 2 || (f_2page&(F_2PAGE|F_MPAGE|F_16PAGE)))
				goto lines;
		}else{
lines:		MoveToEx( hdc, cxIndent - xshift, cyIndent - yshift, &pt );
			LineTo( hdc, cxIndent + cxDib, cyIndent - yshift );
			LineTo( hdc, cxIndent + cxDib, cyIndent + cyDib );
			LineTo( hdc, cxIndent - xshift, cyIndent + cyDib );
			LineTo( hdc, cxIndent - xshift, cyIndent - yshift);
			MoveToEx( hdc, cxIndent + cxDib + 1, cyIndent - yshift + 2, &pt );
			LineTo( hdc, cxIndent + cxDib + 1, cyIndent + cyDib + 1 );
			LineTo( hdc, cxIndent - xshift + 1, cyIndent + cyDib + 1 );
#ifdef	DOUBLE_PAGEEE
			if(IS_2HORI)
			{
				MoveToEx( hdc, cxIndent + 1, cyIndent, &pt );
				LineTo( hdc, cxIndent + 1, cyIndent + cyDib);
			}
#endif // DOUBLE_PAGE
			if(f_rectcut && !f_2page){
				hCutPen = CreatePen(PS_SOLID, 1, 0x0000ff);
				SelectObject(hdc, hCutPen);
				x_div = GetXGray();
				y_div = GetYGray();

				MoveToEx( hdc, 
					cxIndent + rectcut.left/x_div,
					cyIndent + rectcut.top/y_div, &pt);
				LineTo( hdc, 
					cxIndent + rectcut.right/x_div, 
					cyIndent + rectcut.top/y_div );
				LineTo( hdc, 
					cxIndent + rectcut.right/x_div, 
					cyIndent + rectcut.bottom/y_div );
				LineTo( hdc, 
					cxIndent + rectcut.left/x_div, 
					cyIndent + rectcut.bottom/y_div );
				LineTo( hdc, 
					cxIndent + rectcut.left/x_div, 
					cyIndent + rectcut.top/y_div );
				SelectObject(hdc, hOldPen);
				DeleteObject(hCutPen);
				hCutPen = NULL;
			}
		}
		DeleteObject(hRegion);
		SelectObject( hdc, hOldPen );
	}
end:
	if(f_rpcolor == 5)
		InitTTOut(NULL, 0, 0, 1, 1);
end2:
	EndPaint( g_winData.hWnd, &ps );
	f_dstop &= ~2;
	if(f_CurOff)
		ShowCursor( TRUE );
	return;
}

struct F_HIST f_hist[MAX_F_HIST];
int f_hist_pt, f_hist0;
struct F_FMENU f_fmenu[MAX_F_MENU];

#define GetFHPos(x) ((x)&(MAX_F_HIST-1))

void SaveFileHistory(char *name, int page, int id)
{
	 if(  f_hist_pt == f_hist0
	   || strcmp(f_hist[GetFHPos(f_hist_pt - 1)].name, name) ){
		strncpy(f_hist[GetFHPos(f_hist_pt)].name, name, MAX_PATH);
		f_hist[GetFHPos(f_hist_pt)].id = id;
		f_hist[GetFHPos(f_hist_pt)].page = page;
		f_hist_pt++;
	}
}

char *SearchFileHistory(char *name, int *page)
{
	int len, lent, pt;
	struct F_HIST *fh;

	len = strlen(name);
	for(pt = f_hist_pt-1; pt >= f_hist0 && pt >= f_hist_pt - MAX_F_HIST; pt--){
		fh = f_hist + GetFHPos(pt);
		if((	lent = strlen(fh->name)) >= len
		  &&	strcmpi(fh->name + lent - len, name) == 0 ){
			if(	 (lent -= (len+1)) > 0
			  && fh->name[lent] != '\\'
			  && fh->name[lent] != '/'
			  && fh->name[lent] != ':' )
				continue;
			*page = fh->page;
			return fh->name;
		}
	}
	return NULL;
}

char *GetOutPath(char *ext)
{
	strcpy(inipath+dviext, ext);
	return &inipath[0];
}

char *GetHelpPath(void)
{
	static char fname[MAX_PATH];
	static f_Ekeep = -2;
	int i;

	if(f_Ekeep != f_English){
		for(i = 0; ;){
//			strcpy(fname, GetOutPath("hlp"));
			strcpy(fname, GetOutPath("chm"));
			if(f_English)
//				strcpy(fname + strlen(fname) - 4, "e.hlp");
				strcpy(fname + strlen(fname) - 4, "e.chm");
			if(!access(fname, 0) || i++)
				goto found;
//			strcpy(fname+GetNamePos(fname), (f_English)?"dvioute.hlp":"dviout.hlp");
			strcpy(fname+GetNamePos(fname), (f_English)?"dvioute.chm":"dviout.chm");
			if(!access(fname, 0)){
found:			f_Ekeep = f_English;
				break;
			}
		}
	}
	return fname;
}

#include "id2str_idh.h"

void ShowWinHelp(int id)
{
//	WinHelp(g_winData.hMainWnd, GetHelpPath(), HELP_CONTEXT, id);
	char buf[4096];
	lstrcpy(buf,GetHelpPath());
	lstrcat(buf,"::");
	lstrcat(buf,Id2Str_IDH(id));
	HtmlHelp(g_winData.hMainWnd,buf,HH_DISPLAY_TOC, (DWORD)NULL);
}

void SetFile2Menu(void)
{
	int i, j;

	if(f_hist_pt <= f_hist0)
		return;
	AppendMenu(GetSubMenu( g_winData.hMenu, 0 ), MFT_SEPARATOR, 0, NULL);
	for(j=0, i = f_hist_pt - 1; j < MAX_F_MENU && i >= f_hist0; j++){
		sprintf(f_fmenu[j].name, "&%d:%s", j+1, f_hist[i].name);
		f_fmenu[j].page = f_hist[i--].page;
		AppendMenu(GetSubMenu( g_winData.hMenu, 0 ), 
			MFT_STRING, ID_FMENU1 + j, f_fmenu[j].name);
	}
}

void ReadHistory(char *name)
{
#if	0
	FILE *fp;
#else
	char fig[4];
#endif // 0
	int len, count;
	char tmp[MAX_PATH+0x10], *p;


#if	0
	count = -1;
	if((fp = fopenf(name, "r")) == NULL)
		return;
	fgets(tmp, MAX_PATH+0x10, fp);
	if(strcmp(tmp, HIST_ID_STR "\n"))
		return;
	while(fgets(tmp, MAX_PATH+0x10, fp)){
#else
	tmp[MAX_PATH+0x0f] = 0;
	for(count = 0; count < MAX_F_KEEP; ){
		sprintf(fig, "%d", count);
		RestoreString(tmp, MAX_PATH+0x0f, name, fig, "");
		if(!*tmp)
			break;
#endif // 0
		for(p = &tmp[0]; *p != '\t' && *p; p++);
		if(*p)
			*p++ = 0;
		if((len = atoi(p)) <= 0)
			len = 1;
		SaveFileHistory(tmp, len, -(++count));
	}
#if	0
	fclose(name);
#endif // 0
}

void WriteHistory(char *name)
{
	static int end;
#if	0
	FILE *fp;
#else
	char fig[4];
#endif // 0
	int i, j, num;
	int	 tmp_page[MAX_F_HIST*2];
	char tmp_str[MAX_F_HIST*2][MAX_PATH];

	if(end++)
		return;
	if(f_hist_pt > f_hist0 && (i = GetCurrentPage()) != 0)
		f_hist[GetFHPos(f_hist_pt - 1)].page = i;
	for(i = 0; i < MAX_F_HIST*2; )
		tmp_page[i++] = 0;
	for(i = f_hist_pt - 1, j = 0; i >= f_hist0 && i >= f_hist_pt - MAX_F_HIST; ){
		strcpy(tmp_str[j], f_hist[GetFHPos(i)].name);
		tmp_page[j++] = f_hist[GetFHPos(i--)].page;
	}
	f_hist_pt = 0;
	ReadHistory(name);
	if(f_hist_pt > MAX_F_HIST)
		f_hist_pt = MAX_F_HIST;
	for(j = MAX_F_HIST*2 - 1, i = 0; i < f_hist_pt; i++){
		strcpy(tmp_str[j], f_hist[GetFHPos(i)].name);
		tmp_page[j--] = f_hist[GetFHPos(i++)].page;
	}
#if 0
	for(i=MAX_F_HIST*2-1; i >= 0; i--){
		if(tmp_page[i]){
			error(14, "Orig: %d:%s\t%d\n", i, tmp_str[i], tmp_page[i]);
		}
	}
	error(14, "");
#endif // 0
	for(num = 0, i = 0; i < 2*MAX_F_HIST - 1; i++){
		if(tmp_page[i]){
#if	0
			if(++num >= MAX_F_HIST)
#else
			if(++num >= MAX_F_KEEP)
#endif // 0
				goto save;
			for(j = i + 1; j < 2*MAX_F_HIST; j++){
				if(tmp_page[j] && 
				  !strcmpi(tmp_str[i], tmp_str[j]))
					tmp_page[j] = 0;
			}
		}
	}
save:
#if	0
	if((fp = fopenf(name, "w")) == NULL)
		return;
	fprintf(fp, "%s\n", HIST_ID_STR);
	for( ; i >= 0; i--){
		if(tmp_page[i])
			fprintf(fp, "%s\t%d\n", tmp_str[i], tmp_page[i]);
	}
	fclose(fp);
#else
	for(num = 0; i >= 0; i--){
		if(tmp_page[i]){
			sprintf(common_work, "%s\t%d", tmp_str[i], tmp_page[i]);
			sprintf(fig, "%d", num++);
			ReserveString(name, fig, common_work);
		}
	}
	if(num < MAX_F_KEEP){
		sprintf(fig, "%d", num);
		ReserveString(name, fig, "");
	}
#endif // 0
}

BYTE* ReadDIB(char *szFileName)
{
	BYTE	*pDib;		   /* DIBWJq[v̈ */
	int page;
	char name[MAX_PATH];
	LPSTR lpPart;

	if(f_hist_pt > f_hist0 && (page = GetCurrentPage()) != 0)
		f_hist[GetFHPos(f_hist_pt - 1)].page = page;
	if(GetFullPathName(szFileName, MAX_PATH-1, name, &lpPart))
		strncpy(szFileName, name, MAX_PATH);	/* to Full Path Name */
	if( OpenDvi(szFileName) <= 0 || (ExpandPage(),(pDib = MakeBMP()) == NULL))
		return NULL;
	SaveFileHistory(current_name, GetCurrentPage(), id_dvi);
	return pDib + sizeof(BITMAPFILEHEADER);
}


BYTE* GetDibBitsAddress( BYTE* pDib )
{
	DWORD dwNumColors,
		  dwColorTableSize;
	WORD  wBitCount;

	if( ((BITMAPINFOHEADER*)pDib)->biSize == sizeof(BITMAPCOREHEADER) )
	{
		wBitCount = ((BITMAPCOREHEADER*)pDib)->bcBitCount;
		if( wBitCount != 24 )
		{
			dwNumColors = 1L << wBitCount;
		}
		else
		{
			dwNumColors = 0;
		}
		dwColorTableSize = dwNumColors*sizeof(RGBTRIPLE);
	}
	else
	{
		wBitCount = ((BITMAPINFOHEADER*)pDib)->biBitCount;
		if( ((BITMAPINFOHEADER*)pDib)->biSize >= 36 )
		{
			dwNumColors = ((BITMAPINFOHEADER*)pDib)->biClrUsed;
		}
		else
		{
			dwNumColors = 0;
		}
		
		if( dwNumColors == 0 )
		{
			if( wBitCount != 24 )
			{
				dwNumColors = 1L << wBitCount;
			}
			else
			{
				dwNumColors = 0;
			}
		}

		dwColorTableSize = dwNumColors*sizeof(RGBQUAD);
	}
	return pDib + ((BITMAPINFOHEADER*)pDib)->biSize + dwColorTableSize;
}

WORD GetDibWidth( BYTE* pDib )
{
	if( ((BITMAPINFOHEADER*)pDib)->biSize == sizeof(BITMAPCOREHEADER) )
	{
		return (WORD)(((BITMAPCOREHEADER*)pDib)->bcWidth);
	}
	else
	{
		return (WORD)(((BITMAPINFOHEADER*)pDib)->biWidth);
	}
}

WORD GetDibHeight( BYTE* pDib )
{
	if( ((BITMAPINFOHEADER*)pDib)->biSize == sizeof(BITMAPCOREHEADER) )
	{
		return (WORD)(((BITMAPCOREHEADER*)pDib)->bcHeight);
	}
	else
	{
		return (WORD)(((BITMAPINFOHEADER*)pDib)->biHeight);
	}
}

void ReserveInt( char* section, char* key, int i )
{
	/* WXgɐlۊ
	   section: ZNV
	   key:		L[
	   sz:		ۊǐl
	   e.g. ReserveInt( "FOO", "BAR", 10 );
			FOO ZNV̉ BAR Gg10ƂlۊǁB*/
	HKEY hKey;
	DWORD dwDisposition;
	char szKey[256];
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegCreateKeyEx( HKEY_CURRENT_USER, szKey, 
					0, "", REG_OPTION_NON_VOLATILE, KEY_WRITE, 
					NULL, &hKey, &dwDisposition ) != ERROR_SUCCESS )
	{
		MessageBox( NULL, "Error in RegCreateKey", NULL, MB_OK );
		return;
	}
	RegSetValueEx( hKey, key, 0, REG_DWORD, (BYTE *)&i, sizeof(int) );
	RegCloseKey( hKey );
}

void ReserveString( char* section, char* key, char* sz )
{
	/* WXgɕۊ
	   section: ZNV
	   key:		L[
	   sz:		ۊǕ
	   e.g. ReserveString( "FOO", "BAR", "SAMPLE" );
			FOO ZNV̉ BAR Gg SAMPLE Ƃۊ */
	HKEY hKey;
	DWORD dwDisposition;
	char szKey[256];
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegCreateKeyEx( HKEY_CURRENT_USER, szKey, 
					0, "", REG_OPTION_NON_VOLATILE, KEY_WRITE, 
					NULL, &hKey, &dwDisposition ) != ERROR_SUCCESS )
	{
		MessageBox( NULL, "Error in RegCreateKey", NULL, MB_OK );
		return;
	}
	RegSetValueEx( hKey, key, 0, REG_SZ, (BYTE *)sz, lstrlen(sz)+1 );
	RegCloseKey( hKey );
}

int RestoreInt( char* section, char* key, int def )
{
	/* WXg琮l𕜌
	   section: ZNV
	   key:		L[
	   def: ftHgl
	   e.g. i = RestoreInt( "FOO", "BAR", 10 );
	   FOOZNVBARL[̓eiɑBlȂ10 */
	HKEY hKey;
	char szKey[256];
	int i;
	int size = sizeof(int);
	LONG err;
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegOpenKeyEx( HKEY_CURRENT_USER, szKey, 
					0, KEY_READ, &hKey ) != ERROR_SUCCESS )
	{
		return def;
	}
	err = RegQueryValueEx( hKey, key, 0, NULL, (LPBYTE)&i, (LPDWORD)&size );
	if( err != ERROR_SUCCESS )
	{
		return def;
	}
	RegCloseKey( hKey );
	return (int)i;
}

int DeleteRegistry(char *section, char *key)
{
	HKEY hKey = NULL;
	int result;
	char szKey[256];

	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section);
	if( RegOpenKeyEx( HKEY_CURRENT_USER, szKey, 0, KEY_WRITE, &hKey ) 
	  != ERROR_SUCCESS )
		return 0;
	result = 
	//		RegDeleteKey(hKey, key);
			RegDeleteValue(hKey, key);
	RegCloseKey( hKey );
	return result;
}

/*
   mode = 0: HKEY_CLASSES_ROOT
          1: HKEY_CURRENT_USER
          2: HKEY_LOCAL_MACHINE
          3: HKEY_USERS
          4: HKEY_PERFORMANCE_DATA
          5: HKEY_CURRENT_CONFIG
          6: HKEY_DYN_DATA
*/
int ReadRegString(char *str, int size, char *section, char *key, int mode)
{
	HKEY hKey = NULL;
	LONG lResult;
	HKEY value;
	int  res;
	DWORD dwType = REG_SZ;

	switch(mode){
		case 0: value = HKEY_CLASSES_ROOT;
				break;
		case 1: value = HKEY_CURRENT_USER;
				break;
		case 2: value = HKEY_LOCAL_MACHINE;
				break;
		case 3: value = HKEY_USERS;
				break;
		case 4: value = HKEY_PERFORMANCE_DATA;
				break;
		case 5: value = HKEY_CURRENT_CONFIG;
				break;
		case 6: value = HKEY_DYN_DATA;
				break;
		default: value = HKEY_CURRENT_USER;;
				break;
	}

	if( RegOpenKeyEx( HKEY_CURRENT_USER, section, 0, KEY_READ, &hKey ) 
	  != ERROR_SUCCESS )
		return 0;
	lResult = RegQueryValueEx( hKey, key, 0, &dwType, (LPBYTE)str, &size );
	RegCloseKey( hKey );
	if( lResult == ERROR_MORE_DATA )
		res = -1;
	else if( lResult == ERROR_SUCCESS )
		res = 1;
	else
		res = -2;
	return res;
}

int RestoreString( char* str, int size, char* section, char* key, char* def )
{
	/* WXg當l𕜌
	   str:		i[̈w|C^
	   size:	̈̃TCY
	   section: ZNV
	   key:		L[
	   def: ftHg
	   Ԓl:	Rs[
	   e.g. i = RestoreString( szFile, 256, "FOO", "BAR", "C:\\AUTOEXEC.BAT" );
	   FOOZNVBARL[̓eő256܂szFileɊi[B
	   L[Ȃ"C:\\AUTOEXEC.BAT"Rs[B*/
	HKEY hKey = NULL;
	char szKey[256];
//	int i;
	DWORD dwType = REG_SZ;
	LONG lResult;
	DWORD copysize = size;
	
//	for( i = 0; i < size; i++ ) str[i] = '\0';
	str[0] = 0;
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegOpenKeyEx( HKEY_CURRENT_USER, szKey, 0, KEY_READ, &hKey ) 
		!= ERROR_SUCCESS  )
	{
		goto copydef;
	}
	lResult = RegQueryValueEx( hKey, key, 0, &dwType, (LPBYTE)str, &copysize );
	if( lResult == ERROR_MORE_DATA )
	{
		char* szData  = (char*)marea( copysize*sizeof(char) );
		RegQueryValueEx( hKey, key, 0, &dwType, (LPBYTE)szData, &copysize );
		lstrcpyn( str, szData, size );
		str[size - 1] = '\0';
		Free( szData );
		RegCloseKey( hKey );
		return lstrlen(str);
	}
	else if( lResult == ERROR_SUCCESS ){
		RegCloseKey( hKey );
		goto quit;
	}
copydef:
	RegCloseKey( hKey );
	if( lstrlen(str) == 0 )
	{
		int l = lstrlen( def );
		if( size <= l - 1 )
		{
			lstrcpyn( str, def, size );
			str[size-1] = '\0';
			return size - 1;
		}
		else
		{
			lstrcpyn( str, def, l + 1 );
			str[l] = '\0';
			return l;
		}
	}
quit:
	return lstrlen(str);
}

void ReserveBinary( char* section, char* key, BYTE* data, int size )
{
	/* WXgɃoCif[^ۊ
	   section: ZNV
	   key:		L[
	   data:	oCif[^̃|C^
	   size:	oCif[^̃oCg
	   e.g. ReserveInt( "FOO", "BAR", 10 );
			FOO ZNV̉ BAR Gg10ƂlۊǁB*/
	HKEY hKey;
	DWORD dwDisposition;
	char szKey[256];
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegCreateKeyEx( HKEY_CURRENT_USER, szKey, 
					0, "", REG_OPTION_NON_VOLATILE, KEY_WRITE, 
					NULL, &hKey, &dwDisposition ) != ERROR_SUCCESS )
	{
		MessageBox( NULL, "Error in RegCreateKey", NULL, MB_OK );
		return;
	}
	
	RegSetValueEx( hKey, key, 0, REG_BINARY, (BYTE *)data, size );
	RegCloseKey( hKey );
}

int RestoreBinary( char* data, int size, char* section, char* key, BYTE def )
{
	/* WXg當l𕜌
	   str:		oCif[^i[̈̃|C^
	   size:	̈̃TCY
	   section: ZNV
	   key:		L[
	   Ԓl:	Rs[
	   e.g. i = RestoreBinary( &data, 256, "FOO", "BAR", 0 );
	   FOOZNVBARL[̓e256oCg܂dataɊi[B
	   L[Ȃ΃f[^̒gׂ͂0 */
	HKEY hKey;
	char szKey[256];
	DWORD dwType = REG_BINARY;
	LONG err;
	
	wsprintf( szKey, "Software\\SHIMA\\DVIOUT\\%s", section );
	if( RegOpenKeyEx( HKEY_CURRENT_USER, szKey, 
					0, KEY_READ, &hKey ) != ERROR_SUCCESS )
	{
		return -1;
	}
	err = RegQueryValueEx( hKey, key, 0, &dwType, (LPBYTE)data, (LPDWORD)&size );
	if( err != ERROR_SUCCESS )
	{
		memset( data, size, def );
	}
	RegCloseKey( hKey );
	return 0;
}

void KeepPathCash(char *pt, int size)
{
	char tmp[2];
#if	FILE_FONT_CASH
	FILE *fp;
#endif // FILE_FONT_CASH

	if(!size){
		tmp[0] = 0;
		size = -1;
		pt = tmp;
	}
#if	FILE_FONT_CASH
	if(size < 0){
		fp = fopen("dviout.cfr", "wb");
		size = -size;
	}else
		fp = fopen("dviout.csh", "wb");
	fwrite(pt, 1, size, fp);
	fclose(fp);
#else
	if(size < 0)
		ReserveBinary("File", "Freq",  pt, -size);
	else
		ReserveBinary("File", "Font",  pt, size);
#endif // FILE_FONT_CASH
}

static void LoadPathCash(void)
{
	int i, count, max_rep, k;
	unsigned char tmp[0x400];
	unsigned char *pt_rep[256];
	unsigned char *pt, *pts, *ptd, *ptdd;
	unsigned char *pack;
#if	FILE_FONT_CASH
	FILE *fp;
#endif // FILE_FONT_CASH

	if(!f_fkeep)
		return;

	tmp[0] = count = 0;
#if	FILE_FONT_CASH
	if((fp = fopen("dviout.cfr", "rb")) != NULL){
		fread(tmp, 1, 0x400, fp);
		fclose(fp);
	}
#else
	RestoreBinary(tmp, 0x400, "FILE", "Freq", 0);
#endif // FILE_FONT_CASH
	fcash_ver = tmp[0];
	if((fcash_ver & 0xfe) != FCASH_VERSION)
		return;
	fcash_rev = tmp[1];
	fcash_size = tmp[2] + (tmp[3] << 8);
	count = tmp[4] + (tmp[5] << 8);
	fcash_dev = (tmp[0] & 1)?tmp[6]:0;
#if	FILE_FONT_CASH
	fp = fopen("dviout.csh", "rb");
	if(fp == NULL)
		return;
	pack = marea(fcash_size+6);
	fcash_size = fread(pack, 1, fcash_size, fp);
	fclose(fp);
	if(fcash_size == 0){
		Free0(pack);
		return;
	}
#else
	pack = marea(fcash_size+6);
	RestoreBinary(pack, fcash_size, "FILE", "Font", 0);
#endif // FILE_FONT_CASH
	f_path_cash = 1;
								// unpack
	pts = pack;
	for(i=0; i<6; )				// for a broken FILE/FONT
		pts[fcash_size+i++] =0;
	ptd = common_work;
	while( (*ptd++ = *pts++) != 0 );		// copy TEXROOT
	while( (*ptd++ = *pts++) != 0 );		// copy TEXPK
	pt_rep[0] = pts-1;
	for(max_rep = 1; *pts; ){				// get strings to be replaced
		pt_rep[max_rep++] = pts;
		while(*pts++);
		if(max_rep == 256){
			Free0(pack);
			goto err;
		}
	}
	pts++;
	for(i=0; *pts; i++){
		ptdd = ptd + 3;
		while( (*ptdd++ = *pts++) != 0 );	// cmr10.300pk
		if(fcash_dev){
			ptd[2] = *pts % fcash_dev;
			k = *pts++/fcash_dev;
		}else{
			ptd[2] = *pts++;					// position in TEXPK
			k = *pts++;
		}
		if(k >= max_rep){
			Free0(pack);
			goto err;
		}
		pt = pt_rep[k];
		while( (*ptdd++ = *pt++) != 0 );	// replaced string for
		ptd[0] = ptdd - ptd;				// length of a unit
		ptd = ptdd;
	}
	*ptd++ = 0;
									// end unpack
	Free0(pack);
	if(i != count)
		goto err;
	i = ptd - common_work;
	path_cash = marea(i);
	memcpy(path_cash, common_work, i);
	if(!get_path_cash()){
		Free0(path_cash);
err:	path_cash = NULL;
		f_path_cash = fcash_size = 0;
		return;
	}
	pt = path_font;
	i = (fcash_dev)?7:6;
	while(count-- > 0){						// Set Frequency
		pt[1] = tmp[i++];
		pt += *pt;
	}
}

static BOOL IsDVItar(char *name)
{
	int len;

	if(name != NULL && (len = strlen(name) - 4) > 0){
		if( !stricmp(name + len, ".dvi") || !stricmp(name + len, ".tar" ) )
			return TRUE;
	}
	return FALSE;
}


static BOOL CALLBACK DlgTFunct( HWND hdwnd, UINT message, UINT wParam, 
	LONG lParam)
{
	int pos, i, j;
	static HWND hedit;

	switch(message){
		case WM_INITDIALOG:
			hedit = GetDlgItem( hdwnd, IDC_LISTBOX1 );
			SetFont( IsJapanese()?9:0, hedit, IsJapanese()?"lr SVbN":"Courier New", IsJapanese() );
			for(pos = 0; pos < num_add; pos++){
				if(IsDVItar(dviadd[pos].name))
					SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_ADDSTRING, 0,
					(LPARAM)dviadd[pos].name);
			}
			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_SETCURSEL, 0, 0);
//			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_SETHORIZONTALEXTENT,
//				1536, 0);
			return TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
						pos = SendDlgItemMessage(hdwnd, IDC_LISTBOX1, 
							LB_GETCURSEL, 0, 0L);
tar_open:				if(pos < 0)
							pos = 0;
						for(i = j = 0; i < num_add; i++){
							if(IsDVItar(dviadd[i].name)){
									if(j == pos){
										Current_DVI		 = dviadd[i].bod;
										Current_DVI_size = dviadd[i].lod;
										break;
									}else
										j++;
								}
						}
						EndDialog(hdwnd, 0);
						return TRUE;

				case IDC_LISTBOX1:
					if(HIWORD(wParam) == LBN_DBLCLK){
						pos = SendDlgItemMessage(hdwnd, IDC_LISTBOX1, 
							LB_GETCURSEL, 0, 0L);
						goto tar_open;
					}
					return TRUE;

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				}
				break;

		case WM_DESTROY:
			SetFont( 0, hedit, NULL, IsJapanese() );
			break;
	}
	return FALSE;
}

void ChooseTar(void)
{
	int pos, i;

	i = -1;

	for(pos = 0; pos < num_add; pos++){
		if(IsDVItar(dviadd[pos].name)){
			if(i < 0)
				i = pos;
			else{
				DialogBox( g_winData.hInstance,	
					MAKEINTRESOURCE(IDD_TARLIST),
					g_winData.hWnd, DlgTFunct);
				return;
			}
		}
	}
	if(i >= 0){
		Current_DVI		 = dviadd[i].bod;
		Current_DVI_size = dviadd[i].lod;
	}
}

static BOOL CALLBACK EnumProc( HWND hwnd, LPARAM lParam )
{
	/* This callback procedure will be called from EnumWindows function
	   which is included in WinMain function.
	   This procedure check whether there are DVIOUT(s) on desktop.
	   If DVIOUT(s) has already been on our desktop,
	   this procedure set "DVIOUT_Exist" flag TRUE; */
	char szClass[8];
	if( lParam != SEARCH_DVIOUT ) return 0;
	if( GetClassName( hwnd, szClass, sizeof(szClass) ) == 0 )
		return 0;
	if( strcmp( szClass, g_winData.szClassName ) == 0 )
	{
		DVIOUT_Exist = TRUE;
		DVIOUT_PRE_WND = hwnd;
		return 0;
	}
	return 1;
}

static void TellToOpen( void )
{
	/* If this procedure is called, the user wants existing DVIOUT to
	   open specified file.
	   The file's name is given by g_szFileName,
	   the window handle of existing DVIOUT is DVIOUT_PRE_WND.
	   I have to tell the existing DVIOUT the file name.
	   This will done by following.
	   I create memory mapped file on page file as "DVIOUT.TEL".
	   This file will be never seen from user side, only on
	   page file.
	   Although this is certainly some file, but it looks like memory,
	   so I will write there the file name.
	   And I tell existing DVIOUT to read the memory.
	   Of cource memories which are posessed some process are
	   protected by system from any others, but it is mapped file,
	   so I could share it.
	   There is one more remark. Because when this is called,
	   I don't create window yet. So g_winData.hMainWnd and so on are
	   never enable. */
	
	HANDLE	hMemFile;
	int len;

	hMemFile = CreateFileMapping( (HANDLE)0xffffffff, NULL,
								PAGE_READWRITE, 0, 4096, "DVIOUT.TEL" );
	if( hMemFile != NULL )
	{
		if( GetLastError() == ERROR_ALREADY_EXISTS )
		{
			MessageBox( NULL, "Memory mapped file already exists.\n" 
								"Not created.", NULL, MB_OK );
			CloseHandle( hMemFile );
		}
		else
		{
			LPVOID lpView = MapViewOfFile( hMemFile, 
							FILE_MAP_READ | FILE_MAP_WRITE, 0, 0, 0 );
			if( (BYTE*)lpView != NULL )
			{
				len = strlen(g_szFileName);
				if(len > 4 && stricmp(g_szFileName+len - 4,".dvi") == 0)
					len -= 4;
				strcpy( (LPTSTR)lpView, g_szFileName );
				if((f_hyper & F_H_DVIOPEN) && hypertag != NULL)
					sprintf( (LPTSTR)lpView + len, ".dvi%s", hypertag);
				else if(GetStartPage()>1)
					sprintf( (LPSTR)lpView + len, ".dvi# %d", GetStartPage());
				UnmapViewOfFile( (LPVOID)lpView );
			}
			else
			{
				MessageBox( NULL, "Cannot map view of file", NULL, MB_OK );
			}
		}
	}
	else
	{
		MessageBox( NULL, "Cannot create file mapping.", NULL, MB_OK );
	}
	SendMessage( DVIOUT_PRE_WND, WM_USER_ALREADY_EXIST, 0, 0 );

	/* If SendMessage returns, I regard that existing DVIOUT has finished
	   using memory mapped file, I can close the file. */
	CloseHandle( hMemFile );
	return;
}

#ifdef USE_INTELLI_MOUSE
static void InitIntelliMouse( void )
{
	uMSH_MOUSEWHEEL = RegisterWindowMessage( MSH_MOUSEWHEEL );
	if( !uMSH_MOUSEWHEEL )
	{
		MessageBox( NULL, "Register IntelliMOUSE Message Failed!",
				"Error", MB_OK );
		return;
	}
	WheelScrollLines = GetNumScrollLines();
}

#ifndef SPI_GETWHEELSCROLLLINES
#define SPI_GETWHEELSCROLLLINES	  104
#endif // SPI_GETWHEELSCROLLLINES


/*********************************************************************
* FUNCTION: GetNumScrollLines
* Purpose : An OS independant method to retrieve the number of wheel
*			scroll lines
* Params  : none
* Returns : UINT:  Number of scroll lines where
			WHEEL_PAGESCROLL indicates to scroll a page at a time.
* From	  : Microsoft Hardware IntelliMouse
*********************************************************************/
UINT GetNumScrollLines(void)
{
   HWND hdlMsWheel;
   UINT ucNumLines=3;  // 3 is the default
   OSVERSIONINFO osversion;
   UINT uiMsh_MsgScrollLines;
	

   memset(&osversion, 0, sizeof(OSVERSIONINFO));
   osversion.dwOSVersionInfoSize =sizeof(OSVERSIONINFO);
   GetVersionEx(&osversion);

   // In Windows 9x & WinNT3.51 query Mswheel for the number of scroll lines
   // and in WinNT 4.0 and later, use SystemParametersInfo API

   if ((osversion.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS) ||
	   ( (osversion.dwPlatformId == VER_PLATFORM_WIN32_NT) && 
		 (osversion.dwMajorVersion < 4)						  )	  )
   {
		hdlMsWheel = FindWindow(MSH_WHEELMODULE_CLASS, MSH_WHEELMODULE_TITLE);
		if (hdlMsWheel)
		{
		   uiMsh_MsgScrollLines = RegisterWindowMessage(MSH_SCROLL_LINES);
		   if (uiMsh_MsgScrollLines)
				ucNumLines = (int)SendMessage(hdlMsWheel, uiMsh_MsgScrollLines, 0, 0);
		}
   }
   else if ( (osversion.dwPlatformId == VER_PLATFORM_WIN32_NT) &&
			 (osversion.dwMajorVersion >= 4) )
   {
	  SystemParametersInfo(SPI_GETWHEELSCROLLLINES, 0, &ucNumLines, 0);
   }
   return(ucNumLines);
}

#endif // USE_INTELLI_MOUSE

int GetVersionLevel( void )
{
	/* This function returns the "level" of the version.
	  -1: unknown
	   0: pure Windows 95(OSR2) (+IE3)
	   1: Windows 95/98 + Internet Explorer 4.00
	   2: Windows 95/98 + Internet Explorer 4.01
	   3: Windows 95/98 + Internet Explorer 5.00
	   4: Windows 2000 + Internet Explorer 5.00 later.
		
	   Remark:
		 For new common controls, flat buttons and so on is available
		 in the system which has later version of Internet Explorer.
		 If this fuction returns > 0, we can use such new controls. */
	static int ret = -2;
	HINSTANCE hDll = LoadLibrary( "SHELL32.DLL" );
	if( g_hCCdll == NULL )
	{
		g_hCCdll = LoadLibrary( "COMCTL32.DLL" );
	}
	if( ret != -2 ) return ret;

	if( hDll && g_hCCdll )
	{
		DLLGETVERSIONPROC pDllGetVersion;
		if( g_hCCdll )
		{
			g_FlatSB_SetScrollRange = 
				GetProcAddress( g_hCCdll, "FlatSB_SetScrollRange" );
			g_FlatSB_SetScrollPos	= 
				GetProcAddress( g_hCCdll, "FlatSB_SetScrollPos" );
			g_FlatSB_SetScrollProp	= 
				GetProcAddress( g_hCCdll, "FlatSB_SetScrollProp" );
			g_InitializeFlatSB = 
				GetProcAddress( g_hCCdll, "InitializeFlatSB" );
		}
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress( hDll, "DllGetVersion" );
		if(pDllGetVersion)
		{
			DLLVERSIONINFO	  dllver;
			HRESULT			  hr;
			ZeroMemory(&dllver, sizeof(dllver));
			dllver.cbSize = sizeof(dllver);
			hr = (*pDllGetVersion)(&dllver);
			if(SUCCEEDED(hr))
			{
				f_shellversion = (dllver.dwMajorVersion << 8);
				f_shellversion += dllver.dwMinorVersion;
			}
		}
		FreeLibrary( hDll ); // Free shell32.dll
//		hDll = NULL;
		pDllGetVersion = (DLLGETVERSIONPROC)GetProcAddress( g_hCCdll, "DllGetVersion" );
		if( pDllGetVersion )
		{
			DLLVERSIONINFO	  dllver;
			HRESULT			  hr;
			ZeroMemory(&dllver, sizeof(dllver));
			dllver.cbSize = sizeof(dllver);
			hr = (*pDllGetVersion)(&dllver);
			if(SUCCEEDED(hr))
			{
				f_comctlversion = (dllver.dwMajorVersion << 8);
				f_comctlversion += dllver.dwMinorVersion;
			}
		}

		if( (f_comctlversion & 0xFF00) < 0x400 ) ret = -1;
		if( (f_comctlversion & 0xFF00) == 0x400 )
		{
			if( (f_comctlversion & 0xFF) < 71 ) ret = 0;
			else if( (f_comctlversion & 0xFF) == 71) ret = 1;
			else if( (f_comctlversion & 0xFF) > 71 ) ret = 2;
		}
		if( (f_comctlversion & 0xFF00) > 0x400 ) 
		{
			if( (f_shellversion & 0xFF00) == 0x400 ) ret = 3;
			else ret = 4;
		}
	} // succeeded loading library.
	else // cannot load shell32.dll
		ret = -1;
	if( ret > 0 && (g_FlatSB_SetScrollRange == NULL
					 || g_FlatSB_SetScrollPos	== NULL
					 || g_FlatSB_SetScrollProp	== NULL
					 || g_InitializeFlatSB		== NULL) )
		ret = -1;
	return ret;
}

void SetMargin(HWND hwnd)
{
        //hwnd MUST BE an edit control!.
        int ID;
        HWND hDlg;
//      int margin;
        
        hDlg = GetParent( hwnd );
        ID = GetDlgCtrlID( hwnd );

//      margin = SendDlgItemMessage( hDlg, ID, EM_GETMARGINS, 0, 0);
//      check code. LOWORD(margin) = LEFT, HIWORD(margin) = RIGHT.
//      error( WARNING, "%d, %d", LOWORD(margin), HIWORD(margin) );
        
        SendDlgItemMessage( hDlg, ID, EM_SETMARGINS, EC_LEFTMARGIN | EC_RIGHTMARGIN, 0 );
}

HFONT SetFontJE(HWND hwnd)
{
	return
		SetFont(0, hwnd, IsJapanese()?"lr SVbN":"Courier New", 
			IsJapanese());
}

HFONT ReSetFont(HWND hwnd)
{
	return SetFont(0, hwnd, NULL, FALSE);

}

typedef struct _tagFONTPROP{
	HFONT hfont;
	int count;
	int height;
	char font_name[32]; // the font_name MUST be less than 32 char (with NULL).
	BOOL multi_byte; } FONTPROP;
static FONTPROP* font_prop = NULL;
static int MAX_FONT_NUM = 32;
static int MAX_FONT_PROP_NUM = 16;

static void DeleteFontProp( HFONT hfont )
{
	/* Find the font handle from the list.
	   if find, decrease the counter, and if it becomes zero, delete it.
	   otherwise, nothing to do. */
	
	int i;

	if( font_prop == NULL ) return;
	for( i = 0; i < MAX_FONT_PROP_NUM; i++ )
	{
		if( font_prop[i].hfont == NULL ) continue;
		if( font_prop[i].hfont == hfont )
		{
			font_prop[i].count--;
			if( font_prop[i].count == 0 )
			{
				DeleteObject( font_prop[i].hfont );
				font_prop[i].hfont = NULL;
				font_prop[i].font_name[0] = '\0';
				font_prop[i].height = 0;
				font_prop[i].multi_byte = FALSE;
			}
		}
	}
}

static HFONT GetFontProp( int height, const char* fontname, BOOL twobytes )
{
	/* Find (height, fontname, twobytes) pair from list.
	   if success, return the font handle.
	   otherwise, create new font, add to the list, return it. */

	int i;
	static int number;

	if( font_prop == NULL )
	{
		font_prop = (FONTPROP*)calloc( sizeof(FONTPROP), MAX_FONT_PROP_NUM );
		if( font_prop == NULL ) return NULL;
	}

	for( i = 0; i < number; i++ )
	{
		if( font_prop[i].hfont == NULL ) continue; //could not occur!!!!
		if( lstrcmpi(font_prop[i].font_name,fontname) == 0
			&& font_prop[i].multi_byte == twobytes
			&& font_prop[i].height == height )
		{
			font_prop[i].count++;
			return font_prop[i].hfont;
		}
	}

	/* the fontname couldn't be found in the list.
	   Then, we have to create it. */
	if( ++number == MAX_FONT_PROP_NUM )
	{
		int temp_number = MAX_FONT_PROP_NUM + 16;
		FONTPROP* temp_pointer;
		temp_pointer = (FONTPROP*)realloc( font_prop, temp_number*sizeof(FONTPROP) );
		if( temp_pointer == NULL )
		{
			font_prop = temp_pointer;
			return NULL;
		}
		font_prop = temp_pointer;
		for( i = number - 1; i < temp_number; i++ )
		{
			font_prop[i].count = 0;
			font_prop[i].height = 0;
			font_prop[i].font_name[0] = '\0';
			font_prop[i].hfont = NULL;
			font_prop[i].multi_byte = FALSE;
		}
		MAX_FONT_PROP_NUM = temp_number;
	}
	i = number - 1;

	font_prop[i].hfont = CreateFont( height, 0, 0, 0,
			FW_NORMAL, FALSE, FALSE, FALSE,
			twobytes?SHIFTJIS_CHARSET:ANSI_CHARSET,
			OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
			DEFAULT_PITCH, fontname );
	lstrcpy( font_prop[i].font_name, fontname );
	font_prop[i].height = height;
	font_prop[i].count = 1;
	font_prop[i].multi_byte = twobytes;
	return font_prop[i].hfont;
}

static void FreeFontProp( void )
{
	/* Don't call immediately! */
	if( font_prop == NULL ) return;
	free( font_prop );
	font_prop = NULL;
	MAX_FONT_PROP_NUM = 16;
}

HFONT SetFont( float pt, HWND hwnd, const char* fontname, BOOL twobytes )
{
	/* This function set the font of a window (hwnd)
	   by the specified font.
	   To treat fonts, the most important is to keep the font
	   while the window exist. Never delete it.
	   More, the fonts are system resource, we must create only one.
	   This function keeps a list of hwnd and hfont.
	   If fontname != NULL, first we search hwnd from the list and
	   if we find it, after checking hfont != NULL,
	   we destroy the font object and create new one.
	   If we cannot find it, we create new one.
	   We don't assume there is any created font object for the window.
	   Otherwise, i.e., fontname == NULL, we destroy the font
	   and set hfont NULL.
	   the font structure consists of hwnd and hfont is called WINFONT.
		
	   twobytes: SHIFTJIS_CHARSET if true,
				 ANSI_CHARSET if false.
				 ignored if create == FALSE.
				 set IsJapanese() if you want to ensure the selection. */

	/*******************************************************************
				  R E M A R K
	 The default font for the dialog is specified by resource file.
	 This function cannot change it!
	 Use this function for each controls (button, etc.).
	 Because even if we change the font of the device context of a dialog,
	 it will create its own font specified in the resource,
	 and set it to its DC, and draw items using it.
	*******************************************************************/

	/*******************************************************************
				  I M P O R T A N T
	 Since a font is a system resource, we MUST destroy it if we don't
	 need it more.	This function remember the selected fonts.
	 YOU MUST CALL THIS WITH fontname==NULL to delete the resource.
	 If not, you will use up the system resource,
	 Windows 95/98 (not NT/2000) may be killed!
	 Nonetheless, there are no serious accidents you call this function
	 several times with fontname==NULL.
	 Please call this function until you can feel safe.
	 Generally, call this function with NULL in WM_DESTROY. 1999/11/2
	*******************************************************************/

	typedef struct _tagWINFONT{
		HWND hwnd;
		HFONT hfont; } WINFONT;
	static int number = 0;
	static WINFONT* font_list = NULL;
	int i;
	int j; //  = -1;
	int font_index;
	int dpi = 0;
	HDC hdc;
	
	/* if hwnd == NULL, free all font kept in this function. */
	if( hwnd == NULL )
	{
		if( font_list == NULL ) return NULL;
		for( i = 0; i < number; i++ )
		{
			if( font_list[i].hfont != NULL )
				DeleteFontProp( font_list[i].hfont );
		}
		free( font_list );
		FreeFontProp();
		font_list = NULL;
		number = 0;
		MAX_FONT_NUM = 32;
		return NULL;
	}
	if( font_list == NULL )
	{
		font_list = (WINFONT*)malloc( MAX_FONT_NUM*sizeof(WINFONT) );
		if( font_list == NULL ) return NULL;
	}
	if( pt != 0 ) // CreateFont is called with pt*dpi/72. if pt == 0, there's nothing to do.
	{
		hdc = GetWindowDC( g_winData.hWnd );
		dpi = GetDeviceCaps( hdc, LOGPIXELSY );
		ReleaseDC( g_winData.hWnd, hdc );
	}

	/* Search hwnd */
	font_index = -1;
	for( i = 0; i < number; i++ )
	{
		if( font_list[i].hwnd == hwnd )
		{
			font_index = i;
			if( font_list[i].hfont != NULL )
			{
				DeleteFontProp( font_list[i].hfont );
				font_list[i].hfont = NULL;
			}
			break;
		}
		else continue;
	}
	if( fontname == NULL ) return NULL;
	
	if( font_index != -1 ) /* we have the hwnd in font_list */
	{
		j = font_index;
	}
	else /* there are no entry. */
	{
		if( ++number == MAX_FONT_NUM )
		{
			int temp_number = MAX_FONT_NUM + 32;
			WINFONT* temp_pointer;
			temp_pointer = (WINFONT*)realloc( font_list, temp_number*sizeof(WINFONT) );
			if( temp_pointer == NULL ) return NULL;
			font_list = temp_pointer;
			MAX_FONT_NUM = temp_number;
		}
		j = number - 1;
	}

	font_list[j].hwnd = hwnd;
	font_list[j].hfont = GetFontProp( -(int)(pt*dpi/72), fontname, twobytes );

	if( font_list[j].hfont != NULL ) 
		SendMessage( font_list[j].hwnd, WM_SETFONT, (WPARAM)font_list[j].hfont, 0 );
	else
		MessageBox( hwnd, "CreateFont failed", NULL, MB_OK | MB_ICONERROR );
	return font_list[j].hfont;
}

DWORD GetFontSize( int pt, const char* fontname, BOOL twobytes )
{
	/* This function returns the width(average) and height of the font
	   specified as fontname and size.
	   If the returned value is f(32bits number),
	   (f&0xffff0000)>>16 is the average of the width and
	   (f&0xffff) is the height. */
	
	TEXTMETRIC tm;
	HDC hdc;
	LONG baseunit;
	HFONT hFont, hFontOld;
	int dpi;
	
	hdc = GetWindowDC( g_winData.hWnd );
	dpi = GetDeviceCaps( hdc, LOGPIXELSY );
	/* assume 1in = 72pt */
	hFont = CreateFont( -(int)(pt*dpi/72), 0, 0, 0,
			FW_NORMAL, FALSE, FALSE, FALSE,
			twobytes?SHIFTJIS_CHARSET:ANSI_CHARSET,
			OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY,
			DEFAULT_PITCH, fontname );
	hFontOld = SelectObject( hdc, hFont );
	GetTextMetrics( hdc, &tm );
	baseunit = ( tm.tmAveCharWidth <<16 ) | tm.tmHeight;
	DeleteObject( SelectObject(hdc,hFontOld) );
	ReleaseDC( g_winData.hWnd, hdc );
	return baseunit;
}

void Detain( void )
{
	if( g_hWait == NULL )
		g_hWait = CreateEvent( NULL, TRUE, TRUE, NULL );
	ResetEvent( g_hWait );
}

void Surmount( void )
{
	if( g_hWait == NULL ) return;
	WaitForSingleObject( g_hWait, INFINITE );
}

void Passable( void )
{
	if( g_hWait == NULL )
		g_hWait = CreateEvent( NULL, TRUE, TRUE, NULL );
	SetEvent( g_hWait );
}

void Wait( DWORD mill )
{
	Sleep( mill );
}

void ShowHyperLink( const char* href )
{
	RECT rc;
	int cx;
	int sw[NUMSTATUS];
	int sw1;
//	static BOOL b = TRUE;


	if( g_view.f_StatusBar == FALSE )
		return;

	GetClientRect( g_winData.hMainWnd, &rc );
	cx =rc.right - rc.left;

	sw1 = -1;
	sw[0] = cx*6/23;
	sw[1] = cx*11/23;
	sw[2] = cx*16/23;
	sw[3] = -1;


	if( href != NULL )
	{
		ResizeAllWindows();
		SendMessage( g_winData.hWndStatus, SB_SETPARTS, 1, (LPARAM)(&sw1) );
		SendMessage( g_winData.hWndStatus, SB_SETTEXT, 0, (LPARAM)href );
	}
	else
	{
		SendMessage(g_winData.hWndStatus, SB_SETPARTS, NUMSTATUS, (LPARAM)sw);
		SetStatusWindow();
		ResizeAllWindows();
	}
}

char* DefineDVIFileName( const char* dvi_file )
{
	strcpy( g_szPrevFileName, g_szFileName );
	strcpy( g_szFileName, dvi_file );
	PrevPage = GetCurrentPage();
	return g_szFileName;
}
