/*
*               TeX Device Driver DVIOUT, DVIPRT 
*               ̋ỹAEgCtHgg
*
*                            vraster.c
*
*     "{vÓȀꂽ dvii Ƃ dvi hCo
*      AEgCtHgWJASYƁA\[XR[h̑啔
*      gpĂ܂B̃t@Cł́Advii ̃[`IWi
*      ƕ\Ă܂B"
*
*
*                         1992  by T.Minagawa
*
*/
#include <stdio.h>
#include <stdlib.h>
/* #include <ctype.h> */
#include <string.h>

#ifndef UNIX
#ifdef MSVC
#include "msvcdir.h"
#else
#include <dir.h>
#endif
#ifdef	GCC1
#include <djgppstd.h>
#else
#ifdef MSVC
#include <memory.h>
#else
#include <mem.h>
#endif
#endif
#endif

#include "dd.h"
#include "err.h"
#include "vfont.h"
#include "vraster.h"

/* O[oϐ */
static int *vtran = NULL;
static int *htran = NULL;
static int tlinecount = 0;

/* vdata.c */
extern Line *linebuf;
extern Line *linebuf_end;
extern int linecount;
extern int itemcount;

/* init.c prtinit.c */
extern int tategaki;
extern char ptex_mode;

/* vfont.c */
extern int s_ratio[];
extern V_FONT *vfont[];

/* vg^Cv錾 */
int readdata(VPARA_TBL *, DRAW_MODE);
void setflag(VPARA_TBL *, int);
void getthinwidth(int *, int *);
static void makescale(VPARA_TBL *, VWORK_TBL *);
static void get_vindexbuf(int far *, int count);
static void thin_adj(VPARA_TBL *, VWORK_TBL *);
static void maketran(VPARA_TBL *, VWORK_TBL *, int);

/*static int ysljudge( _Setflag*, _Setflag* );*/
static void xsubnorm(int, VWORK_TBL *);
static void ysubnorm(int, VWORK_TBL *);
static void xsubscale(int, VWORK_TBL *, int, int *);
static void ysubscale(int, VWORK_TBL *, int, int *);
static int searchtran(int *, int, int, int, int);
static int rasterexpand(VPARA_TBL *, VWORK_TBL *);

static void inssort(int, int far *);

/* buffer.c */
char *dup_string(char *);
char *marea(unsigned int);

static int *near_ohlineindex = NULL;
static int far *ohlineindex = NULL;
static int far *chlineindex = NULL;
static int far *iolineindex = NULL;
static int far *iclineindex = NULL;
static int lcount_save = 0;
static int tbl_size = 0;
static int *tlinetblo;
static int xsize_save = 0, ysize_save = 0;

static void nfree(void* buf)
{
	Free0(buf);
}

void free_vraster(void)
{
	nfree((void*)vtran);
	nfree((void*)htran);
	nfree((void*)near_ohlineindex);
	nfree((void*)tlinetblo);
	vtran = htran = near_ohlineindex = tlinetblo = NULL;
	lcount_save = tbl_size = xsize_save = ysize_save = 0;
}

/********************************************************
	inssort
	F "CɂASYT" p
	Ē܂
*********************************************************/
static void inssort(int n, int far *a)
{
	int i, j, x;

	for (i = 1; i < n; i++) {
		x = a[i];
		for (j = i - 1; j >= 0 && a[j] > x; j--)
			a[j + 1] = a[j];
		a[j + 1] = x;
	}
}

/********************************************************
	zs_qdraw
	̃hbg𖄂߂
*********************************************************/
static void zs_qdraw(unsigned int xl, unsigned int xr, BUFFER *rp)
{
	unsigned short i, bl, br, ml, mr;
	static unsigned char ls[] =
	{0xff, 0x7f, 0x3f, 0x1f, 0x0f, 0x07, 0x03, 0x01};
	static unsigned char rs[] =
	{0x80, 0xc0, 0xe0, 0xf0, 0xf8, 0xfc, 0xfe, 0xff};

	if (xl > xr) {
		i = xl;
		xl = xr;
		xr = i;
	}
	bl = xl / 8;
	ml = xl % 8;
	br = xr / 8;
	mr = xr % 8;

	rp += bl;

	if (bl == br) {
		*rp |= ls[ml] & rs[mr];
	}
	else {
		*rp++ |= ls[ml];
		for (i = br - bl - 1; i > 0; i--) {
			*rp++ |= 0xff;
		}
		*rp |= rs[mr];
	}
}

/********************************************************
	zs_vqdraw
	̃hbg𖄂߂
*********************************************************/
static void zs_vqdraw(int yu, int yl, BUFFER *rp, int x, int b_width)
{
	int y;

	if (yu > yl) {
		y = yu;
		yu = yl;
		yl = y;
	}

	rp += yu * b_width;

	for (y = yl - yu; y >= 0; y--) {
		zs_qdraw(x, x, rp);
		rp += b_width;
	}
}

/****************************************************
*	xsubnorm
*	jAɃXP[O
*	(XP[OȂƓ)
*****************************************************/
static void xsubnorm(int vf_size, VWORK_TBL *tbl2)
{
	int i, dotsize, offset;

	offset = (tbl2->xdotwidth) / 2;
	dotsize = tbl2->_xdot;

	for (i = 0; i < dotsize; i++) {
		htran[i] = (int)((long)i * vf_size / dotsize) + offset;
	}
}

/****************************************************
*	ysubnorm
*	jAɃXP[O
*	(XP[OȂƓ)
*****************************************************/
static void ysubnorm(int vf_size, VWORK_TBL *tbl2)
{
	int i, dotsize, offset;

	offset = (tbl2->ydotwidth) / 2;
	dotsize = tbl2->_ydot;

	for (i = 0; i < dotsize; i++) {
		vtran[i] = (int)((long)i * vf_size / dotsize) + offset;
	}
}

/****************************************************
*	xsubsclae
*	XP[O
*****************************************************/
static void xsubscale
    (int vf_size, VWORK_TBL *tbl2, int mdot, int *tlinetbl) {
	int i, j, k, dotsize, offset;

	offset = tbl2->xdotwidth / 2 - tbl2->xthin;
	dotsize = tbl2->_xdot;

	for (i = 0; i < dotsize; i++) {
		htran[i] = (int)((long)i * vf_size / mdot) + offset;
	}

	for (i = 0; i < tlinecount; i++) {
		for (j = 0; j < dotsize; j++) {
			if (tlinetbl[i] <= htran[j]) {
				if (j > 0) {
					if (htran[j] - tlinetbl[i]
						>= tlinetbl[i] - htran[j - 1]) {
						offset = tlinetbl[i] - htran[j - 1];
						for (k = j - 1; k < dotsize; k++) {
							htran[k] += offset;
						}
					}
					else {
						offset = htran[j] - tlinetbl[i];
						for (k = j; k < dotsize; k++) {
							htran[k] -= offset;
						}
					}
				}
				break;
			}
		}
	}

	for (i = 0; i < dotsize; i++) {
		htran[i] += tbl2->xthin;
	}
}

/****************************************************
*	ysubsclae
*	XP[O
*****************************************************/
static void ysubscale
    (int vf_size, VWORK_TBL *tbl2, int mdot, int *tlinetbl) {
	int i, j, k, dotsize, offset;

	offset = tbl2->ydotwidth / 2 - tbl2->ythin;
	dotsize = tbl2->_ydot;
	for (i = 0; i < dotsize; i++) {
		vtran[i] = (int)((long)i * vf_size / mdot) + offset;
	}

	for (i = 0; i < tlinecount; i++) {
		for (j = 0; j < dotsize; j++) {
			if (tlinetbl[i] <= vtran[j]) {
				if (j > 0) {
					if (vtran[j] - tlinetbl[i]
						>= tlinetbl[i] - vtran[j - 1]) {
						offset = tlinetbl[i] - vtran[j - 1];
						for (k = j - 1; k < dotsize; k++) {
							vtran[k] += offset;
						}
					}
					else {
						offset = vtran[j] - tlinetbl[i];
						for (k = j; k < dotsize; k++) {
							vtran[k] -= offset;
						}
					}
				}
				break;
			}
		}
	}

	for (i = 0; i < dotsize; i++) {
		vtran[i] += tbl2->ythin;
	}
}

/*********************************************************
*	makescale
*	scaling ̂߂ tran[](translate table) 쐬
*********************************************************/
static void makescale(VPARA_TBL *tbl1, VWORK_TBL *tbl2)
{
	int i, width, _xdot, _ydot;
	int left, right, _xoffset = 0;
	Line *c_line;

	width = _xdot = tbl1->width;
	_ydot = tbl1->height;
	left = tbl1->max_width + 1;
	right = 0x00;

	for (c_line = linebuf; c_line < linebuf_end; c_line++) {
		if (left > c_line->xl) {
			left = c_line->xl;
		}
		if (right < c_line->xr) {
			right = c_line->xr;
		}
	}

	if (left < right) {
		while (mxrscaling(right) - mxlscaling(left) > width) {
			_xdot--;
		}
#ifdef XOFFSET
		_xoffset = (width - (mxrscaling(right) - mxlscaling(left))) / 2
			- mxlscaling(left);
#endif
	}

	if (_ydot <= 0 || _xdot <= 0) {
		return;
	}

	if (_ydot > ysize_save) {
		if (ysize_save)
			Free(vtran);
		vtran = (int *)marea(sizeof(int) * _ydot);
		ysize_save = _ydot;
	}
	if (_xdot > xsize_save) {
		if (xsize_save)
			Free(htran);
		htran = (int *)marea(sizeof(int) * width);
		xsize_save = _xdot;
	}

	for (i = _xdot; i < width; i++) {
		htran[i] = tbl1->max_width + 1;
	}

	tbl2->_xdot = _xdot;
	tbl2->_ydot = _ydot;
	tbl2->_xoffset = _xoffset;
}

/*********************************************************
*	thin_adj
*	xthin, ythin 𒲐
*********************************************************/
static void thin_adj(VPARA_TBL *tbl1, VWORK_TBL *tbl2)
{
	int xt, yt, xthin, ythin, xdotwidth, ydotwidth;

	xdotwidth = tbl1->max_width / tbl2->_xdot;
	ydotwidth = tbl1->max_height / tbl2->_ydot;
	xt = tbl2->xthin;
	yt = tbl2->ythin;

	if (xt < xdotwidth) {
		xthin = xt / 2;
	}
	else if (xt % xdotwidth > xdotwidth / 2) {	/* ؂グ	*/
		xthin = (xt % xdotwidth + 1) / 2;
	}
	else {
		xthin = (xt - (xt / xdotwidth - 1) * xdotwidth + 1) / 2;
		if (xthin >= xdotwidth / 2) {
			xthin = xdotwidth / 2 - 1;
		}
	}

	if (yt < ydotwidth) {
		ythin = yt / 2;
	}
	else if (yt % ydotwidth > ydotwidth / 2) {	/* ؂グ	*/
		ythin = (yt % ydotwidth + 1) / 2;
	}
	else {
		ythin = (yt - (yt / ydotwidth - 1) * ydotwidth + 1) / 2;
		if (ythin >= ydotwidth / 2) {
			ythin = ydotwidth / 2 - 1;
		}
	}
	tbl2->xthin = xthin;
	tbl2->ythin = ythin;
	tbl2->xdotwidth = xdotwidth;
	tbl2->ydotwidth = ydotwidth;
}

/*********************************************************
*	maketran
*	translate table 쐬
*********************************************************/
static void maketran(VPARA_TBL *tbl1, VWORK_TBL *tbl2, int itemno)
{
	int i, j, flag, vf_size, dotwidth;
	int lv, mv, bv, sv, ms, bs, ss, half;
	Line *c_line;

	if (linecount > tbl_size) {
		Free0(tlinetblo);
		tlinetblo = (int *)marea(sizeof(int) * linecount);
		tbl_size = linecount;
	}

	/*	̃XP[O	*/

	tlinecount = 0;
	vf_size = tbl1->max_width + 1;
	dotwidth = tbl2->xdotwidth;
	for (c_line = linebuf; c_line < linebuf_end; c_line++) {
		if (c_line->itemno != itemno) {
			continue;
		}

		flag = c_line->flag;
		if ((flag & VERTLINE) && (flag & HOPEN)
			&& (c_line->dy > YTHICKLINEWIDTHDOUBLE)) {
			tlinetblo[tlinecount++] = c_line->xl;
		}
	}
	if (tlinecount == 0) {
		xsubnorm(vf_size, tbl2);
		goto skip1;
	}

	inssort(tlinecount, tlinetblo);
	half = dotwidth / 2;
	mv = tbl2->_xdot;
	bv = sv = -1;
	while (bv < 0 || sv < 0) {
		lv = mv;
		if (mv <= 0) {
			xsubnorm(vf_size, tbl2);
			goto skip1;
		}

		xsubscale(vf_size, tbl2, mv, tlinetblo);
		ms = htran[tbl2->_xdot - 1];

		if (ms == vf_size - half) {
			bv = sv = mv;
			bs = ss = ms;
		}
		else if (ms > vf_size - half) {
			bv = mv;
			bs = ms;
			mv++;
		}
		else {
			sv = mv;
			ss = ms;
			mv--;
		}
	}
#if	TAKENEAR
	if (3 * (bs - (vf_size - half)) >= 2 * ((vf_size - half) - ss)) {
		/*	if(bs - (vf_size - half) >= (vf_size - half) - ss){	*/
		if ((vf_size - half) - ss > (tbl1->max_width + 1) / tbl2->_xdot / 2) {
			xsubnorm(vf_size, tbl2);
			goto skip1;
		}
		mv = sv;

		if (mv != lv) {
			xsubscale(vf_size, tbl2, mv, tlinetblo);
		}

		j = ((vf_size - half) - ss) / dotwidth / 2;
		if (j > 0) {
			for (i = 0; i < tbl2->_xdot - j; i++) {
				htran[i] = htran[i + j];
			}
			for (; i < tbl2->_xdot; i++) {
				htran[i] = htran[i - 1] + dotwidth;
			}
		}
	}
	else {
		if (bs - (vf_size - half) > (tbl1->max_width + 1) / tbl2->_xdot / 2) {
			xsubnorm(vf_size, tbl2);
			goto skip1;
		}
		mv = bv;

		if (mv != lv) {
			xsubscale(vf_size, tbl2, mv, tlinetblo);
		}
	}

#else
	if ((vf_size - half) - ss > (tbl1->max_width + 1) / tbl2->_xdot / 2) {
		xsubnorm(vf_size, tbl2);
		goto skip1;
	}

	if (sv != lv) {
		xsubscale(vf_size, tbl2, sv, tlinetblo);
	}

	j = ((vf_size - half) - ss) / dotwidth / 2;
	if (j > 0) {
		for (i = 0; i < tbl2->_xdot - j; i++) {
			htran[i] = htran[i + j];
		}
		for (; i < tbl2->_xdot; i++) {
			htran[i] = htran[i - 1] + dotwidth;
		}
	}
#endif
  skip1:

	/*	̃XP[O	*/

	tlinecount = 0;
	vf_size = tbl1->max_height + 1;
	dotwidth = tbl2->ydotwidth;
	for (c_line = linebuf; c_line < linebuf_end; c_line++) {
		if (c_line->itemno != itemno) {
			continue;
		}

		flag = c_line->flag;
		if ((flag & HORILINE) && (flag & VOPEN)
			&& (c_line->dx > XTHICKLINEWIDTHDOUBLE)) {
			tlinetblo[tlinecount++] = c_line->yu;
		}
	}
	if (tlinecount == 0) {
		ysubnorm(vf_size, tbl2);
		goto skip2;
	}

	inssort(tlinecount, tlinetblo);
	half = dotwidth / 2;
	mv = tbl2->_ydot;
	bv = sv = -1;
	while (bv < 0 || sv < 0) {
		lv = mv;
		if (mv <= 0) {
			ysubnorm(vf_size, tbl2);
			goto skip2;
		}

		ysubscale(vf_size, tbl2, mv, tlinetblo);
		ms = vtran[tbl2->_ydot - 1];

		if (ms == vf_size - half) {
			bv = sv = mv;
			bs = ss = ms;
		}
		else if (ms > vf_size - half) {
			bv = mv;
			bs = ms;
			mv++;
		}
		else {
			sv = mv;
			ss = ms;
			mv--;
		}
	}
#if	TAKENEAR
	if (3 * (bs - (vf_size - half)) >= 2 * ((vf_size - half) - ss)) {
		/*	if(bs - (vf_size - half) >= (vf_size - half) - ss){	*/
		if ((vf_size - half) - ss > (tbl1->max_height + 1) / tbl2->_ydot / 2) {
			ysubnorm(vf_size, tbl2);
			goto skip2;
		}
		mv = sv;

		if (mv != lv) {
			ysubscale(vf_size, tbl2, mv, tlinetblo);
		}

		j = ((vf_size - half) - ss) / dotwidth / 2;
		if (j > 0) {
			for (i = 0; i < tbl2->_ydot - j; i++) {
				vtran[i] = vtran[i + j];
			}
			for (; i < tbl2->_ydot; i++) {
				vtran[i] = vtran[i - 1] + dotwidth;
			}
		}
	}
	else {
		if (bs - (vf_size - half) > (tbl1->max_height + 1) / tbl2->_ydot / 2) {
			ysubnorm(vf_size, tbl2);
			goto skip2;
		}
		mv = bv;

		if (mv != lv) {
			ysubscale(vf_size, tbl2, mv, tlinetblo);
		}
	}

#else
	if ((vf_size - half) - ss > (tbl1->max_height + 1) / tbl2->_ydot / 2) {
		ysubnorm(vf_size, tbl2);
		goto skip2;
	}

	if (sv != lv) {
		ysubscale(vf_size, tbl2, sv, tlinetblo);
	}

	j = ((vf_size - half) - ss) / dotwidth / 2;
	if (j > 0) {
		for (i = 0; i < tbl2->_ydot - j; i++) {
			vtran[i] = vtran[i + j];
		}
		for (; i < tbl2->_ydot; i++) {
			vtran[i] = vtran[i - 1] + dotwidth;
		}
	}
#endif
  skip2:;
}

/********************************************************
*	searchtran
*	tran[](translate table) ƂɁAxNgtHg
*	Wnrbg}bvWnɕϊ
*********************************************************/
static int searchtran(int *tran, int nelem, int val, int flag, int vf_size)
{
	int lp, rp, mp;

	lp = 0;
	rp = nelem - 1;

	if (val >= tran[rp]) {
		return (rp);
	}
	else if (val <= tran[lp]) {
		return (lp);
	}

	mp = (int)((long)nelem * val / vf_size);

	if (mp >= nelem)
		mp = nelem - 1;
	if (tran[mp] > val) {
		while (tran[--mp] > val);
		if (tran[mp] == val)
			rp = lp = mp;
		else {
			lp = mp;
			rp = mp + 1;
		}
	}
	else if (tran[mp] < val) {
		while (tran[++mp] < val);
		if (tran[mp] == val)
			rp = lp = mp;
		else {
			rp = mp;
			lp = mp - 1;
		}
	}
	else {
		rp = lp = mp;
	}

	switch (flag) {
	  case LEFT:
		  return (lp);
	  case RIGHT:
		  return (rp);
	  default:
		  return ((tran[rp] - val >= val - tran[lp]) ? lp : rp);
	}
}


static void get_vindexbuf(int far *buf_top, int count)
{
	ohlineindex  = buf_top;
	chlineindex  = ohlineindex + count;
	iolineindex  = chlineindex + count;
	iclineindex  = iolineindex + count;
	lcount_save  = count;
}


/********************************************************
*	rasterexpand
*	ۂɃrbg}bvɓWJ
*********************************************************/
static int rasterexpand(VPARA_TBL *tbl1, VWORK_TBL *tbl2)
{
	int i, j, x, y, vx, vy, b_width;
	int xl, xr, yu, yl, it, tm;
	int width, height, _xoffset, _xdot, _ydot;
	BUFFER *rp;
	Line *c_line;

	int ohlinecount, chlinecount;
	int iolinecount, iclinecount, iomin, iomax, icmin, icmax;

	width = tbl1->width;
	height = tbl1->height;
	_xoffset = tbl2->_xoffset;
	_xdot = tbl2->_xdot;
	_ydot = tbl2->_ydot;

	if (linecount > lcount_save) {
		if (lcount_save)
			nfree(near_ohlineindex);
		near_ohlineindex = (int *)marea(sizeof(int) * 4 * linecount);
		get_vindexbuf((int far *)near_ohlineindex, linecount);
	}
	b_width = (width + 7) / 8;

	for (it = 0; it < itemcount; it++) {
		maketran(tbl1, tbl2, it);

#if SQFLAG & 0x03
		rp = tbl1->buffer;
		iolinecount = iclinecount = 0;
		linebuf_end = linebuf;

		iomax = icmax = -1;
		iomin = icmin = tbl1->max_width + 2;

		for (i = 0, c_line = linebuf; i < linecount; i++, c_line++) {
			if (c_line->itemno == it) {
				if (c_line->flag & HOPEN) {
					iolineindex[iolinecount++] = i;
					if (c_line->yl > iomax)
						iomax = c_line->yl;
					if (c_line->yu < iomin)
						iomin = c_line->yu;
				}
				if (c_line->flag & HCLOSE) {
					iclineindex[iclinecount++] = i;
					if (c_line->yl > icmax)
						icmax = c_line->yl;
					if (c_line->yu < icmin)
						icmin = c_line->yu;
				}
			}
		}

		for (y = 0; y < height; y++) {
			ohlinecount = chlinecount = 0;
			vy = vtran[y];

			if (iomin <= vy && vy <= iomax) {
				for (j = 0; j < iolinecount; j++) {
					c_line = linebuf + (i = iolineindex[j]);
					/*  vy ̓_ړ_ɂȂĂƁAvy  */
					/* _ 2dɕ]Ă܂B]āA      */
					/* HOPEN  Line ɂẮAI_ yl  */
					/* (y2)D悳B̂߂ɁAYREV ̒l */
					/* āAyu, yl ǂ炪 y2 ɑ */
					/* fĂAdȂȂ悤 1  */
					/* B                                    */
					yu = c_line->yu;
					yl = c_line->yl;
					if (c_line->flag & YREV) {
						yl--;
					}
					else {
						yu++;
					}
					if (yu <= vy && vy <= yl) {
						/* hbg}gbNXɓWJ鎞ɂǂ */
						/* x̂ŁAł double Ŋ */
						/* KvȂ                         */
						if (c_line->flag & XYREV)
							ohlineindex[ohlinecount++]
								= (int)(c_line->xl
										+ (long)(c_line->yl - vy)
										* c_line->dx / c_line->dy);
						else
							ohlineindex[ohlinecount++]
								= (int)(c_line->xl
										+ (long)(vy - c_line->yu)
										* c_line->dx / c_line->dy);
					}
				}
			}

			if (icmin <= vy && vy <= icmax) {
				for (j = 0; j < iclinecount; j++) {
					c_line = linebuf + (i = iclineindex[j]);
					/* HCLOSE  Line ɂẮAn_ yl */
					/* (y1)D悳B̂߂ɁAYREV ̒l */
					/* āAyu, yl ǂ炪 y1 ɑ */
					/* fĂAdȂȂ悤 1  */
					/* B                                    */
					yu = c_line->yu;
					yl = c_line->yl;
					if (c_line->flag & YREV) {
						yu++;
					}
					else {
						yl--;
					}
					if (yu <= vy && vy <= yl) {
						/* lɂł double ŊǗȂ */
						if (c_line->flag & XYREV)
							chlineindex[chlinecount++]
								= (int)(c_line->xl
										+ (long)(c_line->yl - vy)
										* c_line->dx / c_line->dy);
						else
							chlineindex[chlinecount++]
								= (int)(c_line->xl
										+ (long)(vy - c_line->yu)
										* c_line->dx / c_line->dy);
					}
				}
			}

			if (ohlinecount != chlinecount) {
				error(WARNING,
						"[vfont] h-data error.(%#x) %s",
						tbl1->char_code, vfont[i]->v_font_name);
				return (FAILURE);
			}

			if (ohlinecount != 0 && chlinecount != 0) {
				inssort(ohlinecount, ohlineindex);
				inssort(chlinecount, chlineindex);
			}

			for (i = 0; i < ohlinecount; i++) {
				xl = searchtran(htran, _xdot, ohlineindex[i], RIGHT,
								tbl1->width);
				xr = searchtran(htran, _xdot, chlineindex[i], LEFT,
								tbl1->width);

#if SQFLAG & 0x01
				if (xl <= xr) {
					tm = _xoffset + xr + tbl1->xfat;
					if (tm >= _xdot) {
						tm = _xdot - 1;
					}
					xl += _xoffset;
					if (xl >= _xdot) {
						xl = _xdot - 1;
					}
					zs_qdraw(xl, tm, rp);
					/*					zs_qdraw( _xoffset + xl, tm, rp );*/
				}
#endif
#if SQFLAG & 0x02
				if (xl > xr) {
					xl = searchtran(htran, _xdot, (chlineindex[i]
							  + ohlineindex[i] + 1) / 2, NEAR, tbl1->width);
					tm = _xoffset + xl + tbl1->xfat;
					if (tm >= _xdot) {
						tm = _xdot - 1;
					}
					xl += _xoffset;
					if (xl >= _xdot) {
						xl = _xdot - 1;
					}
					zs_qdraw(xl, tm, rp);
					/*					zs_qdraw( _xoffset + xl, tm, rp );*/
				}
#endif
			}
			rp += b_width;
		}
#endif

#if SQFLAG & 0x0c
		rp = tbl1->buffer;

		iolinecount = iclinecount = 0;

		iomax = icmax = -1;
		iomin = icmin = tbl1->max_width + 2;

		for (i = 0, c_line = linebuf; i < linecount; i++, c_line++) {
			if (c_line->itemno == it) {
				if (c_line->flag & VOPEN) {
					iolineindex[iolinecount++] = i;
					if (c_line->xr > iomax) {
						iomax = c_line->xr;
					}
					if (c_line->xl < iomin) {
						iomin = c_line->xl;
					}
				}
				if (c_line->flag & VCLOSE) {
					iclineindex[iclinecount++] = i;

					if (c_line->xr > icmax) {
						icmax = c_line->xr;
					}
					if (c_line->xl < icmin) {
						icmin = c_line->xl;
					}
				}
			}
		}

		for (x = 0; x < width; x++) {
			ohlinecount = chlinecount = 0;
			vx = htran[x];

			if (iomin <= vx && vx <= iomax) {
				for (j = 0; j < iolinecount; j++) {
					c_line = linebuf + iolineindex[j];
					/* VOPEN  Line ɂẮAn_ xl  */
					/* (x1)D悳B̂߂ɁAXREV ̒l */
					/* āAxl, xr ǂ炪 x1 ɑ */
					/* fĂAdȂȂ悤 1  */
					/* B                                    */
					xl = c_line->xl;
					xr = c_line->xr;
					if (c_line->flag & XREV) {
						xl++;
					}
					else {
						xr--;
					}
					if (xl <= vx && vx <= xr) {
						if (c_line->flag & XYREV)
							ohlineindex[ohlinecount++]
								= (int)(c_line->yu
										+ (long)(c_line->xr - vx)
										* c_line->dy / c_line->dx);
						else
							ohlineindex[ohlinecount++]
								= (int)(c_line->yu
										+ (long)(vx - c_line->xl)
										* c_line->dy / c_line->dx);
					}
				}
			}

			if (icmin <= vx && vx <= icmax) {
				for (j = 0; j < iclinecount; j++) {
					c_line = linebuf + iclineindex[j];
					/* VCLOSE  Line ɂẮAI_ xl */
					/* (x2)D悳B̂߂ɁAXREV ̒l */
					/* āAxl, xr ǂ炪 x2 ɑ */
					/* fĂAdȂȂ悤 1  */
					/* B                                    */
					xl = c_line->xl;
					xr = c_line->xr;
					if (c_line->flag & XREV) {
						xr--;
					}
					else {
						xl++;
					}
					if (xl <= vx && vx <= xr) {
						if (c_line->flag & XYREV)
							chlineindex[chlinecount++]
								= (int)(c_line->yu
										+ (long)(c_line->xr - vx)
										* c_line->dy / c_line->dx);
						else
							chlineindex[chlinecount++]
								= (int)(c_line->yu
										+ (long)(vx - c_line->xl)
										* c_line->dy / c_line->dx);
					}
				}
			}

			if (ohlinecount != chlinecount) {
				error(WARNING, 
						"[vfont] v-data error.(%#x) %s",
						tbl1->char_code, vfont[i]->v_font_name);
				return (FAILURE);
			}

			if (ohlinecount != 0 && chlinecount != 0) {
				inssort(ohlinecount, ohlineindex);
				inssort(chlinecount, chlineindex);
			}

			for (i = 0; i < ohlinecount; i++) {
				yu = searchtran(vtran, _ydot, ohlineindex[i], RIGHT,
								tbl1->height);
				yl = searchtran(vtran, _ydot, chlineindex[i], LEFT,
								tbl1->height);

#if SQFLAG & 0x04
				if (yu <= yl) {
					tm = yl + tbl1->yfat;
					if (tm >= _ydot) {
						tm = _ydot - 1;
					}
					zs_vqdraw(yu, tm, rp, _xoffset + x, b_width);
				}
#endif
#if SQFLAG & 0x08
				if (yu > yl) {
					yu = searchtran(vtran, _ydot, (ohlineindex[i]
							 + chlineindex[i] + 1) / 2, NEAR, tbl1->height);
					tm = yu + tbl1->yfat;
					if (tm >= _ydot) {
						tm = _ydot - 1;
					}
					zs_vqdraw(yu, tm, rp, _xoffset + x, b_width);
				}
#endif
			}
		}
#endif
	}
	return (TRUE);
}

/********************************************************
*	MakeOutLine
*	oオX^[𔒔ɂ	92.11.10 y
*********************************************************/

static void MakeOutLine(VPARA_TBL *tbl_ptr, uchar *Pattern, int PatHeight, int PatByteWidth)
{
	BUFFER *Tmp1;
	BUFFER *Tmp2;
	BUFFER *Tmp3;
	BUFFER *Tmp;
	BUFFER *OutBuf;
	BUFFER *PatPtr;
	unsigned char Mask1, Mask2, Mask3;
	int ByteWidth, v, h, BytePos1, BytePos2, BytePos3, PatBytePos, PatH;

	ByteWidth = (tbl_ptr->width + 7) / 8;

	if (ByteWidth + ByteWidth + ByteWidth > COMMON_SIZE)
		return;

	Tmp1 = (BUFFER *)((HUGE_BUF *)common_work);	/*̃LXg͖ӖH*/
	Tmp2 = Tmp1 + ByteWidth;
	Tmp3 = Tmp2 + ByteWidth;
	OutBuf = tbl_ptr->buffer;
	memcpy(Tmp1, OutBuf, ByteWidth);
	OutBuf += ByteWidth;
	memcpy(Tmp2, OutBuf, ByteWidth);

	PatH = 0;
	PatPtr = Pattern;

	for (v = tbl_ptr->height - 2; v > 0; v--) {
		memcpy(Tmp3, OutBuf + ByteWidth, ByteWidth);
		Mask1 = 128;
		Mask2 = 64;
		Mask3 = 32;
		BytePos1 = BytePos2 = BytePos3 = PatBytePos = 0;
		for (h = tbl_ptr->width - 2; h > 0; h--) {
			if (Tmp2[BytePos2] & Mask2) {
				if (((Tmp1[BytePos2] & Mask2)
					 && (Tmp2[BytePos1] & Mask1)
					 && (Tmp2[BytePos3] & Mask3)
					 && (Tmp3[BytePos2] & Mask2))) {
					OutBuf[BytePos2] ^= (Mask2 & (PatPtr[PatBytePos] ^ 0xff));
				}
			}
			if ((Mask1 >>= 1) == 0) {
				Mask1 = 128;
				BytePos1++;
			}
			if ((Mask2 >>= 1) == 0) {
				Mask2 = 128;
				BytePos2++;
				if (++PatBytePos >= PatByteWidth)
					PatBytePos = 0;
			}
			if ((Mask3 >>= 1) == 0) {
				Mask3 = 128;
				BytePos3++;
			}
		}
		Tmp = Tmp1;
		Tmp1 = Tmp2;
		Tmp2 = Tmp3;
		Tmp3 = Tmp;
		OutBuf += ByteWidth;
		if (++PatH < PatHeight)
			PatPtr += PatByteWidth;
		else {
			PatH = 0;
			PatPtr = Pattern;
		}
	}
	return;
}

static void MakeFill(VPARA_TBL *tbl_ptr, uchar *Pattern, int PatHeight, int PatByteWidth)
{
	BUFFER *OutBuf;
	BUFFER *PatPtr;
	unsigned char Mask;
	int ByteWidth, v, h, BytePos, PatBytePos, PatH;

	ByteWidth = (tbl_ptr->width + 7) / 8;

	OutBuf = tbl_ptr->buffer;

	PatH = 0;
	PatPtr = Pattern;

	for (v = tbl_ptr->height; v > 0; v--) {
		Mask = 128;
		BytePos = PatBytePos = 0;
		for (h = tbl_ptr->width; h > 0; h--) {
			if (OutBuf[BytePos] & Mask) {
				OutBuf[BytePos] ^= (Mask & (PatPtr[PatBytePos] ^ 0xff));
			}
			if ((Mask >>= 1) == 0) {
				Mask = 128;
				BytePos++;
			}
		}
		OutBuf += ByteWidth;
		if (++PatH < PatHeight)
			PatPtr += PatByteWidth;
		else {
			PatH = 0;
			PatPtr = Pattern;
		}
	}
	return;
}

static uchar *GrayPattern[10] =
{
	(uchar *) "\x00\x00\x00\x00",
	(uchar *) "\x00\x22\x00\x00",
	(uchar *) "\x00\x22\x00\x88",
	(uchar *) "\x00\x22\x44\x00",
	(uchar *) "\x00\x66\x44\x00",
	(uchar *) "\x00\xaa\x00\x88",
	(uchar *) "\x00\x66\x66\x00",
	(uchar *) "\x00\xaa\x00\xaa",
	(uchar *) "\x11\xaa\x44\xaa",
	(uchar *) "\xee\x55\xbb\x55"
};

/********************************************************
*	draw_fine
*	׃[hœWJ( dvii ̃[` )
*********************************************************/
int draw_fine(VPARA_TBL *tbl_ptr)
{
	int h, itemflag, vcorrection;
	int xthin, ythin, stat;
	VWORK_TBL w_table;
	Line *c_line;

	linecount = itemcount = 0;
	linebuf_end = linebuf;

	if (readdata(tbl_ptr, FINE_MODE) == FAILURE)
		return (FAILURE);

	if (tbl_ptr->rotation == 0 
	    /* && !tategaki && !ptex_mode */ ) {
		/* ]Ƃ͏ʓ|Ȃ̂ y offset ̒͏ȗ ? */
		vcorrection = tbl_ptr->yoffset;
		for (h = 0, c_line = linebuf; c_line < linebuf_end; c_line++) {
			c_line->yu += vcorrection;
			c_line->yl += vcorrection;
			h = max(h, c_line->yl - (tbl_ptr->max_height + 1));
		}
		if (h > 0) {
			for (c_line = linebuf; c_line < linebuf_end; c_line++) {
				c_line->yu -= h;
				c_line->yl -= h;
			}
		}
	}

	/* ACeɕď邩ǂ */
	if (20 < tbl_ptr->width && tbl_ptr->width < 128 &&
		20 < tbl_ptr->height && tbl_ptr->height < 128)
		itemflag = 1;
	else
		itemflag = 0;

	setflag(tbl_ptr, itemflag);
	getthinwidth(&xthin, &ythin);
	w_table.xthin = xthin;
	w_table.ythin = ythin;
	makescale(tbl_ptr, &w_table);
	thin_adj(tbl_ptr, &w_table);

	stat = rasterexpand(tbl_ptr, &w_table);
	if (tbl_ptr->dtype == VTRACE)
		MakeOutLine(tbl_ptr, (uchar *)"\0", 1, 1);
	else if (tbl_ptr->thin < 100 && tbl_ptr->thin >= 0) {
		if (tbl_ptr->dtype == BOTH)
			MakeOutLine(tbl_ptr, GrayPattern[tbl_ptr->thin / 10], 4, 1);
		else
			MakeFill(tbl_ptr, GrayPattern[tbl_ptr->thin / 10], 4, 1);
	}
	return stat;
}

/* end of all */
