/*
 *  TEX Device Driver  ver 2.00-2.05
 *  copyright(c) 1988, 1989 by TSG, 1990 by SHIMA
 *
 *  err.h : ERROR MODULE HEADER
 *				May 1992 Slightly modified by Oh-Yeah?
 *				for tracing function calls ... (define TRACE)
 *
 */

#define EXEC_LVL  0	/* execution level */
#define TRACE_LVL 1	/* tracer level */
#define MEM_CHK   4	/* checking memory access */

#ifdef TRACE
#define DEBUG       (TRACE_LVL|MEM_CHK)
#else
#define DEBUG       EXEC_LVL
#endif
 /*  'DEBUG' has debugging-level. If TRACE_LVL is set, function-tracer
     * works. ( Because I have no debugging-tools, hum... ) And if MEM_CHK is
     * set, device-driver will check the faul access of buffers.
     */

#if DEBUG & TRACE_LVL

#ifndef _DEF_SIGNAL_H_
#include <signal.h>
#define _DEF_SIGNAL_H_
#endif
#ifdef TURBOC
 /*   Why Turbo-C has no honest signal-calls ?
         */
#ifndef _DEF_DOS_H_
#include <dos.h>
#define _DEF_DOS_H_
#endif
#define ctrl_break(f) ctrlbrk(f)
#else
 /* compatible with UNIX.
         */
#define ctrl_break(f) signal(SIGINT,f)
#endif

typedef struct MODULE_LIST {
	char *name;
	struct MODULE_LIST *prio;
} MODULE;

 /*  MODULE holds the name of the function and builts linked-list.
         */
extern MODULE *last_module;

 /*  the module working "now."
         */
void module_list_out(void);

#define START(f)  {ctrl_break(f);;}
 /*  set user-break by CTRL-C
         */
/*    #define EXIT(n)   {ctrl_break(SIG_DFL); exit(n);;} */
#define EXIT(n)   {raise(SIGTERM); exit(n)}
#define ENTER(s)  {MODULE crr; crr.name = s; crr.prio = last_module; last_module = &crr; module_list_out() /*last_module = &crr */ }
 /*  built module-list */
#define END()     {last_module = last_module->prio; return}
 /*  unlink the function from module-list. */
#define RETURN(s) {last_module = last_module->prio; return(s)}

#else
#define START(f)
#define EXIT(n)   exit(n)
#define ENTER(s)
#define END()     return
#define RETURN(s) return(s)
 /*  They do no paticular jobs. */
#endif

/* USER ERROR NUMBERS */

typedef enum {
	NO_FILE,
	NO_MEMORY,
	MEMORY_FAULT,
	FILE_FAULT,
	ILLEGAL_ARGS,
	BAD_SYSTEM,
	NO_FONT,
	FONT_MISMATCH,
	COMMAND_ERROR,
	UNPACK_ERROR,
	PROGRAM_STOP,
	C_MSG,
	DIRECT,
	WARNING,
	ASK,
	ASKYES,
	ERRPAUSE,
	DATATITLE,
	DATALOG,
	WRITELOG
} ERROR_NUM;

#define	DEVICE_FAULT	PROGRAM_STOP

int error(ERROR_NUM, char *,...);
extern int errno;

extern unsigned int f_error;

#define	FE_DVI 		1
#define	FE_NOFONT 	2
#define	FE_NOMSG	3

#define	FFE_QUIT	0x80000000
#define	FFE_DVI		0x40000000

/* end of file : err.h */
