#include <stdio.h>
#include <win32dll/texdll.h>
#include <win32dll/win32lib.h>
#include <win32dll/maketexlib.h>

#define MAKETEX_DLL "MakeTeX.dll"

#ifndef MAKETEX_NAME
#define MAKETEX_NAME "MakeTeXTFM"
#endif
#ifndef MAKETEX_PROC
#define MAKETEX_PROC MakeTeXTFMProc
#endif
#ifndef MAKETEX_PROC_NAME
#define MAKETEX_PROC_NAME "MakeTeXTFMMain"
#endif

int main(int argc, char **argv)
{
  BOOL code = 1;
  LPCTSTR name;
  char filename[MAX_PATH + 1];
  HINSTANCE hMakeTeX;

  if (argc != 2) {
    fputs("Usage: " MAKETEX_NAME " <FONT>\n", stderr);
    exit(1);
  }
  
  name = argv[1];
  
  hMakeTeX = win32_load_tex_library(MAKETEX_DLL);
  if (hMakeTeX) {
    MAKETEX_PROC* Main;
    Main = (MAKETEX_PROC*)GetProcAddress(hMakeTeX, MAKETEX_PROC_NAME);
    if (Main) {
      MakeTeXCallbackInfo* pInfo;
      pInfo = MakeTeXInitCallback(FALSE);
      if (pInfo) {
	code = Main(filename, MAX_PATH+1,
		    MakeTeXCallback, (LPVOID)pInfo, name);
	MakeTeXUninitCallback(pInfo);
	if (code) {
	  puts(filename);
	}
	code = !code;
      }
    }
    else {
      fputs(MAKETEX_PROC_NAME ": Could not resolve the entry point.\n",
	    stderr);
    }
    FreeLibrary(hMakeTeX);
  }
  else {
    fputs(MAKETEX_DLL ": Could not load.\n", stderr);
  }
  
  return code;
}
