/* truncate.c: truncate too-long components in a filename.

Copyright (C) 1993, 95 Karl Berry.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <kpathsea/config.h>

#include <kpathsea/c-namemx.h>
#include <kpathsea/c-pathch.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/truncate.h>
#ifdef DBCS
#include <mbstring.h>
#endif


/* Truncate any too-long components in NAME, returning the result.  It's
   too bad this is necessary.  See comments in readable.c for why.  */

string
kpse_truncate_filename P1C(const_string, name)
{
  unsigned c_len = 0;        /* Length of current component.  */
  unsigned ret_len = 0;      /* Length of constructed result.  */
  
  /* Allocate enough space.  */
  string ret = (string) xmalloc (strlen (name) + 1);

#ifdef DBCS
  while (*name)
#else
  for (; *name; name++)
#endif
    {
      if (IS_DIR_SEP (*name) || IS_DEVICE_SEP (*name))
        { /* At a directory delimiter, reset component length.  */
          c_len = 0;
        }
      else if (c_len > NAME_MAX)
        { /* If past the max for a component, ignore this character.  */
          continue;
        }

      /* Copy this character.  */
#ifdef DBCS
      {
        const_string tmp = name;
        name = _mbsinc(name);
        for (; tmp != name; tmp++) {
          ret[ret_len++] = *tmp;
          c_len++;
        }
      }
#else
      ret[ret_len++] = *name;
      c_len++;
#endif
    }
  ret[ret_len] = 0;

  return ret;
}
