/* kpse-dll.c: for Win32 DLL
    Micorsoft Visual C++ Version 4.0
*/

#include <kpathsea/config.h>

HINSTANCE g_hinstDll = NULL;
DWORD g_dwTlsIndex = TLS_OUT_OF_INDEXES;
BOOL fRegistry = true;
HANDLE g_hMutexMissFont = NULL;
HANDLE g_hMutexTeXMFLog = NULL;

BOOL WINAPI DllMain(HINSTANCE hinstDll, DWORD fdwReason, LPVOID lpvReserved)
{
  kpse_context_type *kpse_context;

  switch (fdwReason) {
    case DLL_PROCESS_ATTACH:
      g_hinstDll = hinstDll;
      g_dwTlsIndex = TlsAlloc();
      if (g_dwTlsIndex == TLS_OUT_OF_INDEXES)
        return FALSE;
      fRegistry = read_setting("Registry");
      if (!read_setting("Console"))
        AllocConsole();
      g_hMutexMissFont = CreateMutex(NULL, FALSE, NULL);
      g_hMutexTeXMFLog = CreateMutex(NULL, FALSE, NULL);
      /* no break */

    case DLL_THREAD_ATTACH:
      kpse_context = TlsGetValue(g_dwTlsIndex);
      if (kpse_context == NULL) {
        kpse_context = HeapAlloc(GetProcessHeap(),
            HEAP_ZERO_MEMORY|HEAP_GENERATE_EXCEPTIONS,
            sizeof (kpse_context_type));
        TlsSetValue(g_dwTlsIndex, kpse_context);
      }
      kpse_clear_context();
      break;

    case DLL_THREAD_DETACH:
      if (g_dwTlsIndex != TLS_OUT_OF_INDEXES) {
        kpse_context = TlsGetValue(g_dwTlsIndex);
        if (kpse_context != NULL && kpse_context->ref_count == 0) {
          HeapDestroy(kpse_heap_handle);
          HeapFree(GetProcessHeap(), 0, kpse_context);
        }
      }
      break;

    case DLL_PROCESS_DETACH:
      if (g_dwTlsIndex != TLS_OUT_OF_INDEXES) {
        kpse_context = TlsGetValue(g_dwTlsIndex);
        if (kpse_context != NULL) {
          HeapDestroy(kpse_heap_handle);
          HeapFree(GetProcessHeap(), 0, kpse_context);
        }
        TlsFree(g_dwTlsIndex);
      }
      CloseHandle(g_hMutexMissFont);
      CloseHandle(g_hMutexTeXMFLog);
      break;
  }
  return TRUE;
}


BOOL read_registry(LPCTSTR subkey,  LPCTSTR var)
{
  string value;
  HKEY hkey;
  long len, ret;

  ret = RegOpenKeyEx (HKEY_LOCAL_MACHINE, subkey, 0, KEY_READ, &hkey);
  if (ret != ERROR_SUCCESS)
    return TRUE;
  ret = RegQueryValueEx (hkey, var, NULL, NULL, NULL, &len);
  if (ret == ERROR_SUCCESS && len) {
    value = HeapAlloc(GetProcessHeap(), HEAP_GENERATE_EXCEPTIONS, len);
    ret = RegQueryValueEx (hkey, var, NULL, NULL, value, &len);
    if (ret == ERROR_SUCCESS && len)
      ret = strcasecmp(value, "no") ? !ERROR_SUCCESS : ERROR_SUCCESS;
    HeapFree (GetProcessHeap(), 0, value);
  }
  RegCloseKey(hkey);
  return ret == ERROR_SUCCESS ? FALSE : TRUE;
}

LPVOID kpse_set_context(LPVOID context)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  if (context == NULL || context == (LPVOID)kpse_context)
    return NULL;
  TlsSetValue(g_dwTlsIndex, context);
  return kpse_context;
}

LPVOID kpse_get_context(VOID)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  if (kpse_context->ref_count == LONG_MAX)
    return NULL;
  kpse_context->ref_count++;
  return (LPVOID)kpse_context;
}

boolean kpse_free_context(LPVOID context)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  if (context == NULL)
    return false;
  if (context == (LPVOID)kpse_context) {
    kpse_context->ref_count--;
    return true;
  }
  kpse_context = context;
  if (--kpse_context->ref_count <= 0) {
    HeapDestroy(kpse_heap_handle);
    HeapFree(GetProcessHeap(), 0, kpse_context);
  }
  return true;
}

void kpse_clear_context(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  long saved_ref_count = kpse_context->ref_count;

  if (kpse_heap_handle)
    HeapDestroy(kpse_heap_handle);
  ZeroMemory(kpse_context, sizeof (kpse_context_type));
  kpse_heap_handle =
    HeapCreate(HEAP_NO_SERIALIZE/*|HEAP_GENERATE_EXCEPTIONS*/, 0, 0);
  kpse_context->first_search = true;
  optind = 1;
  opterr = 1;
  optopt = '?';
  kpse_context->ref_count = saved_ref_count;
  current_dir = xgetcwd();
  msglen = MAX_PATH;
  msgbuf = xmalloc(msglen);
}

boolean kpse_set_environment(LPVOID context)
{
  unsigned i;

  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  if (context == NULL || context == (LPVOID)kpse_context)
    return false;
  kpse_context->saved_env_len =
      ((kpse_context_type *)(context))->saved_env_len;
  kpse_context->saved_env_items =
      XTALLOC(kpse_context->saved_env_len, const_string);
  for (i = 0; i < kpse_context->saved_env_len; i++)
    kpse_context->saved_env_items[i] =
        ((kpse_context_type *)(context))->saved_env_items[i];
  return true;
}

string *program_invocation_name_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &program_invocation_name;
}

string *program_invocation_short_name_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &program_invocation_short_name;
}

string *kpse_fallback_resolutions_string_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &kpse_fallback_resolutions_string;
}

BOOL *kpse_make_tex_discard_errors_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &kpse_make_tex_discard_errors;
}

kpse_format_info_type *kpse_format_info_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return kpse_format_info;
}

LPTSTR *optarg_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &optarg;
}

INT *optind_get(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  return &optind;
}

void xfree(void *ptr)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  if (ptr)
    HeapFree(kpse_heap_handle, 0, ptr);
}

