#ifndef __gs_h_included
#define __gs_h_included

#define STRICT
#include <windows.h>

// Susie PlugIn Error Codes
#define SPI_ERROR_NORMAL                0
#define SPI_ERROR_NOTIMPL              -1
#define SPI_ERROR_ABORTED_BY_CALLBACK   1
#define SPI_ERROR_UNKNOWN_FORMAT        2
#define SPI_ERROR_DATA_BROKEN           3
#define SPI_ERROR_NO_MEMORY             4
#define SPI_ERROR_MEMORY                5
#define SPI_ERROR_READ                  6
#define SPI_ERROR_RESERED               7
#define SPI_ERROR_INTERNAL              8

// Ghostscript
#define GSDLLAPI CALLBACK
typedef int (*GSDLL_CALLBACK)(int message, char *str, unsigned long count);

#define GSDLL_STDIN  1
#define GSDLL_STDOUT 2
#define GSDLL_DEVICE 3
#define GSDLL_SYNC   4
#define GSDLL_PAGE   5
#define GSDLL_SIZE   6
#define GSDLL_POLL   7

class CFileMapping {
protected:
  HANDLE m_hFile;
  HANDLE m_hMap;
  LPVOID m_lpView;
  DWORD m_dwSize;
  BOOL m_bByHandle;

  int MapInternal(DWORD dwOffset);
  
public:
  CFileMapping() {
    m_hFile = INVALID_HANDLE_VALUE;
    m_hMap = 0;
    m_lpView = 0;
    m_dwSize = 0;
  }
  ~CFileMapping() { Unmap(); }
  int Map(LPCSTR lpszFileName, DWORD dwOffset);
  int Map(HANDLE hFile, DWORD dwOffset);
  void Unmap();
  LPVOID GetView() { return m_lpView; }
  DWORD GetSize() const { return m_dwSize; }
};

struct CBoundingBox {
  LONG llx;
  LONG lly;
  LONG urx;
  LONG ury;
};

struct CPSFInfo {
  struct CPSFPageInfo {
    LONG nPageBegin;
    LONG nPageEnd;
  };
  CBoundingBox bb;
  LONG nBeginProlog;
  LONG nEndProlog;
  LONG nBeginSetup;
  LONG nEndSetup;
  LONG nBeginTrailer;
  LONG nEndTrailer;
  CPSFPageInfo* lpPage;
  LONG nPages;
  BOOL bEPS;
  CPSFInfo() { lpPage = 0; nPages = 0; }
  ~CPSFInfo() { if (lpPage) delete[]lpPage; }
};

struct CPaper {
  LPCSTR lpszName;
  DWORD dwWidth;
  DWORD dwHeight;
};

class CGS {
protected:
  // Setup Parameters
  LPTSTR m_lpszGsDll;
  DWORD m_dwXResolution;
  DWORD m_dwYResolution;
  DWORD m_bNormalAspect;
  BOOL m_bRestartAlways;
  char m_szResolution[32];
  char m_szBitsPerPixel[32];
  BOOL m_bClip;
  DWORD m_dwDepth;
  enum MagicNumberType {
    MNT_PERCENT  = 0, // %!
    MNT_PS       = 1, // %!PS
    MNT_PS_ADOBE = 2, // %!PS-Adobe-*.*
    MNT_EPSF     = 3, // %!PS-Adobe-*.* EPSF-*.*
    MNT_MAX,
  };
  MagicNumberType m_eMagicNumber;
  LPSTR m_lpszDefaultPaper;
  int m_nAlphaText;
  int m_nAlphaGraphics;
  
  // Status
  BOOL m_bMustRestart;
  HMODULE m_hDLL;
  BOOL m_bStarted;
  LPBYTE m_lpGSDevice;
  char* m_lppArgv[10];
  int m_nArgc;
  
  BOOL LoadConfig();
  BOOL SaveConfig();
  
  int (GSDLLAPI *dll_revision)(char **product, char **copyright, 
			       long *gs_revision, long *gs_revisiondate);
  int (GSDLLAPI *dll_init)(GSDLL_CALLBACK callback, HWND hwnd, 
			   int argc, char *argv[]);
  int (GSDLLAPI *dll_execute_begin)(void);
  int (GSDLLAPI *dll_execute_cont)(const char *str, int len);
  int (GSDLLAPI *dll_execute_end)(void);
  int (GSDLLAPI *dll_exit)(void);
  int (GSDLLAPI *dll_lock_device)(unsigned char *device, int flag);
  HGLOBAL (GSDLLAPI *dll_copy_dib)(unsigned char *device);
  
  BOOL LoadDLL();
  void UnloadDLL();
  BOOL Start();
  void Stop(BOOL bUnload = TRUE);

  int GSWrite(LPCVOID lpData, DWORD dwLen);
  int GSPrintf(LPCSTR lpszFmt, ...);
  int GSPuts(LPCSTR lpszStr) { return GSWrite(lpszStr, strlen(lpszStr)); }

  void InitConsole();
  
public:
  CGS();
  ~CGS();
  DWORD GetXResolution() const { return m_dwXResolution; }
  DWORD GetYResolution() const {
    return m_bNormalAspect ? m_dwXResolution : m_dwYResolution;
  }
  DWORD GetDepth() const;
  BOOL GetClip() const { return m_bClip; }
  
  int BeginPage();
  int DoPage(LPCSTR lpStart, DWORD dwLen,
	     DWORD dwWidth, DWORD dwHeight,
	     const CPSFInfo& psi,
	     FARPROC lpCallback,
	     LONG lCallbackParam,
	     HGLOBAL* lphDib);
  int EndPage();
  int DoSetup(HWND hWnd);
  
  BOOL SetupDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

  // For Callback of GS
  void SetGSDevice(LPBYTE lpDev) { m_lpGSDevice = lpDev; }
  void WriteConsole(LPCSTR lpszString, DWORD dwLength);

  // Parsing PSF
  BOOL IsPS(LPCSTR lpData, LPCSTR lpEnd);
  BOOL ParsePSF(LPCSTR lpData, LPCSTR lpEnd, CPSFInfo& psi, LONG nPage);
  CBoundingBox GetDefaultBoundingBox() const;
};

// Global Data
extern HMODULE g_hModule;
extern CPaper g_paper[];

extern LPCSTR PSNextLine(LPCSTR lpData, LPCSTR lpEnd);

extern int Message(UINT uId, UINT uFlag = MB_OK);

#endif

// Local Variables:
// mode: c++
// End:
