#ifndef texdll_h_included
#define texdll_h_included

#include <windows.h>

#define TeXDLL_API_VERSION  4
#define TeXDLL_AUTHOR_REGISTRY_KEY "Software\\Kazunori Asayama"
#define TeXDLL_REGISTRY_KEY TeXDLL_AUTHOR_REGISTRY_KEY "\\TeX DLL"
#define MakeTeXDLL_REGISTRY_KEY TeXDLL_REGISTRY_KEY "\\MakeTeX"
#define TeXDLL_WM_TEXDLL "TeX.DLL.Message.45B86730-8D74-11d0-BA9D-A79457587F5C"
#define TeXDLL_MESSAGE_INTERRUPT 1
#define TeXDLL_MESSAGE_KILL      2

#define TeXDLL_EXPORT __declspec(dllexport)
#ifdef TeXDLL_IMPLEMENTATION_CODE
#  define TeXDLL_IMPORT __declspec(dllexport)
#else
#  define TeXDLL_IMPORT __declspec(dllimport)
#endif

#ifdef __cplusplus
extern "C" {
#endif
  /* DLL dependent messages */
  typedef enum {
    /* Console I/O */
    TeXDLL_CONSOLE_WRITE              = 1,
    TeXDLL_CONSOLE_GET                = 2,
    TeXDLL_STDOUT_WRITE               = 3,
    
    /* METAFONT on line display */
    TeXDLL_MFDISPLAY_INITIALIZE       = 8,
    TeXDLL_MFDISPLAY_BEGINCHAR        = 9,
    TeXDLL_MFDISPLAY_CLEAR            = 10,
    TeXDLL_MFDISPLAY_PAINT            = 11,
    TeXDLL_MFDISPLAY_UNINITIALIZE     = 12,
    TeXDLL_MFDISPLAY_ENDCHAR          = 13,
    
    /* Program */
    TeXDLL_INVOKE_EDITOR              = 32,

    /* I/O */
    TeXDLL_NOTIFY_FILE_OPEN           = 64,
    TeXDLL_NOTIFY_FILE_CLOSE          = 65,

    /* Notifications */
    TeXDLL_NOTIFY_PAGE_BEGIN          = 96,
    TeXDLL_NOTIFY_PAGE_END            = 97,

    TeXDLL_ERROR_RESULT               = 0xffff,
  } TeXDLLMessage;
#define TeXDLL_SEARCH_COUNT ( TeXDLL_SEARCH_LAST - TeXDLL_SEARCH_FIRST )
#define TeXDLL_IS_SEARCH(msg) \
  ( TeXDLL_SEARCH_FIRST <= (msg) && (msg) < TeXDLL_SEARCH_LAST )
  
  /* TeX Handle */
  typedef void* HTeX;
  
  /* Procedure types */  
  typedef LONG WINAPI TeXCallbackProc(TeXDLLMessage msg,
				      DWORD dwParam1, DWORD dwParam2,
				      LPVOID lpAppData);
  typedef TeXCallbackProc* LPFTeXCallbackProc;
  
  typedef HTeX WINAPI TeXInitializeProc(LPFTeXCallbackProc pCallback,
					LPVOID lpAppData,
					LPCSTR lpszWorkDir);
  typedef VOID WINAPI TeXUninitializeProc(HTeX hTeX);
  typedef LONG WINAPI TeXMainProc(HTeX hTeX, LONG lArgc, LPCSTR lpszArgv[]);
  typedef LONG WINAPI TeXVaMainProc(HTeX hTeX, LPCSTR lpszProgName, ...);
  typedef HWND WINAPI TeXGetWindowProc(HTeX hTeX);
  typedef LPCSTR WINAPI TeXGetNameProc(HTeX hTeX);
  typedef LPCSTR WINAPI TeXGetStaticNameProc(VOID);
  typedef DWORD WINAPI TeXGetChecksumProc(VOID);
  
  /* Pointers to Procedures */
  typedef TeXInitializeProc* LPFTeXInitializeProc;
  typedef TeXUninitializeProc* LPFTeXUninitializeProc;
  typedef TeXMainProc* LPFTeXMainProc;
  typedef TeXVaMainProc* LPFTeXVaMainProc;
  typedef TeXGetWindowProc* LPFTeXGetWindowProc;
  typedef TeXGetNameProc* LPFTeXGetNameProc;
  typedef TeXGetStaticNameProc* LPFTeXGetStaticNameProc;
  typedef TeXGetChecksumProc* LPFTeXGetChecksumProc;

  /* Table of functions */
  typedef struct {
    LPFTeXGetStaticNameProc GetLibraryFileName;
    LPFTeXInitializeProc    Initialize;
    LPFTeXUninitializeProc  Uninitialize;
    LPFTeXMainProc          Main;
    LPFTeXVaMainProc        VaMain;
    LPFTeXGetWindowProc     GetWindow;
    LPFTeXGetChecksumProc   GetChecksum;
    LPFTeXGetNameProc       GetJobName;
    LPFTeXGetNameProc       GetOutputBaseName;
    LPFTeXGetNameProc       GetOutputFileName;
    LPFTeXGetNameProc       GetTFMFileName;
    LPFTeXGetNameProc       GetLogFileName;
  } TeXProcedures;
  typedef TeXProcedures* LPTeXProcedures;
  typedef const TeXProcedures* LPCTeXProcedures;
  
  typedef LPCTeXProcedures WINAPI TeXGetProceduresProc(VOID);
  typedef TeXGetProceduresProc* LPFTeXGetProceduresProc;
  
  /* TeX */
  extern TeXDLL_IMPORT TeXMainProc TeXMain;
  extern TeXDLL_IMPORT TeXVaMainProc TeXVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc TeXInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc TeXUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc TeXGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetWindowProc TeXGetWindow;
  extern TeXDLL_IMPORT TeXGetChecksumProc TeXGetChecksum;
  extern TeXDLL_IMPORT TeXGetNameProc TeXGetJobName;
  extern TeXDLL_IMPORT TeXGetNameProc TeXGetOutputBaseName;
  extern TeXDLL_IMPORT TeXGetNameProc TeXGetOutputFileName;
  extern TeXDLL_IMPORT TeXGetNameProc TeXGetLogFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc TeXGetProcedures;
  
  /* ASCII pTeX */
  extern TeXDLL_IMPORT TeXMainProc PTeXMain;
  extern TeXDLL_IMPORT TeXVaMainProc PTeXVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PTeXInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PTeXUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PTeXGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetWindowProc PTeXGetWindow;
  extern TeXDLL_IMPORT TeXGetChecksumProc PTeXGetChecksum;
  extern TeXDLL_IMPORT TeXGetNameProc PTeXGetJobName;
  extern TeXDLL_IMPORT TeXGetNameProc PTeXGetOutputBaseName;
  extern TeXDLL_IMPORT TeXGetNameProc PTeXGetOutputFileName;
  extern TeXDLL_IMPORT TeXGetNameProc PTeXGetLogFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PTeXGetProcedures;
  
  /* METAFONT */
  extern TeXDLL_IMPORT TeXMainProc MFMain;
  extern TeXDLL_IMPORT TeXVaMainProc MFVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc MFInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc MFUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc MFGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetWindowProc MFGetWindow;
  extern TeXDLL_IMPORT TeXGetChecksumProc MFGetChecksum;
  extern TeXDLL_IMPORT TeXGetNameProc MFGetJobName;
  extern TeXDLL_IMPORT TeXGetNameProc MFGetOutputBaseName;
  extern TeXDLL_IMPORT TeXGetNameProc MFGetOutputFileName;
  extern TeXDLL_IMPORT TeXGetNameProc MFGetTFMFileName;
  extern TeXDLL_IMPORT TeXGetNameProc MFGetLogFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc MFGetProcedures;
  
  /* METAPOST */
  extern TeXDLL_IMPORT TeXMainProc MPMain;
  extern TeXDLL_IMPORT TeXVaMainProc MPVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc MPInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc MPUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc MPGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetWindowProc MPGetWindow;
  extern TeXDLL_IMPORT TeXGetChecksumProc MPGetChecksum;
  extern TeXDLL_IMPORT TeXGetNameProc MPGetJobName;
  extern TeXDLL_IMPORT TeXGetNameProc MPGetOutputBaseName;
  extern TeXDLL_IMPORT TeXGetNameProc MPGetOutputFileName;
  extern TeXDLL_IMPORT TeXGetNameProc MPGetTFMFileName;
  extern TeXDLL_IMPORT TeXGetNameProc MPGetLogFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc MPGetProcedures;

  /* MFtoPK (METAFONT + GFtoPK) */
  extern TeXDLL_IMPORT TeXMainProc MFtoPKMain;
  extern TeXDLL_IMPORT TeXVaMainProc MFtoPKVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc MFtoPKInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc MFtoPKUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc MFtoPKGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetWindowProc MFtoPKGetWindow;
  extern TeXDLL_IMPORT TeXGetChecksumProc MFtoPKGetChecksum;
  extern TeXDLL_IMPORT TeXGetNameProc MFtoPKGetJobName;
  extern TeXDLL_IMPORT TeXGetNameProc MFtoPKGetOutputBaseName;
  extern TeXDLL_IMPORT TeXGetNameProc MFtoPKGetOutputFileName;
  extern TeXDLL_IMPORT TeXGetNameProc MFtoPKGetLogFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc MFtoPKGetProcedures;
  
  /* BibTeX */
  extern TeXDLL_IMPORT TeXMainProc BibTeXMain;
  extern TeXDLL_IMPORT TeXVaMainProc BibTeXVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc BibTeXInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc BibTeXUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc BibTeXGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc BibTeXGetProcedures;
  
  /* JBibTeX */
  extern TeXDLL_IMPORT TeXMainProc JBibTeXMain;
  extern TeXDLL_IMPORT TeXVaMainProc JBibTeXVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc JBibTeXInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc JBibTeXUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc JBibTeXGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc JBibTeXGetProcedures;
  
  /* patgen */
  extern TeXDLL_IMPORT TeXMainProc PatGenMain;
  extern TeXDLL_IMPORT TeXVaMainProc PatGenVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PatGenInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PatGenUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PatGenGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PatGenGetProcedures;
  
  /* GFtoDVI */
  extern TeXDLL_IMPORT TeXMainProc GFtoDVIMain;
  extern TeXDLL_IMPORT TeXVaMainProc GFtoDVIVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc GFtoDVIInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc GFtoDVIUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc GFtoDVIGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc GFtoDVIGetProcedures;

  /* GFtoPK */
  extern TeXDLL_IMPORT TeXMainProc GFtoPKMain;
  extern TeXDLL_IMPORT TeXVaMainProc GFtoPKVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc GFtoPKInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc GFtoPKUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc GFtoPKGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc GFtoPKGetProcedures;

  /* GFType */
  extern TeXDLL_IMPORT TeXMainProc GFTypeMain;
  extern TeXDLL_IMPORT TeXVaMainProc GFTypeVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc GFTypeInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc GFTypeUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc GFTypeGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc GFTypeGetProcedures;

  /* MFT */
  extern TeXDLL_IMPORT TeXMainProc MFTMain;
  extern TeXDLL_IMPORT TeXVaMainProc MFTVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc MFTInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc MFTUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc MFTGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc MFTGetProcedures;

  /* PKtoGF */
  extern TeXDLL_IMPORT TeXMainProc PKtoGFMain;
  extern TeXDLL_IMPORT TeXVaMainProc PKtoGFVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PKtoGFInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PKtoGFUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PKtoGFGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PKtoGFGetProcedures;

  /* PKType */
  extern TeXDLL_IMPORT TeXMainProc PKTypeMain;
  extern TeXDLL_IMPORT TeXVaMainProc PKTypeVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PKTypeInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PKTypeUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PKTypeGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PKTypeGetProcedures;

  /* PLtoTF */
  extern TeXDLL_IMPORT TeXMainProc PLtoTFMain;
  extern TeXDLL_IMPORT TeXVaMainProc PLtoTFVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PLtoTFInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PLtoTFUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PLtoTFGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PLtoTFGetProcedures;

  /* TFtoPL */
  extern TeXDLL_IMPORT TeXMainProc TFtoPLMain;
  extern TeXDLL_IMPORT TeXVaMainProc TFtoPLVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc TFtoPLInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc TFtoPLUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc TFtoPLGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc TFtoPLGetProcedures;

  /* VFtoVP */
  extern TeXDLL_IMPORT TeXMainProc VFtoVPMain;
  extern TeXDLL_IMPORT TeXVaMainProc VFtoVPVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc VFtoVPInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc VFtoVPUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc VFtoVPGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc VFtoVPGetProcedures;

  /* VPtoVF */
  extern TeXDLL_IMPORT TeXMainProc VPtoVFMain;
  extern TeXDLL_IMPORT TeXVaMainProc VPtoVFVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc VPtoVFInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc VPtoVFUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc VPtoVFGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc VPtoVFGetProcedures;

  /* DVICopy */
  extern TeXDLL_IMPORT TeXMainProc DVICopyMain;
  extern TeXDLL_IMPORT TeXVaMainProc DVICopyVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc DVICopyInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc DVICopyUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc DVICopyGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc DVICopyGetProcedures;

  /* DVItoMP */
  extern TeXDLL_IMPORT TeXMainProc DVItoMPMain;
  extern TeXDLL_IMPORT TeXVaMainProc DVItoMPVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc DVItoMPInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc DVItoMPUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc DVItoMPGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc DVItoMPGetProcedures;

  /* DVIType */
  extern TeXDLL_IMPORT TeXMainProc DVITypeMain;
  extern TeXDLL_IMPORT TeXVaMainProc DVITypeVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc DVITypeInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc DVITypeUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc DVITypeGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc DVITypeGetProcedures;

  /* PDVIType */
  extern TeXDLL_IMPORT TeXMainProc PDVITypeMain;
  extern TeXDLL_IMPORT TeXVaMainProc PDVITypeVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PDVITypeInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PDVITypeUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PDVITypeGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PDVITypeGetProcedures;

  /* Tangle */
  extern TeXDLL_IMPORT TeXMainProc TangleMain;
  extern TeXDLL_IMPORT TeXVaMainProc TangleVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc TangleInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc TangleUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc TangleGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc TangleGetProcedures;

  /* Weave */
  extern TeXDLL_IMPORT TeXMainProc WeaveMain;
  extern TeXDLL_IMPORT TeXVaMainProc WeaveVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc WeaveInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc WeaveUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc WeaveGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc WeaveGetProcedures;

  /* PoolType */
  extern TeXDLL_IMPORT TeXMainProc PoolTypeMain;
  extern TeXDLL_IMPORT TeXVaMainProc PoolTypeVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc PoolTypeInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc PoolTypeUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc PoolTypeGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc PoolTypeGetProcedures;

  /* Mendex */
  extern TeXDLL_IMPORT TeXMainProc MendexMain;
  extern TeXDLL_IMPORT TeXVaMainProc MendexVaMain;
  extern TeXDLL_IMPORT TeXInitializeProc MendexInitialize;
  extern TeXDLL_IMPORT TeXUninitializeProc MendexUninitialize;
  extern TeXDLL_IMPORT TeXGetStaticNameProc MendexGetLibraryFileName;
  extern TeXDLL_IMPORT TeXGetProceduresProc MendexGetProcedures;

  /* METAFONT display */
  typedef struct {
    BOOL bBlack;
    DWORD dwRow;
    DWORD dwVectorSize;
    LPDWORD lpdwVector;
  } MFDisplayRaster;
  typedef MFDisplayRaster* LPMFDisplayRaster;

  /* dvips */
  typedef LONG WINAPI DVIPSMainProc(LPFTeXCallbackProc lpfCallback,
				    LPVOID lpCallbackData,
				    LPCSTR lpszWorkDir,
				    LONG argc,
				    LPCSTR* argv);
  typedef LONG WINAPI DVIPSVaMainProc(LPFTeXCallbackProc lpfCallback,
				      LPVOID lpCallbackData,
				      LPCSTR lpszWorkDir,
				      LPCSTR lpszProgName, ...);
  typedef DVIPSMainProc* LPFDVIPSMainProc;
  typedef DVIPSVaMainProc* LPFDVIPSVaMainProc;

  DVIPSMainProc DVIPSMain;
  DVIPSVaMainProc DVIPSVaMain;
  
  /* MakeTeXPK / MakeTeXTFM */
  typedef BOOL WINAPI MakeTeXPKProc(LPSTR lpszFileName,
				    DWORD dwFileNameLen,
				    LPFTeXCallbackProc lpfCallback,
				    LPVOID lpCallbackData,
				    LPCSTR lpszFontName,
				    LPCSTR lpszMag,
				    DWORD dwModeDpi,
				    LPCSTR lpszMode);
  typedef BOOL WINAPI MakeTeXTFMProc(LPSTR lpszFileName,
				     DWORD dwFileNameLen,
				     LPFTeXCallbackProc lpfCallback,
				     LPVOID lpCallbackData,
				     LPCSTR lpszFontName);
  typedef BOOL WINAPI MakeTeXMFProc(LPSTR lpszFileName,
				    DWORD dwFileNameLen,
				    LPCSTR lpszFontName);
  typedef BOOL WINAPI MakeTeXlsRProc(LPCSTR lpszTopDir, LPCSTR lpszLSR);
  
  typedef MakeTeXPKProc* LPFMakeTeXPKProc;
  typedef MakeTeXTFMProc* LPFMakeTeXTFMProc;
  typedef MakeTeXMFProc* LPFMakeTeXMFProc;
  typedef MakeTeXlsRProc* LPFMakeTeXlsRProc;
  
  MakeTeXPKProc MakeTeXPKMain;
  MakeTeXTFMProc MakeTeXTFMMain;
  MakeTeXMFProc MakeTeXMFMain;
  MakeTeXlsRProc MakeTeXlsRMain;
  
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
inline BOOL WINAPI MakeTeXPKMain(LPSTR lpszFileName,
				 DWORD dwFileNameLen,
				 LPFTeXCallbackProc lpfCallback,
				 LPVOID lpCallbackData,
				 LPCSTR lpszFontName,
				 LPCSTR lpszMag,
				 DWORD dwModeDpi)
{
  return MakeTeXPKMain(lpszFileName,
		       dwFileNameLen,
		       lpfCallback,
		       lpCallbackData,
		       lpszFontName,
		       lpszMag,
		       dwModeDpi,
		       0);
}
inline BOOL WINAPI MakeTeXPKMain(LPSTR lpszFileName,
				 DWORD dwFileNameLen,
				 LPFTeXCallbackProc lpfCallback,
				 LPVOID lpCallbackData,
				 LPCSTR lpszFontName,
				 LPCSTR lpszMag,
				 LPCSTR lpszMode)
{
  return MakeTeXPKMain(lpszFileName,
		       dwFileNameLen,
		       lpfCallback,
		       lpCallbackData,
		       lpszFontName,
		       lpszMag,
		       0,
		       lpszMode);
}
inline BOOL WINAPI MakeTeXlsRMain(VOID)
{
  return MakeTeXlsRMain(0, 0);
}
inline BOOL WINAPI MakeTeXlsRMain(LPCSTR lpszTopDir)
{
  return MakeTeXlsRMain(lpszTopDir, 0);
}
#endif /* C++ */

#endif /* texdll_h_included */
