#include <win32dll/texdll.h>
#include <win32dll/custres.h>
#include <commctrl.h>
#include <mbstring.h>
#include <stdio.h>

HINSTANCE g_hInstance;

#define INVALID_COLOR 0xffffffff

struct CMFMode{
  LPSTR szDpi;
  LPSTR szMode;
  CMFMode* next;
  CMFMode() { szDpi = 0; szMode = 0; next = 0; }
  ~CMFMode() { if (szDpi) { delete[]szDpi; delete[]szMode; } }
};

struct CSetupData {
  COLORREF crFGColor;
  COLORREF crBGColor;
  LPSTR szEditor;
  CMFMode* modeList;
  BOOL bMFEnabled;
  CSetupData() {
    crFGColor = crBGColor = INVALID_COLOR;
    szEditor = 0;
    bMFEnabled = TRUE;
    modeList = 0;
  }
};

struct CSetupInfo {
  BOOL bSystemWritable;
  CSetupData sysData, userData;
  CSetupData* pCurData;
  CSetupInfo() { pCurData = &userData; }
};

BOOL UpdateAllData(CSetupInfo* );

static BOOL IsRegistryWritable(HKEY hParent, LPCSTR szSubKey)
{
  HKEY hKey;
  BOOL code = FALSE;
  if (::RegOpenKeyEx(hParent, szSubKey, 0, KEY_WRITE, &hKey) ==
      ERROR_SUCCESS) {
    code = TRUE;
    ::RegCloseKey(hKey);
  }
  return code;
}

LPSTR GetFileName(HWND hWnd,
		  LPCSTR szDefFileName, LPCSTR szFilter, LPCSTR szExt)
{
  OPENFILENAME ofn;
  LPSTR szAllFilter = new char[strlen(szFilter) + 2];
  char szFileNameBuffer[2000];
  
  strcpy(szAllFilter, szFilter);
  strcat(szAllFilter, "|");
  {
    LPSTR p = szAllFilter;
    while (p = (LPSTR)_mbschr((LPBYTE)p, '|'))
      *p++ = 0;
  }
  
  memset(&ofn, 0, sizeof(ofn));
  ofn.lStructSize = sizeof(ofn);
  ofn.hwndOwner = hWnd;
  ofn.hInstance = g_hInstance;
  ofn.lpstrFilter = szAllFilter;
  ofn.lpstrFile = szFileNameBuffer;
  ofn.nMaxFile = 2000;
  if (szDefFileName) strcpy(ofn.lpstrFile, szDefFileName);
  else ofn.lpstrFile[0] = 0;
  ofn.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR | OFN_HIDEREADONLY;
  ofn.lpstrDefExt = szExt;

  LPSTR pStr = 0;
  if (::GetOpenFileName(&ofn)) {
    pStr = new char[strlen(szFileNameBuffer) + 1];
    strcpy(pStr, szFileNameBuffer);
  }

  delete[]szAllFilter;
  
  return pStr;
}

static LRESULT CALLBACK GeneralPageProc(HWND hWnd, UINT uMsg,
					WPARAM wParam, LPARAM lParam)
{
  CSetupInfo* pInfo = (CSetupInfo*)::GetWindowLong(hWnd, DWL_USER);
  LPNMHDR pNM;
  
  switch (uMsg) {
  case WM_INITDIALOG:
    pInfo = (CSetupInfo*)((LPPROPSHEETPAGE)lParam)->lParam;
    ::SetWindowLong(hWnd, DWL_USER, (LONG)pInfo);
    ::CheckDlgButton(hWnd, IDC_TARGET_USER, TRUE);
    ::CheckDlgButton(hWnd, IDC_TARGET_SYSTEM, FALSE);
    ::EnableWindow(::GetDlgItem(hWnd, IDC_TARGET_SYSTEM),
		   pInfo->bSystemWritable);
    return 1;
  case WM_NOTIFY:
    pNM = (LPNMHDR)lParam;
    switch (pNM->code) {
    case PSN_APPLY:
      ::UpdateAllData(pInfo);
      ::SetWindowLong(hWnd, DWL_MSGRESULT, PSNRET_NOERROR);
      return TRUE;
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDC_TARGET_USER:
      pInfo->pCurData = &pInfo->userData;
      return 1;
    case IDC_TARGET_SYSTEM:
      pInfo->pCurData = &pInfo->sysData;
      return 1;
    case IDC_RESET_USER:
      if (MessageBox(hWnd, "All of your setup informations about TeX DLL will be initialized with the system default values. OK ?",
		     "", MB_YESNO | MB_ICONEXCLAMATION) == IDYES) {
	pInfo->userData = CSetupData();
      }
      return 1;
    }
  }
  return 0;
}

static BOOL ChangeColor(HWND hWnd, LPCOLORREF pColor)
{
  CHOOSECOLOR c;
  COLORREF custColor[16];
  int i;
  for (i=0;i<16;i++) custColor[i] = *pColor;
  c.lStructSize = sizeof(c);
  c.hwndOwner = hWnd;
  c.hInstance = g_hInstance;
  c.rgbResult = *pColor;
  c.lpCustColors = custColor;
  c.Flags = CC_RGBINIT | CC_FULLOPEN;
  
  if (ChooseColor(&c))
    *pColor = c.rgbResult;
  
  return TRUE;
}

static LRESULT CALLBACK CuiPageProc(HWND hWnd, UINT uMsg,
				    WPARAM wParam, LPARAM lParam)
{
  CSetupInfo* pInfo = (CSetupInfo*)::GetWindowLong(hWnd, DWL_USER);
  LPNMHDR pNM;
  
  switch (uMsg) {
  case WM_INITDIALOG:
    pInfo = (CSetupInfo*)((LPPROPSHEETPAGE)lParam)->lParam;
    ::SetWindowLong(hWnd, DWL_USER, (LONG)pInfo);
    return 1;
  case WM_NOTIFY:
    pNM = (LPNMHDR)lParam;
    switch (pNM->code) {
    case PSN_SETACTIVE:
      {
	LPCSTR s =
	  pInfo->pCurData->szEditor ? pInfo->pCurData->szEditor : "" ;
	::SetDlgItemText(hWnd, IDC_EDITOR, s);
      }
      ::CheckDlgButton(hWnd, IDC_METAFONT_DISPLAY_VALID,
		       pInfo->pCurData->bMFEnabled);
      return 1;
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDC_CHANGE_FOREGROUND:
      {
	COLORREF c =
	  (pInfo->pCurData->crFGColor == INVALID_COLOR) ?
	    0 : pInfo->pCurData->crFGColor;
	if (::ChangeColor(hWnd, &c))
	  pInfo->pCurData->crFGColor = c;
      }
      return 1;
    case IDC_CHANGE_BACKGROUND:
      {
	COLORREF c =
	  (pInfo->pCurData->crBGColor == INVALID_COLOR) ?
	    0x00ffffff : pInfo->pCurData->crBGColor;
	if (::ChangeColor(hWnd, &c))
	  pInfo->pCurData->crBGColor = c;
      }
      return 1;
    case IDC_BROWSE_EDITOR:
      {
	LPCSTR s = pInfo->pCurData->szEditor ? pInfo->pCurData->szEditor : 0;
	LPSTR szNew =
	  ::GetFileName(hWnd, s,
			"Executables (*.exe;*.com;*.bat;*.cmd)|*.exe;*.com;*.bat;*.cmd", 0);
	if (szNew) {
	  if (pInfo->pCurData->szEditor) delete[]pInfo->pCurData->szEditor;
	  pInfo->pCurData->szEditor = szNew;
	  ::SetDlgItemText(hWnd, IDC_EDITOR, szNew);
	}
      }
      return 1;
    case IDC_METAFONT_DISPLAY_VALID:
      {
	BOOL bEnabled = ::IsDlgButtonChecked(hWnd, IDC_METAFONT_DISPLAY_VALID);
	::EnableWindow(::GetDlgItem(hWnd, IDC_CHANGE_FOREGROUND), bEnabled);
	::EnableWindow(::GetDlgItem(hWnd, IDC_CHANGE_BACKGROUND), bEnabled);
      }
      return 1;
    }
  }
  return 0;
}

static LRESULT CALLBACK MFModeDlgProc(HWND hWnd, UINT uMsg,
				      WPARAM wParam, LPARAM lParam)
{
  CMFMode* pMode = (CMFMode*)::GetWindowLong(hWnd, DWL_USER);
  
  switch (uMsg) {
  case WM_INITDIALOG:
    ::SetWindowLong(hWnd, DWL_USER, lParam);
    pMode = (CMFMode*)lParam;
    if (pMode->szDpi) {
      ::SetDlgItemText(hWnd, IDC_DPI, pMode->szDpi);
    }
    ::EnableWindow(::GetDlgItem(hWnd, IDC_DPI), !pMode->szDpi);
    if (pMode->szMode)
      ::SetDlgItemText(hWnd, IDC_MODE, pMode->szMode);
    return 1;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDOK:
      {
	char buf[100];
	BOOL bValid = TRUE;
	if (!pMode->szDpi) {
	  ::GetDlgItemText(hWnd, IDC_DPI, buf, 100);
	  LPCSTR p = buf;
	  while (*p && isdigit(*p)) p++;
	  if (*p || strlen(buf) == 0) {
	    MessageBox(hWnd, "Invalid DPI value.", 0, MB_OK);
	    bValid = FALSE;
	  }
	  else {
	    pMode->szDpi = new char[strlen(buf)+1];
	    strcpy(pMode->szDpi, buf);
	  }
	}
	if (bValid) {
	  ::GetDlgItemText(hWnd, IDC_MODE, buf, 100);
	  if (strlen(buf) == 0) {
	    MessageBox(hWnd, "Invalid Mode value.", 0, MB_OK);
	    bValid = FALSE;
	  }
	  else {
	    if (pMode->szMode) delete[]pMode->szMode;
	    pMode->szMode = new char[strlen(buf)+1];
	    strcpy(pMode->szMode, buf);
	  }
	}
	if (bValid) ::EndDialog(hWnd, IDOK);
      }
      return 1;
    case IDCANCEL:
      ::EndDialog(hWnd, IDCANCEL);
      return 1;
    }
    break;
  }
  return 0;
}

static BOOL EditMFMode(HWND hParent, CMFMode* pMode)
{
  return ::DialogBoxParam(g_hInstance, MAKEINTRESOURCE(IDD_EDIT_MODE),
			  hParent, (DLGPROC)MFModeDlgProc, (LPARAM)pMode) ==
			    IDOK;
}

static VOID InsertMFMode(HWND hLV, int i, CMFMode* pMode)
{
  LV_ITEM item;
  item.mask = LVIF_TEXT | LVIF_PARAM;
  item.iItem = i;
  item.iSubItem = 0;
  item.pszText = pMode->szDpi;
  item.lParam = (LPARAM)pMode;
  ListView_InsertItem(hLV, &item);
  item.mask = LVIF_TEXT;
  item.iItem = i;
  item.iSubItem = 1;
  item.pszText = pMode->szMode;
  ListView_SetItem(hLV, &item);
}

static LRESULT CALLBACK MakeTeXPageProc(HWND hWnd, UINT uMsg,
					WPARAM wParam, LPARAM lParam)
{
  CSetupInfo* pInfo = (CSetupInfo*)::GetWindowLong(hWnd, DWL_USER);
  LPNMHDR pNM;
  
  switch (uMsg) {
  case WM_INITDIALOG:
    ::SetWindowLong(hWnd, DWL_USER, ((LPPROPSHEETPAGE)lParam)->lParam);
    {
      HWND hLV = ::GetDlgItem(hWnd, IDC_MODES);
      LV_COLUMN col;
      col.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
      col.fmt = LVCFMT_LEFT;
      col.cx = 160;
      col.pszText = "Resolution (DPI)";
      col.iSubItem = 0;
      ListView_InsertColumn(hLV, 0, &col);
      col.fmt = LVCFMT_LEFT;
      col.cx = 160;
      col.pszText = "Mode";
      col.iSubItem = 1;
      ListView_InsertColumn(hLV, 1, &col);
    }
    return 1;
  case WM_NOTIFY:
    pNM = (LPNMHDR)lParam;
    switch (pNM->code) {
    case PSN_SETACTIVE:
      {
	HWND hLV = ::GetDlgItem(hWnd, IDC_MODES);
	ListView_DeleteAllItems(hLV);
	int i;
	CMFMode* pMode = pInfo->pCurData->modeList;
	for (i=0;pMode;i++) {
	  InsertMFMode(hLV, 0, pMode);
	  pMode = pMode->next;
	}
      }
      return 1;
    case NM_DBLCLK:
      {
	HWND hLV = ::GetDlgItem(hWnd, IDC_MODES);
	int i;
	int n = ListView_GetItemCount(hLV);
	for (i=0;i<n;i++) {
	  UINT st =
	    ListView_GetItemState(hLV, i, LVIS_FOCUSED | LVIS_SELECTED); 
	  if (st == (LVIS_FOCUSED | LVIS_SELECTED))
	    break;
	}
	if (i < n) {
	  LV_ITEM item;
	  item.iItem = i;
	  item.iSubItem = 0;
	  item.mask = LVIF_PARAM;
	  if (ListView_GetItem(hLV, &item)) {
	    if (EditMFMode(hWnd, (CMFMode*)item.lParam)) {
	    }
	  }
	}
      }
      break;
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDC_ADD:
      {
	CMFMode* pMode = new CMFMode;
	if (EditMFMode(hWnd, pMode)) {
	  HWND hLV = ::GetDlgItem(hWnd, IDC_MODES);
	  pMode->next = pInfo->pCurData->modeList;
	  pInfo->pCurData->modeList = pMode;
	  InsertMFMode(hLV, 0, pMode);
	}
	else delete pMode;
      }
      return 1;
    case IDC_REMOVE:
      {
	HWND hLV = ::GetDlgItem(hWnd, IDC_MODES);
	int n = ListView_GetItemCount(hLV);
	int i;
	for (i = n-1;i>=0;i--) {
	  if (ListView_GetItemState(hLV, i, LVIS_SELECTED) == LVIS_SELECTED) {
	    LV_ITEM item;
	    item.iItem = i;
	    item.iSubItem = 0;
	    item.mask = LVIF_PARAM;
	    ListView_GetItem(hLV, &item);
	    CMFMode* pMode = (CMFMode*)item.lParam;
	    ListView_DeleteItem(hLV, i);
	    CMFMode h, *pm;
	    h.next = pInfo->pCurData->modeList;
	    pm = &h;
	    while (pm->next) {
	      if (pm->next == pMode) {
		pm->next = pm->next->next;
		break;
	      }
	      pm = pm->next;
	    }
	    delete pMode;
	  }
	}
      }
      return 1;
    }
    break;
  }
  
  return 0;
}

BOOL LoadValue(HKEY hParent, LPCSTR szSubKey, LPCSTR szName,
	       LPVOID pBuf, LPDWORD pdwType, LPDWORD pdwSize)
{
  HKEY hKey;
  BOOL code = FALSE;
  if (::RegOpenKeyEx(hParent, szSubKey, 0, KEY_READ, &hKey) ==
      ERROR_SUCCESS) {
    if (::RegQueryValueEx(hKey, szName, 0, pdwType, (LPBYTE)pBuf, pdwSize) ==
	ERROR_SUCCESS)
      code = TRUE;
    ::RegCloseKey(hKey);
  }
  return code;
}

BOOL LoadDWordValue(HKEY hKey, LPCSTR szSubKey, LPCSTR szName, LPDWORD pdwVal)
{
  DWORD v, t, s = sizeof(DWORD);
  BOOL code = FALSE;
  if (::LoadValue(hKey, szSubKey, szName, &v, &t, &s)) {
    if (t == REG_DWORD || t == REG_DWORD_LITTLE_ENDIAN) {
      *pdwVal = v;
      code = TRUE;
    }
  }
  return code;
}

BOOL LoadStringValue(HKEY hKey, LPCSTR szSubKey, LPCSTR szName, LPSTR* pStr)
{
  DWORD t, s;
  BOOL code = FALSE;
  char buf[2000];
  s = 2000;
  if (::LoadValue(hKey, szSubKey, szName, buf, &t, &s)) {
    if (t == REG_SZ) {
      *pStr = new char[s+1];
      memcpy(*pStr, buf, s);
      *(*pStr + s) = 0;
      code = TRUE;
    }
  }
  return code;
}

BOOL LoadSetup(HKEY hHive, CSetupData* data)
{
  DWORD dwVal;
  LPCSTR szKeyName;

  szKeyName = TeXDLL_AUTHOR_REGISTRY_KEY "\\TeX CUI\\Metafont";
  ::LoadDWordValue(hHive, szKeyName, "colorForeground", &data->crFGColor);
  ::LoadDWordValue(hHive, szKeyName, "colorBackground", &data->crBGColor);
  dwVal = FALSE;
  ::LoadDWordValue(hHive, szKeyName, "noDisplay", &dwVal);
  data->bMFEnabled = !dwVal;
  
  szKeyName = TeXDLL_AUTHOR_REGISTRY_KEY "\\TeX CUI";
  ::LoadStringValue(hHive, szKeyName, "editor", &data->szEditor);

  szKeyName = MakeTeXDLL_REGISTRY_KEY;
  szKeyName = MakeTeXDLL_REGISTRY_KEY "\\Default Mode";
  HKEY hKey;
  if (::RegOpenKeyEx(hHive, szKeyName, 0, KEY_READ, &hKey) == ERROR_SUCCESS) {
    int i;
    for (i=0; ;i++) {
      char szName[100], szData[100];
      DWORD dwName = 100, dwData = 100;
      DWORD dwType;
      if (::RegEnumValue(hKey, i, szName, &dwName, 0, &dwType,
			 (LPBYTE)szData, &dwData) != ERROR_SUCCESS)
	break;
      if (dwType == REG_SZ) {
	CMFMode* pMode = new CMFMode;
	pMode->szDpi = new char[strlen(szName)+1];
	strcpy(pMode->szDpi, szName);
	pMode->szMode = new char[strlen(szData)+1];
	strcpy(pMode->szMode, szData);
	pMode->next = data->modeList;
	data->modeList = pMode;
      }
    }
    ::RegCloseKey(hKey);
  }
  
  return TRUE;
}


BOOL SaveValue(HKEY hParent, LPCSTR szSubKey, LPCSTR szName,
	       LPCVOID pBuf, DWORD dwType, DWORD dwSize)
{
  BOOL code = FALSE;
  HKEY hKey;
  DWORD dwDis;
  
  if (::RegCreateKeyEx(hParent, szSubKey, 0, "", REG_OPTION_NON_VOLATILE,
		       KEY_ALL_ACCESS, 0, &hKey, &dwDis) == ERROR_SUCCESS) {
    if (::RegSetValueEx(hKey, szName, 0, dwType, (const LPBYTE)pBuf, dwSize) ==
	ERROR_SUCCESS)
      code = TRUE;
    ::RegCloseKey(hKey);
  }
  
  return code;
}

BOOL SaveDWordValue(HKEY hKey, LPCSTR szSubKey, LPCSTR szName, DWORD dwVal)
{
  return ::SaveValue(hKey, szSubKey, szName, &dwVal,
		     REG_DWORD, sizeof(DWORD));
}

BOOL SaveStringValue(HKEY hKey, LPCSTR szSubKey, LPCSTR szName, LPCSTR pStr)
{
  return ::SaveValue(hKey, szSubKey, szName, pStr,
		     REG_SZ, strlen(pStr)+1);
}

BOOL SaveSetup(HKEY hHive, CSetupData* data)
{
  LPCSTR szKeyName;

  szKeyName = TeXDLL_AUTHOR_REGISTRY_KEY "\\TeX CUI\\Metafont";
  if (data->crFGColor != INVALID_COLOR)
    ::SaveDWordValue(hHive, szKeyName, "colorForeground", data->crFGColor);
  if (data->crBGColor != INVALID_COLOR)
    ::SaveDWordValue(hHive, szKeyName, "colorBackground", data->crBGColor);
  ::SaveDWordValue(hHive, szKeyName, "noDisplay", !data->bMFEnabled);
  
  szKeyName = TeXDLL_AUTHOR_REGISTRY_KEY "\\TeX CUI";
  if (data->szEditor)
    ::SaveStringValue(hHive, szKeyName, "editor", data->szEditor);
  
  szKeyName = MakeTeXDLL_REGISTRY_KEY;
  szKeyName = MakeTeXDLL_REGISTRY_KEY "\\Default Mode";
  HKEY hKey;
  if (::RegOpenKeyEx(hHive, szKeyName, 0, KEY_WRITE | KEY_READ, &hKey) ==
      ERROR_SUCCESS) {
    int i;
    for (i=0; ;i++) {
      char szName[100], szData[100];
      DWORD dwName = 100, dwData = 100;
      DWORD dwType;
      if (::RegEnumValue(hKey, i, szName, &dwName, 0, &dwType,
			 (LPBYTE)szData, &dwData) != ERROR_SUCCESS)
	break;
      ::RegDeleteValue(hKey, szName);
    }
    ::RegCloseKey(hKey);
  }
  {
    CMFMode* pMode = data->modeList;
    while (pMode) {
      ::SaveStringValue(hHive, szKeyName, pMode->szDpi, pMode->szMode);
      pMode = pMode->next;
    }
  }
  
  return TRUE;
}

BOOL UpdateAllData(CSetupInfo* pInfo)
{
  BOOL code = TRUE;
  if (pInfo->bSystemWritable)
    code = ::SaveSetup(HKEY_LOCAL_MACHINE, &pInfo->sysData);
  if (code)
    code = ::SaveSetup(HKEY_CURRENT_USER, &pInfo->userData);
  return code;
}

VOID AddPage(LPPROPSHEETPAGE pPage, UINT id, DLGPROC dlgProc, LPVOID data)
{
  memset(pPage, 0, sizeof(PROPSHEETPAGE));
  pPage->dwSize = sizeof(PROPSHEETPAGE);
  pPage->dwFlags = 0;
  pPage->hInstance = g_hInstance;
  pPage->pszTemplate = MAKEINTRESOURCE(id);
  pPage->pfnDlgProc = dlgProc;
  pPage->lParam = (LPARAM)data;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrev,
		   LPSTR szCmdLine, int nCmdShow)
{
  g_hInstance = hInstance;
  
  CSetupInfo setup;
  
  setup.bSystemWritable =
    ::IsRegistryWritable(HKEY_LOCAL_MACHINE, TeXDLL_REGISTRY_KEY);
  
  if (!::LoadSetup(HKEY_CURRENT_USER, &setup.userData) ||
      !::LoadSetup(HKEY_LOCAL_MACHINE, &setup.sysData)) {
    MessageBox(0, "Could not load current setup informations.", 0, MB_OK);
    return 0;
  }

  PROPSHEETHEADER prop;
  PROPSHEETPAGE pages[5];
  memset(&prop, 0, sizeof(prop));
  prop.dwSize = sizeof(prop);
  prop.dwFlags = PSH_PROPSHEETPAGE | PSH_USEICONID | PSH_NOAPPLYNOW;
  prop.hwndParent = 0;
  prop.hInstance = g_hInstance;
  prop.pszCaption = "TeX DLL Customization";
  prop.nPages = 0;
  prop.nStartPage = 0;
  prop.ppsp = pages;
  prop.pszIcon = MAKEINTRESOURCE(IDI_TEXCUST);
  
  ::AddPage(pages + prop.nPages, IDD_GENERAL_PAGE,
	    (DLGPROC)GeneralPageProc, &setup);
  prop.nPages++;

  ::AddPage(pages + prop.nPages, IDD_CUI_PAGE,
	    (DLGPROC)CuiPageProc, &setup);
  prop.nPages++;
  
  ::AddPage(pages + prop.nPages, IDD_MAKETEX_PAGE,
	    (DLGPROC)MakeTeXPageProc, &setup);
  prop.nPages++;
  
  PropertySheet(&prop);
  
  return 1;
}
