#include <win32dll/win32lib.h>
#include <win32dll/texdll.h>
#include <win32dll/maketexlib.h>

#define MFTOPK_DLL "mftopk.dll"

typedef struct {
  LPFTeXCallbackProc callback;
  LPVOID callback_data;
  LPSTR name;
  DWORD dpi;
  LPSTR mag;
  LPSTR mode;
  LPSTR result;
} InternalData;

static BOOL WINAPI main_internal(InternalData* pData)
{
  BOOL ret = FALSE;
  HINSTANCE hMFtoPK;

  hMFtoPK = win32_load_tex_library(MFTOPK_DLL);
  if (hMFtoPK) {
    LPFTeXGetProceduresProc GetProc;
    BOOL mode_specified;
    LPSTR mode;

    mode_specified = pData->mode ? strcmp(pData->mode, "") : FALSE;
    mode = mode_specified ? pData->mode : GetMode(pData->dpi);
    
    GetProc =
      (LPFTeXGetProceduresProc)GetProcAddress(hMFtoPK, "MFtoPKGetProcedures");
    
    if (GetProc) {
      LPCTeXProcedures Procs = (*GetProc)();
      HTeX hTeX;
      LPSTR workdir = GetPKDirectory(pData->name, mode);
      
      hTeX =
	(*Procs->Initialize)(pData->callback, pData->callback_data, workdir);
      if (hTeX) {
	LONG code;
	
	if (win32_mkdir_recursively(workdir)) {
	  code = (*Procs->VaMain)(hTeX, "mf",
				  "\\mode:=", mode,
				  ";mag:=", pData->mag,
				  ";scrollmode",
				  ";input", pData->name, NULL);
	  if (code == 0) {
	    LPCSTR path = (*Procs->GetOutputFileName)(hTeX);
	    if (path) {
	      LPSTR tfmdir;
	      LPCSTR src_tfm;
	      strcpy(pData->result, path);
	      ret = TRUE;
	      DeleteFile((*Procs->GetLogFileName)(hTeX));
	      src_tfm = (*Procs->GetTFMFileName)(hTeX);
	      tfmdir = GetTFMDirectory(pData->name);
	      if (src_tfm && win32_mkdir_recursively(tfmdir)) {
		LPCSTR base = win32_basename(src_tfm);
		LPSTR dst_tfm = win32_concat_filename(tfmdir, base);
		if (access(dst_tfm, 4) == 0) { /* already exists. */
		}
		else {
		  CopyFile(src_tfm, dst_tfm, TRUE);
		}
		DeleteFile(src_tfm);
		win32_free(dst_tfm);
	      }
	      win32_free(tfmdir);
	    }
	  }
	}
	(*Procs->Uninitialize)(hTeX);
      }
      win32_free(workdir);
    }
    FreeLibrary(hMFtoPK);
  }

  return ret;
}

static UINT CALLBACK thread_func(LPVOID pv)
{
  BOOL code = FALSE;
  InternalData *pData = pv;
  if (win32_init_main(pData->callback, pData->callback_data, NULL)) {
    win32_set_progname("MakeTeXPK");
    code = main_internal(pData);
    win32_uninit_main();
  }
  return code;
}

BOOL WINAPI MakeTeXPKMain(LPSTR filename, DWORD filenamelen,
			  LPFTeXCallbackProc callback,
			  LPVOID callback_data,
			  LPCSTR name, LPCSTR mag,
			  DWORD mode_dpi, LPCSTR mode)
{
  LONG code = FALSE;
  InternalData* pdata;
  DWORD idThread;
  HANDLE hThread;
  
  EnterCriticalSection(&critical_section);
  
  pdata = malloc(sizeof(InternalData));
  pdata->callback = callback;
  pdata->callback_data = callback_data;
  pdata->name = strdup(name);
  pdata->dpi = mode_dpi;
  pdata->mag = strdup(mag);
  pdata->mode = mode ? strdup(mode) : NULL;
  pdata->result = malloc(filenamelen);
  
  hThread = (HANDLE)_beginthreadex(NULL, 0, thread_func,
				   pdata, 0, &idThread);
  if (hThread) {
    WaitForSingleObject(hThread, INFINITE);
    GetExitCodeThread(hThread, &code);
    if (code) strcpy(filename, pdata->result);
    CloseHandle(hThread);
  }
  
  free(pdata->name);
  free(pdata->mag);
  if (pdata->mode) free(pdata->mode);
  free(pdata->result);
  free(pdata);
  
  LeaveCriticalSection(&critical_section);

  if (code) UpdateLSR();
  
  return code;
}
