#include <win32dll/win32lib.h>
#include <malloc.h>

static LPCSTR dll_name = "dvips.dll";
static LPCSTR dll_main = "DVIPSMain";

int main(int argc, char**argv)
{
  HANDLE hDLL;
  int code = 1;
  
  win32_init_cui_callback();
  win32_init_module(GetModuleHandle(NULL));
  hDLL = win32_load_tex_library(dll_name);
  if (hDLL) {
    LPFDVIPSMainProc Main = (LPFDVIPSMainProc)GetProcAddress(hDLL, dll_main);
    if (Main) {
      code = (*Main)(win32_standard_cui_callback, NULL, NULL, argc, argv);
    }
    else {
      win32_write_stderr_text(dll_main, -1);
      win32_write_stderr_text(": Could not resolve the entry point.\n", -1);
    }
    FreeLibrary(hDLL);
  }
  else {
    win32_write_stderr_text(dll_name, -1);
    win32_write_stderr_text(": Could not load DLL.\n", -1);
  }
  return code;
}
