#include "maketex.h"

#include <stdio.h>
#include <process.h>
#include <unistd.h>
#include <fcntl.h>
#include <malloc.h>
#include <ctype.h>
#include <dos.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <libc/dosio.h>

#include <kpathsea/variable.h>

#define WORKBUF_SIZE 1024
#ifndef IS_DIR_SEP
#  define IS_DIR_SEP(c) ((c) == '/' || (c) == '\\')
#endif

void *xmalloc(unsigned int s)
{
  void *p = malloc(s);
  if (p  == NULL) {
    fprintf(stderr,"Memory exhausted.\n");
    exit(1);
  }
  return p;
}

char *xstrdup(const char *s)
{ char *p = xmalloc(strlen(s)+1);
  return strcpy(p,s);
}

int chdisk(int n)
{ union REGS r;
  r.h.ah = 0x0e;
  r.h.dl = n;
  intdos(&r,&r);
  return 0;
}

int copy_file(const char *to,const char *from)
{
  FILE *ifp,*ofp;
  struct stat s;
  long fsize;
  char *workbuf;

  if (stat(from,&s) < 0) {
    perror(from);
    return -1;
  }
  ifp = fopen(from,"rb");
  if (ifp == NULL) {
    perror(from);
    return -1;
  }
  ofp = fopen(to,"wb");
  if (ofp == NULL) {
    perror(to);
    fclose(ifp);
    return -1;
  }
  fsize = s.st_size;
  workbuf = xmalloc(WORKBUF_SIZE);
  while (fsize > 0) {
    size_t len = WORKBUF_SIZE < fsize ? WORKBUF_SIZE : (size_t)fsize;
    if (fread(workbuf,len,1,ifp) < 1) {
      perror(from);
      fclose(ifp);
      fclose(ofp);
      free(workbuf);
      return -1;
    }
    if (fwrite(workbuf,len,1,ofp) < 1) {
      perror(to);
      fclose(ifp);
      fclose(ofp);
      free(workbuf);
      return -1;
    }
    fsize -= len;
  }
  fclose(ifp);
  fclose(ofp);
  return 0;
}

int mkdir_recursively(const char *path)
{
  const char *p = path;
  char *q,*dir_sub;
  struct stat s;

  q = dir_sub = xmalloc(MAXPATHLEN);

  if (IS_DIR_SEP(path[0]) ||
      (strlen(path) >= 3 && isalpha(path[0]) && path[1] == ':' &&
       IS_DIR_SEP(path[2])) ) {
    /* absolute path. */
    while (!IS_DIR_SEP(*p) && *p) *q++ = *p++;
    *q++ = *p++;
  }

  for ( ; ; ) {
    while (!IS_DIR_SEP(*p) && *p) *q++ = *p++;
    *q = '\0';
    if (stat(dir_sub,&s) >= 0) {
      if (!(s.st_mode & S_IFDIR)) return -1;
        /* already exists but not dir. */
      else if (!*p) return 0; /* already exists */
    }
    else if (mkdir(dir_sub,0755) < 0) return -1; /* cannot create */
    *q++ = *p++;
  }

  return 0;
}

int spawnvp_silently(char **argv)
{
  int code;

#ifndef DEBUG
  int fd,orig_stdin,orig_stdout,orig_stderr;

  fd = open("nul",O_RDONLY);
  orig_stdin = dup(0);
  dup2(fd,0);
  close(fd);
  fd = open("nul",O_WRONLY);
  orig_stdout = dup(1);
  dup2(fd,1);
  close(fd);
  fd = open("nul",O_WRONLY);
  orig_stderr = dup(2);
  dup2(fd,2);
  close(fd);
#endif

  code = spawnvp(P_WAIT,argv[0],argv);

#ifndef DEBUG
  dup2(orig_stdin,0);
  close(orig_stdin);
  dup2(orig_stdout,1);
  close(orig_stdout);
  dup2(orig_stderr,2);
  close(orig_stderr);
#endif

  return code;
}

#define TRUNCATE_UNDEFINED  -1
#define TRUNCATE_NON         0
#define TRUNCATE_4AND4       1
#define TRUNCATE_8           2

static int get_truncate_type(void)
{
  static int truncate_type = TRUNCATE_UNDEFINED;
  if (truncate_type < 0) {
    char *v = kpse_var_expand("$MAKETEX_TRUNCATE_FONTNAME");
    if (strcmp(v,"4+4") == 0)
      truncate_type = TRUNCATE_4AND4;
    else if (strcmp(v,"8") == 0)
      truncate_type = TRUNCATE_8;
    else
      truncate_type = _use_lfn() ? TRUNCATE_NON : TRUNCATE_8;
    free(v);
  }
  return truncate_type;
}

int truncate_fontname_p(void)
{
  return (get_truncate_type() != TRUNCATE_NON);
}

char *truncate_fontname(const char *filename)
{
  char *path = xstrdup(filename);
  char *ext;
  int truncate_type = get_truncate_type();
  ext = path;
  while (*ext && *ext != '.') ext++;
  if (strlen(path)-strlen(ext) > 8) {
    switch (truncate_type) {
    case TRUNCATE_4AND4:
      memmove(path+4,ext-4,strlen(ext-4)+1);
      break;
    case TRUNCATE_8:
      memmove(path+8,ext,strlen(ext)+1);
      break;
    }
  }
  if (*ext == '.' && truncate_type != TRUNCATE_NON) {
    if (strlen(ext) > 4) ext[4] = '\0';
    ext++;
    while (*ext && *ext != '.') ext++;
    *ext = '\0';
  }
  return path;
}
