#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <malloc.h>
#include <dirent.h>
#include <ctype.h>
#include <unistd.h>
#include <dir.h>
#include <crt0.h>
#include <libc/dosio.h>

#define MAXPATHLEN 1024

char **__crt0_glob_function(char *a)
{ return (char **)0;
}

int _crt0_startup_flags = _CRT0_FLAG_DISALLOW_RESPONSE_FILES;

void *xmalloc(unsigned int s)
{
  void *p = malloc(s);
  if (p  == NULL) {
    fprintf(stderr,"Memory exhausted.\n");
    exit(1);
  }
  return p;
}

char *xstrdup(const char *s)
{ char *p = xmalloc(strlen(s)+1);
  return strcpy(p,s);
}

void decompose_path(char *path,char **b,char **e)
{
  char *last_slash = NULL;
  char *last_dot = NULL;
  char *p = path;
#ifdef SJIS_FN
  int kanji_f;
#endif
  while (*p) {
#ifdef SJIS_FN
    if (kanji_f) kanji_f = 0;
    else if (IS_KANJI(*p)) kanji_f = 1;
    else
#endif
      if (*p == ':' || *p == '\\' || *p == '/') last_slash = p+1;
      else if (*p == '.') last_dot = p;
    p++;
  }
  if (last_slash == NULL)
    last_slash = path;
  if (last_slash > last_dot)
    last_dot = path + strlen(path);
  if (b) *b = last_slash;
  if (e) *e = last_dot;
}

char *unix_filename(char *fn)
{
  char *s = fn;
  if (_use_lfn()) {
    while (*s) {
      if (*s == '\\') *s = '/';
      s++;
    }
  }
  else {
    while (*s) {
      if (*s == '\\') *s = '/';
      else *s = tolower(*s);
      s++;
    }
  }
  return fn;
}

char *concat_as_filename(char *p,const char *fn)
{
  int l = strlen(p);
  if (p[l-1] != '\\' && p[l-1] != '/' && p[l-1] != ':')
    strcat(p,"/");
  strcat(p,fn);
  return p;
}

typedef struct dir_t_s dir_t;
struct dir_t_s {
  char *name;
/*  unsigned char attrib; */
  dir_t *next;
};

int ls_R(const char *dir,FILE *fp,int top_f)
{
  int code;
  struct ffblk ff;
  dir_t *directory = NULL;
  dir_t *pdir,*pnextdir;
  char *path,*base;
  
  code = findfirst(dir,&ff,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC);

  if (code) { perror(dir); return -1; }

  while (code == 0) {
    unix_filename(ff.ff_name);
    if (ff.ff_name[0] == '.') ;
    else {
      if (ff.ff_attrib & FA_DIREC) {
	pdir = xmalloc(sizeof(dir_t));
	pdir->name = xstrdup(ff.ff_name);
	pdir->next = directory;
	directory = pdir;
      }
      if (!top_f || !(ff.ff_attrib & FA_DIREC)) {
	if (fputs(ff.ff_name,fp) < 0) return -1;
	if (putc('\n',fp) == EOF) return -1;
      }
    }
    code = findnext(&ff);
  }

  path = xmalloc(strlen(dir) + 256);
  strcpy(path,dir);
  /*  concat_as_filename(path,"."); */
  decompose_path(path,&base,NULL);

  for (pdir = directory; pdir ;pdir=pnextdir) {
    pnextdir = pdir->next;
    strcpy(base,pdir->name);
    if (fputs("\n",fp) < 0) return -1;
    if (fputs(path,fp) < 0) return -1;
    if (fputs(":\n",fp) < 0) return -1;
    concat_as_filename(path,_use_lfn() ? "*" : "*.*");
    if (ls_R(path,fp,0) < 0) return -1;
    free(pdir->name);
    free(pdir);
  }
  free(path);
  return 0;
}

int ls_R_top(char **fv,int fc,FILE *fp)
{
  struct ffblk ff;
  dir_t *directory = NULL;
  dir_t *pdir,*pnextdir;
  char path[MAXPATHLEN+1];
  int err = 0;
  int i;
  
  for (i=0;i<fc;i++) {
    char *base;
    int code;
    if ((strlen(fv[i]) == 1 && (*fv[i] == '\\' ||*fv[i] == '/')) ||
        (strlen(fv[i]) == 3 && isalpha(*fv[i]) && *(fv[i]+1) == ':' &&
          (*(fv[i]+2) == '\\' ||*(fv[i]+2) == '/')) ||
        (strlen(fv[i]) == 2 && isalpha(*fv[i]) && *(fv[i]+1) == ':')) {
    dir:
	  pdir = xmalloc(sizeof(dir_t));
	  pdir->name = xstrdup(fv[i]);
	  pdir->next = directory;
	  directory = pdir;
      continue;
    }
    decompose_path(fv[i],&base,NULL);
    if (strcmp(base,".") == 0 || strcmp(base,"..") == 0)
      goto dir;
    code = findfirst(fv[i],&ff,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC);
    if (code) {
      perror(fv[i]);
      err++;
      continue;
    }
    strcpy(path,fv[i]);
    decompose_path(path,&base,NULL);
    while (code == 0) {
      unix_filename(ff.ff_name);
      if (ff.ff_name[0] == '.') ;
      else {
	strcpy(base,ff.ff_name);
	if (ff.ff_attrib & FA_DIREC) {
	  pdir = xmalloc(sizeof(dir_t));
	  pdir->name = xstrdup(path);
	  pdir->next = directory;
	  directory = pdir;
	}
	if (!(ff.ff_attrib & FA_DIREC)) {
	  if (fputs(ff.ff_name,fp) < 0) return -1;
	  if (putc('\n',fp) == EOF) return -1;
	}
      }
      code = findnext(&ff);
    }
  }
  for (pdir = directory; pdir ;pdir=pnextdir) {
    pnextdir = pdir->next;
    strcpy(path,pdir->name);
    if (fputs("\n",fp) < 0) return -1;
    if (fputs(path,fp) < 0) return -1;
    if (fputs(":\n",fp) < 0) return -1;
    concat_as_filename(path,_use_lfn() ? "*" : "*.*");
    if (ls_R(path,fp,0) < 0) err++;
    free(pdir->name);
    free(pdir);
  }
  return err ? -1 : 0;
}

#ifndef NO_MAIN
int main(int argc,char *argv[])
{
  int code;
  if (argc <= 1) {
    char *cwd = getcwd(NULL,MAXPATHLEN);
    code = ls_R_top(&cwd,1,stdout);
  }
  else {
    code = ls_R_top(argv+1,argc-1,stdout);
  }
  return code < 0 ? 1 : 0;
}
#endif
