#include <stdio.h>
#include <dos.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <dir.h>
#include <io.h>
#include <unistd.h>
#include <crt0.h>
#include <libc/dosio.h>

static int force_f = 0;

char **__crt0_glob_function(char *a)
{ return (char **)0;
}
int _crt0_startup_flags = _CRT0_FLAG_DISALLOW_RESPONSE_FILES;

int tty_yes(void)
{
  for ( ; ; ) {
    union REGS r;
    r.h.ah = 0x07;
    intdos(&r,&r);
    switch (r.h.al) {
    case 'y': case 'Y':
    case 'n': case 'N':
      putc(r.h.al,stdout);
      fflush(stdout);
      return (r.h.al == 'y' || r.h.al == 'Y');
    }
  }
}

void *xmalloc(unsigned int s)
{
  void *p = malloc(s);
  if (p  == NULL) {
    fprintf(stderr,"Memory exhausted.\n");
    exit(1);
  }
  return p;
}

char *xstrdup(const char *s)
{ char *p = xmalloc(strlen(s)+1);
  return strcpy(p,s);
}

void decompose_path(char *path,char **b,char **e)
{
  char *last_slash = NULL;
  char *last_dot = NULL;
  char *p = path;
#ifdef SJIS_FN
  int kanji_f;
#endif
  while (*p) {
#ifdef SJIS_FN
    if (kanji_f) kanji_f = 0;
    else if (IS_KANJI(*p)) kanji_f = 1;
    else
#endif
    if (*p == ':' || *p == '\\' || *p == '/') last_slash = p+1;
    else if (*p == '.') last_dot = p;
    p++;
  }
  if (last_slash == NULL)
    last_slash = path;
  if (last_slash > last_dot)
    last_dot = path + strlen(path);
  if (b) *b = last_slash;
  if (e) *e = last_dot;
}
char *unix_filename(char *fn)
{
  char *s = fn;
  if (_use_lfn()) {
    while (*s) {
      if (*s == '\\') *s = '/';
      s++;
    }
  }
  else {
    while (*s) {
      if (*s == '\\') *s = '/';
      else *s = tolower(*s);
      s++;
    }
  }
  return fn;
}

char *concat_as_filename(char *p,const char *fn)
{
  int l = strlen(p);
  if (l >= 1 && p[l-1] != '\\' && p[l-1] != '/' && p[l-1] != ':')
    strcat(p,"/");
  strcat(p,fn);
  return p;
}

static int
rm_remove_file(const char *f,int ro_f)
{
  if (ro_f) {
    struct stat s;
    stat(f,&s);
    chmod(f,s.st_mode|S_IWRITE);
  }
  if (unlink(f) < 0)
    perror(f);
  return 0;
}

static int
rm_remove_dir(const char *d,int ro_f)
{
  if (ro_f) {
    struct stat s;
    stat(d,&s);
    chmod(d,s.st_mode|S_IWRITE);
  }
  if (rmdir(d) < 0)
    perror(d);
  return 0;
}

typedef struct dir_t_s dir_t;
struct dir_t_s {
  char *name;
  unsigned char attrib;
  dir_t *next;
};

int rm_file_or_directory(const char *f)
{
  struct ffblk ff;
  char *path;
  char *base;
  int code;
  dir_t *directory = NULL;
  dir_t *pdir,*pnextdir;

  path = xmalloc(strlen(f)+256);
  code = findfirst(f,&ff,FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_DIREC);
  strcpy(path,f);
  decompose_path(path,&base,NULL);
  while (code == 0) {
    if (strcmp(ff.ff_name,".") && strcmp(ff.ff_name,"..")) {
      unix_filename(ff.ff_name);
      strcpy(base,ff.ff_name);
      if (ff.ff_attrib & FA_DIREC) {
	pdir = xmalloc(sizeof(dir_t));
	pdir->name = xstrdup(ff.ff_name);
	pdir->attrib = ff.ff_attrib;
	pdir->next = directory;
	directory = pdir;
      }
      else {
	if (!force_f) {
	  fprintf(stderr,"%s: remove ? (y/n) ",path);
	  code = !tty_yes();
	}
	if (code == 0) rm_remove_file(path,ff.ff_attrib & FA_RDONLY);
      }
    }
    code = findnext(&ff);
  }
  for (pdir=directory; pdir ;pdir=pnextdir) {
    char *p;
    pnextdir = pdir->next;
    strcpy(base,pdir->name);
    free(pdir->name);
    free(pdir);
    p = base + strlen(base);
    if (!force_f) {
      fprintf(stderr,"%s: recursively descend directory ? (y/n) ",path);
      if (!tty_yes()) continue;
    }
    concat_as_filename(path,_use_lfn() ? "*" : "*.*");
    code = rm_file_or_directory(path);
    *p = '\0';
    rm_remove_dir(path,pdir->attrib & FA_RDONLY);
  }
  free(path);
  return 0;
}

int main(int argc,char **argv)
{
  int i;

  while (argc > 1) {
    const char *p = argv[1];
    if (*p != '-') break;
    p++;
    while (*p) {
      switch (*p) {
      case 'i': force_f = 0; break;
      case 'f': force_f = 1; break;
      default:
        fprintf(stderr,"-%c: unknown flag.\n",(int)*p);
        exit(1);
      }
      p++;
    }
    argc--; argv++;
  }
  if (argc <= 1) {
    fprintf(stderr,"Usage: rm-r [-fi] files-or-directories\n");
    exit(1);
  }
  for (i=1;i<argc;i++)
    rm_file_or_directory(argv[i]);
  return 0;
}
