/*
  NEC PC-9801 screen. Written by K. Asayama Aug, 1995.
 */

#define EXTERN extern
#include "../mfd.h"

/* If your djgpp is older than version 1.12, define `OLD_DJGPP'. */
/*#define OLD_DJGPP */

#ifdef PC98WIN
#define WHITE			10

#ifdef OLD_DJGPP
#  include <string.h> /* memset() */
#else
#  include <go32.h>
#  include <dpmi.h>
#  include <sys/farptr.h>
#endif

#ifdef DJGPP
#  if DJGPP >= 2
#    define DJGPP_VERSION_2
#  endif
#endif

#include <dos.h>
#include <pc.h>

#define SCREEN_WIDTH	640
#define SCREEN_HEIGHT	400
#define VRAM_WIDTH8		(SCREEN_WIDTH/8)
#define VRAM_SIZE		(VRAM_WIDTH8 * SCREEN_HEIGHT)

static const int GVRAM_OFFSET[] = {
  0xA8000, 0xB0000, 0xB8000, 0xE0000,
};

static void clear_gvram(void);
static void stop_graphics(void);
static void set_palette(int c,int r,int g,int b);
static void term_graphics(void);

#ifdef OLD_DJGPP
#  define mf_dosmemset(p,v,s)	memset((unsigned char *)0xe0000000L+(p),v,s)
#  define _farnspokel(off,v)	*(unsigned long*)(0xe0000000L+(off)) = (v)
#  define _farnspokeb(off,v)	*(unsigned char*)(0xe0000000L+(off)) = (v)
#  define _farnspeekb(off)		*(unsigned char*)(0xe0000000L+(off))
#  define _farsetsel(sel)		0 /* do nothing */
#else
static void mf_dosmemset(unsigned ,unsigned char ,size_t );
#endif

/* public routines */
/*
   Initializing graphic display.
   This function is called at once when displaying starts.
 */

mf_pc98_initscreen()
{
  /* 400 lines mode */
#ifdef DJGPP_VERSION_2
  __dpmi_regs regs;
  regs.h.ah = 0x42;
  regs.h.ch = 0xc0;
  __dpmi_int(0x18,&regs);
#else
  union REGS regs;
  regs.h.ah = 0x42;
  regs.h.ch = 0xc0;
  int86(0x18, &regs, &regs);
#endif

  /* 16 color mode */
  outportb(0x6A, 0x01);

  /* make graphics display invisible. */
  stop_graphics();

  /* start GDC */
  while ( inportb(0xa0) & 2 );
  while ( inportb(0xa0) & 0x20 == 0 );
  outportb(0xA2, 0x0D);

  clear_gvram();

  /* make graphics display visible. */
  /* 16 color mode */
  set_palette(0,0,0,0);
  set_palette(1,WHITE,WHITE,WHITE);

  atexit(term_graphics);

  return 1;
}

/*
   Flushing graphic display.
   This function is called when each character finishes.
 */
mf_pc98_updatescreen()
{
}

/*
   Clearing graphic display.
   This function is called when each character begins.
 */
mf_pc98_blankrectangle(left, right, top, bottom)
screencol left, right;
screenrow top, bottom;
{
	unsigned char left_mask,right_mask;
	int offset;

	if (right < left) return 0;
	if (bottom < top) return 0;
	if (left < 0) left = 0;
	if (right >= SCREEN_WIDTH) right = SCREEN_WIDTH-1;
	if (top < 0) top = 0;
	if (bottom >= SCREEN_HEIGHT) bottom = SCREEN_HEIGHT-1;

	left_mask = 0xff>>(left&0x07);
	right_mask = 0xff << (7-(right&0x07));

	offset = GVRAM_OFFSET[0] + (SCREEN_WIDTH/8)*top + (left >> 3);
	_farsetsel(_go32_info_block.selector_for_linear_memory);
	if (left>>3 == right>>3) {
		unsigned char mask = left_mask & right_mask;
		for ( ;top<bottom;top++) {
			_farnspokeb(offset,_farnspeekb(offset) | mask);
			offset += VRAM_WIDTH8;
		}
	}
	else {
		int s8 = (left>>3)+1;
		int e8 = right>>3;
		int e32 = s8 + (e8-s8)/4 * 4;
		for ( ;top < bottom;top++) {
			int off = offset;
			int x8;
			_farnspokeb(off,_farnspeekb(off) | left_mask);
			off++;
			for (x8=s8;x8<e32;x8+=4) {
				_farnspokel(off,0xffffffff);
				off+=4;
			}
			for ( ;x8<e8;x8++) {
				_farnspokeb(off,0xff);
				off++;
			}
			_farnspokeb(off,_farnspeekb(off) | right_mask);
			offset += VRAM_WIDTH8;
		}
	}
}

/*
   Drawing a scanline.
   This function called when each scanline is drawn.
   Each argument means:
     row:
         The # of scanline (The top of the display is 0).
     init_color:
         Whether the pixel at the beginning of this scanline
       is white(background) or black(foreground). The value 0 means
       background color.
     tvect:
         The array of the positions where the color of the pixels changes next.
       That is, value tvect[i+1]-tvect[i] means the runlength of the current
       color, and tvect[0] is the horizontal coordination of the leftside of
       this scanline data.
     vector_size:
         The size of the array `tvect'.
 */
mf_pc98_paintrow(row, init_color, tvect, vector_size)
screenrow row;
pixelcolor init_color;
transspec tvect;
register screencol vector_size;
{
    if (row >= 0 && row < SCREEN_HEIGHT) {
		int c = init_color ? 1 : 0;
		unsigned long row_leftside_offset = GVRAM_OFFSET[0] + row*VRAM_WIDTH8;
		int left,next_left;
		_farsetsel(_go32_info_block.selector_for_linear_memory);
		left = *tvect++;
		do {
			int next_left = *tvect++;
			int right = next_left-1;
			unsigned long offset;
			unsigned char left_mask,right_mask;

			if (left >= SCREEN_WIDTH) break;
			if (left < 0) left = 0;
			if (right >= SCREEN_WIDTH) right = SCREEN_WIDTH-1;

			left_mask = 0xff>>(left&0x07);
			right_mask = 0xff << (7-(right&0x07));

			offset = row_leftside_offset + (left >> 3);

			if (c) {
				if (left>>3 == right>>3) {
					unsigned char mask = left_mask & right_mask;
					_farnspokeb(offset,_farnspeekb(offset) & ~mask);
				}
				else {
					int s8 = (left>>3)+1;
					int e8 = right>>3;
					int e32 = s8 + (e8-s8)/4 * 4;
					int off = offset;
					int x8;
					_farnspokeb(off,_farnspeekb(off) & ~left_mask);
					off++;
					for (x8=s8;x8<e32;x8+=4) {
						_farnspokel(off,0);
						off+=4;
					}
					for ( ;x8<e8;x8++) {
						_farnspokeb(off,0);
						off++;
					}
					_farnspokeb(off,_farnspeekb(off) & ~right_mask);
				}
			}
			c ^= 1;
			left = next_left;
		} while (--vector_size > 0);
	}
}

/* internal routines */

static void clear_gvram(void)
{ int i;
  for (i=0;i<4;i++)	mf_dosmemset(GVRAM_OFFSET[i],0,VRAM_SIZE);
}

static void set_palette(int c,int r,int g,int b)
{
	outportb(0xA8, c);
	outportb(0xAA, g);
	outportb(0xAC, r);
	outportb(0xAE, b);
}

static void stop_graphics(void)
{
	int i;
	for (i=0;i<16;i++)
		set_palette(i,0,0,0);
}

static void term_graphics(void)
{
	stop_graphics();
	/* GDC stop */
	while( inportb(0xa0) & 2 );
		outportb(0xA2, 0x0C);
    clear_gvram();
}

/* direct VRAM access. */
#ifndef OLD_DJGPP
static void mf_dosmemset(register unsigned off,unsigned char c,register size_t len)
{
	register unsigned long cw =
		((unsigned long)c<<24) | ((unsigned long)c<<16) |
		((unsigned long)c<<8) | c;
	_farsetsel(_go32_info_block.selector_for_linear_memory);
	for ( ;len >= 4;len-=4,off+=4) {
		_farnspokel(off,cw);
	}
	for ( ;len > 0;len--,off++) {
		_farnspokeb(off,c);
	}
}
#endif /* !OLD_DJGPP */
#else /* !PC98WIN */
int mf_pc98_dummy;
#endif /* PC98WIN */
