#include "config.h"

#ifndef LONG_FN

#include <kpathsea/c-proto.h>
#include <kpathsea/c-pathch.h>
#include <kpathsea/hash.h>
#include <kpathsea/types.h>
#include <kpathsea/line.h>
#include <kpathsea/pathsearch.h>

/* Following routines are from `kpathsea/fontmap.c'. */

/* Open and read the mapping file MAP_FILENAME, putting its entries into
   MAP. Comments begin with % and continue to the end of the line.  Each
   line of the file defines an entry: the first word is the real
   filename (e.g., `ptmr'), the second word is the alias (e.g.,
   `Times-Roman'), and any subsequent words are ignored.  .tfm is added
   if either the filename or the alias have no extension.  This is the
   same order as in Dvips' psfonts.map; unfortunately, we can't have TeX
   read that same file, since most of the real filenames start with an
   `r', because of the virtual fonts Dvips uses.  */

static void
map_file_parse P2C(hash_table_type *, map,  const_string, map_filename)
{
  extern FILE *xfopen ();	/* In xfopen.c.  */
  char *l;
  unsigned map_lineno = 0;
  FILE *f = xfopen (map_filename, FOPEN_R_MODE);
  
  while ((l = read_line (f)) != NULL)
    {
      string filename;
      string comment_loc = strchr (l, '%');
      
      map_lineno++;
      
      /* Ignore anything after a %.  */
      if (comment_loc)
        *comment_loc = 0;
      
      /* If we don't have any filename, that's ok, the line is blank.  */
      filename = strtok (l, " \t");
      if (filename)
        {
          string alias = strtok (NULL, " \t");
          
          /* But if we have a filename and no alias, something's wrong.  */
          if (alias == NULL || *alias == 0)
            fprintf (stderr, "%s:%u: Alias missing for filename `%s'.\n",
                     map_filename, map_lineno, filename);
          else
            { /* We've got everything.  Insert the new entry.  */
              hash_insert (map, xstrdup (alias), xstrdup (filename));
            }
        }
      
      free (l);
    }
  
  xfclose (f, map_filename);
}

/* Search for all the MAP_NAME's in PATH.  */

hash_table_type
map_create_with_mapname P2C(const_string, path, const_string, map_name)
{
  string *filenames = kpse_all_path_search (path, map_name);
  hash_table_type map; /* some old compilers ... */
  map = hash_create (751);
  
  while (*filenames)
    {
      map_file_parse (&map, *filenames);
      filenames++;
    }

  return map;
}
#else
int web2c_lib_dosfnmap_dummy;
#endif /* !LONG_FN */
