/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.components;

import com.github.ajalt.mordant.components.Padded;
import com.github.ajalt.mordant.components.Padding;
import com.github.ajalt.mordant.components.PaddingKt;
import com.github.ajalt.mordant.components.Text;
import com.github.ajalt.mordant.rendering.BorderStyle;
import com.github.ajalt.mordant.rendering.BorderStyleSection;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Renderable;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB7\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/ajalt/mordant/components/Panel;", "Lcom/github/ajalt/mordant/rendering/Renderable;", "content", "", "borderStyle", "Lcom/github/ajalt/mordant/rendering/BorderStyle;", "expand", "", "borderTextStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "padding", "Lcom/github/ajalt/mordant/components/Padding;", "(Ljava/lang/String;Lcom/github/ajalt/mordant/rendering/BorderStyle;ZLcom/github/ajalt/mordant/rendering/TextStyle;Lcom/github/ajalt/mordant/components/Padding;)V", "(Lcom/github/ajalt/mordant/rendering/Renderable;Lcom/github/ajalt/mordant/rendering/BorderStyle;ZLcom/github/ajalt/mordant/rendering/TextStyle;Lcom/github/ajalt/mordant/components/Padding;)V", "borderWidth", "", "getBorderWidth", "()I", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "mordant"})
public final class Panel
implements Renderable {
    private final Renderable content;
    private final BorderStyle borderStyle;
    private final boolean expand;
    private final TextStyle borderTextStyle;

    private final int getBorderWidth() {
        return this.borderStyle == null ? 0 : 2;
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        WidthRange measurement = this.content.measure(t, width - this.getBorderWidth());
        return this.expand ? new WidthRange(measurement.getMax() + this.getBorderWidth(), measurement.getMax() + this.getBorderWidth()) : measurement.plus(this.getBorderWidth());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        int maxContentWidth = width - this.getBorderWidth();
        WidthRange measurement = this.content.measure(t, maxContentWidth);
        int contentWidth = this.expand ? maxContentWidth : RangesKt.coerceAtMost(measurement.getMax(), maxContentWidth);
        Lines renderedContent = LinesKt.setSize$default(this.content.render(t, maxContentWidth), contentWidth, 0, null, TextAlign.LEFT, 6, null);
        if (this.borderStyle == null) {
            return renderedContent;
        }
        ArrayList<List<Span>> lines = new ArrayList<List<Span>>(renderedContent.getLines().size() + this.getBorderWidth());
        BorderStyleSection b = this.borderStyle.getBody();
        Span horizontalBorder = Span.Companion.word(StringsKt.repeat(b.getEw(), contentWidth), this.borderTextStyle);
        lines.add(CollectionsKt.listOf(Span.Companion.word(b.getEs(), this.borderTextStyle), horizontalBorder, Span.Companion.word(b.getSw(), this.borderTextStyle)));
        List<Span> vertical = CollectionsKt.listOf(Span.Companion.word(b.getNs(), this.borderTextStyle));
        Iterable $this$mapTo$iv = renderedContent.getLines();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void line;
            List list = (List)item$iv;
            Collection collection = lines;
            boolean bl = false;
            List<Span> list2 = LinesKt.flatLine(vertical, line, vertical);
            collection.add(list2);
        }
        lines.add(CollectionsKt.listOf(Span.Companion.word(b.getNe(), this.borderTextStyle), horizontalBorder, Span.Companion.word(b.getNw(), this.borderTextStyle)));
        return new Lines((List<? extends List<Span>>)lines);
    }

    public Panel(@NotNull Renderable content, @Nullable BorderStyle borderStyle, boolean expand, @NotNull TextStyle borderTextStyle, @NotNull Padding padding2) {
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(borderTextStyle, "borderTextStyle");
        Intrinsics.checkNotNullParameter(padding2, "padding");
        this.borderStyle = borderStyle;
        this.expand = expand;
        this.borderTextStyle = borderTextStyle;
        this.content = Padded.Companion.get$default(Padded.Companion, content, padding2, false, 4, null);
    }

    public /* synthetic */ Panel(Renderable renderable, BorderStyle borderStyle, boolean bl, TextStyle textStyle, Padding padding2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            borderStyle = BorderStyle.Companion.getROUNDED();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            textStyle = TextStyleKt.getDEFAULT_STYLE();
        }
        if ((n & 0x10) != 0) {
            padding2 = PaddingKt.getDEFAULT_PADDING();
        }
        this(renderable, borderStyle, bl, textStyle, padding2);
    }

    public Panel(@NotNull String content, @Nullable BorderStyle borderStyle, boolean expand, @NotNull TextStyle borderTextStyle, @NotNull Padding padding2) {
        Intrinsics.checkNotNullParameter(content, "content");
        Intrinsics.checkNotNullParameter(borderTextStyle, "borderTextStyle");
        Intrinsics.checkNotNullParameter(padding2, "padding");
        this(new Text(content, null, null, null, null, null, null, 126, null), borderStyle, expand, borderTextStyle, padding2);
    }

    public /* synthetic */ Panel(String string, BorderStyle borderStyle, boolean bl, TextStyle textStyle, Padding padding2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            borderStyle = BorderStyle.Companion.getROUNDED();
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            textStyle = TextStyleKt.getDEFAULT_STYLE();
        }
        if ((n & 0x10) != 0) {
            padding2 = PaddingKt.getDEFAULT_PADDING();
        }
        this(string, borderStyle, bl, textStyle, padding2);
    }
}

