/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.MathBg;
import com.dickimawbooks.texparserlib.MathEg;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import java.io.IOException;

public class MathGroup
extends Group {
    private boolean isinline;

    public MathGroup() {
    }

    public MathGroup(int n) {
        super(n);
    }

    public boolean isInLine() {
        return this.isinline;
    }

    public void setInLine(boolean bl) {
        this.isinline = bl;
    }

    @Override
    public TeXObjectList createList() {
        MathGroup mathGroup = new MathGroup(this.capacity());
        mathGroup.setInLine(this.isinline);
        return mathGroup;
    }

    @Override
    public String format() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.isInLine() ? "$" : "$$";
        stringBuilder.append(string);
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.format());
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        String string = this.isInLine() ? "$" : "$$";
        stringBuilder.append(string);
        for (TeXObject teXObject : this) {
            stringBuilder.append(teXObject.toString());
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    @Override
    public void startGroup(TeXParser teXParser) throws IOException {
        super.startGroup(teXParser);
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setMode(this.isinline ? 1 : 2);
    }

    @Override
    public TeXObject getBegin(TeXParser teXParser) {
        return new MathBg(teXParser.getMathChar(), this.isInLine());
    }

    @Override
    public TeXObject getEnd(TeXParser teXParser) {
        return new MathEg(teXParser.getMathChar(), this.isInLine());
    }
}

