/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texosquery;

import com.dickimawbooks.texosquery.FilePathSortComparator;
import com.dickimawbooks.texosquery.FileSortType;
import com.dickimawbooks.texosquery.TeXOSQuery;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileWalkVisitor
extends SimpleFileVisitor<Path> {
    private TeXOSQuery invoker;
    private Pattern pattern;
    private Vector<Path> result;
    private Comparator<Path> comparator;

    public FileWalkVisitor(TeXOSQuery teXOSQuery, String string, Comparator<Path> comparator) {
        this.invoker = teXOSQuery;
        this.comparator = comparator;
        this.pattern = Pattern.compile(string);
        this.result = new Vector();
    }

    public Vector<Path> getList() {
        return this.result;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (Files.isHidden(path) || !Files.isReadable(path) || Files.isSymbolicLink(path)) {
            this.invoker.info(String.format("Walk skipping directory: %s", path.toString()));
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        if (Files.isHidden(path) || !Files.isReadable(path) || basicFileAttributes.isSymbolicLink()) {
            this.invoker.info(String.format("Walk skipping file: %s", path.toString()));
            return FileVisitResult.CONTINUE;
        }
        String string = path.getName(path.getNameCount() - 1).toString();
        Matcher matcher = this.pattern.matcher(string);
        if (matcher.matches()) {
            this.addPath(path);
        }
        return FileVisitResult.CONTINUE;
    }

    private void addPath(Path path) {
        int n = this.result.size();
        if (n == 0) {
            this.result.add(path);
            return;
        }
        for (int i = 0; i < n; ++i) {
            Path path2 = this.result.get(i);
            if (this.comparator.compare(path2, path) <= 0) continue;
            this.result.add(i, path);
            return;
        }
        this.result.add(path);
    }

    public static String walk(TeXOSQuery teXOSQuery, String string, String string2, File file, FileSortType fileSortType) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("No such file: %s", file.toString()));
        }
        if (!file.isDirectory()) {
            throw new IOException(String.format("Not a directory: %s", file.toString()));
        }
        file = file.getCanonicalFile();
        File file2 = new File(teXOSQuery.getSystemProperty("user.dir", "."));
        if (!file2.equals(file) && !teXOSQuery.isFileInTree(file, file2)) {
            throw new IOException(String.format("Walk must start in current working directory path: %s", file2.toString()));
        }
        Path path = file.toPath();
        FileWalkVisitor fileWalkVisitor = new FileWalkVisitor(teXOSQuery, string2, new FilePathSortComparator(fileSortType));
        Files.walkFileTree(path, fileWalkVisitor);
        Vector<Path> vector = fileWalkVisitor.getList();
        StringBuilder stringBuilder = new StringBuilder();
        for (Path path2 : vector) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(teXOSQuery.escapeFileName(path.relativize(path2).toString()));
        }
        return stringBuilder.toString();
    }
}

